(* Content-type: application/vnd.wolfram.mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 13.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       158,          7]
NotebookDataLength[    260863,       4917]
NotebookOptionsPosition[    252108,       4757]
NotebookOutlinePosition[    252504,       4773]
CellTagsIndexPosition[    252461,       4770]
WindowFrame->Normal*)

(* Beginning of Notebook Content *)
Notebook[{

Cell[CellGroupData[{
Cell["Cyclic Quadrilaterals - Steiner point", "Title",
 CellChangeTimes->{{3.947133122765019*^9, 3.947133141273266*^9}, {
  3.947144439694456*^9, 3.947144443366682*^9}, {3.947339713636549*^9, 
  3.947339717251663*^9}, {3.954728574674156*^9, 3.954728576840864*^9}, {
  3.9547567434027576`*^9, 3.9547567507460337`*^9}, {3.9555039848244762`*^9, 
  3.955503986915159*^9}},ExpressionUUID->"29001ab6-6556-7b4b-a45f-\
7ca429ca0ceb"],

Cell["\<\
This Notebook contains the proofs for the results about cyclic quadrilaterals \
in the paper \[OpenCurlyDoubleQuote]More Shapes of Central Quadrilaterals\
\[CloseCurlyDoubleQuote]
by Stanley Rabinowitz and Ercole Suppa, submitted to the International \
Journal of Computer Discovered Mathematics (http://www.journal-1.eu/) in July \
2025.

This Notebook is Copyright \[Copyright] July 2025 by Stanley Rabinowitz \
(stan.rabinowitz@comcast.net) and Ercole Suppa (ercolesuppa@gmail.com) and is \
published with open access . 
This Notebook is distributed under the terms of the Creative Commons \
Attribution License which permits any use, distribution, and reproduction in \
any medium, provided the original author and the source are credited. 
The baricentricas package must be loaded before running this Notebook . It \
can be obtained from http://garciacapitan.epizy.com/baricentricas/.\
\>", "Text",
 CellChangeTimes->{{3.947134015183899*^9, 3.947134126514601*^9}, {
  3.947134165027289*^9, 3.947134216283169*^9}, {3.947146196077376*^9, 
  3.947146197937656*^9}, {3.947147714654799*^9, 3.947147721422184*^9}, {
  3.947147756182218*^9, 3.947147799085409*^9}, {3.947147829468706*^9, 
  3.947147925478302*^9}, {3.947148657900776*^9, 3.947148664004244*^9}, {
  3.947339725299139*^9, 3.947339727179648*^9}, {3.954756786770439*^9, 
  3.954756791707377*^9}, {3.9611186285468063`*^9, 3.9611186309070377`*^9}, {
  3.961412637514739*^9, 
  3.961412644914424*^9}},ExpressionUUID->"22c83543-03f0-524a-b077-\
52bf40ea5d06"],

Cell[CellGroupData[{

Cell["Setup", "Section",
 CellChangeTimes->{{3.850468990902514*^9, 3.850469001252577*^9}, {
   3.850469071318833*^9, 3.850469073637095*^9}, 
   3.850469177050805*^9},ExpressionUUID->"4726c28a-23e3-c144-b5b8-\
1febfd23a730"],

Cell[BoxData[{
 RowBox[{
  RowBox[{"<<", "baricentricas.m"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"$Assumptions", "=", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"a", ">", "0"}], ",", 
     RowBox[{"b", ">", "0"}], ",", 
     RowBox[{"c", ">", "0"}], ",", 
     RowBox[{
      RowBox[{"a", "+", "b", "-", "c"}], ">", "0"}], ",", 
     RowBox[{
      RowBox[{"a", "+", "c", "-", "b"}], ">", "0"}], ",", 
     RowBox[{
      RowBox[{"b", "+", "c", "-", "a"}], ">", "0"}], ",", 
     RowBox[{"t", ">", "0"}], ",", 
     RowBox[{"t", "<", "1"}]}], "}"}]}], ";"}]}], "Input",
 CellChangeTimes->{{3.815380012932528*^9, 3.815380017875984*^9}, 
   3.850469040353149*^9, {3.8504693680519905`*^9, 3.850469423540739*^9}, {
   3.850472927885082*^9, 3.8504729485372677`*^9}, {3.850473440747275*^9, 
   3.8504734481722603`*^9}, {3.850475925894286*^9, 3.850475928077327*^9}, {
   3.8504761619065633`*^9, 3.850476174390406*^9}, {3.850556206333856*^9, 
   3.850556223600524*^9}, {3.8505562541705465`*^9, 3.850556312095413*^9}, {
   3.8505595402294674`*^9, 3.850559540656997*^9}, {3.850559577535342*^9, 
   3.8505595778428125`*^9}, {3.957575933740265*^9, 3.957575946500149*^9}, {
   3.957575978072499*^9, 3.957576015387537*^9}, {3.9575760749636536`*^9, 
   3.9575760753069916`*^9}, {3.957577346528906*^9, 3.957577349252188*^9}},
 CellLabel->
  "In[146]:=",ExpressionUUID->"fe7e3f24-57f0-1445-8125-872b46d33312"],

Cell[TextData[StyleBox["Point T on AC such that AT : TC = t : 1, with 0 \
\[LessEqual] t \[LessEqual] 1.",
 FontColor->GrayLevel[0]]], "Text",
 CellChangeTimes->{{3.817293631733445*^9, 3.817293669912202*^9}, {
  3.8172945191307793`*^9, 
  3.817294567706676*^9}},ExpressionUUID->"54ce8b45-a9ff-364a-b007-\
50e763233c41"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ptT", "=", 
  RowBox[{"DividirRazon", "[", 
   RowBox[{"ptA", ",", "ptC", ",", "t", ",", "1"}], "]"}]}]], "Input",
 CellChangeTimes->{{3.8153943277906637`*^9, 3.8153943533872595`*^9}, {
   3.817293588623359*^9, 3.817293590671271*^9}, 3.8505560088454385`*^9, 
   3.850556165035162*^9},
 CellLabel->
  "In[148]:=",ExpressionUUID->"2b97bda7-fc4c-854c-a342-fa797e627188"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"1", ",", "0", ",", "t"}], "}"}]], "Output",
 CellChangeTimes->{3.815394355261637*^9, 3.815394436413099*^9, 
  3.81727674378023*^9, 3.8172935920367208`*^9, 3.85046938567021*^9, 
  3.85046942698629*^9, 3.850472723754394*^9, 3.850517747901428*^9, 
  3.850554109409218*^9, 3.8505560460500946`*^9, 3.850556124094026*^9, 
  3.850556171368501*^9, 3.850556593131568*^9, 3.850564126489251*^9, 
  3.850564248903241*^9, 3.850567545919678*^9, 3.8505730856858573`*^9, 
  3.8505737165676312`*^9, 3.850913176467263*^9, 3.85091858704643*^9, 
  3.851255515638445*^9, 3.9575759515990715`*^9, 3.957576086890831*^9, 
  3.9575773549090595`*^9, 3.957580057932876*^9, 3.9575801501402645`*^9, 
  3.9611186558471794`*^9, 3.961119050413542*^9, 3.961412670842801*^9},
 CellLabel->
  "Out[148]=",ExpressionUUID->"f13281aa-faa7-4b12-bb73-f832d574037d"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"(*", 
   RowBox[{
    RowBox[{
    "coordinates", " ", "of", " ", "the", " ", "vertex", " ", "D", " ", "of", 
     " ", "a", " ", "cyclic", " ", "quadrilaetral", " ", "ABCD"}], ";", " ", 
    RowBox[{
    "assume", " ", "that", " ", "D", " ", "lies", " ", "on", " ", "the", " ", 
     "arc", " ", "of", " ", "circumcircle", " ", "of", " ", "ABC", " ", 
     "that", " ", "not", " ", "contains", " ", "B"}]}], "*)"}], 
  "\[IndentingNewLine]", 
  RowBox[{"ptD", "=", 
   RowBox[{"SegundaInterseccionCircunferencia", "[", 
    RowBox[{"ptT", ",", 
     RowBox[{"{", 
      RowBox[{"ptB", ",", "ptC", ",", "ptA"}], "}"}]}], "]"}]}]}]], "Input",
 CellChangeTimes->{{3.957576116748625*^9, 3.957576156811014*^9}, {
  3.9611196907192764`*^9, 3.9611197811357574`*^9}},
 CellLabel->
  "In[149]:=",ExpressionUUID->"d4990506-4c5e-3c4f-ae15-03b45e912fc7"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{
    SuperscriptBox["c", "2"], "+", 
    RowBox[{
     SuperscriptBox["a", "2"], " ", "t"}]}], ",", 
   RowBox[{
    RowBox[{"-", 
     SuperscriptBox["b", "2"]}], " ", "t"}], ",", 
   RowBox[{"t", " ", 
    RowBox[{"(", 
     RowBox[{
      SuperscriptBox["c", "2"], "+", 
      RowBox[{
       SuperscriptBox["a", "2"], " ", "t"}]}], ")"}]}]}], "}"}]], "Output",
 CellChangeTimes->{{3.957576147247395*^9, 3.957576157447836*^9}, 
   3.9575763242565155`*^9, 3.9575773580403376`*^9, 3.957580057950884*^9, 
   3.957580150153263*^9, 3.961118657225003*^9, 3.961119053750889*^9, 
   3.961412670877512*^9},
 CellLabel->
  "Out[149]=",ExpressionUUID->"cf2f0efb-76e7-4125-b536-0028d1199333"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["Support routines", "Section",
 CellChangeTimes->{{3.850468990902514*^9, 3.850469001252577*^9}, {
  3.850469071318833*^9, 3.850469073637095*^9}, {3.850469177050805*^9, 
  3.85046919499736*^9}},ExpressionUUID->"fc2fcd82-4d50-ec47-b5a7-\
8944aef04ea5"],

Cell[BoxData[
 RowBox[{
  RowBox[{"(*", " ", 
   RowBox[{
    RowBox[{
    "Rule", " ", "for", " ", "replacing", " ", "powers", " ", "of", " ", 
     "S"}], "=", 
    RowBox[{"2", "[", "ABC", "]"}]}], " ", "*)"}], "\[IndentingNewLine]", 
  RowBox[{
   RowBox[{
    RowBox[{"S2", "=", 
     RowBox[{
      RowBox[{"(", 
       RowBox[{
        RowBox[{"-", 
         SuperscriptBox["a", "4"]}], "+", 
        RowBox[{"2", " ", 
         SuperscriptBox["a", "2"], " ", 
         SuperscriptBox["b", "2"]}], "-", 
        SuperscriptBox["b", "4"], "+", 
        RowBox[{"2", " ", 
         SuperscriptBox["a", "2"], " ", 
         SuperscriptBox["c", "2"]}], "+", 
        RowBox[{"2", " ", 
         SuperscriptBox["b", "2"], " ", 
         SuperscriptBox["c", "2"]}], "-", 
        SuperscriptBox["c", "4"]}], ")"}], "/", "4"}]}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"sustS", "=", 
     RowBox[{"{", 
      RowBox[{
       SuperscriptBox["S", "n_"], "\[Rule]", 
       RowBox[{
        SuperscriptBox["S2", 
         RowBox[{"Quotient", "[", 
          RowBox[{"n", ",", "2"}], "]"}]], 
        SuperscriptBox["S", 
         RowBox[{"Mod", "[", 
          RowBox[{"n", ",", "2"}], "]"}]]}]}], "}"}]}], ";"}], 
   "\[IndentingNewLine]", "\[IndentingNewLine]", 
   RowBox[{"(*", " ", 
    RowBox[{
    "Rule", " ", "for", " ", "replacing", " ", "Conway", " ", "symbols"}], 
    " ", "*)"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"sustC", "=", " ", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"SA", "->", 
        RowBox[{
         RowBox[{"1", "/", "2"}], 
         RowBox[{"(", 
          RowBox[{
           RowBox[{"-", 
            RowBox[{"a", "^", "2"}]}], "+", 
           RowBox[{"b", "^", "2"}], "+", 
           RowBox[{"c", "^", "2"}]}], ")"}]}]}], ",", " ", 
       RowBox[{"SB", "->", 
        RowBox[{
         RowBox[{"1", "/", "2"}], 
         RowBox[{"(", 
          RowBox[{
           RowBox[{"a", "^", "2"}], "-", 
           RowBox[{"b", "^", "2"}], "+", 
           RowBox[{"c", "^", "2"}]}], ")"}]}]}], ",", " ", 
       RowBox[{"SC", "->", 
        RowBox[{
         RowBox[{"1", "/", "2"}], 
         RowBox[{"(", 
          RowBox[{
           RowBox[{"a", "^", "2"}], "+", 
           RowBox[{"b", "^", "2"}], "-", 
           RowBox[{"c", "^", "2"}]}], ")"}]}]}], ",", " ", 
       RowBox[{"SW", "->", 
        RowBox[{
         RowBox[{"1", "/", "2"}], 
         RowBox[{"(", 
          RowBox[{
           RowBox[{"a", "^", "2"}], "+", 
           RowBox[{"b", "^", "2"}], "+", 
           RowBox[{"c", "^", "2"}]}], ")"}]}]}]}], "}"}]}], ";"}], " ", 
   "\[IndentingNewLine]", "\[IndentingNewLine]", 
   RowBox[{"(*", 
    RowBox[{
    "central", " ", "quadrilateral", " ", "of", " ", "ABCD", " ", "wrt", " ", 
     "a", " ", "point", " ", "E"}], "*)"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{
     RowBox[{"radialTrianglesOfQuadrilateral", "[", "ptE_", "]"}], ":=", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"ptA", ",", "ptB", ",", "ptE"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"ptB", ",", "ptC", ",", "ptE"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"ptC", ",", "ptD", ",", "ptE"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"ptD", ",", "ptA", ",", "ptE"}], "}"}]}], "}"}]}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{
     RowBox[{"centralQuadrilateral", "[", 
      RowBox[{"n_Integer", ",", "ptE_"}], "]"}], ":=", 
     RowBox[{"Map", "[", 
      RowBox[{
       RowBox[{
        RowBox[{"Simplificar", "[", 
         RowBox[{"CentroETCTriangulo", "[", 
          RowBox[{
           RowBox[{"ETC", "[", 
            RowBox[{"[", 
             RowBox[{"n", ",", "2"}], "]"}], "]"}], ",", "#"}], "]"}], "]"}], 
        "&"}], ",", 
       RowBox[{"radialTrianglesOfQuadrilateral", "[", "ptE", "]"}]}], "]"}]}],
     ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{
     RowBox[{"centralQuadrilateral", "[", 
      RowBox[{"ptX_", ",", "ptE_"}], "]"}], ":=", 
     RowBox[{"Map", "[", 
      RowBox[{
       RowBox[{
        RowBox[{"Simplificar", "[", 
         RowBox[{"CentroETCTriangulo", "[", 
          RowBox[{"ptX", ",", "#"}], "]"}], "]"}], "&"}], ",", 
       RowBox[{"radialTrianglesOfQuadrilateral", "[", "ptE", "]"}]}], "]"}]}],
     ";"}], "\[IndentingNewLine]", "\[IndentingNewLine]", 
   RowBox[{"(*", 
    RowBox[{
    "Steiner", " ", "point", " ", "of", " ", "a", " ", "quadrilateral"}], 
    "*)"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{
     RowBox[{"SteinerPoint", "[", 
      RowBox[{"{", 
       RowBox[{"P_", ",", "Q_", ",", "R_", ",", "S_"}], "}"}], "]"}], ":=", 
     RowBox[{"Module", "[", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{
        "X", ",", "Y", ",", "Z", ",", "T", ",", "U", ",", "V", ",", "W"}], 
        "}"}], ",", "\[IndentingNewLine]", 
       RowBox[{
        RowBox[{
         RowBox[{"{", 
          RowBox[{"X", ",", "Y", ",", "Z", ",", "U", ",", "T"}], "}"}], "=", 
         RowBox[{
          RowBox[{
           RowBox[{"Apply", "[", 
            RowBox[{"Medio", ",", "#"}], "]"}], "&"}], "/@", 
          RowBox[{"{", 
           RowBox[{
            RowBox[{"{", 
             RowBox[{"P", ",", "S"}], "}"}], ",", 
            RowBox[{"{", 
             RowBox[{"P", ",", "Q"}], "}"}], ",", 
            RowBox[{"{", 
             RowBox[{"R", ",", "Q"}], "}"}], ",", 
            RowBox[{"{", 
             RowBox[{"P", ",", "R"}], "}"}], ",", 
            RowBox[{"{", 
             RowBox[{"S", ",", "Q"}], "}"}]}], "}"}]}]}], ";", 
        "\[IndentingNewLine]", 
        RowBox[{
         RowBox[{"{", 
          RowBox[{"V", ",", "W"}], "}"}], "=", 
         RowBox[{
          RowBox[{
           RowBox[{"Circuncentro", "[", "#", "]"}], "&"}], "/@", 
          RowBox[{"{", 
           RowBox[{
            RowBox[{"{", 
             RowBox[{"X", ",", "Y", ",", "U"}], "}"}], ",", 
            RowBox[{"{", 
             RowBox[{"Y", ",", "Z", ",", "T"}], "}"}]}], "}"}]}]}], ";", 
        "\[IndentingNewLine]", 
        RowBox[{"SimetriaAxial", "[", 
         RowBox[{"Y", ",", 
          RowBox[{"Recta", "[", 
           RowBox[{"V", ",", "W"}], "]"}]}], "]"}]}]}], "\[IndentingNewLine]",
       "]"}]}], ";"}], "\[IndentingNewLine]", "\[IndentingNewLine]", 
   RowBox[{"(*", 
    RowBox[{
    "tests", " ", "for", " ", "parallelism", " ", "and", " ", 
     "perpendicularity"}], "*)"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{
     RowBox[{"parallelQ", "[", 
      RowBox[{"r_", ",", "s_", ",", 
       RowBox[{"cond_", ":", "True"}]}], "]"}], ":=", 
     RowBox[{
      RowBox[{"Simplify", "[", 
       RowBox[{
        RowBox[{
         RowBox[{"Expand", "[", 
          RowBox[{
           RowBox[{"PuntoInfinito", "[", "r", "]"}], ".", "s"}], "]"}], "/.", 
         "sustS"}], ",", "cond"}], "]"}], "===", "0"}]}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{
     RowBox[{"perpendicularQ", "[", 
      RowBox[{"r_", ",", "s_", ",", 
       RowBox[{"cond_", ":", "True"}]}], "]"}], ":=", 
     RowBox[{
      RowBox[{"Simplify", "[", 
       RowBox[{
        RowBox[{
         RowBox[{"Expand", "[", 
          RowBox[{
           RowBox[{"PuntoInfinitoPerpendicular", "[", 
            RowBox[{"PuntoInfinito", "[", "r", "]"}], "]"}], ".", "s"}], 
          "]"}], "/.", "sustS"}], ",", "cond"}], "]"}], "===", "0"}]}], ";"}],
    "\[IndentingNewLine]", "\[IndentingNewLine]", 
   RowBox[{"(*", 
    RowBox[{"tests", " ", "for", " ", "a", " ", "parallelogram"}], " ", 
    "*)"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"parallelogramQ", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"ptP_", ",", "ptQ_", ",", "ptR_", ",", "ptS_"}], "}"}], ",", 
      RowBox[{"cond_", ":", "True"}]}], "]"}], ":=", 
    RowBox[{
     RowBox[{"parallelQ", "[", 
      RowBox[{
       RowBox[{"Recta", "[", 
        RowBox[{"ptP", ",", "ptQ"}], "]"}], ",", 
       RowBox[{"Recta", "[", 
        RowBox[{"ptR", ",", "ptS"}], "]"}], ",", "cond"}], "]"}], "&&", 
     RowBox[{"parallelQ", "[", 
      RowBox[{
       RowBox[{"Recta", "[", 
        RowBox[{"ptP", ",", "ptS"}], "]"}], ",", 
       RowBox[{"Recta", "[", 
        RowBox[{"ptR", ",", "ptQ"}], "]"}], ",", "cond"}], "]"}]}]}], 
   "\[IndentingNewLine]"}]}]], "Input",
 CellChangeTimes->{{3.954755422028537*^9, 3.954755444302299*^9}, {
   3.954755510189615*^9, 3.9547556654655304`*^9}, {3.954756246303211*^9, 
   3.954756258310093*^9}, {3.954756539544531*^9, 3.954756557385113*^9}, {
   3.954756592197891*^9, 3.954756630631082*^9}, {3.954756965437847*^9, 
   3.954756984534746*^9}, {3.9547570451409245`*^9, 3.9547570732294483`*^9}, {
   3.9547571716004887`*^9, 3.9547571856117535`*^9}, {3.9547572771795826`*^9, 
   3.954757312322375*^9}, {3.95475745528866*^9, 3.954757469730625*^9}, {
   3.954757619426098*^9, 3.9547576217454853`*^9}, 3.954757823439115*^9, {
   3.954758024281746*^9, 3.954758036096319*^9}, 3.9547580746525097`*^9, {
   3.9547582109077053`*^9, 3.954758249530725*^9}, {3.957580088291739*^9, 
   3.957580130173944*^9}, 3.9611194587859135`*^9, 3.961412651732005*^9},
 CellLabel->
  "In[150]:=",ExpressionUUID->"c44d3c99-d821-aa44-a5bf-67b591807924"]
}, Open  ]],

Cell[CellGroupData[{

Cell["Properties ", "Section",
 CellChangeTimes->{{3.9464385601246834`*^9, 3.9464385707657948`*^9}, {
  3.9464417172462025`*^9, 
  3.946441726397751*^9}},ExpressionUUID->"2609bf4c-7f5c-314e-a744-\
f86d4be283dd"],

Cell[BoxData[
 GraphicsBox[
  TagBox[RasterBox[CompressedData["
1:eJzsvXlYFMf2+N3D6wJPUF/0q1eNikpA5IIawIXFK7jgirghiuCGioKogAuu
uBOXYPSKRsUNTFTUiLjhhhuiUYkRjSAShQgRDHhlFJSBaX7TVT0z3TM9Mz0L
gsn5/JEnDjPd1dXnnDp16tSpDlPnjpphRBBEuLHkP6OmLHIPC5uyePT/L/mH
95zwWYFzpk8bPGf+9MDpYb2m/n+SD29Jvusj+R/q/6sBAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAA4LODLHp+7VjCqYwcEVnbTfnb867o15PQ1dyI
ch6eSjj2sOhDbTdELWRl4bVTCZevFn6s7ZYAgEpIYfr1hE+oTZ+H8gJ/b17c
Wt99lEdzC4JCYD+ks4OD7aprebXWHpHw1w0Lrr0Sc/+1vCBpxNABHft0EMha
a4MYMKCjS4v6jYcuDU97pVqhSFHhyaOr+/r2NJb8trtrp57NezqsP3dLWFVN
5j/a7up+5hW/RlaUXJkwcmgbB1OCaBsZ+x48k5qjsvTGZLqrWy2OeatCLv6h
UMo71q2xpG/qLbjyZ223RiWl8RsHdBpkV48gLG0Tcg2oLaTw/O4F17NVXJHM
j57/n84je1KnqxKmDm2GemJb4eBAfSiwHzdw98/ZdXNaQeY/3BIZX1ip/ksG
smb8qcXBgrq1J7YDBGE0JzlX5TdFpbd9B1Bfa9XYbZRNr6XR+SJedyCfXlvp
iLWp/rIbxYZquErkyiuYfPxRnRRDXhRETiQ4sbBJ+KO2G1cXyDw/8/8sNyaf
/y338eM/X1fq+6ZJYdIe7xb2ifkGaZyc97HL29YJf4YsPbiup1HDDffUxgsK
bq9sRhBOA6+WsD6uvJcUbEaYDvW6+ZrjMUQZqdGODkZ9nb49deqV7PLCgutT
Hdxjb54d7i6YEJqjTZiiKvG7bgLC50j656u/nwviy3v71YOu5kScGeRBtLc8
9KJu983HP4/aE4RXQEaZwS5Jvkhb2Yqw2JSgzlciP6R6tecY1oUFP/WxJtq2
WHkzr851nKg0dbQT4eZ9553qrxjamvGnFgcL8kacZ33Kv/CKS1N18/KknV6N
JG/cKPD0U+0bWPWL39efUpsoD8qs2fbH/PzUuszre1HNke+nVm7/geDBSzWC
wNPZ/K9G5qRFtjGtAQdbnBHgqmF6pRmy6Ojm4MRb5fpoT9GjbZamGrsFmwLT
kKiiKoU/VKT7O0u61WPvVVbEiBTl7/tuXCOBe2RUdqlS+0pz4+3NJL9y3Zlc
pfg3tY2NChQIGm35tUKbH9Ul/nq8raPgqyUxJVo9dm1QHD3HyOgTmUryadqq
8OhsrexYLfakqORMbzPDOldawPngH17fWh58Ivst65u515eYGdRzEH94OGO4
xFhw2AEm737fZ00Q1hwT54qTW52MCMI7KLOOrcWVJ+0Y0oC7zRQ1Y814U5uD
RXH08J4hqyRDqkrP/82znSNWrLBvRbRqtTtTfSCVi4rXJ3uaEoP8fnmv9U81
wmFYxO+vDm6rHM34LAEnUAUf4te2V+0CWk4Pfvg/3mqAp641EWX9UHDUwVRH
rZHx5vE2c8IsPLpYZ9NDirLnT/yyARXIVx/zKY6ea6bs6SFwaJrdDLL0h01u
9QXuG+JUjdGFUTPNtF0CwPrr4HbhLy1+VLd4nblviMu6K4/q5oqYnE9qKtEY
19XpTKE2P6rFnjS4c6UVXA9edW6ni5Gik4A+NGQsV5RycHwTC8pYTInIUzM5
yEwONlXh6aUfn9CQ0Ppd1zRvcmLtLc0l3il3PKpmrBl/anGwID/emWCz71Li
NBNVnj9ZuHX0+iu3NrcmiAHed0q1bxjSpppJO+EyLKgfNAjw5wI4gSqgfBLL
5h4jbdiM8mjeQTB40IU/eE9BJQ5ShKez5ahWNeEE5lwJb6yr1kjB0Tk1UXrN
V0g/2cP/u+QgH+oR1SzxYJeA28qhpTGJXd+U8FHaDlHaiYDGhKlPQIZQ5a0r
EzY0tNByLCh9+r0FQdTYmgsgR//5BX9w4Ojzea2cHletQuaEehFtzfc/Eyt+
aGq4sHl5wU/9HePOHBzTQMOgo2btkl6m0c/uGRoyf52HY2zKXluJGePIiqkp
a8afWhwsSp/+18X7Tj5yNri8ejI7ZeSimL8yqIvrZi6wSOgziqmEy7Dgfvh6
66k6vxTDA3ACuan6xa9JQJJiZgL55Np8a7t9v73l/hEHpPDYJqvAyOzzmyxq
wAnEk3Q9B1l9F+wqSi4Ms975m6goKlDDFgDsfXFmmBc/3tZBYvFbfnv/Df1J
+Z8nXSwJM7NVt16p0Wvyxn5zLy3H/YzTkglp+3XxH+p4GO3zh7x/ws+YO/Br
eFDgqMaW0gwOmR85WfAv/cIyhoVzebqy9GK/VgYMm5dsD7bekyJ6Qemg2svi
WSFX4j0pypg2QPKn/tsSy+qMCpNZF/2dgjJL0aKk8mafmrNmvKnNwSLzjGtY
zNuPeYfsCMJ1+E2F8VNcdi9k2E9/kHidSDdHDo0+DdbcVu1h6wyXYXkbs7BV
3d7SpQVaOoFkSf6t1Rtn2LZp07tPHysLizEDt164WkJLRNXD0IEoVmaBpkKV
5KucsyFh45wmejRv2NDdftGxZKGkH0XvsnduC3afNMaip7FNu2kbo357K3vn
+l+BovJ5xtHJU4Y4ePaidp62b963Z/j2b+6q2XmqTGXphUEd2TNiSV9lxfYw
j0hRtaONq7tyUhf2HJLyiqxMqAknEE3SddUaGn0X7MjSg8ust1DWmH7GwMgC
FcMadgk4kqCoYOmUrwSC/tFHS6WaVnZkU08jwtQv9Jlakyj++ZjfT/e18jFQ
hKFORWD+tkhM5b8EphvufYrpJXqtn2RvoEHAzlWdimVxLk+/ure+pcHiq+SL
tIVOfuml0nFHjT3Ea5dcifeia4f9GhGmXmPvlNQZF1BUetPHeiM1ga28401Z
wYknHjP/XnPWjDe1OVi8jw3tfCidFCOZV3rpogsx/Q+kivA+IN22WuCG1Ux6
AIdhIT/+PLarUsz8s0UbJ5DMf7SzmyXxte3O+3nUbllSlL91ee/6srGbLH+Z
//SHvQFUtkfDby7c3zY55PpL5J/hOI+pyYILzx8s9fn2xqNysWxCR1gvi5HO
TfS/QnX1x6IzbpaEqfGk40ibyMqShJgxEt/Dzf1Mnh5pxBVvbo5pNTQuVQsB
FRb81L/TpntFZHV1jTiBeBzhsVJD+dLBoT2sHYIXL5vlaLfkEpUIVJa408vW
1RXVf6CLMAwcfPoPLaW66NFml8FX0ZZeeo1GdaI7Xt9RDBW+K0oLndPTuElA
7FF5ITL8aIRg3OH7hjb0KMHDzCw0evOYbs5hwZMsBnolsxf3hakXtw50s/QZ
GDo7yN5tRLI2S/+FRw8EWVtMWrJsYg+XAzduHwgMuU7XzCGFSTsHdQuc2KFV
xMVHopLMH4fbDQxetKiPR8sZobzzS0nh6dhxveeF2LYY+8MtpihKXnGi32gr
74GhoRFTu9guvchOciMr8+N2zu5iOSZs/vx+w819/a68ZD2Uhp9T064ds7va
+C2aPdtzkoO//2XGz1V2FzaVStEeTmmUX+3G2bU9rUaHBc32nGbjyaPz/3zw
X1cbGxtUsQFVlrCxsQ07+4ikrNM8x7Cdm5xbjt518c7GtS7Dhm/evW+BuZHD
nEVP3qnsSepxM3/e09/CYlLwgr4O3vtvpq6euPEGPfVDFTxsp3j1aLVie36Z
8LfVoXZDPcKCQ/5j7hD7sEjxLUpke/5sC1ensOAx9mFrrpza7r8rgc4HQ86V
cthcJ9mjnsWrxwzWs0gmVpEBVmHrXnxErV43818NWm1/+J5DhMRl6SEjbWxw
EQ+6dpOsOgdW6q6R+87N8LX1mxo22LeNh6K+8EX84eFMu9AUtKUXLwqoGfGR
R6ooPEi/ZrU0cggKSiusQ3tCypO+s1sRi94sndbCChzVoDXjTW0OFuJHM6y2
PhLRG3gV2lBecGzCtPS3UpHQLeaMM/Tc3TYsl0hpWJiThf2amHymv40tGDaA
/QfarWb/lRNVhqVa2lR3zx9+2kINIhFLx7U3j7zEkVes+1DyKeHvBFaUXPCg
djcM+D5Z/rAfC086mRHt2x94Ko3+0Bes5zHVN7lQ9j16fmTmbL4mRR6BoV0j
hfeu5xWwPDCT0+hUNMJ6ZWypbp47KXoROd1Y4t7w33lEip4t6d79EG2Ta8QJ
xJN0TVojenBpURsTv11SFyv3xsI28hmTXgmB1H6QLiNOStdrcLa2SkHCe9MI
s6FOi5d5I8JCB87s31ggGDzwxFN2aRicvlITUy0cYSCMxsYcoToE7UoWyGbo
lOewpHNT26236Spk72OXNQzjt4Ai/e33vyJn4Eny7EaMRxDmxPZwOfNKTM3H
HTqPmO51HD8yVTOH7+hAZl307hOaXUbmRfiw9sF9KDrjbjrhyD1UyIgUJsYM
asGQCpHw4Rw/kwHSRFZq6tRf4BuUyfPnwoLk0f2aTKF3QpFPrkd2bGi1BSXD
qO8unEvDzp3WII0Z52e2tj2Ug9opevdw5pgGi/hleivn7by8FdHV+85bLHUC
99Xb8yVXfZv1vaVA4BPw8KmKnpS1cP95atGhovhMn1aM+In4WajFtPOvxTfi
hjUwGRfYZ+5JqrYbKmbSTjA1Ipc5wEr6zbP7F2FR2F9GOf+E6cxI7FxhvWPt
ttBV9sjsqzNdAjKE7GdBZtCUbhJZuC3CwYgKT5G5qh6cMyEQr7IR7f/jsDUN
taqcWtGzXR+vwzqsKGVvl1lRdOU3XHaGK3cOg9cuCYs201dgWxEYOHLBpPb2
gtYtFiehPq87vMnZ7dLjpNQjwhvcWKnRNWfN+FOLg8WHgsP9BqWg4CHqHNYq
avGOEeOuoHkBytKRKYhW0GtMlpabsZS+/nVzG8GIg7fo7qY0sZfJ5Gm38Wog
5Q80nM1zJYgz0xg1lWjfJGA37iikTW7Db/6P2SY9hpJPDG8nUHwtzrMBoTSV
QI/P3O8pvSAzw1/mwiksf3C7RnpeQeKwRUc4uA8+8axc9jW6KKKu+8fJrMvh
TbUSfioVsFNIlCxeUhNOIF1uRb3W5N5dby5oFBjxQtoSUeoPAy0kgyN9DX0S
k6j9IF6SAUX6b1wDUNUzYm1S3JtGCn++tqt3T+Oh7nEZ8kAKHVRUzh7RHxRh
MGN0CCUbtH3G2/eMJiXco8tCkpUvlvg025DAZ8grP79njDHjt+zqauLLu9ss
jHlbheYjbVtG3ZGmBqFO01AwjQZ7IC/ISsnMqxHT5RBfjnUzkW5IrBReHWLF
dGuzIyYa/5/Vviy5OlQmbOzAWKVV93OR8P4UT4Gz+0Xpyynds+zLBrhEm6bu
Us6l0SCNKIoicxqfX1/cjGHJ1aKcfPg+bkWb6FMVVSjPjdF+9T1Z/Tprp42R
0Qy2eMgCVqVZO+ypYRTFtBnZC3gli2lCqSoongIru4Q8ukVYW2UtVMqt0ln2
yNwI69Gnnio8i8LtUOyiwZrbZSofHE+OFJL28fTZ1Hj6ifv0xB85gWpSPlRS
XvBTvy57ZUJI1wBUXDaVPRReu1TIJiWLci/PCenauM28I8k8/cDSPcutBGoq
fbHQuFzL2dT8dSO6HJCvENFlJRhdVIPWjDe1OVjkXHR3p++LO0c+9ym4M2dC
NC6sjdeJdMvpxRk+irYXe25UAer+Aivp1FJCaV68Y7Oou29UX08OZ1Yzbqrl
3EhpRyEviDXw6TWUfGrUO4HiD39cSf4DjWJ4Sqg8xGP3Rr6uIb0gW7ulLhzb
eqh3AnW/ghK0E6jb5hdS9CTYS6uyclQqoNMIZt3jmnACcRoth9aIhA+PJhWJ
ZC3/YnVaSXWV8PekSz8GLRlg6Shft9InMYnaD9Jp668Mu1b8gNrgr2rCq2Zv
Gg6auQ9KkbULd5emDfhkwa9Jz7QzrCjCwMw2x5EiKgG1uiTr+06meEJHFr1I
iz2xZdhw8+n81mrLC444mrEm2uh5ZTETYUJw8O2i6hLJFJUwmxtVyBog+NWc
rBSmLQy+/aaaTDvs3ZAVPMQP1Wfe1APnjj0XslorSj3sZ6IYusFGTKZf6n5+
Yc+wBoTztlMVyn2gqbsUc2k0SiN+F22bz9wWefJOulbRHuXkQ9HjpKSXIu48
N5U9Sb6MnGLGjFRgBZHN8fNuB0cnCKtQTUtbh8R86e/Q8hCz9gW6MqvbWS1U
zq3SWfbEZfeWBt54TZIPk6Z/IXsWNF43YjiZ5X/Ed7dNeKFShLC4sufd0lWV
oX6/vGN9TYdNkSXbgzvFnGcUl0Mrg6pS1Oi1S65sUhybNWuy9FqdqBRNZl2a
3IO14RcXomfGjmrOmvGnFgeLqnNbbHfTThT2h+k5r+SOC4YcpH0zbId1y+lF
v2XuN8Ryi4Z7bMGQJpLC9Ltn1+1Y2NXc7+B5nuaFK6sZJxQ13fJAGlHCPcMM
MekzlHx61DuBEtPRA9e9lPpgZo3HLfJmsGyx01AzZtnPOuEEkuWP7idGfrds
kJfDWDe30YtDbRx0dwJfpkWqz2FWgJEKqKmdeqCqnL7kLw8TB3VBM3qsC3hJ
xd9v/a6o47fZY6uKxCQ+ty89uNLcXHb0m+xEJ5VLPB+PbrQTqLgXvTYk36xB
LwZpCDiIn4XbLLmlVY4yGhxbM9xUHABBdb3o3XN4tXp+0LYfY66/4Dq/hAv8
W+bToedV3D6GXT6GC0rmRoxjtUczKFzG9ECq8XqHuykdzmg4JEqa8YJLcJsi
w65wBabkqPq5uCx1hC3L3Ck9suruQndhpmprlEa8GvUl3RDCuh1nmg0HKpIP
pY1UtQlIqSdxC5nX4VQQ7PIxgirY5ZP7M3Tlc8bbV2ghugJzn6Y+sodvQAnS
v6XPouC7Ssi9FtJVlqzLIUKc4orDR0zP8H3cmn8LtB6pyRe3lneSHf0mq7Vl
obhsKkPt2iVXQdFaQlR6c2y3Nh7M5xpAn4zJGGtqzJrxpjYHCzIn1HJpmtRL
Rgup+N2JUg8Ols0LsB3WbWcH/i3D66ZXhymvm66PPXjO6KlTvUM3Rhw4rTjP
Vdt2LsOCl7SYzjDyEJgzTb3V+dOi3gnMuRxsgT+nE7o0uzG17gQKCy77+nwl
EPQJnXX2yUscjNUnEojsnjbBfJwapxYViyDagHNTuUrTF0b5fbkLzbxwloXq
svxKPglvGPtB5ND5z5xjLl7fUXEvrFbMQVNNnVjZFV/cmufGSGzjA47AMLeu
4PgkuhGKdWt3EIysLSgpghVgpMZZxWI4SuspOH6o1cEHVLoL0WpBdLHSgCLK
eXxm494VXRwFApOl19Hho5y51u/z4ruYKrqRan6uYjOghu5SXl7UJI00pKjw
yqWjoevHNTUlXAde5eNuKHllsmtx5rnRKPUkeefwmAas63AqiNIKEfkycrJR
M8ZrVT7qgt1C5TUmPWQPQfW2QL68qzReV5zc1G6D1JfjECFOcVWqgyEuu+Pj
pHXqPnM/iOLFuX05tWuX9EpxXTiNmrEfhAE2KUx/poasGX9qcbAQlZwe7CLv
Cjy4Sxy2d4WnfMffLJZejGGHtQZF+5lBTixalH5Vooo9qg5w0QinYUFNZYof
2vrNmkDpq86fGLVOYMn2BSbjaAebTq7QuIO7lp1A8bPQEdSBRL4shdLDCaR3
e6n7bfmbJ2dPZZaoyyahG6DsQpOVJXdOncp6qfXZxDg3VVlrSrJ22rSmxyPk
jqrON2P5JGTOjYmrlAwa9+9E2fO7+p9RPt6RXuLhcHFxCTIVxepxxJ6VuIV3
IVlYHfpdhaEXCe/P6L4yTV3RLQ5QyJGpv8hcGE0+kUHS70jT2cfcIOFkqobc
BSLzt009+hw9Ne4ExuKafFVOTK/TaeR93FobI+Skfcj9MeSbF2XCh8sCnaNi
C2VKSZlEqR8uM7nMMqcobOW0GWWniHj8XMUylobuki0viop+crNLyNMgjWT+
o/3DnSOvyusvvY9dVr8Tr8gAy6eqKLkR5H+lCP1B7blsij35kTYmjNFEpiBi
8kHi1BP3Gel8jOgo5VTTDph00R/1G+O+Chl60jWmj+TDRIexlEHTQ/YQqLdl
LVccr0nRoxkdl0mjTMoPzvbYyZK4mf4peXQYhOnMoIgHWlkTv9jkd+w5r9ww
UcrervOiC5W+Sy+bcsXH1JwrRC+0mZosuMwrsb8GcwLfPNvdu/eZfKU24qwY
pqmvIWvGn1ocLF7djXBj2B+cU+o25uyp0JEX5G8QC4NiNgJPqJYrpXBYS2wO
Sa8x6VoDmdOwoJg5I9CBl0tQ1F1W4Udfdf7EqHECqTRRU7mSYu0jBF57U9hr
NGTpwcjWK6Qbb2vXCaQXFtnCLK0ko4sw0NEt1b+VbppWSj5nocoJLNm+iLJR
vG2aDJzWpVjxWFz+JGSs0WipsqMIv8J3JKPtf/t5pRSzczyotNUuvRIy+Kig
KO2wy8wozgRjjp1xGFzwgTOf5HVWrL0lK/kc3wVVA+u+hsvUSFyXcPeRx9O0
3kZGPXK91hulzaMCcUZGk+m9LSiGr1BulBQm7eiueVM5ik4wXq4o5aC3MRqU
K/LinBxP4pibYn4aWsKzQsbqybmx3XjMgrHBGUSlaovObuuwLLY0lzLvlqHy
10E+PD35/6T7EfDgzlSZijcpno6CIV50wmqGlj+vRpt253ZfeO2t+u6SrsP+
WZ1zabK9fL1JlTSi05yNZyTJ4wyFUYH1Z0a+5PGOmXk7otT4LhOlv1JzLpty
T4ppV01udt7k7LPDPqR080U1RzofcqrRPKKq+EzfNhKPkY4EyvqNzraSZRbJ
T6F6GxPSBqVL6SF7CDSCy1qOjANjDCq4u7yHdOrB9eCshMDS3IMuXY/mksoH
67yPW2NVz+ybu6XVxY+3dOUXDyzN+3Gg60nOWiKqignQu1G4EgLFH56ET/5K
wMzJryUkBnOVS/+TXGExro3Pulsz0buso3vT9auHU4uDhfjy95bfMFw7Otuz
wZfBSxhvEEd3da3dSkmvvLfJe8f9TYx8DuGtOkjXFFbxaAv2SuOFuQwLCgox
FxfQzIiaU4slbsaXIZcpX1Rfdf7EcDmBlUX5Gft/WNBBMWdD9ODy8o4WhKXF
2ivp5fhZKstfHor1dhgsL4BTy5FAMn/drK8EjKqAZGXJT9vHj1/lY0wQXe1j
76c/L3ytRdhN6lWqdALxvI9Q3jfNQoUTSIfOJGiXa00nHbG0hnyVc27qjK71
GDNoUpQd7mM0Ql7ZRnjj7PLujjseIG8V6yPqT8qv843I5nGQvSjz7nddTeer
qJSOH1N52BWd3elej6sq2o1zq60tibYtQo+nKGXqkoX7Nno1Mh6zIepBkaz0
nOjVqZ/W9HFcqethr0WbQ0wmo1UzhcIp1XjQN+orq4AkepcdvcrOn9ch0eJr
B4cZ09Eh0ZPUVfauvRpIBDiXTDtkHUhvA1HKT0Nvf0pEXoWqyKoS1CHpgtaS
7hXhU1oqqv96FO3Y94KskpKwIHm4+UhG4TsqmG/pfBbHGJQfWaufIxk75WM3
dA9Kq1bbXcihorbbFEdP67gbTRvVSmPF6W0dF8mrfYoeXAq37hL/VL6jWQ1v
YxbUa400S+JyeHSX/Upxzq6uJ9FPhL/v6yxw3op2wbwrujFxoq2ZGaUg7xme
vNJBeFWJW6waUjmljJAXtR4hGIL8LrKyMH4rVadUvoqKhjyJPflfyen+HXfh
W+she4otL8077NKlRX2jwNNIokTC+wF2sy5IQ6ycD46cQMreUr7NKFzYCodB
mKtslKPuIhlPyZJdoXasXR4qeFd0O3CCaYSKdVvsBConG+CSsFzlJU+NpfJ8
3JdEKpwO8KkhRYU/xIz8UoUbTA8ZCgl4Olkzcfn9iQNM9UyArL3BolpUmjra
rO9B5t4fNI63N6fFHoMLzelcQoeqDGwyBu1yQqWMTXqtQvWgcBNS4kaZttz+
qFz24HILpgkOw1KB5sXMxQVqHi3x9z5IKzWhD/VU508F7ZZoQnGTfkl+6obt
Yc6e/27TbqBXt/8Mcg7bHfO4GDvhUj9NBvJ5aD+NAWVthFLnUwYlYPpfAXX4
97vDnEbamzZ2G2XrPWP4+rO3hJLhb9XisV1Q6u6siCdazKvI/I1z/92wie+B
89ybu0lR/vY1Hl8w0umZvFZqpKz9CORXN2w4gnf91fKCpBFD6dxjaWVXeTay
BGbNxmpqWL8+w9d8pEdY2IJJDrYT1kUyT04pv/SDr7nlrPAJtjzqFZMPzs23
pu9i6tBm5rE0pmAIj24daU2VEqVApTUnJ6SJybL0kFHSDSPSKqM0qAinZYtJ
36xIea4yaVaUkRrjNc3JGD1p5wEtrCyCN6+6q8+8WOLnjLHqM2tpmJOFxbzw
NPY5MpLbfdvTfPi8oNmeAf26Oi9LSCzkGdGnxGCZpaNTWPAE2ykB11+WPgn3
buE9w79n3+PP6VtQY6ij89k/5c8quvbDiHY2c2c5eMfy3K1Glhxc176P09xh
Dosu4IGDFF46Nq+bzbTFgYEjQ71sHNadY1dRk0j+UlSveHFEgJ2lT5TC8Tq8
f750yZzebpZ+Y+PvZ8sGLHXdVfHmpm+3Nr6TnWeEPHwrdzJVSqNI+NvqMFvn
PnMWzQ/zGG01YcKpbN6p1K+zDjq39AheOLab8x5GxWaqw+0ducNQHD2JWvHg
0hJbi0mLFo3t5vTtjT9Kk/d7SV7QDIcAWZg6IyngC+M55xjHBr3Jie/RYmRo
kEMA60mTx9hbTAoNdbEdGrrE5wvWOE7mpK21buM723n8Xvl711320CWF536c
bdHGFxf4vfD7799/O/LLdtOWLpnh7BDyI7OgCteDi8ufLJrUctjYOS62Ew7Q
TapK/M6ari8ta/at5RbtpoWNdlgpH2S5kZgprzFY6ylrsCDyGfP7eXe/dUbq
T0iN2DzqC6giMb1hRFqeF+M5tI29QNDQZcbYuNT7tVokkMyPXjoYt1DSci+X
wznMkITwdqAfqrktNXcjXY8wvqC1Nat8d2e8u6B1i6VXtDimSk7tDRbo1uPo
V2za0GmMvB+Koia2iqbP+yMfX1pk7yntMdTCKUHp2u+Qlqjt4i42M5Ys8e9k
MftgAktxJJZ5/7YxlrYhyyJC3AbbTmRZMA0oGxYq5iPw2HleXi0BnSLRI2Bu
XyfWIK6fOgMAAAB/E2rwaHsAAAAAAACgjqJUsg8AAAAAAAD4+yEsOO/nPPOk
NM+/NDfe3siI3w4XAAAAAAAA4DMFJTAL+m9LpCvwKOzEAQAAAAAAAP6WvM48
6GRm5u0RNn/F7C7t+ixS3HwEAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAADw+UFWFl47lXAq6XchVEv9pyDKeXgq4djDorqYEl+X2wb8TXhX9OvJ
hITb6bV6vIVegJrwp272FWer6mZT6wRIZ09l5Oh2ICmgCnFqwkRbdGpYq1a7
Mys1/+DzhhSe3udjYRsyo7/VcvUnK5H50fP/w3GemgM6ZE1gP27g7p/Vnm7z
rujumo2zbFxa1G/sNmrowHbNOwf4JVInbZHCpJ1dwvQ4a1KZt1nfW5pynH6n
gFmz7Y+rql/cWt8dnwklmHyc64D1WqQut61uQvWY9CQvdJhX/6VRL6TnH5Ul
7h7RhBYMiQx7rozOh2p41eJnkTPok7m8gzI/x8FWfzWpLL0xeYBrJ/ocSbVH
35KlP2xyqy89NWzQ4NPcx/yphMx/tMe5ndecENseg/kevmlAPpFJ4T+yKLSq
3gLZOe+cHwLVWFxH4tPrlA+4BwwAPnt6gPed0tpuSU1TcG99a6PA068Kd65w
acjjjADyQ6pXe6Wjxql6sz/1sSbatlh5M4/DqlCHIW6f1MzoP3MDjqazDnJd
59z94OULEV8KvA4a8owq8eU9bsYtQn+QnX4ozgzyYBk9svLlqsB6HewT8+mf
UCdTm9XRUxLqctvqKJRgEwpn0GOKo+fU6+UQc4f3cZz/EHKuhDcmum5K+PjZ
dosB1OTd7/us0QxhQmiOqoNTix5vtfmqnYAwmxtVqEOQQFx2x6en0ZyoV3nX
JHbPZUdyrURea9ykaDuyUCAr3d7y0AtS04cABT7e0edIOnSNdvz1eFtHwVdL
YkrU6N6bx9vMa8DB5nNrFZBP01aFR2e/M2h7qqsLowKNWprvzyy50P8rwRCv
m681SRM2ktZy30lGxcmtTkZckQThnzemTPhXgxaLk24przSJUg/7mRCGNkcS
u9HDbENCmfzI7Ncne5oqhnbTj3m28b6Du1T8/urgtoTTwKslhmuFLpBFRzcH
J94qZ1nBOtI2Pfjw+tby4BPZ2p+zrjOkKGPaACoQuCC6mPHOyZzUhT1rI/yi
EbIiY5qHoJfbhSLDX7vi9A73BsbzL+ep+U7VuZ0uRnUv3sLdLTWmJplnXFxW
LDEnCDepZVBsjyg7ov/84NmtCMJj71UdxgfyYdL0LwivuOzi7fMlVpF71mxI
asekaD2ySBCVnOltRngFZJRp+tDQ8FGQOohkPmtkBMEB7XmduW+Iy7orj9TF
ATJOTzOpgfPT+dyaG3FGgCvR1elMoUHbgwOersNv8h+cM5ODTVWsGaUfn9CQ
UGykqPS2b39Ba9W27mPhSSczA5uj93nx3Tsd+p1hoXOvLzEjFJ6UvHPI0i+y
AHsIyO0npkTk1a4+oWYoLkXVkbbpAXIwOIJyNQqZdthbIpDWdgl5Ukl4nbWr
j2Psb5/QF+WPuPzJUl+XTXvyVQWg9KD80oG+ff0vv1Tn+hZFBQpam+9/VscW
lji7pcbU5OPRVTa7U09IJoxc81wJZMbp0dt+vuH7NWFquuGeLnPytzELWxEN
1twW6t5KragVk6LDyFJNW+m2kbHvSU0fGho+ClLn+BsEB+owH+LXflmnHGwc
f1OzQqEbyBSYhkQV8Y5Mvo9d3pbgVkkcmmatoZOiF5EzvxIIPL8/X65ShSvv
eJsbGTQhkEw71MknIrdC/glyQhQtYWXCN42/ScA+IHkjzrM+8fXWU7WbFI+b
oTD7qCNt0wMyJ9SLaPvJHQw8vyAEIw7eom4sLDg/ssvqtFewdMIBTvOo4XiL
oagxNRFnBluuufv+jrcFd0J4RcmViSOS83Ioa6zjlBxN51V4mDVB7ZgU7UeW
ahVTxVqZP34ecLr3gGFAY5aD24W/arshMlD8zXWnobNHUMBTm8sqZdbJoFff
pCeQ4s/Sk6Y1JggPr9RiNQOvpLfNzfcbMuhacX7HmNPMFpL5kZNNCUVLWJa4
cXxyNv4ETc9rfy2MM7xfR9qmO59kQYeT0j3LrQQEMdTvl7fvHs7q4p+YAXmA
3KBp5ueSYV5TaiIqSRrW98JfZF6ED8EVrCv7af2wk4/IF2g1RLcpOc5L+YS6
UDsmReuRpRpbacG/FHxvzg8BCvL+CT9jHXMSAA1Qoex/CWZG1p1tgyj+prQX
Q2+qEr/rJtBmkvWh4KiDKWf+nujaYb9GhKnX2Dsl0lGWyn92ksdhVCJ+scnv
2POa1HG8NqFm+Yb8+PPYrrUQqlKAM7xfR9qmD59kQYcbvD3E9IuZYWO77z7/
+RY/qXGoXSGfyfbzmlOT3GtTe1MrpMhHIiaeeMz6a0lm9Jjw7DJqnag9oeuU
vPjB5tafMHpTSyZF65GlWsVmzH/ODk3tkUjpvwQ65iR85lDlRAZ1C5zYoVXE
xUeikswfRjt6Bi9a1Gew2RifG69I0a9X1zrZTli4ItyhTbc1MYxMElJ4OnZc
73khti3G/nBLwYkRZf68p7+FxaTgBX0dvLfuX9FS7mCT+RnbB/YNdnJovy62
8HXmj8PtBgavmN3F3O8ge0whK/Pjds7uYjkmbP78fsPNff2uyBMMuG4tevdw
rpet7+R2vQZd+EMkvJQQ4mAftGT1rE4tJ8VJr/zng/+62tjYoD3yrRq7jZL8
v23YWb6GWpSRunWgm6XPwNDZYQMt7L5JkecilsZv6IMva9rQaQR12aDE+5ot
As6sU4iRkqLCowdmtTRyCApKK2TkVKDNhoSFFSs3r1bACTBqQrulT7+3IAh3
zx9+2jKmm3NYxNJx7c0jL3GkbgpTL0q7NMjebYR0f4GiTCIhkcikR8sZoQ//
p/l1lSXu9LJ1xeUp6No7A6V1J/RtGw9E77J37pjd1cZv0ezZnpMc/Fm5Mbo/
srgsPWSkjY0nqmOAimk42PRayirJwn1xYcH5MY6zt2yd2sF259X7P03s5xw2
a1v40gEmTQJ+TFGdV8CFdHsIMSog4702P9QBtd2oRhnJ/Ee7BzvPGD+yxbSI
bDpApJ1Eka9yzgbPtenjHLYkIsTNYfS30gw6kfDhQl/nyfOHtrM79LSc/RtK
bYOsLSYtWTaxh8vu7as711eKt+Anwjat/0C71UxzWi28cXZtT6vRYUGzPafZ
ePKSN8mT7urnMGUS80mrRTcS/O1cj7+gbo3WDgQeO89XkBzdYhA1UUPVua1W
2ynXDvkwCqulZP7GYevvv5GuhmgfRqOqnWBdICzcLPr1s+m1SF65SKV4kKL8
rfMcw3Zucm45etfFOxvXugwbvnn3vgXmRg5zFj1RPf7XlklRN7KoGyKrq1/d
W99SKRbN+aEmbeIvY5wKIrnCdlfbKV49Wq3Ynl8m/G11qN1Qj7DgkP+YO8Q+
LFLspHdFafNnW7g6hQWPsQ9bc+XUdv9dCRo3fnI0svzPky5fCUYHZMjeKVtD
D9y4fSAw5PoraUdgT54xqIkeXFzo5BQ6yavdrBXPZHHm11n7+9pt+Jm92Uyt
XkuMSaLfaCvvgaGhEVO72C69qMMWhhpGmBPbw+XMKzFase08YrrX8ado3xEa
6J3mzfEbMuP2K0q0yDuHxzT8YnUaPQUisy569wnNLkOh/kF+vzBGBNGDS4va
mPjtR65XRfGZPq3kJVBI0ZMQ6+BLxaKETeZGjboNctzxgBID8uHpaaYmS6+/
kl5C+HCOn8kAiTv3Af8qY1p/gW9Q5nuVtxZf22cxL7r4PbUKY+3j4L8yKruU
eo4P8WsaNGU7TrokBEoGkdhxTVsskb5B0dkd/zEx3/UbYyDQPq0UZ9YRFm2m
r/BGBAaOXDCpvb2gNcfOXzybNnweo/bgBBh1LUGLF0T7JgG7j6KSMuhNuQ2/
+T/mVSTWeEnnprZbb9OlRd7HLmuIUxlVyWTB7ZXNBOMO3+epQ5zZO/q2TSPC
guTR/ZpMCcauBfnkemTHhlZb0PBnmEdWkRCo+uLv41Z8uSGh7D1y3dvSMlx1
KbZ/ffXJpdyd+nbPin8LCMLWITG/Jm2Zmm5Ur4wVJcnDu+7NEiF71WjLryiT
VRuJEj24vNyiyfh9eOZIFu5a6/EFfZ2S7TO7HkgVVeQdsmO7NNLO//5XNKg9
SZ7diFA0BZIn8uxlMnkaNqfIXDScLY3tkBnnZ7a2PZSD/iSZz84c02CRpqXk
ijcpo+2++7Wc9aQ4R046VSQfXw5vThCBkQUfuLoF31pnNdEAmR/Zbe41ZPbR
Hjem70FmJY9YGksN7ng919I2IVcXceJa01ErHi9vRXT1vvMW9RIhcF+NCu5R
RVAFAp+ADE2bS2rHpHCOLGqHSFlTFaqdcH2oXpu0kbFKTgURPwu1mHb+tfhG
3LAGJuMC+8w9iYY2Kmm2nWAqK9Uc6Uj3L8KisDNbGDXTjCBMNa4hcjbyQ9GF
Qd0JC5uEP1j9z9JQphXFXoFsa8+bZ7t7u57MFZFUs+X6wiFvavVa0owz7qYT
jtyrRGZMmBgzqEVdyotDiC/vbrMw5m0VErO2LaPuSNO8X9+LkrxZB4ejv9OT
C6qHG8hC+vjNviArC086NWK9ytdZO22MjGZEvJBOSqgCSrKk39cP1ttT2lEc
PbeRwGTBZWlfodvRK1xU0YCJxv9ntS9L7mJVJmzsQIdqOW8tmU62CblcjGNr
zFVUtNbQcMM9RgRT+6V/tDhr5HMoVS6MqMGsImB4PqjFBjE0misVRiCLci/P
CenauM28I8kMPxDPl4n26+I/1PY8QvLuzNQu3+DdLpZzI6UygKyiTB/RJ6g8
rNGkBKwd1Kz2xRKfZqgKjUqZpIZswmJTAr+lbu7sFz3bpgGR8P4UT4Gz+0Xp
BLd0z7Iv6bIVBnpknEKguJ1c9cXFZamj22z+5SPOg7VeFqPPwplkdjy7x8yZ
ltT2EP7euPa3UdONGpSRngxWopIa5vQ4xb97yZcPNlkIrGS9VCm8OsSKrshB
e5IkqknCevzy83vGGDM6/+OfR+3Za5R4U7+V1M2jHikv3rFZ1N036B9Iu2Wm
4/n1xc00Zn1Q27WsA6nCeswnpccyuXhIruzeYG182SOObsGX0VVNNFH59sKw
rkdxDQPUz/IHFJfdnjksKR+1Aa+G6JjUx1HyTr14SCZEbaJPVVShrFqGgPGj
NkxKNdfIomGIpODMXVT+UH13aSVjHz5wKUhp1g57yu1BvSToH320FCsF3jnF
LBwk/vBwhqfASl58ALusGkdq7kYirbdpQe+n5tRQltSxtwnQE2eSzI0YJ+gg
vSZZke7vzNrBpEGvJW2IdTORyic2Jn6hz2o7jKOAMCE4+HYJjhIza3ViT8l5
26kKqZSiFXOpS1wpTFsYfPsNrhrBtIfky8gpZszYPk5CkEWN8m6H7DhVVqU0
tcGVUtBsAle6s10fz1QQrGiUCyrmurW0Pai2nlHg6aeyRDrKSrD3jmm99F+a
G29vpjizw7YrUFoRRfoIWmwQU5NZh8OnZk2WXpPVgamkdtgRmutYlt5KyqrR
pAYcNleXUYnmiWZNtzyQTkrxkzLDxSVZ33cyxV1KFr1Iiz2xZdhw8+n0whyS
yaLqkl83t2HJJNouLQg8nc2rndzZL/q2TT2iC3uGNWBpjRxDPTJnCWI1FydF
fyQnSWbW+ufBki9/WefU90yeqDh6XquaXBFW142alJHuyY958V0Esskp3+4l
RU+CvQSNGOLBJO92cHSCUMweFySUFxxxNGNlR6B3xIwX4SdCNo0Upt89u27H
wq7MBBgklm2bz9wWefIO32Pmyk5tDryRpzANx3abMUGTOCRW/Y+9LOXqFgqd
1UQjbx5t7Cv1E7AbIx3xRRe2DfmRHo7xaoiOCa54hxSzVZrEQ/Q4KemlSMes
2towKRRKI4uGIbJaRfBQ+UNN3aWNjD0iX3MpCNaaKuQ+MZcPkEgw9zvjClTM
h+I5UnM2krrgnUNW/iiKqEJDmfdim0cyf9vkPb+9ry5+vK0DYSq7Jm4z4xaa
9BqLt6DPvKkHzh17XrfPzMXGkJnGrNj/4rLUEbZKa53IxWK+WeVsMeReKo5Z
SrWjcdIICnMhaTGVrzvLb8QawpRuLfuQubLwXmL0TFkLl0pL/xrBRZsVNA7X
b2GaEa1zd1HPqGoJFT5lnbWE1y+UkqsVEObs6uOV+oZvE3QB23M1yzd4nsg0
lS/TIpuz+wpXmBnqtHiZt/f8oG0/xlx/oVj8VEkmkW3hX3iNM/vFQG3jBuuI
GbcLYahH/nh0o51AMYGKx8X1LoxZmvejB528gTuNMDP75m4NiJrabuSpjOgT
5mRQ9qHa7sXPNdTvFzXDDpJ/pieJO58paR+PbrI1Yg5eWHmNBs8ZPXWqd+jG
iAOnFUcEKoXmS+mxjNbt+GffoaFT/qTIbjOMp/h9yrCW2x+JVHaLrmqiuWE3
9lmuli5b4DVfLH6lufvGznhIL7ziOgO6VixR2hXC11brVibl05sU/HOFkYXP
EImlVGG/jNKHPLtLKxlTVhDZh8yFXezyySdK+KGY4SMtR2ry3nF/E1Z8/n3s
/Ha7qCgil4YqWFHUe0rmUSGmpLSGqFmv0WKxu/RYzYZDomJqomypIVCKcmM7
zOx/tCtQUf5fUzNr5gkCeMmY+a6RRCmOWehrTGuMBRjJeTnyMRRePfblmC6f
0q0plFbKkGCw48lK0qgJzrxlyfAxXmK7GOYULQFoczgyjnWraAm9UszscLwI
qzY2TpYeXNx1d0rN5p2qqW6NQZMsZsvLjmzqyT46oSgq0JRQH9NTkkk8m+N9
EqvyvMZwbVMBdo9VJIUa6JGVpjk8L65nYcwPr6+MsQtNlmXXY4tNWK+MLTX4
LiV13chPGXHzvnY+yyphqLl7lYc/ZdC4UG9u8guW4hNK1oxpwbALpLGWHSkq
vHLpaOj6cU1NCdeBV3mFbNFDyZerlMbN1w/WO0r9E65u0VlNNFIc7eJyRuZl
oYUMKgWrqnDLsIU3pS3AQTNdz5THww1zUOZpq3Urs1kLJgW1VnFkKdU8RHKm
PCn7MDy7SwsZ41AQzluTLyMnGzVjPJTyyVlajtT0iSqyd0p+vDPefBvlmqrQ
UKYV5cyxIRWjl4qRMZ56LZni5Tw+s3Hvii6OAgFj40OdAgfVmfNfXDWR4cy/
j1trY4Sc/w+5P4Z8gzdhoQ/RQ0k/rEzYZMHKFkPyQ821SfJB4tQT9LamtzEL
6tVTkupB3nfeSnMR2aMVnjU4bZZnUCjfmgL5J4xVJFlcmpQu5bClsaLkRpD/
FQ2nSsnMF0OfsMbhBmO03xWizqnDywemjJxJKpX6cnhTVixaAfJl+tq+PvKS
MjWDmurWGDTJYsxb8YQCrTiIfz7m9xMlAyjOyUrUVERJJuWr/9J8ALWwRnwy
58bEVVQWumHapgosuiqSQg3zyCxjRZbEzfRPyeN1cX0KY1L77h0d97P2EYuv
xXk2qJntIeq6kZ8yolAMclAZ5ZJ4dC82X+oyLrDAIA9NKjCoScwqT/gdURaM
zN829ejzKjoBScW5aWT+o/3DnSOvZjMiGMvqd+IXs8VOlCy1SWncFJ3d1nGN
NM7D0S26q4kGJEPwBJt92fLMQzQQN/zm7JXxoYysVBTK07liiVKGAz/x0LHM
Zm2YlGqukYXHECl1Vz6SDxMdxtI5S0of8usurWSMQ0EoUC4iI7b/Xp6WIE3V
QA/FeCk8EwJZjWQuwb+8FeaKt8mo0FDKimINFctzbERFP7nZJeDD7hQmzowX
UXZqXYikzZXq9JraubMs0DkqtlBmx6h19rpaplspQUJxDxR+s0gwRGe3f7kQ
zXpYH27rsIyKCeAfypcs3+Tss8PqJvHHrEefQpMLPJVgnIBTdmSjYz2TOefR
X/ELYubaVbxJ8XRknZbIdetqZZuAJK3RrMiXIokQzmizmxInpjMvSo3vMpH6
q1rwPIiV5Vuya/m/G7IPbtN2VwiWKM6EQPGHJ+GTvxIwM43xbUXZEVPa1mMm
CjJb+ei/g/odzylX+gv666unx+KTiwwQiGbEbNV8oa3iEhtlncSijGlfhlym
Zp0oPq9QPJYUJu3oLossKcok8uepnGGy+sm5sd00xQOZ2TtUDnaXXgkZpKHa
pgpl0a3GHlT3hdfeGuaRmQmBpbkHXboezRXzabPuCYGkKH/zbKu1cYpVGnAY
TXl7iERKl/s6O49sMWVe2u2TEW5uIXPmureSbsrjg9pu5KOM7+PWWNUz++Zu
aXXx42hHaUiNR/fiGaJCxgWlWf28UvBFGALzaEaHBdde0WElxi4AUcpBb5wx
VZEX5+R4knKS0bKRwplf9BOVUqfLCYxnJMnjS4VRgfVnarRLCOxeyvoKPaN8
n4u47Gffjpuk4yJHt+ihJhooffpfF5Zrh4sbtHdy+CFHrrp4vNC1yp/yrhB+
tlr/hMBPZlKquUYWzUOkPPfjbUwIHvi4PuTXXdrIGJeCcPixeH158okMsqr4
TN82uzPFtMcluwvOzuWfuq/QSMmjreox5SIepDRrqDQ94M/qnEuT7aWDC3K2
5U8qO0+kEm+1e69Wr/+H94xbhkbJV8Afnp78f4wzN+sSygkSVGSVuYeICnsK
2q2N/1CJ92K/lX3YWqJKopILw6x34h3lwt/3dRY4b0WxOOGfl8f72ZqZUa/m
vcweSqW6Vcvtj9BPcu+tay+tJ4Mo2b7AxFK6ZqGwEZ7RHsVbK2c9oWkmNa8v
e7a7d+8zaDMaFYRsjeSBynHqHv+U22tigkJwsvi24oZ6Gm13haCMU+WEB/JV
zqmxPl8JBO5LIn97q2SkPhTd8Btj/JXlmlPn5R7du6K7UWud+/moPKjxzweb
25uq9dx4g+eJapZvsIFizrIpXZAYwA9k9tWZLtIiDNTswKjv98l0H4reZUev
svMPlmVKK8lk1S9+X1OWsEKUPb+r/5mnGuw3ttg4FTztsIsvKh5loLapgSW6
+G362A3dg2TbII+MnEDKS5EMQ6tGdT8kLZKp/uJ42qVDQuC7orTggCZNOH9I
Zywobg95fnXIzOjiTGqdznoBLvWg9TmGarqRjzJSblUvasQp2R5svYfOjuDV
vRUlFzw61JsvTzIR3ji7vLs0E7IaC4zEl35HZl30d6LLcYivHRxmTEc5RA+v
Lu7q2ouqopAr27RIfZ4SN8pUavHYT1RxelvHRfLgmOjBpXDrLnzsEkL8LHSE
YAgKb1JnSs6wMf7SaA6+KSk8tsEuIqZIasU5ukUfNVEHWXpwlZk3K1SFoqwC
r72sZBVcA0THM+WVd4Xws9WKsTue1JJJ4RxZNA2RSDfdvO/8r+R0/47SOmYc
H/Ia2rSRMU4FUT6OrSpxi1VDynsXpeztOi8aXYp5l8rC+K1jjNWWolUAL93S
togUJu91mRMlGw9ZGvokdZW9ooaiyUjDDfcqi6OndZTlU1GnZBo1wwv9pOhl
1DwrAfIJ39xaaE8vKKjR6+q/HkU79r1QKO1KYUHycPORShWV6wiUcXB0Pvun
7MVLzGM3VpVFyQRh38pWvZ3mDnNYdEEmIWTJwXXt+yh8SBmxJbYWkxYtGtvN
6dsbf5Qm7/dqZzN3hkPAifv4O2i6LfDbtJuqxLgQlaY8z66JJ5Hqpahc5OKI
ADtLn6goJXeI69bIM/xqYXSRvNyDKDtibAvvGTN6usjN+Ousg84tPYIXju3m
vEe5UiU3pPDcj6jI5JI5vd0s/cYee6L4Q5S7yytnBhUdHeXRnNrqKy1YjfEc
2sZeIGjoMmNsXOp9lTsEycr8+NiF9r1b1Jf8dsCAju2bD3Nbk5BYqCbKl3d3
bTuBYPDglFe6zkHe5Z4Y1osuso1TXFG51D7fxivOZCnHW1o4FFPx5uaYVj0C
5vZ18mIWRxVlpH7b03z4vKDZngH9ujovYz+CkkxWi679MEIiSLMcvGN5HVRR
fukHX3PLWeETbGXVgA3UNnXIRHcpLSrx97PlqqH/I4vLnyya1HLY2DkuthMO
sPpB3cWxajDmpBoR/5wYZEvVxUUI7KfOus+c7b7NOthb9ldUqndm6ENkLsiM
82vSSqiplpV0pZgaKNGUjf9Ir64bNSsjmXNrjY3FpHmjHVaiKnAInhJF5j86
6GFhMWl4cBAyPusi775iTj/f3PRt7zCVLTCkKH/7MktHp7DgCbZTAq6/LH0S
7i0xO/49+x5/zvjO/m1jLG1DlkWEuA22nch4IpHwt9Vhts595iyaH+Yx2mrC
hFPZWuwakDQ4rv+/2/jNwFVqn2dd+6ZbC5fp00MHejmEL2G6GZzdoo+acDcn
erEnKuCMBWN6QhptITISR3T2S8exwY9Fyd59ceFl2piMcIz5RctNRmiOr1T3
WLN4UJJg73jyD62NYa2YFO6RRdMQSeakrbVu4zvbefxehmxzfKi5u6q1kTFu
BclICvjCeM45ecKDxCuO79FiZGiQQ0DIQ1nLJW7SGHuLSaGhLrZDQ5f4fKFd
iFjSyD1OuFWejstWsTpEo4ZSze7Wxney8wxGe5Azs8yqxcjwBcHuzmHHMrJi
IiVeR/AQxw0/yyaoqvVa0reXjs3rZjNtcWDgyFAvG4d15xRr//5jUUwI/DuA
Ml50rXcKAH8rcOBRuoCFioZ9zic1A3USpd2Ff0v+oSML3qKlY4gYqOPgAUKb
DRSfAfhwZNVbNgDgHwTK95BuQkHbAF0GXn1d/jhmy281fdIc8I8BJfbUgTM0
a5R/6MiCkhUbKVa6Bv4mKJWI/Ix5kxPv+JXAJygzn9r1Q6W51naLAKDWIe8f
9zORZnSjlehemxLeF1wYPJORqgEAOkBl+Ez6V4PWu38rvTq4pRHP7TOfHf+0
kUVYcN7PeebJNPplUiWsjf62L/cfj1Kx8c+ZzOSgRsZ+8Rl/7V9lOkSa7gIA
/2yqErc06iLdk0uKXqyd3m6k/4g+IzSlkwGAJqjNIEYdZ4Q+yU2LbN3y2/s1
Wha/9viHjSx401D/bYlUnRnOraDA34NK4e3AyXhDBJUJ7OedoqFAX52H2gzu
ZRsQMaKzYyzfPSYAAACAbpDCpJ2DuvmHdrf0OcBrg9hnyT9tZHmdedDJzMzb
I2z+itld2vVZFJ72CjxAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAADA0IuHD8AntRs6e3dVqfrLCIYMAAAAAAADA35OyI99YNnJIfFF0
xctdwDw4GwAAAAAAAPi78rHwpJMZMSE0J/dyqJnAfUNcyd+1UhMAAAAAAAAg
I+dKeGOi/br4D7AKDAAAAAAA8I+h6txOFyNB4Ons2m4IAAAAAAAA8OkoigoU
NGq2/TGc6wwAAAAAAPDPoeoXv6+Jrk5nCmu7IQAAAAAAAIChICvz43bO7mI5
Jmz+/H7DzX39rryUHuJcWXpj8gDXToPs6hGEZXOPkTY2A/r99KKS4yJUAZnx
zhOntes16MIfIlHmz7uG2dtPnho22LdNb/fDmW85fpJ7d5OVBeHgePIPcQ0+
HQAAAAAAAKCMxHmb42cyQOK5IcePFGVM6y/wDcp8z/hO7vUlZkTbyNj3qneF
iC7E9IhJFon+PGpPtBrfZ/y0GbdfoQuK318d3FowNSK3QvEnVYnfdRMQhLP7
xSLYbQIAAAAAAPAJIUXZERON/89qX1a57LPKhI0dBKYb7r2TfSK+vLdfPcLn
SLpKX42sSJ9iszNTXF38YHNrgnAflCLz68gPqV7tCTfvO++UfiUS/n5sL+0r
AgAAAAAAAJ8KUephPxPCdn18GcO9ex+7vC1BTDzxWPZJcfTcRoJGW35ViuXJ
qBSmfrPlxcdq8kacZ33CKy5Nfr3Sp99bEKYzI/NhTwkAAAAAAEBdgKxI93cm
TL9YnVbC+FScGeRBEPWX3SiWfsJ/VwiZHzlZYRMxmXbYuyHhsfcqpP0BAAAA
AADUCVCMjnBwu/AX48P3efFdTAlbh8R8aTCvPO+QHUF4B2VqXLatLL3YrxXh
Nvzm/2QfkbkR4wT/arU7k2svCQAAAAAAAPDpeX0vqjlBnQT3Uf4ZDtw5bU6Q
LxDz2BXC/GarxTFvZVE/7GciB5LMub4w6T7EAwEAAAAAAGqZDwVHHUyJwMgC
WZSu4k2Kp6NgiNfN13KHT/OuECn4VJHJxx+R7E/GHb4v+aTwG9eZV1/JvizK
ur035b4QDiAGAAAAAAD45JRsX2Bi6Xz2FfLaFGrFSNG8K4SGzAn1IlqxVn4/
xK9pXk/yibg6987CYeHZZdKvZl0Ob0oQpnwuCwAAAAAAABgaieO3dLaFq1PY
4ogAO0ufqKjf3ioE/NCuEIW8QU7Ijz+PtVMsMPgm57BLU7fAWW5uY8+/lPuW
ZHrStMaE5fTgh/+DCoEAAAAAAAB1D7QrBAq8AAAAAAAA/LPIuRLemE7qAwAA
AAAAAP7eiK4d9mskGBj7qDR2Wf12dgl5sKkXAAAAAADg709x9ByjLrZ7HxWn
jjB1+S6xDOKAAAAAAAAA/wDI/EfbXW2nB4+xDAiFvRsAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAOiCsCDZs4X38ccqv0CK8rcuaTEtsqCy
lm9XEOlr7O31Q3q2iKT+KcpKj/f2bL8xoYysyfZIbvTg0oKOtgl/qPjzu6K0
BQv+Y245c3HE1C62S07dElbp0R41vS350/7/TunYpvcgrx4mDV1mjI2/T3eF
HGHB9ZnT2rWzHdDRqWHLFpO+ibz76oOOLVHTMxrvkn58TDPLZQmJhR/RP98V
3V21ytZ27M9vdWwLhe49Q+ZFDG6+JDLtxWt9JEUZNYIhykjdOniwra/XPA//
li0t5scl0F0h/8a77C0bh1nYhixbFuZkYRESfD1f1zfFoz3UK5sb0q+r04yw
hb5tmnssCU9TJxhkya4lZsFRRbpJslqLob5nyDs/uLYf+OPddL2USPmm+ryp
alJ4+eSKnpZu00NDXfu0G+997EmRYQWJl2ozv559fWF7+8R81ReseJPiaTY5
KVvrlmhnQJTlxNC6Rlbmx+0IdrT1nbc8pFvn5sMH7v5ZsWc0v0HKRM+lhH/h
itn27ZxnBSQ+1bV5PNrDQ9cMKVGizJ93DZM8/sDQ2fPHdLSYunVLdqnSxUhR
4dH9oZ3buM+aM6e3Ta/Ib1jf0cNcG+Du1F/3zaa6NCzMY3w7d+dvz+s3hgK8
IYte3NgWt6JLd1OCmHiCa6wXvXv+0/k9oyd1rUcQgfo6gfrfriByIsHGcnrw
w//pqs0a2yNR1fu3Ty1cP66pKWFhwzmCkPmP9vQ0s4/cTg/gEts7stPG+290
aZCGxyeLdobbLaNvRL7KOTHYXdC6xdIr2fLn//D6yhi70ORH2CgJryUt/FIg
GDw45ZVYq4Zo6Bk+d0k/PqEh+1V9bfv9r7oaOn17pvKOtwWhArPw6GKtDY4G
wSCfXA3pMTj5D9ryi1IOehsL3Fdvl3t5pCg7wt9klH86ll5S9DIq5Iu+Wr8p
nu1ReGXVb3L22TUSDB504Q/u8Z18kbaylU4qr0mFNfZMZcImla+qq9OZQi3b
o/+bkvg5+9Y4NLLc9gBLL1n6wzfdmtodelqubVPUNFKzajMRlaaOdlJlkfAF
Sw+u62mkyqypRksDwiUnhtU1Vs9QWhPuY9SyxZKLj2R+l+Y3+KHoirdDxJXH
0p+QwqsnZne03fubDjNSze3hoWuGlCjJ4we7jLgie1rRu2er57acHPrkHeNL
IuHD8ClmfWVtkLju8ztFJ8qDJ7qaa0PcXdKl8xzW7MmX+u0S+T/ar+XouJRy
A0+0AEWqUuJHSKYqq9fETw1pyznWv8064G7rGzrhm10xMxvr6wQa5HYFkRMa
Wtl3EFBCatrdImxvvM6xE83tqa56EjFaMsFZHnMsuntbbpNb8ebmmN71poRm
l9EflGxf+JWAcN2ZrLVboenxyaxLk3sEZAiZn1wOb0oQzu4Xpcpasj24U8x5
pu6UbF9kJSCsl8Xwt70ae4bXXdJPjGvcuTM2LK0aD12sR5hL/575WHDUoaHT
CBs2A6hYx78djv6ubcM0CYa4LHVEowlH71XKuqiy9GK/VoSpydLrr+gW3jvu
b1JvbvILeS8WP97WgXDarENYW7Ogvo9b1Sgg4gXjQd/GLJSM3tYrY0uVh3dR
6W3fARL/X2uV16jCPHqG0nEni379mG/KwaGzVw8T4+kn7qsJjnFhiDeFZIn1
Xj4WnnQy6jgvKl+kVWNUwke1mV8v/WGTW31CnROYe3e9OfUCtXUCtTMgnHJi
WF17mbbC3PZQDuNXOVfCJaLlOvBqMfonjzdYcfLb5oti3rLlvDAqsP6cqEJt
RzSN7eGha4aUKLIi3b956OU/WR9SV6sfeOapzE1GPqfVviypk/n0cqgZQXgF
ZEiHLR3NtUHu/vrBBhu3C3+xL/wwaXJzh8R88AI/EXjqrc5cvL4X1dwAkUD9
b1cQaWOToOXcVv/24Lktl8ktO7LRsd4Xq9NK5J+cjBnQuMXKm3m6i6+Kxy+O
ntlsRQxrmYP8kOrVniCM5iTnUv8UlZxxa7bk0lPWQFlwe2Uz3UIoKnqG513S
E2x8DZQ/IEPnnil+sL6H3y/vWL+qFn94GNhpSmKGln4FExWC8ebxNnOCaNvy
W3lAmA6PWGxKQG0XZwZ5EO0tDzF8QLrNDor20ADtqRZnBLgShKD/Nvncnw64
uXnfead4lfKkLd0XfruwmR4qr0qFNfdMZfpE800P3is1aWunkKiXuq+W6/ym
yPzIyaZEvQVXmCMdmRPqRVhYHfpdt7CtIpoFmEnRo439l6525bZIFOLyh0Hd
I1cu0WTWlNDSgHDLiUF1rercThcjwnSEX3qp9CMsWkTDDfdQf2l+g5JRw7/e
/OhitihWJmxo6MQh/Pq2R7OuGVSiPv551J49l0Q3vOPdsOEG+vGrC+6tb03Y
ro+X+5x//rq1k7HTN3El8jm7TubaIHdPPz7m/5zPvmJfg+pVWZcCNQ44gTo6
gdSUx4xwGni1hPtnOsL9+LRlUwjd4PXxr7eeqpL9kDEFRo2U6Knkw0Zbfq3Q
tiHcPcPzLp/OCeTRMzkXhkTGsyNsZOkPazotjinSK5ijQjDK/zzpYkl8zVzf
oRtJt+dDwVEHUyXJQQOBqemGe1qOTBrbIxl31s3saGQ88cgt2ePSA9Mgv18U
HK6SzG1uI1Jf6KfyqlRYY89Ulp4fPzL1f+xf5d5d6djv4p/6eFy6vinx+6uD
2zKGeJri6LlmnB6azm1TL8AySNGTOV0Xp5aompZKEF3Y0XVtfPFJjWZNCa0M
iCo5MaiukelJ0xoTlrMiZEst0kZK26PxDUq85qhAQWv2im01mRsx+osVXGFw
PdujUdcMK1EVr0/2FCjmdbzPi+/6hewlFkbNNCPqL7tRzH0FjG7m2iB3zzg9
zUQhAaOaTPvRo7U8uArUNOAE6ugEZiYHmxqsW+RwP77Etsz6SiDw/J65WEPm
RfjIzR22h+3bbfuVketSnnfIzqBOIM+7fDonkEfPKEHmpIa7+Nwp0XO5QWWI
WBGJYexiKo9X4AdRisLhcV/rPC4d2kMNguNN2fEK9LEoe0H3uVfyyLc14wQq
o9AzylSU3BjfZXXaK/1ela5vCrtASkM2Vg1V0qUlWgiwKCW2+/LYkirVj/Mm
Z1e/IVdfkzzMmhL8DYg2cmIgXZNeLe2wd0N2LE4BJYnCnhth2nBI5Krf3lLN
qLx3apq5DnkgOrVHQdcMLFFYeCRTiHaLTqRQmymo7OKgpkGR9Hq0qORMbzPN
kq+juTbE3bHUEYTFqEGHf0PZD8KCn9yaTj2mbe4HoDuflRM4oOPq/VsHO3gF
B88ZNsnCwin6xmM9RUVnJ7Aq8btuAqL92j3PEqJ9e7qFzI8IsLP02RzNsTdK
K/j3Np5UKszcFci9vsSMlbLCHy3GEeW7SKxKL+89UcEOoweGhi71t2o37fs4
fTe/GqpnKkouDOmw7raefkU1X9eCFOVvXti1nrHf/vP0ljdq8qvSCdQloVSr
9khsc/r5sOYcm6pEqfHdF6LsLz1VnufPlXtGiZLtczpsPFqqr7Ol65vCCWZK
Q/aH+LXtCaLVYsVMM4PBKcCluQf69btYSKp8HLLyxdLuARepaJIuTiAnXAZE
CzkxmK4hhAVnPLqr27PAKVGSD7evHWSCMsld7ddtjrAb6p2UbYjNyxrbo6xr
BpcoYUHyaE+UJy9wnLlos6ed3RrGGFT8YHNryesbnvIodVM/h0nhS+b0drOc
6Jeo8Pg6m2tD3F304PLyjmgzUasmU6L+u8DBbtU52B38SfmsnEA/I5+xspzV
8vN7vBqp3kNnqPaoMLlFUYGmErEdbDn9+0RaYj8UXRhkYzyNvTdKW/j39pPk
2Y0IUx9WSrkCxdHzWhEKQQa+8B9HOO6SftynicXa61IX/XXWTpt6vdfuKdJH
hAzUM2VHopoFa58TzoFa14IUPd+x1t97RUg3l4YtLTenMepI4L14KpxAWS6T
gdsjMbZ3z68aPz/MY5qTsdHYmCOKZTTKC04M63cmHw1CNeoEqukZBQrurbE0
SH64rm+KDuMoZnDhMJ3hVwFkcAgwmR/Vezydb8/9OGT6T71Do7FgG8oJ5FBt
beTEMLr2NvdM8KzAkYv8W5kb+fpzlDbSLFGk8NjWIQ3QxgfThkNWLLlXqMeM
VGN71OlaDUiUSHh/ynBTvKvXut2iI4ny2+H5pnUH58DJ9+kZH1m4bUGTJuzN
0fqYa/3vLvn05YNNFvQ1LEYNOqi2PhJgcD4jJ7D8zqGLzOxwPKtyG37zf4rf
NGR7VJhcul4NO7OLvBHnWV/gtTdFdxnm2du4TMTX6goL4AIOrAwWbeA5jnDf
5a+sQzdZQdq3MQv/JWBtotEag/RMecERx/qGzObSFF8iX+WcD5jauLHl2hRp
VlItOYE0onfZO7ZPamY8Zou8LANlnKPH9/7pEf3GPkkkkKNn2H9/GTmpfpgO
BXyU0fVNST58dD64CeG87VQFwws64mhWg04glwCTGWf6zZDtHuV6nA9FSV69
f8qjA0kGcQK5VFsbOTGkrlEIUy9FO3Yy9hl7RcUeIRUSRQpP7xtq1/dA6q/X
5s11qY88wUHux7P1KVrKqz2cumZgiaIKsHhbhUek3kvd3dsNOVIC92XrsnGu
L137hZ2V9+73fdaEqW9QpiwfWGdzbYi7k/mPdrtazY6/eG/vgVkt0TXatghN
vAUlYj4Zn5ETqATKpVecVRm6PWqdQMXKV3gzHXP3vbbweXxq1WO+ZD6lrpQT
tVRhYzxFtgwhvLfM31st/gdOCRmLEbzGEYW7qGky5R7rt4JmiJ4RX4sbbMre
lqs7vDPN8LDeVrptvLaXg6V15ATuG+g9emTWhcGjIuV1LdhdLTy1R4PohEbc
Z07E+KuwQs8wEf6+r7PA53C6IV6Vrm+quhoXvm7f3PlkLq7iV5kfHTzReVpb
HStMaoJTgCtKkse4HpHnsHE8TnHMTNej8jQqBeXV+g1Wc6u2ejlRwKC6Jm0A
8ktNh3rdVLWcq/QGy8/v6tPO/Uwe3WjhjXNRXakKqGoT+QzXHiVdM6REicuf
hAxrGhFNL45R9eejqZKYshRE7IYpbO7Ge8/Nmm1/rHKvDi9zbZC7v87cYdc0
/BzttEvc+FMTUJVRNXnCgKH5nJ1A/cdN3Z1A/EPFuA1uvLXaYv7q0fz4pDBp
96jWaj1AyQRtzjizybpX0q7m0zNa3QUbhJp1jzX2DKrN4jr8pr4xAAx/p4vO
+SGGouoZtb8xRDpbMWu65cH76so3Kd7dY7MYgdNPkxOIYPUMA/Hlvf3qNVhz
W3Wugxbo+qYw1HEe2yZZWExasjTU1X7qD/df76O+o4/ZUQGnAJMlu+Z2P5DK
GLAVH4fMvja5XygzFK9vJJBTtSu0khPD6poUungOO5LGhvUGqX0i9QJPP2V9
913R7Sk+htnfzaM9LF2jf2UYiSLTDg9vqpgvIcr8eZO1Ge16cZsavIFaEHha
9YEyMnMtxDtZWGC5MsTdydyIcfUUCjaSlYXxW8cY18wkC+DiM3ECxbkrpnQ0
Mp50/D5zaqL3CpruTiD3XKnmnUBR2jG/L9V6gKToReQUPT3Aao09o/ou4jvH
JzYiLGdHvmBmnalYA9UC/XsGrUQQ3kGZBtgXWK3StXhXeHvHdz8rnaNHPX6r
Vrszq+gdl4olAXGFMX3cHlX7BUSvkr77TuFwK3qXIuGx96o4N2lS0+YeI2Wl
fV1dOw2yk0zGLdGHXt4pRVo2RNWb0tAzrJGACvIrfqgzur0plbdGZkevBQhO
uAW4ouikk3FPL2bt5bFujU0JU1yT2XbVtZKiqGnGPZkVtj2HtnEwlRhGN+rD
XlGxJdr5FipUO0MbOTGEromyfv7ux1Ov2MmrdB4OvrKGNyiWtHlKE65o5Otf
N7fR2unS3B6NuqbiyrpJFFX9ZkpEnlI8r+Lkd93rN9v+uIp+C4qmhuUEajDX
wg9P922OZLHq/LO3hrl7FVVkhiPaT5WhdtYrYgBow2fiBFb94vc1YargBOLl
YL0mdLqXiCl9+r3klwpagDfT6WP61Pa26MHF2Ywzkqqp6djBPrsYtoVaawiV
H2yEPspd1ue/T7R+eep6Ru1d8L5pBauCfWa9Jnd69ky1tLy/wVK5OAUDJ34r
xTyxUaVLbSB/r635/meM1uENoTVQLBpXsVBc/ZEOTNxVKXBrDRwJ5NMzskdB
6b48o5qa0flNcV7MAKnIyvASYAx+d2o7R/eoslYGRI2c6K9ruNiLUnyMdrqo
snsa32BVdeb5IDO2omGoPlQbCtOlPTrpWrXuElUcPcfINzRHuaZy+nFvMxyI
4KpLj02NdJqjs7nW++5VqIaMkWdcmvK0vSDSXxCi69nlgJbo5QSKhL8f23tb
3QnjBrtd6Z55XQ7cYk07cD6t+6AU2dS5Jtqjugbvy8jJRl1Y1c5FZ3e61zOa
fCJDllcuvHtu7z1t9jqp7m0yP2PbsBHJ7PNe38aMcz0j84FJYVJM3+WswpsS
C5Ps5WqwE0P43OX5tal9Qp+xmon6yqjJ0mt5tdQz6GvIsqkamMii5yfjkl5p
UaWeWzBQ3VfCelE0c43jfdyafwsImZ1Hx8YZsVapUGn97lHxsrRMQ7WHLmjp
5ELv6MS8TIukityqyP2uESeQV8/Q4BiCqgO7P+WbykmLbGc8dMcpWUFF8t4J
/y/YZ9hpb3YUn4ifANPUoBOopQFRLScG0DVcZc7UZM55hppQ58TZSh4NH0Kh
+Q1+LDrjZjJEaacemXU5pKNcIwzVHj66ZkCJIh+dn9XcfNdvijvgSraHNQun
+0TVCZVmsyJf4tGUl7muqbsXbQ4xGcvYooKpKLkwsFnwuafMwSL26n2oG1ND
4AwKnyOqE7BxSgNX4BcflatVhq3ut8MHcydKKwhRWSt+xp1Yqyc10h6c9dGe
c00hK9bepNcq6cnv+Y92djOxnr9OnjiNz0nUKsdV1eMLC37q01LpWNWxfZo0
3vKADllU3ksKaqpwcKeraye3xv2VDobggaqe4XEXdMx6RJS0YJRkZIn1bcwu
3vVpe4ZuOS7dzz2dKbnQ35JQrp+sBhWCIRGD/w7q+/11ucmSfLK1sxnRllHO
SPzhSbifybCxdBFdagFuhsmAwSmvpGOH4dqDdvC5D9m597lQNld693Cmjxkh
cFdVBQIP7lwqzwsVb4pXz2CwG8np53zaNyW+FufZgLBcEoNXVEWZd7/rKld5
jA5mhwVvAabBTiCnRZKCnUB1Zo0LrQ2IajkxhK5RHqn7tHmXnr+WOwOJO8YY
E6aDaU3h8wZFDy4vbN9y3vEU2XeEqZfW25svuiDdQWy49vDRNUNKFBW2XdzS
2f3wE+kgKHqXvX2jmzXjFA9sagZIP0HjpkkP5xPyUYqHua65uwsLkj1btpwf
iet4V+Mt3v7DzVcwOuT59cXNVM9YAZ3JvrbCQZrUgaonUbrfq0d8llSfRW+u
+Pai809wAR+UYeJ96KpMNMqOf0cdZa52n5EBbycRmOtzF/Zr2WLAiNEuTZsM
jQg6+4y1KcuQ7ZFoYuyqXtLsGgqc+jIr4gnzgJuCzGNjx5m1aTN06IAWVhZh
e+NZk+g/H2xuz7GCwIGGx6/KDBpkqpifi78nHSjfZn1vyf0V7UI66nuG513I
yvy4XaGdmrfvL+nAJk1GeGy9lMYyKZ+yZ2SNos4OUGHqxeX3Jw7gWFriQqNg
SOzYmXmRfq0bdx0i6UmPzg0bD12sKKsSe/jbN2uHWdiGLFsW5mRhEcI+tN2g
7aGM8/d7Ftp/3fhrSddJetLoax+lN4KoSjk02naUR3NUu5UQ2A/p7MAWeHXw
UGFePVONzxH4SsA5CH7iN0W9ptWjOlm6uQ0Y0LFrY1eHladSFPpNC7PDgRYC
LNG+A+6SZvRB5XkJU4c2Q0ewTJbkak8ivB06j+xpjK7QqrHbKLYJVYM2BkSj
nBhK14SpF2K8JtuaSV6c5D1+beRgEbZrB7MgPx+JEmWlx/tMQRcZOaBF46+n
jT32hJF4adD2aNY1w0oUKSo8eWSlI7qd+2BrsxaTNkb9P/bOPS7m7H/87+mB
8tjBL1YfESG1bd/CNrlUrHIpt5RLspTctuhGF0kuuee2uWxhCatYhHUnJLek
RWvFuiSrVlG2rEYXTfWe37zPec/Me2be8573TLfJnudfTDPv97m8zuu8zuu8
zutIDCrKG6PdO7YbMt7V0bCj0yJZVSNkoa4b9O0fi+6ujPYielBJg7zPSbQx
Zc6HhmhaCqKso+5q0V3P2lYeYeZR63WaH135nNG2lvn05hfnOhxdqXe0rTza
g/a1jNapHS1H23pQ28qDJArRbKjJ8ht8JK+pSyFF28ojrLmwafCxer7y+PNA
61rm/aPVbg12DYQGaFt5tAetaxmtUzvajrb1oLaVB0kUorlQ/GjD8PrKuVEf
aFt5cEHW3L5x6h/O/fzRvpYRnN/Sd7fSNA6Nj7aVR3vQupbRNrWj9WhbD2pb
eZBEIZoLJbEz+ydlqRV+3KBoW3nwZ5eHuYvPYSEoaF3LVJUku/Y/mqs184C2
lUd70L6W0Ta1o+1oWw9qW3mQRCGaC7lpC8ZqeDVtg6Bt5anm35w+6EA2CmdV
QPtahp+wZNDB29pjk2pbebQHrWsZbVM7Wo+29aC2lQdJFAKBQCAQCAQCgUAg
EAgEAoFAIBAIBAKBQCAQCAQCgUAgEAgEAoFAIBAIBAKBQCAQCAQCgUAgEAgE
AoFAIBAIBAKBQCAQCAQCgUAgEAgEAoFAIBAIBAKBQCAQCAQCgUAgEAgEAoFA
IBAIBAKBQCAQCAQCoeXUXk9waYWxYoR7RqlQ+DwlWJ/8YPqJx01d/Hqg5kr8
8JawQrob7n2qy6NKYsN7ccCTTCyS/lb+PVzwxN+VK9O4HLcDt2tpv1zx5qS9
Kcbyy3Up1WfKf7z6CAQCgUAoozppg24HkzXJ6fwa8hM84/AkkVk4aNytD+Iv
fSy64+uppyeeQ/Hq1yvnGn4uRiCB4ONvUx3rbgQS8POPDjBkZW98enPUGsNM
vzr4slZwPrbTIM/fP9J8i7TSfaMKqoVlCSu5470y/8UbsFSfJZ939eEywdx4
+4P3TV0UBAKBQDQnyuIXt1udWE41KzKPT9PFMAf3DKpNUpaX2M9SModWJ20y
+ZyMQKGwIGp6/RiBwuoMdxP2RmB3E91+W09XfcpL7Ns++q7CJI5XZXrZEV4s
YAQWRE3T3ZBU3aClaghe3119IZO967Iu8M+sPvlKsYWatPoNzYdnu0y5GFcv
LCVP7d9W83/bsuNV3aUegUAgEM2Qgiir7y7kynxEawQKa373/DJabCMhI1A5
6hmB05YtH2Y07ta/wsLoOdxl8aVyptLr9CiDL5asjNCd04yNwJoLP3Zer1mx
1aU2a3bndTSd+FkbgUKhIDtz7xWpM18N3j+OsZEb6QgEAoH4j4DnRViuvCs7
adIbgSILxDrqLjICVaKeETj9SOZJ21ZByQV4Tsp8Q96pfJmt3uKY+S1GemZc
3NCMjUBckDXnW02LrSbFj7f3oO3Ez9wI1BgiDsEEGYEIBALx36TmSdS0iwWy
MWZKjMDyU6t8br6F/0ZGoHLUNAJP5JfuWcINiC4UlKe5cSf8cl/aGZ8KT9rq
DN/7sCqp2RqBuCA/ftN4PcxkU8MbgfyCG9Pc9ek7ERmBNAiy0taY6SuOdAQC
gUD8d1FiBFIhjcDjf73+aa39cOfggEUTOupP2bonX3b6xd/mnJ7m1m3EkKDg
sEk9TQIOJBUyG1l49eufNrha8PwX+/qO97EdGhRpb+B+/LHw9fUo6/ED9MAZ
T9OOozbGl4Cdr5JdS/u0AOc+Hfsk/vnu0nDyFK3I5KjIvbba0c4nfMV8C319
T8+rrwUiIyFl1jA7n7CwYe765pYbUh8JKMYvNALXX8o6NNHGxX+W7/iF47p0
C6IrsGjq/HGoiYn3OH+/SK+vTPzjE/MrZdpGTSPwsfD9vTU9zA6+xKtObmk/
cnZWmbgx0n9xa0t8Xq2+EYgXPE36blo3R9uQJYv8HW3n7k87NkqhVIKP2Vs2
uvQwnRu5PMC6m11IaPpbUBPpAXCRQVXB3MWE6RXkbzJI9KKlIbYmJoH+NyTN
8er2un4jRvQc0oODcXlGY1wsCFzdU4tUFUCoXBKUUJq4YYjFBKeOIqnkWI/+
mscjXjUwmpQTaac8Z5IBojY3z6/ldRvi6xPi9F23YY57fsuWfEHwx7W1A8wm
hkzy9Iz0sbMJDZ9vADqFLK9aoi4okcgq9v2i9PNbvHm2PuFLZ/Xo6BRJaQQ2
jVz8YHNn+dP60gPRolH8D12Vq0tvznDkfQ3GlGFbhwmgaywsV17P06DxEQgE
AvH5wNoI/HYqL/BQ6kcwzwrO73RsoTPjRJZkUsXzH+3s23rgylg4X+Gv0lcY
6kzef7VC+dnW8uObO8+MeCWZA9/n7LPS8RRPbeVHNg3QwbqvTayUPgHPCR7R
LiJGMiUKfjsxh4t193WZPjvsyQfwPWKLENOfFbnzu5F7Hr0jPiI2KEdg5lZJ
edIIPGAEcnpNHJf8upK2/JCKK4emGxqvuym2DT6+uzl1qH7A8hfl0rZR2wgk
ytOpU1yyoDJnr6X4eAjx4VCdoOjCaqG6RiD+5HpEFx2H1eKS49WFu1Y7tJTN
kSLgPwzybD1i5KW/wZcEpWkTB+h4+j35SP4EHABv5R81d+QBpV0sfPf0gK3+
0M0JpMGDCwr3Rdsa2hzJrpCWBogTjSeQsQDMkqAM5e5c0CmGX06YzSADOP9M
/JT2BpGXoWWIlx5YbfGF6a5H4JD8mwcbv7Y6mCOxUQXZoR46PqQRqIGoC8Wy
inH1PPdfJMP5+AXJLg46zuI2gahsZNrT+vBAdL8BISHKqwzPpyv6/DVqfAQC
gUB8DrA2ArmewS8k823BnRUdMP3QmGI4ndVW3J8+nPN/1CA3PDdiCsdMxvSS
pTZrdv9Wa2RsvPwoS8sk8ewDzDlsDCWVSm35LY++iS8pD3x3L7ojhnXv/vNz
iY+mMs21u1xuvcrENd0xnaBk6YkYYD+0mJ/8ijpvV53c2r+Fns+ZR+SHRY+2
m3L+b2X8B2oE/uv0qI4c172pYpeR+kYg4fQ7NLiHe8YH/HWUF3k8pODe2i6t
l9wg9t/VMwJhwpCRoqdRPqwtuzaqK7VU5ce3OrTU8T37XNo96YfddaU2Hosu
rnzo48IZPDK1mNJmteVpbv/Hmer3VOzPVGYEMhZAlSQoQYURyCwDbx5s7s5p
M5+wuknK8hJ7c9rMi3otENZciO1gQkmaJCrQ/STLacAI1ETUAVBWpwXnUMv7
JDmgDaYPXkrArpHpwjNYVJneCNSw8REIBALxOcDaCHTae006ycEZzVe8QfbX
jcUdMGxmRJ5A+quaCzvtdTi+Z7OVPLX2qZ8T9o3FBso5x5pr8fPvSLYPa18E
u3E4X6xKLyE/+OvaqGmUWVtSDHe/p1JXCvQCGe5+Kv2e4qRJbz+8vbeuk9Ts
LN2zzIwjYzoSCErODdbHBjlfK6a8Tk0jUFhRcLQfd8mNf4VPLvp2tjv/Fi/d
s6T1MNKQU8sIBI2M9dmU9EnGDSVbqmr+tdHmWHfTg1Sb9/3j7cYYNzC6qEba
RCq7WGoTiimOmd+GQ5qvBLRGoIoCqJQEelR5AplkAHQu5nEkk2psZc0ehJlb
n8oX1qbED22pN3VbXHap+O8fnmxdlsSv1UzUAXLtSRar9PIwQ0y//ZYHwMJj
18hKjUBmsVdiBGrW+AgEAoH4HGAfE0iddGRntJpTW/ty5LZuySd/s+20slQW
eOaZOW1BLJNhW4fpDhF7dkjnXPgFwlmEma8gU6kUxwwefE7Gd0c3sdJYZWyN
QDhLdjXe/6JW7FFUtDGgy6XV6jt8Za+jh2oEEnUJahUIj4e08Tx874StztBd
ydC7qI4RiOcEu9Jd5iJbKhhINkjGtUVWdqTn72X0TSTXtsCtROPigz+Udj2t
EaiqAColgRYVRiCTDNT87vkNpRMpD+S22fJHNeXeFo61S99ZK4PPZb+DBdJM
1AlojUDiwL6H6DWuCek460ZWagQyi72S7WDNGh+BQCAQnwP1YQSC6RjTH2O7
eKm7LJNjbmUzzCiCrLRtThOsWpCx7txRsvFRxIFZfewbwlcmrCj4ZZRb2r+y
v28IIxB+Tv23bGMAI1DyNA2NQOHr9OXGVkl5xPGQru379m5jdlC8za2OEShX
GCWNALvYxOj75XK94+61IxF6Vll2sTL7RNoFtEYgiwKokAQ6NDcCyc7VGRU0
cdYs2QIFBN54CzqCX3BjfsSYduLr/rqS0YMai7oSI1CmYVk2cv0agUKNGh+B
QCAQnwP1YQR+iAs3pJu8GMGLLh56Ln6pIDvr7IIlI1tL/X4Q8GSdGSf+qklP
7L8+qVxulm04TyAMq1NqBLZcerNY2evokTMCictBOgw9cLv2U97R/j115oqj
whrCE5hzNbRtXbu4LH5ZV+X2Sdeo+DI6T2DNqTVDTmYL85gLwEoSFJHtxOpM
nyG/FtBVX7GCcBNWeY4gPDvtULbYa/nx3e9x+xf2MIExABqJOkCJJxD2IPQE
smzk+jECi39fPD66qEbDxkcgEAjE50B9GIH4/ROeejSxTMKPbx4XKXMpVGd4
dP7xESWySoi/jpqh861sSYiDGBh31o8nZlls+L1M/hn1awSCoxCY6+wscPi3
MHquPqYQ6FX17uQALmYpORegqREoFNam7Da08/z930KQPlq6za1WTGDVyW22
KmMCKwuO8rhYH9tzhbI/xgUFT18KlNkVcl388Mz3X0hjCCUURftyMcqJD1kj
sDopyvroY6GAuQDsJEEBOSMww9P6aB5d9YWKFcTzo2ZwMYWAT5EVlPv4zSfR
l9d1/jGZWlH83nGv1qJ3VWsk6gCmmMAOsY+J6rNs5PoxAt/dDXEWFUbDxkcg
EAjE50B9GIHCqvepLv3IfVsKJbEz+ydlKdkjE01but/uTKambiPsn/HUUx7E
0cgMD1tij8pd9nPaYpCPZWkEyp8OLj+y0YZ6OhgcIP3fwphi6qxNHOfkDN9+
SuyT1NwIJI6j9uFG7d/rakxcJCfTCOqeDqaeoRZRVXxuiCGlVHjJT8t5OvL1
xZ9dHuZOeiBVdzE8FdtXtouJF/2P4+aZWSr+5GmyP1cavVYW7z380htVBWAn
CQoUx8zXl8T11Zalegy/9I78tUoZwLNvRhpghnKdW1WS7Nr/aC5I1ThOmsIR
tMb9dcSxixqNRB0+QfEQE7QtMdPg6HzydDCrRtbQCCTPNIkjM3OvjQ6K+1Cr
qvEF/JfH4i/kvENhgggEAvH5gWccntRKIWhfFjibyBylVLC+QPI0PYtIShK/
B8nTXUKfKLUtwbTF4x19KflB6a1Jht6nH8lNN8DZxZly+D7NNASLIXNUEzxW
9iAqvRE4qO/kOW7J4tgnwYMri7roOKzdUyS1CuRSycHEbgNbz/R/+K/Ub8fS
CKy+d8ZfHzMPjqRG3QNnI2a3/XSV5DMB//7MEdzViSIjs/xIdPtxXpn/qph+
iZIbtZZmnxN8zF4W1leXixkaRGcU4eLHPgzy1LN1PJcnbm1+wcWpQ/f8+YHa
RCy6mJJKERfkb4v8ur3lrj+KpL/6VHTOQWyUijrUc/ARmDiFqQBsJUEO/NFF
/3Zk6+Gv0ma7SLbU2cgA0bnftWsXdlHcuaLqbA8auj+1Ahd9eWMPjt73J+6L
TSO89MAKQ3/SVFNf1CntyW0deDZLIk6/DjHjjBqV+la688qmkZUagarEvmjz
/K4t4ElkUY3CBh8TWa0qGh8eo8YcZNYpCAQCgWjW1KQenGjJIy8RgNHg8JYH
6hUPIrKvL+dNdmjLhZd3OE3on/j4n6tT3cYY8YiPuLq2bhbuB69B6wN/m3Pe
P/RbY9O5kRGBDtaDlq788wPDNF7929Ruy35N3T/ScpT/JM9JEbN6W8yjvXmh
9NkOK4UkbIL3CsV4/C5+1dCvRsL4dhMHk2EBEU9eKZT/GTGRF60f1+/Eo9qS
R/vH2U4JDgoaO9OyJ2/F6VS+wvFOftrlbc4Oph7OwQHB480t5u+Snp0sUXwd
recKJkiRQknm9teNRYbSJIe11xNcWmEKcAauS2AO0BI8vbtnmL2Bu1NISKhX
f7s1F54mu5mQvxaf/yWMw507F3xt5DjPPcBlhvVY11/+BHaF2l0c3N+c5794
qb+NqUOo3/kX8j4iwR/X1vfR13d3Dx1m630iXWqeKysAe0mQg7jq4gf3jvru
4REe9sOO51TQd4oSGSA718nRaOSQoPCF0214i06QAlCdtLZb1OHkhXMtXZ1C
wiKDBltYBMtc7aGmqAPIBcu8c7vCbcaLxGmhR49u0zZEK/6QqZHlOms6MVrV
qDI/P2X6FH2RGC+eahuyFuQ8V9H4guuHPdtgpvMissuFCAQCgUA0Nk/ODZop
mx4QgWh2KDkdjEAgEAgEQhmF0f1nXHnT1KVAIOoGMgIRCAQCgVAJOJHRC0bL
f8jZ5TT5N+XxighE8wAZgQgEAoFAqOR1epSB7uiYxJJqwev1w8aee45OJiKa
PTABkex9cwgEAoFAIGTBC/etsnFyWuBqN/Xni4qHNRCI5oT8ISbLldfzmrpM
CAQCgUAgEAgEAoFAIBAIBAKBQCAQCAQCgUAgEAgEAoFAIBAIBAKBQCAQCAQC
gUAgEAgEAoFAIBAIBAKBQCAQCAQCgUAgEAgEAoFAIBAIBAKBQCAQCAQCgUAg
EAgEAoFAIBAIBAKBQCAQCAQCgUAgEAgEAoFAIBAIBAKBQCAQCAQCgUAgEAgE
AoFAIBAIBAKBQCAQCAQCgUAgEAgEAoFAIBAIBOJzR8DPuZCUlHKt8FNTl+S/
wMeiP04mnc7KEeBNXRItpLk0TnMpJ+I/SKPrc0HOw9NJxx4WVTbS+xAIWl7d
XtdvglNHE4yAYz36ax7PcuX1vCYrj4D/x4aF19/W0v+1ouCM25gRPYf04EhK
awEYMaKnvUHLtmOWhKa/VT6mcEHhyaOrhk4doCf6bb9BXw3oOIC37sJtfo0Q
z38UO8jx3FuWpcSL41eP+GqkVQsMs3W+VqJ+NRHsqS69OWP8GCMeF8MMF8d9
UCIa/1GaS+NQysmdG5UvqM9n4/kPt0QlFlYr+WNM2Ldfjx+gRyg4Ls9ojAvU
GDwe8SHHeorz7t+ytdcoZdaHEj4W3V29cZ4FoQMdJoxx7tbx69mep7Lf4UKc
f2Zn75CY4poGKFsTzh3Eq12gOGFcXVs3ap9iJk68FadT+WpUudH1OVH+yQ5t
RcXnzDj+SGulTyUFUdMxWkwskv5u6sJpA4KSc4Nbum+Nzcx+9PxlTqm6eq/q
3a+jrFYeSXhWIl6ZVFcWXrq8fVifHY/rVYcKhWXxy7piWNeo+LImFke89MDa
ATq6G+4xLsYK7qzoQDNaq++d8dfHuGNcb72jqYYgKy3Ghqcz1PaH06ffSh7P
L7gxi+cYf+v8OEfOtOActdaAxQ82d8awmRF59dwbCBpqU/YOa4F5HMlsvgqz
4Wg2jZN5fJouNmhncn2aJILStIm2mIN7xkfl38Er01y7Y1jLpTeLZT7nF/w6
xBzrarDiVp5WNh0LfYgL8vfHenfQ+Xb+7KOZUmtWpO7W2vU7kHIpogvH9UB6
w9WuCecOKPbyGljwMXvpfDMOxyX2lDp2YBPoc8KC0u8QW9+zeRPw7l50R2D7
MQ/D/yClz3eZ0JvJEG5gdBGDlH56c9QafM+044T54/y9F3p3B+toN8/M0vot
aG3W7EEYphOUnKv5Myrf3V7mfyL7Q50KUvRouymxOPI9m83wLfxmgktLutbD
qzK97EQN5rT3mszKWaQn922d0objGBWdXaqgqkpzE631Rb9Se27KOjunNfbN
ttMNschuJP55vL0np1dkXInW16E4JkhHp7EUpgbCjFdlzXHiDHS4VNRgpVJO
ozaOIrRSRNeGwGBQsMTqRsWZHaNbYZi59al85V/6+HKfOf13qk5us9XBMHe/
p1q4KadSH/Lf3Jw57X+tDBafua1o8AjSDnu2xhrYzGjKuaMo2pdLq7fhzNu9
+8/P6b3D9DSkPsefp68MjcmmGki1ZddGdf1MNpKQEagM6LBSxjeWu/4oYlo8
SYxAqt04auSlv+tbW1UWHBVZl4aGu5+qM2Rkqbmw016nbqoAF2SHTe/SinDw
M/s0imPm6ytaegDondYPpW5/4KWHNjm05DhuSFBm6hRGz9VXf24CM1qLhVff
qPUr7eLd032j7ddefaS922GQxlWYmghzbcWTJVPtN+3Jb/wA0SafTeikiK4N
gcHQ3fTgq/qTtvc58damxiIrjvmxT5P9uUosPeCcxPrYniust0LVDyr1oaD0
ztThnM7K3ZifCk/a6jesYDTh3AHFnlYDk1OnCmeCHA2pz4Hky8nY+8fbjT+X
jSRkBCoj88RUPUm4goQRI3ratW9lEHlZ1cz7STS+dG2Hgfg3w7YO0x1XH016
3RA+95yroW0xbIR7huYORjwn2BXrarz/heYxSXjmyf5eW5P9PIiAgk1JSnUK
OfZpbbbap35Oop/32ZT0SbItkn5idluM6zE7i6/01dVJG3RN1J0FwLvqVmUE
W4DClLXtG456EOZGpVEbhyV0bQjdcSM9fy+rt7fkr3WyiU/dayka9Ex7pgxb
luSWYp20X4OgQh/igldRc3txOC67LlYonROqM9yNdRooIBDShHMHNKJojX/4
J/UsuobU51DyZcON4H5W895IkoCMQCXUnNrSzj9aPly5suiqm7HrgVTlI1fM
pzdHbBsjuhIsxOo2iRDRj/qY6+ysck2fUFVyaaz5zj8F0MPPFOIOXf2mlkm5
Ci1Y/Hh7D5Gu7/TD/ffkJxVvTtqbYvr6K2+/ZWhv/OZ+Y1c1AwKr3p0cwMUG
jbtVtw1wBBvw+yc89eh9v/VP3YW5cWnUxmEJbRsCg6EeT6/gzy572fo9LQUj
kWnGh2tDugh8XJA1Z4ToT8O3nyrXKme4Kn2IZ56ZI7K+nFzTipkUW06wsfH+
BgwIbMK5A4o97ZoCTz/srothlrxT+ayr3qD6HDii5batP8SFGzb3jSQJahqB
eEn+7VUbfSyNjAYPGWJmYjLJedulayWkR7TmYbCzhQU8cCRa2VXjb3POB4ZM
sZ3u1FFX19F60bFkIvJB8DF753Z/R+9JJgP0LLrN2Rj95wdJX9f9CQTVf2Ud
nTFzNM9lIOG4695x6IDQ2PV3GY6d0vEhLqCn3ACsrXwS6mq8Yk8RG995IxmB
YCGGYa4JddAVuTci9esSG4yXHlhqvoXQw9VJm4g4St+oAiVNRI59RaWBC7Ij
ZoqWxsNjjpaKB1v5kU0DdDCuZ/ALRgOv9rdjnr/eV29qAlXWMvfLZ4tIYf6P
w91wr1EWmXUV5samURuHJXRt+OnoRitO3fQMFUHpLQ/zjcRyrzrDndAZ0088
pv8m3LKkC40TXD/s2Qbjuk7OKNGqzlalD2vLMzxsRbar24HbjFqr9tUmz2N/
ab5Rq7KcTTh3ACOKbk2BC574u3LVNewbUp/ThMLin36b3Kc5bTcwo44RiOc/
2tnXFPvGcuf9vGocROxvWza4pWTixite5z8/tHc2EQehu/7S/e0zAm+8BvYZ
dPJwWy+89NeDJR4/3HxUUStZx2HmS+PEfVf3J4i0VdE5B1OMq+d9HBgGeHVJ
UtwkkeHh4Hgury7xeHjJvhWGXsHZLJc8wAg8+PuTi0s2BTm4WAy19VnlfzgD
FLseqS69PMwQ47bZ8kcV8xf5aZe3OTuYejgHB/hZO7gl/10pxMszA8dbWMCj
+mTCloFLYtTO/1D0aLP9qGvgSC+5O6N8YQh3duTH/sei9OCgAXrtZscflWZ5
glXDOFMO3693FQ+XwLahm9YPtpwWGun1lenSKzL7+8Tqwz+4vznPf/HSeTZW
kVfUibvDBYVHf/YzN/GOXDq9v/3PN+/87Bt4g0wTQeR8GNnXd3oPw4jLjwQl
T38ZZ+Xsv2jREKdOPsEP/2X5Dpx/Nn7K4AWBlgaTD92mdpeo2Kc8J5q5OwcH
R8zqbblELmgBr85P2BnQ23RSSFjYsHHGUz2vvpYZESp+Tiy+dgT0sfBcFBDg
4s3z8kqh/JxGwMiHAoXJc7j0j1DuXQwtzL95fs0As4khfgEucyxcKE9TRq1S
YRY8uOxvPzIuyqeTt9/1tDMrHe1Ctu3f6TxKx56X8KRcpNN2j7Lz+W68wZwI
+aEtEsuwAJNBtiGhM3k+4WnXEqfHijOZCD4+nO9qOXVGt4EjL/0t4F9JCuRZ
+0WumvdVJ++Ei/JB/hJ5WBQ2rt/QYzeub50Tmv4PrnHjKEXAfxjmzvMOG9PN
6uDzCvLD9y9/GW42G66SCNd6L87E2VmEqleQIuVtSLrjuNwVSVc2iYZM+PJQ
nlHf1XEah1BWnNlqtTweRPmSQSBKD3aB+V2+iUCTzuukw/PzSy/UsjMhKvUh
3IQ1MTv4sklNCJZzBxz1UGkMd7ZaBTqdSVTYUPO75zd09qdIPcZPa8NxXBWb
r06vNog+f/Pgx0EWFhYgFYxhW4cJon9bhpwH7mi4n+XocujXLZP62oVELJnS
3TiK7plKtaJWwd4IrCq55GQu+uKIXcnSysLgVepBHvKBLZxmTU0ulHyPXO7p
2xmvTpVGkJILJbkBXscnkBEFlEgMMg4NM18RX6rpsBOkH5vVvlPsowrVX4UQ
MYGtLDxGHUi/T6SXqfj3YahvL47a4q2Ct/fWdVJoQDkIWz3y6/aW2+6QKQjK
4pfqSkNN6hZDRcQ/93Y7Kd6pgXHaSmUJHkbD9MfYLl7qDggJdp47vC2HM8r5
xHPZ1DBQVTbIagvPj5ohWmfoT/OCaQmrTm79Rk8qw4IHVxYZtfb8SWyR5t4M
N2IdcyhubfLc0JPkgDaUWvBz4vvbn3tbS7Q572u3712Pw1oTp5DYmrv4s8vu
Q0SLETwvwkNmP6Wy6Jwjd9qRe8QCTaROT8WNNKAIhshCCPJsPUJ8NIlYQA3n
TPV7yvLn/ILkicPazfSHlir+5EZUT12zLSAkhlnAYESNbAQ1cwvjWRfndrY8
mAPKKTK35k5qtYjlLqSCMNeWp03ssva3cjhNiE9m1Tz1c+Z067Y9Mz95XJ+9
zwR4xuFJurKzoai+LgNbi+tbHLNAtCCRxAXVXt9nsiCmuIyomrkHz2sFeW69
MnF1q/aykztonO4d7U7mEtXBH575/gtKOIT6jcNQ95Kfgq3iLlZ8yjtoJY1W
AhUXi1Zl0aWR/WASMKVSRKsQ4HYbt5XVPJ87YMiAFvtiVbpGhxbe5+y273/y
b/L58DiYskBi2HGYidH3y6HG8PUdv9C7uzWnM/2h2iaGhT6ETjBM3ZRW9Q6b
uQOOghlzYKeDmVQ3QHoGRNO5A4o91f4UWfVXrx6ZE2zXwWhBQpKaCZ8bUp/T
BQTCk8hY93azd8NngkHkMO7Wv9RCMU+72gRrI7D2eoJLK0xh4QCqTz3sKX4g
NbxfYsLJxaCSJpxcZsI6PgEXvIqJ4DmOOvFCarCRSRE1jmqGBrBaw1ZQcmXu
9Jv/UGZ16MzEdDwOptXXiSIy3QpT+lZ4ulbHOwlO7oQ76FWkR4cNSaSzHe62
aJpjgYh/dqV4R+GRamWpJuGAkj+MhvN/u/7T4AF6YxwTsqQHrslFdEOEecBF
gbnYzBCSuppclubeXWfMaeMb8Ur8R0HaIWcT9wx2xai4uGeSHqW14Uk3sSug
NmW3UXjchxpQgK6dojPEsY6g3ZgO1FBK/yLYZM7FV3i1aP3VhjMrIlc8HGtT
4h1aiwOtq/nXRptxJDvpxG77dL0vzfY9kw6K6qSNPSgbkUw/F/Dvz3Th2Dle
FvdP6Z6lXVrBg42qBEwxokZFCwPXkMQu+uvG4g4qN87EKArz69vh1p6/fyTO
pLfhtF6YInOGkbTlqoWF0b46xhTjrbbiSeBkHVN5CRHXQlRCo8CUYuikom5H
Viau6S57xgGkQNGZcSKL/AYcApISqt04yinLS7C1OZmPAztTsqAA0zRlxIkk
0MJANKaUShG9QiDdcbyjL8lPCSOwlfI9XCbw/LVuvX+W6kDQaMpiSMgtS7mY
SbwoNyUosE9bowVHktnbgaV7lplxlCd8kMvkoCoKhb5uqvUh6fnsvjaxskk3
sVXPHfD8shllFJTmJdp0iL4rjtnWeO6Ax72lhj0gzC/u14Mv+eo3SkPqc9qQ
XbifZTo/SvxMYAXJ9LIqrahVMBuBtZV/X03+G4g0jHFVnN+hGSbd4BM/UFY/
iE042ZHObARq/gQFSCNQ08Mvgkt7xraq81EgsUMSG0PMSvUCTLdCs5Mi4D88
eqZINLpLnu36igsXKXjRq/T4E1vGjjP+nrLzCBxusvY2a4j456+2/UEZTjBj
p7K1IcNhNOgxcxyZKjYzyJ5VdQYfL/jjzAs1zUTgK6ZqP+htIGwwEJHC4QAX
Rw3/5Zkrv/hFjjC1iX/ImA5IQkXBERt9mcU1qLLlukQ49vlJ/v53ioQlf2w2
wvTnS48dAYuXXUqEan56uP+d9zB8WsZ5CH0+QxbM+vnCsb9kdSnMOSYpBgSq
MskoY/o5kH+77aerFFtBlYDJR9SobmHgLu7ace72qJMZmeq5ehSFmf/6zO3H
AiVpWMju+JSX2JtDNYTwe8e9WssELYDIPbHjS9wFIEmdju/Z55KSE/M7NZ1d
mejJXBkXgWwJ1W8c5by5H7o0sUTOoIXTNGU7Es84aOYVlf9JqRTRKgQ4QKgC
ABpEdRSKIvizKzP6yxz2rzm1tS9HiWeM3LKki5msKj43xBDTb7fkutZkimal
D8mJTGVu8NLbZ541ZKCoyrkDjnqgNHB+5t3za3eE9zH2PECJdtB07oDxpfXm
C204fU4fsgsUlH77LQ/EHiUopVQXk8ppV6tgNgIr/k7sD3Wa2AbTbztlEcV6
d1+62HaMPjVzslYYgXjFo/unorYuHenKm+zgMHFxsAVPcyOwtjzNzZIpdJkt
4irU1xanskT6xK7TqZG9iQUaef4Lbr+G+W3/Je7GK5ldVzAeNTvlhJceWGFs
LLn6TXrvj7KED3Ds0x8wJHNDSfNNkdtAys+YAGpfhFpE3lZvTwou7ijhKORu
AqGWy0EsAVyienmu+yn6+B017BBYZmoFaZsXmnyU0454bsQUTme1pALYG3IH
6Ii9G0cu6cjQHR0tDtmCWbi5cpt30CNBER5lP4fyT1V6ClVWLmDgLdQUW+9V
tzCxfdOFLAhm3o022IYWpcLMmIYFdIeMLQeCFijPoY/cA1WjnnOHJh9laoOp
jJXLgyaNowKiDJw2kvWF7BqE+Hv8ok6xknmfRoro2hC446iWGBQJDVLYCUpv
Te5r5CSXdAvk0aJVzoxblnRpRZsQlvqQDIlRMZvwc34a4pr2nukrdSusyrmD
zCM9KmjirFnuwRsjfj4rvzbUdO5QFQWqJg2nz+kHPnTmU10Zr9OjOsqcjlE5
7WoXzEZgToq/CfycFF3Vl8o1uRHIL0iZ6tGLwxkSPO/8k9fQGVsnTyDoYgxr
tfqO8lx1clS9v+MzrWubbiuuZVO6XlwFxqRYagDDU+kS6RdGe3b5ifBgA/8t
g4tJYSJjDyX+WQp5moM2dyjc2VFy2SIcWdSZlyFDrOSJr24vcKBEtbGjLH5Z
J+oFDbDMxJZZLQz2UHEXjPLigNAIagVpm5fQUZz/UfbEof9QrV2Vd4Qv0XAh
sZUphyDn8bmNe5f3tuFwWi+5AW5ThnIip8qgxaKQh0Hpz5XM+CoETHHDiGUL
EzFCV44Gr5vSnosNcr7GKhG4UmGGO1/0pyChhfyN3XlJFqIKIqZO5jmgBeQ3
zhSqBv2HlJ0jUuApjSNbQo0bRzlgQpR69uSnaVFlp3dbc1esBGmkiK4N4QCh
yk/BvXWdNUkXQzkPQgFuENAlfGbcsiR3irXlzmXW+pAhW74YkT25uM/u1AZM
Aq9y7qgGUaBMN7loOnfA+NL6u3qmwfS5koGvkCsJZLGQMYZVTbtaBqMRWBK7
sPUUcmFLBlSovMWmiY3A2hfBbsTtbFNlbIO6GIFkcBqD5YZXl2ScPv2MNDip
VZAtLb0nsDrv6enr6SUahAnC8FRF46Hk2U6LztDGABVXXnKZaQgvSZjrlcru
AnEi/rmP17nnCuOfPPZFs86FGaWUZKeHWw8YJeqMjMNkOEMn4N/36bcinSmF
IC1Emyjs2OrPi3otIINJ2MXmKQL6lzpApM2L52+fdRRme4DtQAkJkG7J1ZKb
dCopS1hjoQOMtMrcXwLXvyrnP1zqaxcdXyiRIiKISzz1QGmUS3YKknHZbgYx
KgIWP1eyL69CwCQbRoKiXx2skvJUtDCe/2j/OLsoytKpLH5py6/YRXErF2am
e9nAEg8cGYMZOWrJ+lK3UCVxQYKCE8HrX8G6gkUKZYcUuHN7iMQVF+bd8Y9J
4tcqyINcQKCajcOGD3ELO0hrqjBNFz/+ob90b1peij4pacMSwh1HdbiBHwLH
suSHbHj/YvfgwefyFYYz3DOlcy8w2Utwx40rH+fJQAPGBKqjD/FnKaHtMS41
DlPuYa8z1wz1aNi8Nyrmjhpya4ZhxtR47oDxpfV3yUuD6XPZgMCqkpt+XleL
4MKKYtVDrzjY+ZUkK1OhFbUNBiOQiKjkSs0YOOgwjuteuRWKaNkS1Xm5+OBt
0xqB4svaZPpdnElGMyOQPMylvE9LYhcRuoWqjqCbxVzWE0g6uzD9OREStQkV
AiaX5YYdMKZLPsAYxrRPJEc38EvL+TBx/pkd/eBBaWpQR2nuAfs+R3NZLaoF
6Yft50bTRhQrPesHxz5tQOC7Z/HWRFaf70/cp4oWzAPWb7WC60AI7JZQx/HH
0zWwnUUTZYtBEknAX0fN0OkpPjEB9uPkmlRkmfw4zDVV9bIVuCYowixIPeCu
B3Y9qsigfeJT+cxawHgwE9kAuPDJhcl9WfgDodoZScQ2C85v77E0vjSXUOmm
wdIewR+enfGl6JmUwDDqwKl6n+piwxntegs6LrLU/LkQ5kjpF379A7OAia+U
eiPMuTLDGlSNsYVFK2gOR8/njNRXXBjt23Iu0OcqUSbMjPeylSWsNmuhv/5u
qchAirEBLkc4TiX1Fc3voR7AhqzB0w+a+5I7rfLhfHAfFkw9xTE+RrtFE4eC
PICVjiSGSt3GYQMx+iRvhBWnKL3yI2t6bhFbrYpSRK8QcLgKlvpRZX4Y2yWc
nSMOr3610n74SbpdAFJpKyhYWH7agEAiZeuMXhxqcH5Top4+BDlRu7agj2Yk
unvksOM59Gko8LfPjyUmF9XZuGAxd4C9P7lzeeSoBxsEms4dZJxP/R2ObjB9
LhMQKEhL7D1dNLoVriYBq0hiNV0rMjO6BKa8EaqcdrUNOiOwuig/a/+hhT1M
5KRX8CBlWU8TzNRkzdVMMt9ddcXrg/HuvFHSBDhN7AnE89fO68WhZAXEq0t+
jf3uu5UeeqLVh3X8/cy/Ct9Vq7PGIr2ISo1Acq0ngnpypOJSvM14z1OZmaVA
M+Afiu74EVpL7vpgMigaU//kMtzGkt1owN/mXJjl06cFZe38Pmeflc5QSVYf
wcfsmJVWXmTiCziQiXYmVPSEfgdvs5lsBU/vbu3DDVMSCgKbSzF9qOD8TscW
NHs3/JsXVpmbYl0Ngo+nKkRr4IX7Nrq20Zu0IfpBkWTXTfD29K+rh9is0PTO
XPzRxbkG0MFIpKWa0p5yCSCc8d1mZ4n7gn/z/LJ+NjsesAokrr1+YKweGTsn
eJK20nrQQOIEZS7VeFC4ahPIz8yIvCplzgQFiP0UTmdRCwvgxQRVwn8exdgM
vSTJp8QvSB5nPJ6SQpBw6ZuKdzzlcsWIUOvnQMxOe1iN2QNCxBkFDGznEVnf
i2Pm9ITbW4wtXHV2e89F0tWQ4MGVUPPeic/Z5WVSJsxv5R1ZVAizcyBhH5bE
+pvvgctbYjeBMxq4anFB4b5ojy6DdIxFGkZkrptPPA07SOE6UeDOAmFIUn+X
jDw8/W2TuT414EHdxmGDzBvTj8/6sn0rU3LHH3/9+1rbYZffiIefvBRVKGlD
EL3QhuLPBD/stiaxsvp96kSrrX+wOJYlasZDceO7KMlGQhqBCvuDMJ0CXRLF
05OJgB/HyCi5awKaBE30YWXRTc9Jer1MV5++KLXoPhbdjV5jN8wj5bUSu/bN
g83duUqCbdSB3dwhSE2YwJVmRZMZ9UIN5w6w5v2Oi9XnhWsNp88J87IzMC1K
835x6kcooir5k1ZgBS2y9yrx7Gtz7cUnnpinXa1BbNuoQP5sfkl+2obYEDuX
/zPq5uza99uRdiG74x4XQzmWxLyJAbYZaadRICSHLzY+JRDWXd2fABp81+4Q
2/HW3LYOEyzdfcatO3+bL5r4Vi6e3BuE686LeKLO4hF/cN7/Sx3e3AUPlVyw
CGxjXV03V9lUkHjF/Vt7Js8b1RGU3bTjqO9Hrk9SuD6YSL82WtdYjeh3YUXB
GbcxZDS1OFGnNL5aBDVto6h4WWk/DDAet8AvwGX2sD52S5NOSbMwiZZ+i7w7
jZ0cZG857WeFJLc0TXEhzJx8C5dnNPdYOlU2+Ee3jTcfadUClAFk15yRlF5L
pKSeIA6QJn41xkUSOA3ycJoaeK9fnvqX0rhZUfnjXOfY6oGafj3CwMzEf/PK
u3XJEIsL8mOXmo1wWDTP22SI457fsmVanl9ww2eq8XinkJCF3jzLaWuj1Lhr
BjzZ1MY2xH+a5czZN16XPgl1N3D38Row9Phf5EMIq8PG7vwb6SsF1w+5dbOY
P4/nHq+6C+BrSg6s7T7Edv5Y3qJLUGxw/pVjC/pazFns6zs+2NWCt/aCbAo1
kfwvAXmPF0fMtjL1iJa7ZIf1z5dEBg12MPWcnHhf2mhMAlb1/tbUvkZTZ9j5
BD78IDUylbawgP/nqhBLuyFBi8JCnCaaTZt2Opt1QLUyYc46M/sLGe+iTFPm
3F5tYeK9YCJvBSWBp2hUTrI28Q4Otrec+mNC/rtn8TYG4xfM5IWsJf1OwBDq
FR4jvTyIcO9MFvW1zwB76RRDlQf3ZcFfGcrYjeo2DhuIngrqZmW9MAIkp83O
TZnubuBoGxI+d+SAkQeyqHOfohTRtqFokdJXnF9a/MN9KwwHy/5QKXh+zBJS
B4qUlav94RzqGp5/x9cTJBwWK4fxg47k1Jaf2ulqCe+NwsR5eiEuY4ysORxd
e5/JCWn3mzxJoCb6UPrj6vzE+HDrwQYtRX8CN1uNdVhNHTuK5N1d043DGTUq
9a2m7iS15g6R9O7fPsnUMnBpRKDDKMvpMqNe3blD+DH3xNihg74iGwRMBJYr
r7PbQWam4fT5u2cH7Do5+YdP7mu3Bx4oJtZ6HKedF6V5EkSjeJJh/9nzh9rK
GABMWhGBQCAQ/zVgKH6TpwhGIBAIBAKBQDQiMMi8vtJiIBAIBAKBQCC0EVyQ
H7fULjz6BYwdIu4L8NYxFZ+1QSAQCAQCgUB8loDTbVw3z0wikFghXh2BQCAQ
CAQC8VlChM3P1De3mL88PGyYazdn591y8eoIBAKBQCAQCAQCgUAgEAgEAoFA
IBAIBAKBQCAQCAQCgUAgEAgEAoFQQJDz8HRS0g3ld08gPktAvx97WKQFd4j+
50F9oYWgTvnvoL19jVcXXj+dlHINXZyBaBD4L39xIq8ZkrvnroHB+Wf3eZhY
BvoMN1tGuXbqswXnX9y98Ea2tpjZr26v6wfunsM4M47T3wuGaCRQX2gh0k6R
3lncGAj4D0OndRsfENDHLCxZncQ4Av6DbRv+qOsVq4xqiv7qNHh7mr1By7Zj
loSmM94sJnh2P3F68HiDHhxrozEubv0NOnnHxGSX4uBW7t7fX6jbxb5UPjzb
ZcpVfqerGP0OsY9rtHkAliZuHAEvjDO1TMrVqqIhPis+xIX/j8PdcO+j6q/W
FwX31nXW8T37tnDncntdyh3rnyn4q/QVhpjJpqRqlV9tRIhbsPU//8ZvFqC+
0D5qn/o5Yd1ND75qvMm3/Mh60za8U6+Krro6clxnZ5Wz/uHxrQ4tOcO3nyqv
Q2FZqamCOys6YJit87USmY+r753x18e4Y1xv0W4oERfRzrHQ6zg3dr30Clpc
kL8vmjczPPXAsoGtjfe/qDcnRG3KHgc9g+BDkmtnQVdSbTy8+vVK3xY9rE/l
i6ultQPw05uj1himjjAgmiuV724v8z+R/UHmQ7wqa44TZ6DDpaKGe3Ft1uxB
GM/h0j8N9wp5CqN9dToZ739acml4L85oJXqjXqk6u8OxlV5Yigb3buNFRzf7
n7pdoXEZaysf+owTrTO5gdFFDX33Fb3A0FWhtuzaqK6KyvzzRf1+pB2SDVGM
pu6LOowOLeOfx9t7cnpFxpXUfaAJSs4N1m/UyfdT4UlbfeKW5NyUYH2O44YE
trWoKDhi09Jz5dpJHSwP5mi6rcJOTeE3E1xa0n0Hr8r0sqPdURJk3d5g1Ysz
yvnEcwVFT9wIM0Mfq18jR2Ty9dffkCS1h6venRzAxQwNdz+lmLeZx1yM3DOg
56OpByAJrcLJvRGpj3WNii9rto5A/Hn6ytCY7EZ0MjVTai7stNfRCUqWdYnX
VjxZMtV+0578hosHgAOkMe9nry69PMwQGzTuVv3OroxUXPl56FCvlNfqa8j3
j7cbY/qhMcWaTiuC1APftTMhNidmRuQ19EKTVmBoqwA+bIwiaQnq9yP9kGyI
YjR1X2g+OrSNd0/3jbZfe7U+bhhp/Mk352poW6z72sRKNd9YEruw9TD3jH/L
MzysWkfGaaapWKqp4pj5+kpihwhnGqYg27l31xlzGFb6+MMz339Rr+1clpfY
76uDLykFBF0pN+PgGQdNPaMKoFXY1AMQQqtwwIeYx5HMZmsDAi9TH9tzhU1d
EG0Hzwl2xbrWp0ucLcC936j3s4MR1xhusfoArnxdE9I1HIMVBb8Ot0k4d2BS
KwxzEC88GxfaKsAPv9l2ujl0Qj2gfj82yJBEfdFcaJAlgOo3cnzPZqv3s5Jn
O82/CEshyok/S1nQqdv2P9RfXbNUU9BjhrVcerNY8W9gyxXrsynpk0S4S/OO
2Jpi3RmLRFwUWJ/tjKcf/MojIrdK+gm0o+Ss0+qk9W3Xkxvf2jEAaRUO+JDb
ZssfVUp/p+V8fLnPHGtUL1MzpfG3HsQA+W/c4Oess3NaN67ZWQeKY4J0dDSP
FSmJ9Tffkyp4RVS5kffcJdBW4UNcuGEjB703KWr3Y8MMSdQXzQQ8P2oG53+y
G4gNTFG0L6eNuqoGfx3l3dI7OBtKKS7IDp3ccm7UazXVFVs1Vfp8l4mSQwrF
j7f3wLCunX64/15Stvy183pxMNsNiaUMul5kJFjV51Kr6uKOSWep5zuIruRi
8iuv8lMbv0smj8BoxQCkVThw16yJJo764WmyP7fZTPdNSdPt+3+IW9iia6Oe
PKo5tbUvp1GX2JpTt1gR/FV6uK1nZilc7WKYiUXS3/VcQNXQVgH/9NvkPk3j
eW4SNOjHhhiSqC+aC3DyHeGeUdpor6z53fMbdXfN8OwbEYb66+++l35UcG+t
Ubsl1/PYiy17NYXfP+GpRxe/JzI+I2b24nCGxxyV2nvE6T8M69795+eMhvTH
3F8C179qODcR7Equ8pOPWjIAaRXO23vrOjVvN1pZ/LKu9K7jz4WPRelhASaD
bENCZ/J8wtOuJU6PTSyEIi/4+HC+q+XUGd0Gjrz0t4B/JSmQZ+0XuWreV528
Ey7y4UipLc8MHG9h4TLGiMcVH7ofuCQmXyBavTzaPcrO57vxBnMiyFWeEOef
2eE2JNzLrHtU6psP8IHhISNMbeIfFskMeX7BjfnB/c15/ouXB/Q2do2RjRCT
KfOunc7fYO5+T2WjgfC3Oef94ROWzrOxiryiRoyNICttm7ODqYdzcECIs4nV
+lTpb0sTNwyxAIfxubq2bhYWFpZ+p+4rH3j1UV8B/2H4VLsZYWO6WR18XkE+
N/9R7CDLma79DZfH5pfz/1wVbDXGKcQ/8FtjnuTJ5ad2uloOGgSO53N5RmNc
LCycR539Wx0tUVv5cK5VcCrQxnAFrebpM1E5fxrGm+lNlQGh4GaSl9Wg468I
IcMzz8xpy3HaebEKpxEYpirA8ji6HPp1y6S+diERS6Z0N45i18uCB5f97UfG
Rfl08va7nnZmpaNdyLb9O51H6djzEp6ATR/Bx+ydOwJ6m04KCQsb7my1Ko4q
fvyb59cMMJsY4hfgMsfCxS35byB5RGaM7+yme5s4uqXmfwA94h46bJzx98EP
ZbNe8NMui6XLz9pB/HPYXITQzrcYYhcSGRHowJv4AyEGavej8iEpbQHlEq6M
eukLhrozQ9syoCY0o0Nl/yp9Gr/gogfPNTDM2cTmSHaFuD0rn0RMtYpJ4sMm
V9CKIXa2PuGr5pnqu8QkFAqqX/+03rmPykawsJg+zt8v1Ku/nTj8D+efjZ8y
eEGgpcHkQ7fJvhKVZ5JNwJZts3pY7rx2/9fpw+xC5m0PXTKidbvZv6QSB3Og
oPax8FwUEODizfOiREWCyddwcdyHWsW3a9IFQrw6P2EnOShEgj3V86rkXdWl
N2eMGERmAunoJJK+EcN+fcXCA4kLnviP/CIsplDmu3jh5qAvJvs9LWNXMHXU
FJjQFZpFNKEEBw3Qazc7/ig1lx1wr2HcWTI7s00AjPdT6d7UfACK5qmdI/v6
Tu9hGHH5kaDk6S/jrJz9Fy0a4tTJR1590cCocGpT9g5rgfWJ2nfBZ6ql56yQ
UVONnFxppI5R5TKjdDgrfyybCVT45sGPg0RTPJjuDds6TCCm+5DzUg+tMhtD
9fyiVfALkl0Gtp7pDzu6OGaBSOYlRnvt9X0mC2KKy4gNcXMPnteKaCIhklBY
mbi6VXszmbBVxWCAqpLkcX32PhPgGYcn6YrjAUqextoOvVQoyHA3wfp0HDSP
fC9x0tbe+ZrY0BZ10M6+rQeuFCffI7z0HNe9qaRI05VZbvUheHBlkVFrz5/E
Izr3ZrgRy/WpaDjET2lvEHlZ3KHnd3zb2vinPyukX2Hvk6mP+pbEzu3zc5qg
Ku+glSTko/ZFsMmci+9qbyaMbdV6iu+Q+SdvEzY5Xpnm2o0jq7LqEhAoSN3b
e140aTzAY/6Y7oZ7rAdn1fvUiVZb/6iQkQEYZGtCyg/+OCVUtHL3jSqopBMY
hiqAHXmse7vZu2Ev43kRHpjDuFv/qipVbXnaxC5rfyuHYTbcUaKpXNTuNU/9
nDndQORPORCwGXPuwEQQRHfrBoi9vnjWxbmdxQcYRfbA3EmtFhETiuDSTvOI
uOJ/CUfENw7dPPeBVRJxWFLHdEV8KRwWuCB/W+TX7S233cmGnVsWv1Q3hIzz
ETxIWWbS7jv4Q9E8+NMapy+k7VB/AYEsJJzhoRr3BWPdmWFoGZrRoaJ/K5Q+
DRdkh/XxPJUlqCQ0njS8Sta/oUwr1lzYMaCl/oKV84b+yNgIsSvsDSx3/QEm
msqiVPfRuiM8fy8T4s8uuw8Jzi4HvxpJfEI0UcLyLhuSysuADdCV7LKaK/HD
W3Jcdl2sqChInjisnVgT4k9uRPXUNdtCFhv2lEw0fh26AOTB82w9AjYm8ais
OcM5U2XtNPU9z3jm2Vlf0sleybNdX7WYeSKLzZPUUVNA+YiMxDG2i5e6A0KC
necOb8uhOfkL/W8Km7CND+xKJmdaHQcgPye+v/25t7WExuB97fa963HYFESw
PWfK4fvsqk+vcIqifbmion3L25YO3ltBDFXLdYkyiYD4TCqXGSa1qfSxakyg
ygICldoYKucXraK24kngZB1TypH8zOPTdCV737VP/YwCU4rh0Oa6Ts4oIbut
MnFNd7lRVllwVLQIoLjjSFVZDQweY3LGrzq52Wh1Ynk1iBywc7wstrirkzaZ
SNyt73MSbXrqzAjOlrrrqwkjCu5r0JdZdmcWHOZq4xvxSvwVQdohZxP3DBbN
L7h+2LONjsfBNOkyEuwvyIYKg2UXi3NY9VBfcnji4ACaeDyWPtthTawKwaqW
sn9ByHB32aDoOsQFVRT8Oqz33mdi/QwfjmHTTzxm+QA8/aC5b3ShrAyQY0oq
KiIxc2y1JrH8EY3AMFQBruhN50eJexnoPTa71a9vh1t7/v6ROCTYhtN6YYqs
qhGU3pk6nGNGEbDSvESbDtHkdhUIHZd0/V83FnfguB24XSusypxutDy9DEaP
mC+VHG8EXUmuF/DSQ5scWup4J92rhoJAJJfw6AASQeCvH2wy4ZhJfljNvzba
jHIgUf1+VBiSZP3YSLhSNO4LprqreCVDy9CODsb+ZXra69sRfQgtgacfdteV
zn1VJ7fZSo9XKNWKYFCraAT+sa2jdSlFAvID8qjAWekVXi1aNbQhpyFiNjHa
/PsnBaECCPj3Z7pwKFqldM/SLq0MVtwid1EVQjc17wKwVTpd70uzfc+k1lp1
0sYesqlZoc9HjUOgteUZHvr6SgpQfmS9vp1rWrGqh6mlpqDykUu0IuqX367/
NHiA3hjHhCzKBg3U81ir1Xf4LCvUQMDjzAwxaXUcgLUpu43C4z7UAOdG107R
GW/JRgAnLtnmhqVVONBhwtX7/sR90ocDjEBi1S95qAqVywTTcGZ4bBn7CZSM
H5A/S85gYzDPL1oGfu+4V2sZxzhIufzFqnTg4armp4f733lP6kDfs8/FowPM
g+bSHJUEIDMAdR7hJ/n73ykSfspL7M2RmNb8pMC1mWWKC0Yo5MSwBTmX2kjK
QL4QCBIQaboyL2zx/yirD2J/wZUDn1DDf3nmyi9+kTTbr7SU5iZa68svoODZ
fKrQAp3M5hxW3esrzLvjT+xD4bkRUzg9xKYR/LAGZLWy5J3Kl+xVE1pL5sxy
HeKCSmL9v4q7SMkFBwJ+1FkXl5/e7HszT2ZeE48pikIT6Suz4cdel9IJjPIq
gBW9fvstD8pkviZ2oTDBf33m9mOBEneu4NKesa3gQhXnZ949v3ZHeB9jzwPi
4Af43q4d526POpmRyZe2M/92ROj9DwrRIzBSGnYl4dzgQunCi16lx5/YMla8
WQyFtg2lOnJo0I8KQ5KApYQrQ+O+YKg7M8wtQzs6GPqX8Wn4g1MzElMragVZ
c0ZIPNWkupP8V6wVPx3daMWhakVgHrdh0QhjiAlCHvFjZexPXPB38pnXlfQh
SVBQ7bafrqJtQsXqa9wFxAR32LO1vPcGGh5UWwvMemocAhVVYciXNieVBTZU
vDlp33q0ZANICeqpKTAo6MfRk+SANhjmODJVMlHA8EKVqbYF/MzkDM1TsKoE
xvsxxaTVdQCSk3XJH5uNMP350ZKteWDVsz7rTatw4EY2VebB16izpyqVy9Ay
TMOZ6bHsJ1DaeyiYbQzG+UXLgI5xynkiKGzygQdAB1LPUpWJpmn5pHxAJdIc
TQJSRFWVBMBNSv0yHLaiBVeF8B0hh/KTFFyREe2ppMzUQQ2lzsTo++Xu7l6e
636KPn4nU7U4AYC5K6/r4PKWasKpeyqkDvWV+YQ6PCUfcudGSWK9wAwiq/2U
xAWpBH91e9lXIO5LCnk3n7qXhoBSSWVAZqEhJGar1LGdYh+RdaARGNoqwBU9
td9fp0d1VGcrij7nHhQwnVFBE2fNcg/eGPHz2WN/8WWeSOwCdBFf52TeTTbw
RiFpefGDzZ3J7F5kkge4DxXmt/2XuBuvxNtPoPD05gFDIzBCOyRZSrhSNO0L
prozo7JlhEpGB23/snnaO9mpkN6hqqAVFc1jhUYoS1j9fxzlZpvksdRZCXxI
k6OstjzNzVJm3pcDtgml+pp3AUyhzJVdqJLZVKiWiZqnQiqLzjl+MTKeycYT
XNo9yMD+XL5SoVdXTYFBoWQckfvIFMVOTiUqNhdqr++zWJ1Yl1tOVMBwnBlS
TwMQmnyUW+fA2qoz28MmtAoHbmRTLUMwCqhio1rlKoVpOLN4LJsJlNYoYmNj
1Dk3b2MAvbJU0VJoEwIFHQh9cbLeUQWVSH4VaI9v7M6/pX4OPNUK74XaA85H
coMUdg2hlpWUWeb7IDpCowx+UK3JibFoIHzHxWSW/ET55TcUGKhDfcVvAHN3
i/nJMitSBTc1/jpqhk4HmYIpjGt2UAOtKcAwaTUFG3hIJF4axTH17sE6G7H6
ohMY+iqA5SS13cqPbBqgo0aGBPrYNph1XM7LTfNjQeHVK0eD101pz8UGSWM7
4ZiijiDYv7DFQGwM/bJapRmmfj/SDkmWEq78oZr2BUPdWbxRhYFKPzro+pf1
0yitQevfULQMwXzE2AiKVpMCwP40XEgERUihDUlSXCfKoriHpXEXkO+Smweh
K4Bqr0LlrBB+oAxit7c/xe1GS9X7VJd2xso2rNVWUyBoTdnturCdqaMDuvGZ
Vb2g9NZ3fXawi6fVELDxxNSw9TMAFSI9iDtc9Fl3KL0NIJ+4hggAsJWRJZYq
l/aVDMOZxWPZTKD0RhELG6OuuXkbB+jrppyUl7aJoOBEsPjAO5BAyupVsvOC
i/di5FQiXpIw1ysVXN4EFKM5ERVf+2qT57G/QNvCJTM1ehB0pe1mYqTDuBrZ
pgNvbKO//i5fWZmJ70vKDMIaNbriFoRvycW1Ql03khJPqK6bV/P6iiMi4Kof
GBu1vx3z/JU8jAxifiiugDLpRirp3pcd13jOzekr49nc4iRI3dtngdx5PQLg
AmW3byhXfUmXKYwpwfntPSXraBqBoa8C3IyTrtlhEwGHKrWJGKDPuQe9AUoy
zeL5j/aPs4u6Jr2bvix+acuvKK4PoI0pWgUoRn2yK8FlBPTx6lAMlAdTqd+P
9EOSnYQrRfO+YKg7M6pahnl0yPev6qcpBLeLt2JLhW/uh24QHxCW14pkWmap
6UjTCKDxGfcWyxLWWOi0XnLjrbCSknKENkcZ1ITKw5LFe1if8IeneJOJAatx
F5DvkrVC4UIVKjEStU6FvM/ZZ9XSm8W5D/ze8ant6E8tqa2mGI06uHtIjdwW
EnvNi8w4DCcjcP6x9f02HWVKIVhn4LY7Q8PWzwCEjUPxqkkjE2rJWAUmaBUO
XPJTncNAw4OdCKjha5hVLjNMw5nFY1lMoLKGYlXJTT+vq0WsbIw65uZtJODC
RzJSiBSdHqDYNZJ4fqFihhzQUG3mEZk8i2N8jHaDxqEulktzD9j3OZpLfFyW
sNqshWgGLBUWP46xETtMwI6S9F4huDSwJX3+sM2pcSZ49s1IA/EdlGzKDNyw
cvcWiabvH4e5pqpI8wN9VjLBtCU/Lfs/XWmsNQHrUyEkdakvBAwcQt/WCh75
9Fh4/S14jrwtCnddZ4j0ak3xuaFGhKKjblERwYe9ByaxOG1XmveL8yD6QB0g
/OoNWDgYJV0GZgrp8Kkt/21qz03iyBUagaGvAjCuqMYMpYmy5nQJTFHlD1Rq
yYNNBLnbAImUIP3Cr5cSiXA5ej5npG6EwmhfalZboI0pYeQgyZj5InKeAnaC
XJA5kUGo34r4Dy/kxUBIFVoN+pF+SLKTcGXUoS8Y6l7KaK8rDhCh3HBmNzrY
Pg2aalIJl27FliUsN4ohrT6FID2Fc5E0jaDY+LKNAOduYI2LVkY9lpItQ5+j
DM65cnYOKahvqcX+EBcItbTGXUDzLsJBZyN3jZpap0JKYsPYZoCBOWQUL5LT
QE3B2FfagMB3z+KtTWXOL0CIU3umMoGClJLxz8Q5Bq19oSQTOz/97N7fc+p8
9x90IDNEH9XTAJS34YEvwswqSaQYnlyY3FeVP5BG4eDkXElZPlA1/JY+0B/I
oHLfMjcN43BW9Vg2E6hsQKAgLbH3dKDtVdoYzSMgUAhOSbtxRgPLHxcU7ov2
6DJIx1iko0S9bz7xNFzSKoSjgBgnYqSXv9g9eDAZrQEEgDzmsHJCv4Nkkiti
0hxItAOZyx0+EegKbMLsLEID4KWH1vdtL06YICSM7UtOPVqEkRsi8rlTZMpc
nb9zhbtimaFl6AafT8C/eX5ZP5sdD1QfDMGfpYS2l+wryWfSIGF9KoQscZ3q
CyCcz6JZ4CP+7LKXrVhzKoQc1JzaYqZL+BmkC2Q4awPtLUg/bD81IlvlzREf
i+74TuNGKIk9g9pVPdmWEbNXUT4Wel10guASQ7SO3mAVEVckNqJoBIa2CnBW
oqZ7JZpIpOIq8exrc+1nZ6k8zAcsc9p9bUFqwgRup9hH4nyMb3NOe1iN2UOE
E1ed3d5zkXQyEjy4EmreO/G5xEdB3jk1YlcyUXLibNq3kkRGBIT3Q2co/KsQ
JLCKWWnlBb4gKwZCOaHVoB+VDElWEq6MuvQFQ92ZYW4ZoZLRoax/VT4Npm/6
htyuqr53xl8fmBOl8KAufLqCViQSAemrbATZxldoBGIDi9NZNAsLSi6NNd8J
fV+KvhQxxGW7ptLACaqgkkapqNj/lpwd3pN0o2ncBXLvkssVI0aNUyFvHmzq
QV4Sxwb82dWQL2WzSWukpgTndzoqxN4ICRm4sMrcFOtqEHw8VTF6HH96e625
np6H+7GHUotO8CzzqNd4m/V7lOWyKz++1aElVg+3zUJHPcOWdD0NQIUbBkGE
58yIvCoib5LXOVWxInQKR+EMINDw9iLDTLT2DLYSH+dhULkqYBzOKh7LZgKF
x047g4WbaNHh1I/U9iptDOXzi9bBL0ieZG3iHRxsbzn1x4R80WrIxmD8gpm8
kLXkwWegl3qFxxRJBJDIFTDZwN3HZ4C9tMq1FU8WeXcaOznI3nLaz9K+w3Nu
r7Yw8V4wkbdCYtWA5XCvrzfERvDc54GMo9NOZ8tEqIoMoQNOJibe7gEuPv3N
bVaclh2YKssMvnPDZ6rxeKeQkIXePMtpa6PuvmWZEBXnX/jFz9zEOzIyaLCD
qefkY0/kTUew18A+9qzO9RUS6+5bU7vzZs0fakvJsZl1ZvYXekEXpFuTxKK1
v8H4YD/e7MCHH8iPK64cmmpsOi90mqXKnJ8VBWdcJw3QA+cdDNs6LIx6QW2z
vLs/2IGcmQQgHegC2S8wNcGjhOH/Z+TpA3N1/vXs+vq+Bvbffx/s7MoLjaSW
ik5g6KpArETI/NLSJppk2H+2bBMxAFqP6tOjFFeQv3/7JFPLwKURgQ6jLKdP
TryfLdac/D9XhVjaDQlaFBbiNNFsmmxXEtqYw/Fa+ON4nusCkPF7YwzMICdB
kJX2wwDjcQv8AlxmD+tjtzTplCQzrVgMxvn7Rcy2MvWQFVo1+hGiZEiykXAG
6tIXDHVnhrllGEYHbf+qeJoQaJiJgwzcnULmeNhFrnz8+PqSr028g1xstiSR
u36KWpFtI0gaP4Ac7MeojYCXHFjbfYjt/LG8RZfEZjl8V3B0vuK+g8gYWwIS
5i8hu1IqqMRQSl9jbjQ1wO67vdLe17gLpO9aDBotOvrPD/J6kbAZ2F0NBmP2
1IU03jRQUxXlmYETeF+Ph78i85yTgC+bGnivX576l/JjMvyC62FRXoY9ONai
37o6GnZ0CvY6SGltml8c2ji4JcdxzZ4i9pEzVD7mnhg7kCweJi32kB8S5d22
9TQACfPMxu78G2mVBNcPuXWzmD+P5x7Pwh6jUziiudK8lWHsQ6nDV6Thl5l0
mxMio+GZVK4qmIYz82PZTaDCd88O2HVy8g+f3NduDzXBCLONwTC/IBQC5Job
Cqc8mGn29UWwRj4gEIH4z6BwJAqBQCBoAG7SJrlfuH4gjLr/yWcUZ6C51xfB
GhAQ+FnfL4lAKINYAbG/WgKBQPxHUS/5pPZAhAf34nj4Pc2/EakPYkfZ/a65
1hehNnQZ1BGIzxpw+wzHOf5RafzSlt2skvKQFxyBQDAAk+pr/blpRZ4m+7XR
80zM+mf/Su5oz0y2tzY02/oi1EUxPBuB+Nwh8mD0ttz7qDjNjWu/9VQDJkxG
IBDNnby7P9jC0FwiXvfbaFYJ67QF4mi5q+XsCLev2V0/J2zm9UWoA//oNg+T
IT04IFJ9guXK63lNXSIEojHA8x/FDrL83n+S6Wx255UQCAQCgUAgEAgEAoFA
IBAIBAKBQCAQCAQCgUAgEAgEAoFAIBAIBEJLwKsLr59OOn3mJb95xkJ/LPrj
ZNLprLrfa/lZoIWtQVskLSynNgAHY8o1tpdfIBAIBEJCdenNGWNH9ARnG+FV
O+OH/vqX+KqbNw/ievPIe2sM2zpMG3WW9sLu/xK1aUnTLcGxX4b7HLUWorvH
jzEi+lST9P7Ez0cM+mqkVQtCIkwcTIYNg7cvTXDqaELcvrRR8T4pleD8s/s8
TCwDfYabLZO9NLmhqWNrsAPPf7THrptrUKBl/1Gqr7SjFEl6ySnthwihsDRx
4wgojewuLNMOmk7gEQgEgpba8gwPW9G0TnPl8dOLfu3azY4/ihbaUuBlcCPc
M9gmDNQywAXr1Hu91aP0+S4TDOtO3LVN+RTnXz3sp49x3b0y1UoWUXBvXWcd
37NvC3cut9dtipyKdWwNZoiRNUAnKPpt3vWILhz7HazeAnKMYx5HMnFVHyJI
aZwZkddcknE2ucAjEAiEAoLzOx1FC+pv7M6/pUwyVSU3v7MKTn6kbTtQVWd3
OLbSC0tpgIRs/zze3pPTKzKOKa3f+8fbjbXOJ0PbJvjz9JWhMdkfZb5ZFr+s
K1aHC86yzs5pjdElRga3ZmActwO32TdMYbSvTifj/U9LLg3vxRntekv5Le51
p0Fag/mND898/wXmmpBdHBv2v1YGK27lsakekYNXR948oP2wnmEj/NrG02R/
boPZ8A1AYwo8AoFAsKUsL7E3F8Mod6LVVjwJs7HZn1qhfVqq4srPQ4d6pbxu
gK2Ud0/3jbZfe5XR7gVWkGtCulY1DF2b1GbNHoT1sT1XKJT/UN6PpwbAaqK3
gQuipmMYxg2MLmI5JUOf6qBxtz5oVha1aJDWYOZDXLgh1mr1Hb4av6ktuzaq
K2brfK1E1Yf1Dhvh1zIa1IavfxpV4BEIBEINCqPn6otmcM/gF5+EQlyQvy24
96ajpc1lgd2IVCau6dLQPpl64ePLfeYYNi0455PChyM9fy/T7KHAasJo9yXJ
P6nhIwU+VTWMxrrQIK3BDGgQdS8UBm0iH5hB+yGC3rDXYhpT4BEIBEIt/rqx
uAOG6bff8uAT/9TW3vOjG8LT1vzBc4Jdm0cgOu1OWc7V0LZ12MuGl+Ry22z5
o0r+T2Jnsu/Z52w9ScCn2kh7eQ3RGsxUvTs5QO0LhfH7Jzz1MKe912pVfYgg
pdHd72lz0VSNKfAIBAKhFuLjIZZz3AZP9Ed3QdJDbOj8j9Ngh0nrEdqdsk9H
N1px6rCXDawmWhtYcGnP2FYY180zk/V5mZpTW/tydIKSczUri1o0SGswU/xg
c2e13Xcf4sL/x+FuuPdR5YcIKI19NiV9aia6qjEFHoFAINSFPB5i2Cn2UUWD
voifdnmbs4XF9HH+fqFe/e1kwpD4BTfmB/c35/kvXh7Q29g1Zk++ZP9OwH8Y
PtVuRtiYblYHn5MlhJeYz3Ttb7g8Nr+c/+eqYKsxTiH+gd8a8+IfFslPDoKP
2Tt3BPSx8FwUEODizfOSBNHh/LPxUwYvCLQ0mHzotpx9J3j6257hJibe/guH
8ty37V/eicYnA2rkYOrhHBzgZ+3gRk0Ggr/NOeU50czdOTg4YlZvyyWXVcVc
iaoZ5s7zlqmm8P3LX4abzf71PvHeijcn7XtxJs7O+kjXJm8e/DjIwsJiskNb
LpHYZ4Lo35Yh5x+Bd4KzG1zuiqQrmwZbTgtfHsoz6rs6Lp/10W8wiylsqoJe
2Nm3F2fUyEsqs6AAShM3DIEl5OrauhEl9Dt1n2xSvDo/YWdAb9NJIWFhw8YZ
T/W8KnFJ8wsuTrIJ2LJtVg/Lndfu/zp9mF3IvO2hS0a0bjf7FyXBq/XRGqIe
PO8PZXLpPBuryCuqevDV7XX9XGBSF5hIZ+Ci6Ffixwqy0sSiEuJsYrU+lfI0
/NNvk/vI29i0HwpVjRT2IkQr/IKPD+e7Wk6d0W2gqE8F/CtJgTxrv8hV877q
5J1wkS9n1uKCwqM/+5mbeC8KG9dv6LEb17fOCU3/h6mNRALz0zDeTO/xBnMi
sqGnVKZI4npQh97+W2mrpm+8mS15LrDhWyy8+ob88oPL4ba2wd6u3eYtfyHx
vr57tn+o1YbfiuQKwDBgCS2xZb2rhahhI4MGWwxkPUAYepZJ4GUbhn9mh9uQ
iFk9DCNEiqKyKH1hoLWDQ2DYkinduwUdu0Yj5ILSjBkuxjp6PmceNRNbGIFA
aCn4yxuLv8TU29FT+x2C/NgV9gaWu/4AFlplUar7aN0RZFAWsCVaD1wpTp9V
/Hh7D47r3lSoS0ti5/b5OU1QlXfQCvtm22kwEdW+CDaZc/Fd7c2Esa1aT/Ed
Mv/kbWKGwivTXLtxZkXkUjct+QXJE4e1m0k6OfEnN6J66pptIZ6DP7vsPiQ4
uxzPi/CQixATPLiyyKi1534w8VUVnxtiiMk5lIj4yciv21tuu5MNy1kWv1Q3
ROz/qSw658idduReNXgn/1TcSAPmrWS85Kdgq7iLFZ+o1RTWXNhpr8OZcvg+
bLRLI/thJhZJf9O2CYA2BA5uUHJbWc3zufOWaGI84/Ak3S9WpbM8bwC2wjGZ
Fwly/ry45seA7m0dwkPT36qzLUd72EFkvQR5th4hNiZxQdac4Zypfk9Bj5Ql
LO+yIam8jAiswroaRAJzuuZK/PCWHJddF5lOMNWhNUgB+EmcJSn3ZrgRqyA0
Ot+jaIqPn9KeLDnx8PM7vm1t/NOfYjsNllMu4Qndh4wjRT0RohX+2uv7TBbE
FJcRrzb34HmtiM4uBb9LXN2qvdnBlxT7Bch/9452J3NBG4ID0ZipZVKu8v6o
ep860WrrHxWgwcWhBZQiybS8zNCjum2BNEoO9bx/sXvwoJO5ApxQBdJwBZpe
YB6wQrxwcyB3TsSrSrKdt33dKkxsZypHVc8K2Z3uKXm2deScrDJwxsry6+/9
hsakSwvZ0kC25SHA4YxxWy9MQQ5GBAJRB/gFF8f3njVtGnE8RM58qjdw/rGt
o3Up+ooIROQ4bkggslK8z0m06akzIzhbGkNVneFuQmbk4+fE97c/9xYHs4x4
Lit9tsOasKmAqucMjxGfZCGMwO6Yg3uGxKsg4N+f6cKxc7ws9g6W7lnahcza
AS3JV3h14UnbNjKm47tnOy10dHzIGUEID8DKBKLjpYc2ObTU8U6CZh7hyHoV
6dFBZKtAZ1NKvENr8TxVzb822owDj94ooywvwdbmZL5sNeF8R0lPXZuy28Jg
3K1CujaBpaCNIsu9ESnqXR7v6EuyPsQs3AqbfuIxY69J2rDk3GDR73VGBU2c
NcudxMtz3d6YlJfqp7pQzPCGC7Ijput9abbvmXTqrE7a2APuhOLlaRONNv/+
CUb3mS+NY7/Nqnlr5N5dZ8xp4ysVAEHaIWcT9wzVpzuBm1H23LHg+mHPNjoe
B9Ok1ty7e9EdKRuatIGLih8yjxS1ROgDrfCLCm8UmFIMm4jrOjmjhKxFZeKa
7pjuhntSCa44s2N0K0pWAWiyMsbp4ekHzX2jC6tBvhRjqWEjLhJsGbqhp085
kAWlURxySS4QcDw3Ygqnh/iZeFWml51aAxaKpeTck0hLdNLt/vNzFWnhVfes
kFVKw6qTGyx2i6S05nfPbzD9dkuuS3MKKba8pEb8uxf23stuRme6EQiE1iGy
kWZb+Z57JHieHNCmwXaES57t+oqLjfH8XTG4iVDFM9pwZP0wcO0MnQN5d/xj
kvi1skoeflgDVL0l71S+ZPeF0LfUU3gwYs1u++kqRVVZzU8P97/zXjQ3HXbX
pZpS+OuomfqYdL+JzPBAdSjBGjmMu/WvEC96lR5/YsvYccbfB0siKqH7ZciC
WT9fOPYXm2vm3twPXZpYIjc/wgB4yhEDPOOgmVdU/v9n78yjoji2Bt7DwQgn
qAf98EmeCspDkOCKqCBGCBG3KG6IC4gLcUNRcEPUjDtuwSXiiiYBExU1KjEq
7gtBoxIjGjUEFSKo+BwfjIo6QPNNd83S3dM93T3T4ETv7+SPOMxU36q6VXW7
6t5bj9nahITVi4wUhtYI5NfYojxYeXRlWSMMa+L0zV9SBCiQtg1tUzFzV5gt
5rks9SWlnVBGGsIww1V/H0t/8MqUrCAmtgauuhUVLEM6WaG8m37ih0nx3V07
sLgZGIJMFOqucml+ant7pCp6kCE6Xl5Urqsss2rMD3lHiigVes2m/NoR8ebA
Oh8r6rkAadlS451RNBC1UgL89F4eWj3+fIHhO5dGJMJG4hh61AeRTddEnvyC
3PwsXD9q2x8vyB1Ryjssmgeor3V8A1YTwNvdZ/WupHP3hb3aCOhZAgOFN0T5
47w99yrZNq7Jlje+vwoAAGAa6mVl4eAOW8ljl8qXmf09MQzzWZ32Uur55kXK
4o9lHJbYk99XN8aYEyl6d6YeoJCf2E8lthEYX6Pe/EWuaJSTI1QpIvDZSCoQ
cpqlWpLkckDzxSKtIOoChwwJ+z4+c+aFhMyYtP4Hg4VDWXSsb4Dm6j272r0T
hPkXEWurrI6umuTCSrWOXiTPbrRBuzVk2CbsXmTkXpAdxRZCzSI4+xy6tEJs
uCsXTCd5tGljxziNRQmoqXaR+KwgJrcGUgCXxl98SW54bknYdzGb6Q7HhUFU
CGlQMU1c1KRaS4asrEEmQ+aHAkeKKBUyVH7dh1TDA5l8FOMEVYoaXs3w0zMC
fmVfuC1t+/pF8oymW8jdWo6hR30Q2XTMIAuG1Wq4A8w/YInD4vlda6ERi7kM
Cua97E9Az5KPFhwVgsSm7f2ilv8HxUEDAPCPAS/eNL3VPP0tlmhOw/x6nJE4
A6vhgk75GzlnMpJ1IFuOat6QsllPPUa/sYw51eMP5KOsGlDu9jVcIg0h11bH
mYlPtT9Ch4NU25IUkrbAFSeMt8Nk43/KNV5zVd7Nwyu3f9m6g0xmO/fcI+Nf
1tZIvz4yF1a1vTSy6ZLLGuuFpU0MrGICtJdCXViJG6xEJEghK0tb18yA9EBz
NOgjhqmG1j6qccLq3Wcck1uDTOhhWlY3pDwUnUTKz7CO8Py4YXY6F1zWhCcG
HwocKaJUyFD5WR9Nmm20gUb6iFL1X8SGlebuDN2uMv760jCn9TdUVZxDTzZq
ny72AS+Uj5L9i35/N848ETDcARY4YKueP8n57mDSgIg21pj7guRSYwNEQM+S
nzAVnhtSbNrbEOpfyBEEAIDUEMFoHcJjblEPypR3d7QUmfBNEKTbEsftDOVp
q1wwRrIO8pSzjv3yy880H6C9GtI6rfx1b9iPmvA68kYtyi4fuQeCjpmUaVFR
F4urFIR/jnFvnBcpSzysSAvtVf4PU5bff60RifI+Tq47H6mXLRy/dnDMfuLp
5B0ZrI46ZIzDvPG+CcmPdQ8lTogEbQWUJM1soM9HbbCwPr35VUftRhBbm9Cs
4jeK85PCTxVr9lKoe1Nklcm1RltlY6ADR0yiBBeGTvKkDxXDukNrH21TWvw1
Yaa3BnmtsMuqNP5l2wCDg11S+Rkn6cjE7an1MNQdpKqKf/RvlVbA/qGgkSJK
hdiUn4Bsasq+vc7rANf6ZpCVovrpCXAI1LYHaYRTj8sf/BLrp4kAYh96hMlX
qRl6lfr7ux8n9G6VdlP/dJ0KUXTs5aGlUy4SAcLGBqx6MjySEhEQevqRznJX
l9DIKtZ4kh8BPVvFpvBcoG/S3obI7iMMyAq1Ap9evIZnqAIAAAhDlf1zZHvD
+yuRQw5LeIjqbOpQv6g+TT23/3J97zDf0GmLJrraD/3GIGUEO+RM3kwf/Yc+
VFuh3guSS/4iVmqqTz6eez6+oTZmBPEgS+5AmgSVqhvjms08S26pGcyupOVA
eqpXPD38aWNi5kR7GlT/nCqUBMN7lqYQ0pQiJ23Vz+ubzSPe/fHzKX1rUUR6
lrejFXJEV6+G7oMOERYyebrEuBdMU6PSfGIfyTUmQX9Iff2nUf+nXsf53+aJ
pUoXJokqSAlyebl7SfM12qWZrU2oGyCqzNTWI+UPVJodJOYRuabKG/49i28/
EJ3QSeUQaOgkb9hHb56d7tuBcb+qmQ6B4lqDrLLz0tRXVHur8MbXgcGneZ5v
GBViqPy4Ysv8j2vrLxQmdUltYz+syjsxqr3GjjL8ENm0PCNFlAqxKT9LU6Pz
5YlE6z1NHNeYiF8gdwKp8byk562gxH2vH+5pT3WZwwsXdhx9XPN+wT/0Xmiv
UCkvzejRWLO9Rr5H6I123TUr5Sik6EWV8QGLosW9Ohz4W3e2/fiAT60IXcwL
O/w9SyAgKkRbWdIpkbpxjT4hZ2P8+gG/uZSdyeePf0n5/q4QZ2MAAAAquOrx
D1vHNLBm3dhBkzAzPKS89HRo4OECIu8E5qPJCFGetqK2i1AHLfzOyen1KQeX
que5iQtbhZM5W94oMoKaWc/QHEgxM2AgiOM59ar0HL9zPNxHs2lgeKNWxcE1
LWoT66/q9PY20xLRAZliw0xbV9+fH2k3NR7lHQpt1Web1nwl5n/ZR/LkFypF
xufum1BiB2JHVOa7jlwrlQ9PDgvztLcnli1t9CX5dPXyZPXp5mOa0Dxqjf57
I7HDpxmPtfOzsuhYP6cBBkkIWak8+93nNpq9TVXWvjH/V/8DV80hF/7gt6U+
gccfapcBtjYpSZpp/RG5KpUW/BDknUpkiiOXqjqUTRuyyk2XpL4qR/k6eOJd
0aacZDessTnJ0/qIkStGIwTp3SfymjDTWwNX5U4Pteo/NkdbZeX5n+d7d9h4
jS8wxDAqhKn8zIwiVZpBV3vFlfKniZHNt2rSIrF8KGSkiFIhVuU39L0kvRyJ
sNmXf23t2vVwYSXzKbd/XeVub3AwygE6uh2I2hZXHtveJZpyRRF16D0vPj9y
JHPokZt+antPVfTz4A7aqYCw2awaoINyXPUgYVoLGWkTPvtlVnttMJqRAYu/
uT6u+ZQTOidVVeG62U66NIZGqsLXswQCokI0pZFzL+3kt+jiggbkJxWlF8d0
TdbFzhOa4M5I2QQAAMDD8/z9nw8l0paiYAXvFpt+e0b5c8WtuC90f8VcHYIG
eiffICfZsqL0NWmKolPT6+pOisnFtLPwe+1x5ZEfiKSy8ZMn9x3X0b3Dgr0H
H2uPNtTL2XdBLi4RIZo/HTrN3GB88+zCcGevMVM/9aF4a+ekj/3QJvqIPoUs
kUCjY8MBMZO8xk65XqL9WG1UzJ3s4ucTOzc+uqu/a9iQ1KvUpAq44rulzt18
pn7uNTtDP3urrp2I93SJmD17SFufr87/XXrsm+CmHlPHeY3df1X/nZzMrzo5
9Zs2aXLfsYFtfOel6WqEK0/sndbWI3LO+PEDYoI9vJYe+UVoWAEhbXTTVu1n
xpGZbHPzT44MaRjgEztrQs9OPb/LoRghrG3y5M53vo2ComYNaeu7TRPKWvFb
WFt6Jl5csWOBY1dmlQ2ovJ8Q1RnluSUuBibyLXdOSFaYt+qQTvIG1oKuj+bE
jW3lGpqQ8EcJXSzSXPkPZXNVEOa0hrLo3LjhTgOCYmNnRnh5jlgqvywkFyJp
Lxk4W+qUX6OBe2/RjUmiK9s2Hj7KdxxFb9k+5B8pVWJUiFX5UVPPSizWRxup
cuOGNAwZN65TF70ZTKT9nOfawSc2aoRnyPwYN0fhJrq6Ftt8Gnb54ouYHn07
zFvI6Gu+oaeWeZmTR/txIwKSKDa5+lfzWjQcMH1mVIBv7N6cO0lydb2iendY
8esj/Xc4B2wVXnT7h36dPcb0i4qaF9WhxaCViSg7Im9VeHqWS+HZeL1nhUtt
eoJBdcvPH1s/0GfqcN95VNuSSK/tirXT5lwFAACofsg5SnvORX31BgChkE7y
726+CzKugRrF8H6ATjxFxey8L7zjCg8AwHsD6eykTRKCX9kf/qHt3HMlZadX
7rglyTEh8B6A7l+uroTkbx/yAJrtcod3GpbEJgDiXVd4AADeFwjvfVkrreN3
ccJ4WY+QS08Vx0ICDxfBSy5gFOKei//IQifdLiSipEfx+Nv/0yBOSyP+9cFH
W/8oJUJKJxABFO8yuKowaZ7vrATNLb1ECusIK1dBcU/vC++2wgMA8B7y9Pev
/q3PdKe6dGC0q+eUcb4zjhlxKgMAktvHJtWxCUvN+e83C+16h2WXvm15pIUI
BrFqPi7mVn6W/KNGX119xv+TfzRkKK5df9SPHNEQ7znvtsIDAAAAgHCInDzB
nmPj+rcUdvPaPwy1IbSpZ9vwGG/X0G8FJk36J1NZdmv2aHt3j6lfzpoRGNy0
R4+tv8L1tXTecYUHAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAC7w
grheDvHyrPtPcIG/ePPsdF/7Uem5Zj1Wpfxj+ZJB7h6Rs+PHuTftvzThjxL6
83HV4z07JnfwHD4tNjZoWNMA36+O/qKsMOuZqNjCdfENI+VF5Wx/fJR3aESw
04Cg2Nj4cDeXqOTUwlf0byiLzk2IbNrUs3tzn9qNGkYsl19+9IqlICEoi471
bRiy7yb7H8//vNTLqd+0qOjPI1y6+X+deVNl2D3Pi7NmzvzEyXXCnLgxrT3j
D0nQPqprJ2Y290z7m/sbRhtQaCEmwKJ1/KqLX/rez7nHD5ezJdAcKtwtL+iJ
2fsGN3Cdl3bw8WtNaZcXLvT0HPJriVlCqW5f3tozoHHPbtGTIj36Bv/4J61Z
8KLbacNCXXuo/zrRt1mrhYdO0yQsK0ht6xCXtveeUug0IAhiFH8T07JxwMTo
6K4eneXLc0tpQilPHviyk6v/FzExft2aDgvZe6uY8XgesUVKI2iuUz3PXbPy
cxfPKfPmxfq4uEyJOsecBbRflETPhbW8oKlp6pTANj7jYmcNb+wQFD89y+Sp
SfDA4ZmmpNVzgSpqvPuk1nOBDcXffbwLohihRKzpAuZz40uVUES1vJEn4uWF
KRujCMNg/pS2LR369dj6ay7L4igMUQsE53ivnvm8Bim/FOKCcWA/PfEps3Hw
0u+WdrLCRu43QyXePLswuKt1WOR1pOeq0ovDP7EdH5f7Uv+U4k3TvBZvK3yt
/fejvD2BjQalnC4zeWSont/78ei2QRFtrDFsPJvOP8tL7WDbc8NBjT4oi37s
9qH34m3Fum++enJqcKuYYzeQyinPps/6t0zWq9fpR5WiBMGL759fn/Jla287
jL0ZVWd/GNqg6eqrmgWx/Er6RIeGc0/l0pbPwhvbOtm3l2/QTCZqG2mA28qr
z0RJQi1PefXioVnLhta3w1w82Nc13gYUUoip4rFpHb/qlqet4vxGG5/Dj00S
xWjLC3pi9r4Rtel/aue5+Xem/SNKKOVP30Y0ajQnQ6OceO7ZyR3Dsku1f87L
kje2HrLtiEa3868sdbYN3/WLSlfAkysJDlxyW0UfyzdFKJXy+vTR9p/2zPgb
tRSu2DLDLfHgS009ccWOxV51XNdfQxXHS79f3rZ+q51/lulrxSu2OATMdbgq
Ny7cdmB49v+QUKoHCVM+/JQxxiXVcyEtL3JqUn9/R6s6sl66lheNEDXmn6ak
1XMhDcXbfVLruaDxztt9/AuiOKEEren88zn/UiUCYS3P90S1YTC91Tzt3Kvu
7umhVo0axh+/YZodKGyB4Bvv0s/nNcvroj1etX36e9DpTux0fey1567BHJJ/
eZmTun/MUgnFhlnNrO2XX9ZbLPj1nyLtbMal39C025NrKzz8M/5L+xV+PX2U
g9fBQpOatuTOtwGew2NGLN+SNKEuq87jD+SjrFr7/vxIX77q543dPtDLqdgQ
5ZZ0lGqFKjbMbiHD3OclGZjKnFScTu2vfltftDh1zJQmrM1YVrS7g1WDGYlP
dRLiqpzI7ljPkEu6Nws0aYyO0c0S6ib9jwzz23TMpG2SiltxgzyH95iftDfR
uwm7nvM3oIBCTIZV6wSobpF8RG0fl8BA6he8vFoGd7S1+WL/VVPmDb6WF/TE
7P1D67ZsieYNx7p95nDuNQkEGUtDUzM11pFKkfGZK2bfYMNN8oM3iowgd5r+
VFU9Thhv1a7Dgb+1i2P2vtB6DkEDGI05MMihdoPJ8vumSIdsvBY77miNuj9P
xthjWPDYHLLp8Dsnp9fHfFanvdT1wuvHB3ysmk9LKETVECK2KAQoDH5lX7it
9dRj9/Wq8fTm+mZUOaXWc/6W55+aXqQsrDM2jtpNJUmzHDHMfUFyqUlNxa/G
QqYpafVcgIryd5/Uei5gvAtZWfgWRFEIWdP553MBS5UoBLQ8/xMfZH3p5Lkz
j9JPeaemq+X363HmqSlCCeg+AeNd6vm8pnl6bVnHsN+e0z+sfHV9vNvogznM
VbKy7Pokb/mCeBdzVOKVWkXtMC+6jff87g53zG5MXP4b8p/Z+wb/H23UEBCv
ErVXXHldZQ7ofcRQ50v/3Kyu1ei4AuouQ9HFBQ0wxzlJJZXEwnrYv0H8iT9p
bUJ+wbQ9JfQOYtiMlSe3B1pjobuzqc95lbrEGbOeeeoh+ufL3Ss7WH+4KEuh
+8LLA0nd6zZccKHAvLcP8hXS+LrG1YCiChEFl9bxq2559kinVddeMMorS1/n
NiXhgUnDlK/lhT0xO81juNHzF1FUvrwU6oP597vwP/0n2ZF9bHoFXyCPg/Cr
+8NstGqsBT+f0reWbOiuq0hhKg6ucko89IahPcU3Er27HMg3qaWKriz7CPNc
lqq38R7+vs7Nxmd5ioIwl/FC+Sg7ikojofJigjGXFjvvVgoUWxz8ClN5e1IQ
5uy6k2JEVOGvMoOdmfMVgTR6zt/yvFNTVWXOWD8Mk322XrfLqt3i8A+5xKiv
IPjVWMg0Ja2eC1BR/u6TWs8FjHfe7hOyIIpC1JrOP59zLlWiENXyXE+sOLKp
ixVm119/xqHdYDTNMBC1QHCPd2nn85onL6O3nDJRE+Cl3y92m5NUbHDoosrY
2GZJ6tMD5qlE/rl4e4PZSW1idbXXW1M5P0XaygIWbaAa1HjWD0EfmWjw6+HQ
ebTiNJEnv6A2BTkSse4hl0q1P7SznXvukf4Lrx/uaa/+sM6a30WPVQ49R4tj
rXnnafUk1z6szaq01zjaMLHHfHqcUVRJjSUagZxax6u65aVHhw3I/B+ttKr8
yws6BB5/aNpWEl/LC3yipJMGfj39iw8NVJfCi+T56tdql1VptAfePhZlpz8b
KtnYe8IFeq1UpRfD3CZn5Jr2WvE4YYK9gRrrqXxxplcTw6n7aeJUe+3ZkBCx
xcGrMGg5ZvYvaZra2a24wlhWpdFz3pbnn5rUk8bSCc2tbEbu1h+Ua4zAnmG/
MZc4AfCrsYBpqkpiPedXUQHdJ7GeCxjv/N0nZEEUhZg1vcaMQFEtz/VEPDs9
si7mOpFyUK5Zl01ZgkUuEO+uEWgAnpc5vUvoJYVBzzzL2xLY+8wT3FyVQAfo
zFdUsoV1XVn28EAXV/Uc5jKw564/yLN1ZdGP/vXH7DXpCI8Kh86jSjFXHGTj
oX5HIjk3Xf875XSqrGBnK2mNQOTOYfBegxoNiU2ug8aHralYnhEoRus4VVfH
G8X5Ya0XZT0yUYlMaHnWJ0o6aZCGk7GWKZKPxAx1G/Ujp5GAK3bMab1qT6lp
URhoCTOiA2hkGeg56uV26w5VmCi2OJgKgwo32D1DkrAPVYl9X6sMW55/amIr
JD9umB19b9AsmGosYJqqqu7F0UBFxXUfRyFmYjDe+btPyIJoHsYmxpoyAg2F
MtLywp+IZ+0KqU3fGzQHYwvEe2MEvlFk9G629KJBI+Dl9+d6jz1OvKGbqxLo
EJ+h82jTnnKUoLp2cn5z0mfTsd7ohK9nerVaeESK6GAOnS9OGG/HNVR1vlWG
oJc4kxwS2JvxzZMDnew4Z1fSn6ri4Nq2Msx5yba/0hKHd/KfMiNubCvX0NWJ
9LhL07AwI1CU1nGpLgXFhuhmK02f8E1oefYnqieNziHbEqK8BvWIiZkb3qJp
5OYUU71IKn4La4dhHyw+fffcxAiviJDJfcd1dO+wjDJYkHsYU7eRJwPLKScB
fufEF22HGDOnjfP02uqP1OOi3+kbmasCvSKmx0d39XcdGXYwVxuuWF56PNDR
UM/J80TNMZkJYovDUGGIAwhOK8LA4bZajEDDljdhalJlH411wFy/iLr+P2mc
05lqLGCaIv8poZ4zYVFRcd3HUYh5GI53vu6rELggmo7xifEtGYHGW17oE5VF
h4O8JYzCMLpAGDUCq03Pa56XuxMaRCU8NtAHPPvHrjGJ6HNzVeJFQWprAxcI
tKVGLxZ/cG2Vix2KtnEZ2PO7q6ZHguvh0Hn2bQeO/QodTxOnOWKyvpuPmhCz
zN6MXE+kvC2iWcWxl+sXm7XhZq+KM3p62ETG3DLF/4cmlEUZgaK0jkt19RRd
WexqamARieiW53oi4SPtsuScNp/GkzubPKy7LqFECwpHsxxbB4d1XX5FMxPi
N0/GNrQJS9WE0qOXZaZz3aVdgz/g2EoinAwbjEn/0/SWQsuxezPf8aOuauwQ
/PH6mfXqeW7/A22ko60qpk9gQVwoMdpJ7RIttkhYFIZ9T4ZjcqgOI5Ct5YVP
TarLRxcOmxEbFOljYzUkafdj87ynKRIYqLGAaQr9UzI9Z8CqouK6Two9Z8A2
3vm6TyV8QTQNnonxrRiBfC3P88SS/MNRE8cPmB3u6GQ1PNycVEg0eBYII0Zg
tel5zUMEfNViCZN/VZwe3PXHAs1cbL5KFK+e2sS6/hqKQyYZ1UXTebzwxla/
FpNTj1/Z/u3ERqQp2KRhzMFfTE8Rg5DOCMTvZy1wpPsniMFkIxCJynB9QQ7z
wdtPm2cnW5IRKErruFRXD/5AHlEr1iRfMi0iW577if+9s/MCLaNaSdKsf8lo
8SZC0SgMw+mI9INydtryBxmZ+7r4sL8r1ofqK66WbbQ9xm5NqQdjqIOJ+XM0
aHIm0H3GkK/78Em3yXGP3zgaVQ/zXU/xFSc60V5nBIoVWxysCvO2jUDWlhc9
Name527cENHAZvAafYotc4RiUWOBRqCEes6QiVVFRRqBEug5vTzW8S6k+4Qs
iCbCOzG+DSOQt+UFPlGZeSKxg5tN6JBTpoX50YXiWyC4x3u16XnNU3k2pZcd
PbSK5GnSBL89emc8CVSCSAXp/WGsNgBHWXRoSFSYexN9vqAntze2qj/9iDbp
GZFpk0xn1KTRV6anwiOR6jiY2Ij2sBmtPXApV16ZFx5ilPBvDykpexomHwej
WYXpG4+OyXQHMSZiQUagKK3jUl09yrs7WspCd2WbYyOLa3kxT0Qe9YxdL0Fo
VhNmijN0rqo7AlNdOzG78YdT0jWxgarsw5EBkyLqsAa2V/4V01/GCGYUC1JX
RuHohEs3msgstc4OvprYQLy8MDFqpG9kE0oLixFbHOwK85aPg9lb3iRPFZRX
UxawAsVimwGrGgs8DjYUy2Q9p8GhouK6Two9p8Ix3gV1H++CaCr8E+NbMAL5
W16ETyC5FWPXR5MJwXT4p2sR410iPa95yPh6v34X6Gmu8dyzowJjqJtd0qgE
unojwCd2zox+3gHf5jy5oF8g8Py4odbR9B1svPxx6rrBNqYGBuowOTCEikp5
PXqo/SizXG5MDgxhFxXVy739wUKTJaqyHCNQpNaxqy7tG0RGiw8WX1SaLhOX
knC0vLgn8q2eRoRiVRgkqt2UhGLtYFHlZH7Vpalv5Ijozwe3nxJ3/V4Wu+1K
ZrRwXpr6ypw5ld1FH4kqG/+T9toXtR34zfoIF5eI+Lkxfu3HfH/1yQ6a7SpC
bHFwKMzbDQzhaHmTAkO07yb2tP0lE+BQY2GBIYaYrucUuFRUVPdJoucUuMa7
0O4ztiCaLhTvxPgWjEABLS/iiRrnSfqZgngETNdixrskel7zoKD1kEm36Rur
xQmRNp2o2RT79mnsRbza+BMfdk5INvdNE4EGBfKLIF4z2Wxy/E12uK+5DcuV
Iob0NWKa7s9urnfCmIMIV92XjzbTAqziThFDukUx/YFRfiQ0cNjfMt4tI1Cc
1nGoLgXyeNTRcetts7w0xLQ85xMrL+0bWQdznSy/T10/OU6yhAhFPMhAYQyN
QCbkEw3fVVEdg7afMesVFvUIM3zDwAg0gFyvjTrDc4htiniGCoMcsZhioyx8
HIaQdEYgV8vzT0246lH62rWMy7O0fgLmdSWXGvNPU1LrOeXZXCoqpvuk0XNK
eVzjXcTKQoW6IJoM/8T4FoxAIS3P9UTVnV/X/nDoEf3NQ+OlY7yafEIJWCDY
x3v16flbAMUoCUh/YTTi3qyna1LLEvklrPqmZBnaWEXycJmRdU0IXDqPRuWI
mDxqV5LBv7TxS5xhxeivrSE/yp/X7etboq0L4/kwg+nVJ3Omaadc1uyjKE7Z
rIFQZTlGoCHGtI5XdVEsqvkiCW957ieiEGPGpIEmRtN2uVnT9qIke0ZmWi6v
FRSTa/boZkvbi3IDGplpUaNRs14LFlscnApDGgxNnL75i9JsSOxqSxatg7Pl
+aYmFEHD3DXSGoEo346JGFFjvmlKcj3Xwa2iIrpPIj3XYmSGEbiyMKAuiCYj
ZE2vcSNQSMuzPxFF0Bic7GuMQHPSRglaINjHe/Xpec2DxDbdCFQp7+7dflFQ
nA6u2LGoXV2n9dd03n3kxTrt9LfUFa+eYjtE40Cu540io0eDqCPakCIRT6TA
qfOkDB604KCXu1d61aq38Jdi3XeU6UmfzqelsFbrz7FgPwlvDEH3MVlRT8PR
lRDd+2lzbbLeQ7QpwNpq1P4c7Ue48vKR7VfExlNXsxFoWpeRGDEC+VUXvRFz
1AsvvncgJf2RIBd6IS3P98R7Z8d0i/mL1gZksVb15p4tMKX7uC7wcm+VhsJq
iKvufGxCxmaX0H7SPNrwniy0r8gxRYvpPq4LvOwnyh8gl8C8LHlTmz4bD+mW
OfzK/vAPKZfrCRNbTPdpf8KtMKTYVuN/osQtklefeCekKpnrtZHBYsLoM9Ly
fFMTSl/p0+VwIUXEB1lyIomu3mA2oaGMqTHvNCW5nmt/YkRFBXefZHquwdgM
w7uy8C+IVVLruR6zjECJu4/niSj7qJ1t9FFK/1a+zOzvqS5QbzBL3H16odjH
uyA9N2n01TiaDPOCjUDGzgO6QVVYzkbSL1RmM+NkAfEvXPX4+6Sh9el3QBOO
so0azZD/UaL5CH+UdzS8n9OXegNMzBOp0pOuMqxeqU/uJLe3/SRRmyaotGC3
j21nSqB3+ZX0SfUZdzL6+bn51/3MlHcQ5LrPaEZEWca3Q+s3SrikMTVUWfvG
NKDfzE6K2nmhpjXwwhub2tq6z1iqXxzRPa1i42iQf4WzUUdiIw3IV4iJXYYe
y6Z1CH7VRRMdu11KXrMrPK0ub8vzPhHdgR6XoM0uqH6zSB5e1ybsm6P6NJgi
u49UGN0IUhe4bah9vaiDWmuK8Hm2w3z8M9Ca87z44vgw2+49M/42nCc1V8+z
TtHiuq/y1a3plKcQbrRhth1992tbqvJsSt8PMNf4JHSyr7p9eW0bfcMKFVts
96FKGlEYJPbn2gxmhO/HONvuvU4/MtiyMTJYTBl9xlqeZ2pSt+30gN6btt9T
aiVRPb8+IdQekwXov2NKQxlVY95pSno9JzHaUEK7Tzo9RxhtKL6VRcCCKLme
6+Cdz40sVZJ3H88TiU2YgMhpJ+7pgkBw5cGNg20wu176Lpa++zSP4hrvAvTc
tNFX45AXshgXsuJWXIhXywGdbDQXJfsP9AjZeQZV9OW+tf61jOZVpj6r6Pbe
0MGubdRG1IDuDeu2ixyy95ZBssfnxZcXJoR/VLdN7+7dm7ep6+e14NBparJo
UU+sUj07Nbyzh8cQ/7raxIOkd5lOfr1gQ4KdBgTFxsaHu7lEJafql6SSO5td
Nb9lIuoKidyzX3qpTceerazJ39qRVmXnjql3qLXAlScPyts79ZsWFf15hEs3
/68zbzLetkhRh9o3btynT/eGLVxit6fS9icfXlvtzLJzzoUieWFnrd8dgSt5
0/fEuFu6MgU0IG8h4rpMgzGt0zQFr+oSt738R8Y6LVSWXR3ZnRBYsK8pT8vz
PrGKjIRN2RLj5uD8mbq56tXrH7TuRBYtEbrI7kMKs7C1U71un3Zv7uzQL2gd
TWHUfz0wv6Or6ydeXi17uds3jFiZoHu9YpRTuHTCvz5gn9VFd59K+cfyhBCH
et0GBAc4OgTNpt+rTvx10UA3V39/9gEuSGzx3VfFqzCEYEs+d/GcMm9erI+L
yxTmdfD8g0V091UZb/kq41NTFZkWZvO2We3b1W2nHpXqQWrVLpSuVCY1FI8a
805T0ut5FW9D8XYfbyGmTFM8DcXTffwLouR6LmRB5F2qJO8+AYujMjMjKXiU
p7160KmVqp2Vl0vslo3UdP2Sdx//eOfVc9NG3z+TInl7+eUa3fGs+Sf+k8je
036ZQYrUt40ldtnrhz/0sDwnXug+gUD3CQQaSjCg50KB7hOIZXafxFTkTOq6
u+DdfuI/iYojq7rulfbCR/OxyC57dmNxf4u7/BG6TyjQfQKBhhIK6LlQoPuE
YpHdJzFPb6z4zMzoVIt/4j8IXJUzoW2S+LDl6sUiu0z185q2W6VKFiER0H2C
ge4TCDSUUEDPBQLdJxhL7D6pUWwY3TEtpybdHmv+if8g8DvHA0M0kZiWgyV2
2RvFseCOe/Ita3RC9wkFuk8g0FCCAT0XCHSfUCyy+yQmP3Pa5ybeovuPeeI/
iHLl+ZF+3+WWvW056FhklylT5vrt/MWypjHoPsFA9wkEGkoooOcCge4TjCV2
HwAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
/zzwgrheDvHyrPtP+PPq4KrCdfENIw2zXosppCbkIf9YdDttWKhrj27Rkyb6
Nmu1kHkzqaTyKIvOTYhs2tSze3Of2o0aRiyXX37EnqpSde3EzOaexi6qrhl5
iOsON0Z18Bw+bf6Uti0d+vXY+muuypTOk0aeIvlwm5Dg77M1MqjuZKeG9HVe
mSb+um0p5CkrSG3rEJe2957SbHUWWBS//hAX6X7ZydX/i5gYv25Nh4WwXLct
rTxTpwS28RkXO2t4Y4eg+OlZ1aTPwuRR5WSu69XLc3jwtKDwRo1cZqSkPWZc
CSWVPkskj2T6LIU8+KXv/Zx7/HA526QJUHp5yG8QN/wOcveInB0/zr1p/6Vc
l1lLIw8VPPfcLOf2BwtZ/2ZsQRFUuPimZpdH8ACsCXleF+3xshm8RDsp4arH
B/YsaOu89DLH9c1SyoMrtsTbRyUUU74voT4LKUrQWJaov94S5ZdCXDAO7Kcn
PkWNo3p+78ej2wZFtLHGsPGGY0RYITUnTxWelyVvbD1k2xFN5+ZfWepsG77L
hEQ9AuR59eTU4FYxx24gJVGeTZ/1b5msV6/Tj6iZIXHl1YuHZi0bWt8Oc/Ew
wwiURB68eNP0VvM2aC4xx1W500OtGjWMP35D/LopTfsUyUcyfuv6RdT1/5mw
Lkghz5MrCQ5cZVhFH8sXIY6QogT0l2LHYq86ruuvIcMPL/1+edv6rXb+KT5D
l3h5qp7l7WhVR9arZ8bf1GlNIn0WIA9+68yUjr2OaZ+uOv1diI0sYJFWe0lh
JNNnaeSRTp+lkKc8bRXnkGjjc/hxjbfPm2cXBne1Dou8jgw/VenF4Z/Yjjcp
t5vYoaoqzRzkw6KxfAuKQEQ3Nas8ggZgDcrz+uGe9vTf2tmEfXPUBBtMrDz4
/awFjswekVCfhRTFP5al66+3A2Hk1/bp70GnO7Ej8bHXnrtkLUrufBvgOTxm
xPItSRPqso0RIYXUpDxvFBlB7ljPkEsl+s8eJ4y3atfhwN8iU3YLkEexIcot
6WgZRSkUG2a3kGHu85K01m/FrbhBnsN7zE/am+jdxKxFUxJ5HmR96eS5M4/S
L3mnpqtb0q/HmadvQx5ioI2o3aJ9Mxk5wXi7xG5PLTRtAEkiT/a+0HoOQQMY
hQwMcqjdYLL8vijBBBTFKw9+5+T0+pjPasq75+vHB3ysmk9LKBT7ViNAnhcp
C+uMjaNWsyRplnomdl+QXKoZPdLpM688lS8z+9cZsedKua7u5aXHAx0xO9u5
5x5pPpFQnyWRR0J9lkIeQhgfl8BAagleXi2DO9rafLH/qjg7WQp5FBtmNbO2
X07ZR8Kv/xRpZzMu/YZoK1ncUFW/Pa3yr4UxNZZ3QRGMyKZml0fAAKxRedCk
2rIFMpdk7YcGrcu8adKxkUh5iLeD7nYYs0ck1GchRfGOZQn76+3w9NqyjmG/
Pad/WPnq+ni30QdzmO2JXrsMx4ioQqpfHvzq/jAbzHFOUgmlC/DzKX1ryYbu
uipOeXnlUSkO+zeIP/EnTbaiiwsasL6VkPtU5iyaUshTcWRTFyvMrn9Ydqn2
C5oX6torrjCObWpCHuIDuYdHmhS3kEvSPgdXOSUeesNQlOIbid5dDuSLW8v5
i+KXBy+Uj7LDrGeeekj5Bp4XE4y5tNh5V9wsI6BqlTlj/dRT/WfrD+psTs37
sn/IJUbDmq3P/PI8u7neCcOaNPrqqs5m0Gz2uqxKQ+NeQn2WRJ4q6fRZCnnK
s0c6rbr2glFyWfo6tykJD0SaphLI80ptUdhhXv4Z/6WU8PzuDnfMbkxc/hup
5aF/vvKzuYv8uDWWa4ETisimZpdH1ACsAXmIncDdPuacXpkoT1n6Gu9ZX81q
wOgRCfVZUFF8Y1nC/npL5GX0lqfSPVXUrwOL3eYkFRtuMnCNEVGFVL88L5Ln
N6HPyQS3j0XZiT2bFiAPkoG+D6DZP7ers+Z3xqRmthEohTx4dnpkXcx1IuX8
RfMrQ4FrQp4qCY1AKeQp2dh7wgUFrVj1O2mY2+SMXLGvv/xF8cqDvzjTq4mh
PfM0caq92LNpQVXDC5dOaG5lM3K33ndCM6f1DPuNOV+aq8/88pQ9PNDFFWtH
PfvWGBXt1h1CQ1lCfZZEnirp9FkCecpLjw4bkPk/ern5lxd0CDz+UPQ+hQTy
5J+LtzdYH9WvQl3tRZ9NixqquOpWdJs5mQpjGmumESiqqTnlETUAa0Ae6YxA
UfIobq/3759536BHJNRnYUXxjWXp+stiwPMyp3cJvaRgW+4EjxFjhVS/POgQ
n2kEoi+b3S9MedCk59x0/e+Us+eygp2tqscIlFgebSFZu0Jq0/dSalYeyYxA
ieRhlKHYMaf1qj2l5vvVGxbFI49K65DDNALRPEM1PKSRh+07+XHD7Oivujop
pNZnAfK8KEhtbUffazIoRTJ9NlGeatNnKdrnjeL8sNaLsh5JMDubIE/2vhG1
DTdJSEUy4SVUsDyq08ne85MVFUY11tydQAO4m1qQPBqMDMAakUeynUDB8uCq
3JneU08V4CUCekRCfWYrSvxYlq6/3gpvFBm9my29yNGeAseI8UKqXx50Is80
AtERG+MYQlp5dKC3XRaXJKkXTXPlIVEWHQ7yxtp5bv7dpIBTKeQpkndvvuib
db28gqOioj+PcHHxSTxvotuJJPJQwe+c+KLtEGneaAQWRZUHuVQZGIGvUpc4
Y0yfh+qQR5V9NNaBK65BYn3mlwdXFa6e1cbaqF+6dPpssjzVpM+StI9iQ3Sz
lZK80ZgkD3LXZBiB+KvMYLU6M3wepJOnNP/bwMDjj3EejZXaCORsaoHykBgd
gDUij/o9tFPzJTuSJnTyGTdrXqyPb9NxkedMdHIVJI8qM9V7FukRLaBHJNRn
1qLEjmUJ++ut8HJ3QoOohMdcDS5sjPAUUv3yoH0Apk/gpV2DPzBweZVWHi1P
E6c5YrK+m2ne/iQSL5pmyVOSfzhq4vgBs8MdnayGh0sS0m6yPEXyMKvQIbqJ
pezotuA6DeeeEn38KpU8eipfXgptMCb9TwnGs+Ci6PKg90qmT2BBXChm4DIt
oTyqy0cXDpsRGxTpY2M1JGk3M8WHBkn12Yg8uOrexiXhIV9OaduldiPX1Vls
6V8k12cz5KkWfTazfTSSXVns6nWwUIrlyTR50MYg42UcbX1j2Mj9ZmyfcsqD
FyZ0HXYYfV6DRiBnUwuSR9gArBF5iMMIq0FrvytEMlSW3ZoyxDqIkf5COnnK
ivZ/Hni4kCyct0ck1GeOogSOZen7661QVrS7Qy1jXkZCxghvITUgz+viw/6u
WB9qgAD+QD7aHjPPCBRWNRTVTvNQ0iPpoimBPATKzBOJHdxsQoecEusmLp08
ZZd2Hqc+HW1/+fe78D+D39eIPPq/XtkX6iDaVYn9QcKKMpQHv3E0qh7mu57i
AE9Uzd5MI1CQPKrnuRs3RDSwGbxmWyHLtCalPguRB3+Ud3TsmLp1XZec5kz/
IpU+myNPdeizFO2jngYjasWK9IuWWp7i1VObWNdfQ3HIVxcVbmuuEcglD55z
OHCcLo6+xoxAzqYWIU8V7wCsEXkqy+7s3fuA+nRyO9dzWaoZx51c8uCPE4d1
/VEbJ87TIxLqM2dR4sayZP31dqg8m9LLznXnfe5+FTBG+AupEXlU107Mbvzh
lHRNQLEq+3BkwKSIOuLzYomSpwodRXnYjObaCpZy0ZRCHg3I8LDrE3zBjGzf
EsqjiX4173hICnkq/4rpLxsdVyA+v6SJRbHKQ+awdXbw1QQ84uWFiVEjfSOb
iE7CKV4e8nml3y3tZCULWJGiYD5LQn0WLA9KZdak4YILBVxdK4U+SymPFPos
hTzKuztaykJ3ZUuyD2i6PMqiY329P4zVBmAqiw4NiQpzbyI6CacQed4ojg32
261PU1ZTRiBXU4uSR4ORAfhW5NFEc5vlW8UhD34no9dASm4f4z0ioT6LKIp3
LEvRX2+HytuTgjC/fhdKuL/CP0YEFFJT8qhyMr/q0tQ3ckT054PbT4m7fi+L
8AkMHptjQkpSgfKolNejh9qPMmLhSLloSiGPFo1PDn276S3Ko43u8dt0zNRh
JIU8pX9udsGcl6a+Mn+WEVKUEXnUduA36yNcXCLi58b4tR/z/dUnOwifQNPb
R1TVkD+tPW33hkQ6fRYjD/KHpG/10zFfn6WVx3x9lkKeypPbA60/WHxRaZoI
UsqDrsgJ8ImdM6Ofd8C3OU8uqPvLvsGGm6a+brHLgyu2TPX+NpNSaA0ZgRxN
LVIeHZwD8C3Jg6LVzOgvdnnePDsd4p18h5ID32iPSKjPooriH8tm99fbAdn2
IZNuGzlC4R0jQgqpSXmokFFppjvS88qDq+7LR/NZONItmmbIo7rz69ofDj1i
XnRF5kU3ue9Ml6cy/8vRza1sIvZdpfYMe4h3TchD+QqRWxIL2n7G/JSf/EUJ
0h89ZPuYvrPEKQ+uepS+di3jzjXtlQEG35dMnznlef744sa1vzIc/FCEqaPj
1tuEdlSHPpshT7XoszntoyuD2MFgfmgiUshDASmYGTtL7PK8KT7gY9MpmJoK
eIh/XTvMDuWT91x4toBWimRGIEdTC5FH3ACsfnleF+zp6Iq1a512j/JbjpQF
5sqTkx5Rn5r628/PrWcrawxzJT8MDjldLKAQCeURMparpb/eEihoy7j+844R
IYXUpDwUSpJm/Uv24aIsBf9XTZCHOLCL0V9cRX6UP6/b17cY35bOCDRRnkqN
Y7bBi4xm0TQ5hY7p7VPxW1g7zI4x0NCWuxnHQ1L0FwozN8tZXWBRQvVHi9k+
ZlzyoKAq5ju+dk4zyEgjmT5zyIOCYgw28JFRQWQUKa8mfTZVnjfVpM9myKMF
6YxEvigSyEPFbB8zoUMVaXJ17wQKb2oDeUQOwGqXp+rptdUfYUwjEL1im+xb
JVwepDmsPSKhPnMWxT+Wq6W/3hLoTcpMo8toIbjy8pHtV4Te6m6WPMTdlD42
IWOzdUeBhCO9VfNo6kVCEsqDK9OTPp1PuzxUrVfHgv3E3BhSU/KgvKx2ttFH
KWF0xGVPnmqlpczDNdc+pdumtf6Wfq0zCnwI6Hlal+RDpby7d/tFwSGfUvQX
GuwcK4s4eYwWxScPcRF2U5s+Gw/plkj8yv7wD+l3JEklD5lTHfPpoonOQzzI
khO5lw3fobj1WSJ5yJzYmPvsRGqI94uUxR/LMI0NLFCfa0yeatFns+TRgBZu
rkWz5uTBFTsWtavrtP6aLo0h/kA+yqod/YJRKccXBVONQLz43oGU9EcC972M
N7VxeYQNwJqTp7z09IDW2+/QOgIF8ngvTtb5vFWXPEaMQKOFSCUP/1iujv56
S2hyXBs3utBJN7czsLFC/jwZY48ZT/EqmTyEk6cd5uOfgXaPnxdfHB9m251+
obN08pRfSZ9Un3FfrZ+fm3/dzwx2IZCrkjNbtELNyUOYHAGR007c0znN48qD
GwfbYHa9KFH/Ndk+6ALug79oMokRrnFhNm60PG+KDbP+IxOR/leK/tLcdMC6
soiUx1hRvPJUnk3p+wHmGp+EplzV7ctr29h2XkgzGiWTR9340wN6b9p+T6kz
V55fnxBqj8kClmwrZjQmtz5LJQ9eeOPrnp9uPndVl/VO/cm6lvZYE12WBkH6
XIPyVIc+mycPAlk4HItmDcpDRnDIbGacJI9icdXj75OG1m8Yf5wWzizh+KKB
jBzWGbiKe0FRKTI+c8WEp/812tQ88ggZgDUpj7qLbp2Z0rHn/j8140vdoZva
2tCC16pPHmQEspocRgqRUB7esVwd/fWWIK9e4hBS9ezU8M4abwESF3/izuWQ
nWcqhBfy8NpqZ5ZTm+qRB1eePDC/o6vrJ15eLXu52zeMWJnwRwm9IKnkKbmz
2VUjBhOKBaJIXtjZo2+fxl6aryInh4lxt3TreM3Ko8zMSAoe5WmvFkMtVTsr
L5fYLRtzSyll1aw8hKP41FmBjRp27z+oS/16feIm/fwXLbDz5b61xM3mgl2R
zZWHLKNw6YR/fcBuBouUh7soIfKolH8sXzTQzdXfv3v35m3q+nktOHSakQpY
MnmqyCwHm7fNat+ubjv1sFKPMqt2oUHrTmRRn8irzxLKgz/KOzxNHvZR3Ta9
1bZxUMvadfvMYaoHrz7XsDxS67PZ8lShu2n+I+Mwq2pSHrzo9t7Qwa5t1C87
A7o3rNsucsjeW8y03lLqM6LkzrcB6uHTrZmMUFg7r8Z9+ndMvUMWzrugVJZd
Hdmd5ZibC6NNLUAevgFYw/KQUZbrgoIcPF0C/brVczNYLKpBnorTOwd5Dgxy
cCE7RNa+d0sv6nJpvBBp5eEby9L317tN9p72y0x19a8OQB7jWJg8RfL28ssW
tKUO8hgH5DEOyGMcy5Ln9cMfejBuu3urgDzGAXkskoojq7rurZYrYk0D5DGO
hclTkTOp6+4C/u/VFCCPcUAe44A8xrEweZ7dWNxfumuFzQfkMQ7IY4HgqpwJ
bZO4Ah5rHpDHOJYmz9MbKz6TIvuQVIA8xgF5jAPyGMfC5FH9vKbtVgvK+AHy
GAfksUDwO8cDQ+QPJLh8QRpAHuNYmjyKDaM7puVYjl8tyGMckMc4II9xLEue
N4pjwR335FvMGg7yGAfksUDKledH+n2XW8b/zZoB5DGOpcmTnzntc87rj98C
II9xQB7jgDzGsTB5lClz/Xb+YjEvxCAPDyAPAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAADvInhBXC+HeHnWfYO7JnW8Ltrj
ZTN4ifzyIzJxJ656fGDPgrbOSy9TLmrM3je4geu8tIOP0SU/z4svL1zo6Tnk
1xLxAl363s+5xw+Xs5Xcd9YWyYfbhAR/n52L7hxX3clODenrvDKNelEsXnQ7
bVioa49u0ZMm+jZrtdDgulWhlBWktnWIS9urvyGai+fFWTNnfuLkOmFO3JjW
nvGHfmF5Iq4qXBffMNKMzOHC5VH31J5vYlo2DpgYHd3Vo7N8uf7CR+GFCEN1
+9ctn/fyHN4jZvKMwc1dxqxbQ7tcksGbZ6f72o9Kz2XK+yjv0IhgpwFBsbHx
4W4uUcmphWJTxRJV3jG5g+fwabGxQcOaBvh+dZStF3Rfzz03y7n9wULGp+WF
KRujiELmT2nb0qFfj62/5qpMbSehesitGEK0XQTETcRLBrl7RM6OH+fetP9S
g2u1dV+8dmJmc0+DS9UFzBjSyiNkbiHu95wS2MZnXOys4Y0dguKnZz0yOcsw
cfP4l51c/b+IifHr1nRYCP1mW2HVV/fmN1+Pbt64a8/gjra1u4wbknrVdBUC
AACoNsovhbiw31+PYfbTE59WEHfe7WlP/4OdTdg3R2lrWfa+EbXp32nnufl3
5rXgggRKW8UpUBufw4+J7xTJRzL+4vpF1PX/6Z+G52XJG1sP2XZEI2T+laXO
tuG7TErU8+RKggOXQFbRx/I1Tyy8sa2TfXv5Bo3dorZzBritpF5ornp+78ej
2wZFtLHGsPFmGIHC5FGvrdenj7b/tGfG30ggXLFlhlviQY3lILAQYeC3zkR1
6X9KZ7Gpnv+1aGqjUTG32O9JxEu/W9rJChu5n34h3bO81A62PTcc1HSZsujH
bh96L95WLKKh8OJN07wWbyvUXjeqtir3BDYalHK6jFURVaWZg3wwFw+6naMu
ZHqredp+xFW500OtGjWMP37DhEVckB7yKQavtovgzbMLg7tah0VeR4aWqvTi
8E9sxzMSsuHKqxcPzVo2tL6dQeNUCZoxpJWHd2559eTU4FYxx7Qd9CxvR6s6
sl46zRcFrtix2KuO6/prqHy89Pvlbeu32vmnLmGmkOrTVEithPt7Bcg+ajj3
VC6YgQAAWBbELl9tn/4edLp3b+5T+2OvPXdf6b7TsgWa+mTthwaty7zJXBCz
9w+t27Ilmqsd6/aZE3VO9CaOhiL5iNo+LoGBVHm8vFqqX6htvth/FT2X+E6L
9s1kxNPsvF1it9O3jN4oMoLcsZ4hlyh7BY8Txlu163Dgb/Epu7P3hdZzCBrA
aKKBQQ61G0yW39eafMRaNjpGt3gpNsz6jwzz23RMsySW3Pk2wHN4zIjlW5Im
1DXPCBQij2Yta7Hjjnbx+vNkjD2GBY/NeSm8EGHgb7LDHWJOPqR9+PrxAZ9a
4w//ybLq5V9e5mSn7ji6EYg/kI+yau378yP9L1Q/b+z2gf1y6oazcZ5cW+Hh
n/FfunTX00c5eB0sNBREvb6v8q+FMe2cB1lfOnnuzKM0Qd6p6eou8+tx5qlQ
QTQI0UMBisGj7WJQq2Uza1qT4td/irSzGZd+Q9tAFbfiBnkO7zE/aW+idxMW
I1DIjCGlPPxzy4uUhXXGxlGVtiRpliOGuS9ILhU53PE7J6fXx3xWU3ZZCU22
aj4toVAltPr4nROjOo7NUTKLxXwDjpvyWgwAAFBtPL22rGPYb4wdm8pX18e7
jT6Yo7H0Xj/c7WO4IUAnO81juCSXI5dnj3Rade0F49Oy9HVuUxIeaOf5IrmH
R9pN5k+14Ff3h9lgjnOSSihLAH4+pW8t2dBdV8XOwhUHVzklHnrD+FnxjUTv
LgfyNQK93L2yg/WHi7IUur+/PJDUvW7DBRcKmI9DW3BmGIFC5KkqurLsI8xz
Wap+LXv4+zo3G5/lKYoKwYUIhNgotp567D69sPJLIbVrr0hj1rKy7Pokb/mC
eBeGEVj652b1R6PjCqh7ZEUXFzRg9qMxsvcN/j+aGUlANHjtFVdeM79cfGPl
Z3MX+bkw7JyKI5u6WGF2/cOyS6klqO0PtkKMIk4PuRXDuLaL4JXagLHDvOh2
8vO7O9wxuzFx+W8Y3ya3vAyNQCEzhrTy8MwtlTlj/dQvp5+tP6jTds1pgn/I
Jfa9aC7wQvkoO8x65inqGw2eFxOMubTYeZfsRQHVf5o4ocGXSY+pyoK/ygx2
NmGPHQAAoHrJy+gtT6U7F+Gl3y92m5NUrFuOa9IILC89OmxA5v/oH+ZfXtAh
8PhD/VJqfFl8kTy/CYa5rKJbILePRdmJP66qqirZ2HvCBQXtI1XpxTC3yRna
wx1ir8Ae8+lxRsHycyZmG4H88hDbTRPssVrzznNuXQkpRChvnhzoJGOevr0o
SG3z4dxzjxjfVWVsbLMk9emBVQwjENlLTeTJL6iPJ+0BrHvIpdIqQeT8FGkr
C1i0gbpRhGf9EPSRwSYerroV3WZOpsLQzsGz0yPrYq4TKSeSqMvs6qz5nWkn
GUecHtaAEZh/Lt7ewDRSKQ53tdc5WlDgMAKFzBjSysMzt+CFSyc0t7IZuVt/
yK4xAnuG/cZ8mzRK5YszvZoYWvtPE6fa6+w3/uprzosZ+5DoTL/dukOmOSYD
AADUDHhe5vQuoZcUlGmuRncCDXijOD+s9aIs2v6O8WURzbfMxRctsmLXBRZw
xY45rVftKdXN5uSyLtSuM9sI5JcHLaMs3lxiChEjQOHSif+RqZe9prP3k1EP
uOpBwqT6kwyOlZ/lbQnsfeYJjtZoqhGIPmF2GXJGFV6RsocHurgSXT+w564/
yIM3ZdGP/vXH7L3K2KFSnU72np+sqOCwcxjVy9oVUpu+NygMcXpYA0Ygcq5j
7o+RjcBi4gpqnCrWGUNaeUTPLXh+3DA7+t6gIDTOz0wjECknl/1mUH00HGR9
Nx+leKLiBXGhYAQCAGDpvFFk9G629CL9RE09N3ZqvmRH0oROPuNmzYv18W06
LpLp8qeeqDuHbEuI8hrUIyZmbniLppGbU0z2XKKi2BDdbCXTOCmSd2++6Jt1
vbyCo6KiP49wcfFJPK93U0QeQczFlzxbZJ49iQe/c+KLtkOoS17FwbVtZZjz
km1/pSUO7+Q/ZUbc2FauoasT2cNjpTYCDeWpenpt9UcY5tfv9I3MVYFeEdPj
o7v6u44MO5jLGc/IUogolEXHBvUlndZkHSbMXt23VavFBtXHy+/P9R57nNhO
MTQCixPG23EZgfYNNtwUusekunZyfnPSedWx3uiEr2d6tVp4xCA6uDT/28DA
449xQXaOsuhwkLdpUU7i9NCYEWhM20WAnBsZRpfmpJJxBlol1AhknTGklUfk
3KLKPhrrYFLsTHnp8UBHQyPwVeoStUDsbgkCq4/2GO1sDffGAQAALIeXuxMa
RCU8ZixDxFpsNWjtd5qgy8qyW1OGWAf1Ov2IMicSgQYuS85p16YndzZ5WHdd
Iiq0k42iK4tdWbz6i+RhVqFDdIZo2dFtwXX0wXdo64bpi3Vp1+APxGwrsVL5
8lJogzHptHgHZMA49nL9YrM2svVVcUZPD5tItvBYaY1ANnnIU1EMc2/mO37U
Vc06iD9eP7NePc/tf7Cl7GEtRCwq5dXR/exQkKR709m7Dz6mO9Dh2T92jUlE
qmVoBLJvmnHszBgHf3BtlYtGEJeBPb9jpubACxO6DtNErHDbOSX5h6Mmjh8w
O9zRyWp4uGn5RsTpoTEj0Ji2i+BFQWprAx+8soKdrTCDOJ0qgUYg+4whrTzC
5hbV5aMLh82IDYr0sbEakrT7sTj/TQTaQmT6BKJNPNauEVr9W8cm18HsQmnR
IgAAAJZFWdHuDrVYXJcry+7s3fuAOqmSr/C0uIP/3tl5gbY7UZI0618yWqyE
ePAH8ohasSxefGWXdh5/QFmX0Su8f78LyJnwdfFhf1esD9V/W13UaHvMXCMQ
v7Iv1IHpPaXJ4EH3CUT+/8HbTzN3bCQ1Alnl0abUoPsEIn/74ZNuG5yGsxci
CiIdTUiL6XGZVzK3dvUnLTBZwLylubpnvSpOD+76Y4HGGKo+IxAvvLHVr8Xk
1ONXtn87sREpSJOGMQd/0R3M4TmHA8dpIz0F2DnKzBOJHdxsQoeceiDeDhSl
h9yKwaPtYihePbWJdf01lMArde+H25pqBHLNGNLKI2puUT3P3bghooHN4DX6
TEHCwW8cjaqH+a6nxEwRdbRnNwIFVh9lImpHzTMDAABgcVSeTell57rzvoAN
BuSxb/RolbSCxIR2GqK8u6OlLHRXtgCByAg+yiu86tqJ2Y0/nJKuiddTZR+O
DJgUUQdjc4AXTuVfMf1ljAhWrQHDdPVHp366lCw6pDQC2eXRGIGMmqJTNpaj
VY5CREhRdmvK5/XjEjU7VepVeE0ikWKO4pT1NGmC3x69Y57o4+Czl7eEhRhl
yLbfiqsUtze2qj/9iCZfHJl6mky+16TRVyhh4xvFscF+u/VpTIT5BN7PWuCI
2fUJviA+O7IIPRShGExtF4Gy6Fhf7w9jtYH2yqJDQ6LC3JuwBa7yN46IGUMC
efTwzS0oEaUsYIUmFl4EZMpuZwdfTYw8Xl6YGDXSN7IJWwpEQdVXF7h6Rr16
JiZNBQAAqCkqb08Kwvz6XRByx4cQZy1kihhaQcIFOrk90PqDxRcFnaAgS0yf
l0+94OZkftWlqW/kiOjPB7efEnf9Xha7VSYcMo2J89LUV4xkKKxBDWhNdze4
jUJCI5BDHs0jWP3tMdn4n+j3dHAVIhg8a1e/+swje9XtX1e5a2I88dyzowJj
qOl/qycwBM+PG2odTT+bw8sfp64bbINWcFyxZar3t5kUlRXm9qbxUqNvEAlG
qB6KUQxDbReBsujchMimAT6xc2b08w74NufJBfa3A97GETNjSCAPBd65Bb2C
2dP2GIVCXPaxPsLFJSJ+boxf+zHfX32yg/AJNGhtIdXHlelbB34EFiAAABYP
2twLmXSbcer1vGBPR1esXeu0e5TFiX5OV3lp38g6mOtk+X3q+Qt76J9wyO0O
R8ettxmLYmX+l6ObW9lE7LtK3QZgP0+kQspjzs4k2n8I2n6mku1zZsnVbwRy
ycOxT8tuBHIWIpjihPGsG4lvDqz1rqVeyiuKEyJtOlGzf/ft09iL2PfzJz7s
nJCsqNB4yjHb8NnN9U6YUDODzFTDsm9M5LL2JQwGZfEBH5tOwdQcv0P869ph
dij3r+fCswVVxKVsv6794dAj+kmi5sTfcHSYAJcesiuGqdouHDSWWXb1+YxA
rhlDUnn45xZc9Sh97VrGvX7aS47MUWwdZGsb7LsKqL4qa2/Yv8ECBADgnwCK
1DM0TlCoKcMIRBOg9kgLhccyJmpkXZiQl08DcnxiWYMqfgtrh9kxlkV0QGbs
CMl8H0UU7GngOsWR6BjlQDNcI6QzAjnlQXsUzvSDKhSfaGBUcxcilKeJ0VbD
Y/IM/a+y94XYG9jAJMiGoT0U2Xsj6OWQbSjUbicS41j1TckyXHCL5OGyKQnF
hnpouNOIQhUMtn00RqAE+YW49ZBdMUzUdhEY+vdq4DMCuWYMSeXhnVtQ9A1z
51BrBEqQkoXLA5Ov+qprxyd37HWMkjwTz/qu2xYJjFIAAADJQfMqy5xWXnp6
QOvtd2imDHLe9l6crHG5uXd2TLeYv+hfIW4Bs6o396zuygxcefnI9iuCb1FH
dibbGlS6bVrrb+m3ryLn7YCep9E7N3GJm49NyNjsEuoXrJpH0zLX4cX3DqSk
PxIcc0CuvKz2EuuVZ5sCrK1G7c8RcWOISnl37/aLQgNRjciDOoh+i8fTm+ub
YfYT5Q9oDWesEIHy4DeOTnRw2vIH0+ldsSG2wfRE1sBJFiMQtaEH7Vj55e6V
XrXqLfyl2LgAOopXT7EdYhD58kaR0aNB1BG22GdDIxClWLSzjT5K+X7ly8z+
nmqB9ZaSwJ4SpocaOBSDX9sJBA4uXLFjUbu6Tuuv6a5pI5u9Het1bzxGIOeM
Ia08vHMLytLp0+VwIcW8epAlJ/J7641tgYOduOu5qU2fjYd0JjF+ZX/4h/oL
K4VVvwovzFn/ef9j9MuLS5KG+h3WX+19d2/ykTzxbqYAAADVgCbHPtucht86
M6Vjz/1/auYrvPDGprY2NqOpabjIC9PjErSp4XBlevLwujZh3xzVp2hDd9fq
XPR5QWsi6xqE7os/qM3/plJejw6zcaMcuxARJXaYj38GMh+eF18cH2bbnX6l
hUqR8ZkrJiKjrOYiAHZ76cmd5Pa2nRdqr4wnmsjWfcZSlrUeeSuxnZ+i64YF
JyU2Kk/lq1vTKVUmm8i2o+9+pkDGChEqD+FLP6eRb8CuW9r2Vz3P3bDS353e
4BSQERi6m350S7bhJ4nanJClBbt9bDuLyjJERBk0ajRD/keJpmD8Ud7R8H5O
X25gTyuHjEDalqladZMCIqeduPdE//JycONgG8yulz4nktCWEaKHOrgUg1fb
q4QPLjIISGYz42QBWTPV4++ThtZvGH/8Bou1hjwhnTkDH4zMGJLKwze3EJHp
Ab03bb+n1P5G9fz6hFB7TBagUx7Bg73ybErfDzDX+CT0equ6fXltG/24Flp9
ZdGP3RoZXIA+pFu9umuuaTJgl26b30KGmRbiDQAAIDnkbVmck6QqJ3NdUJCD
p0ugX7d6bi6xWzYapgIuTNkS4+bg/FnfPo3r1esftO5EFi1J78Nrq51ZDto4
IW5/+I+Ma51VFp2bOiuwUcPu/Qd1qV+vT9ykn/+ivlPjypMH5nd0df3Ey6tl
L3f7hhErE3SGgYbKsqsjuxMCCQ0VIW6n+tcHnOsaXnR775Ch9o0b9+nTvWEL
l9jtqbSFQ/Xs1PDOGic0lMKO9IgL2XlG1xov9631ryU8NzKPPOrF8Y/lCSEO
9boNCA5wdAiaHcXM781XiAh51Mv3gd0LOrSr284lMICjwQkqbsWFeLUc0MmG
bALHuv4DaS1AtmGw04Cg2Nj4cDeXqORU0fnGnxdfXpgQ/lHdNr27d2/epq6f
14JDp5nJotWU3Pk2QP2FbmSCa8zOq3Gf/h1T72iqqczMSAoe5WnvEDRArczt
rLyYCi+4ZQTooQDF4NN2EYOLaOHQwa5t1DbJgO4N67aLHLL3FtNjTZG8sLPW
b5PAVd0OHh4T427R+8LYjCGpPPxzi/qlY/O2We1J9QtUt6RVu1D6d4QPdmLU
LBro5urvb1R/jFW/4vaknpqmY0B5pVWd3RVWh347IQAAwDtP9p72y6TwZpeK
1w9/6GFy6Eq1UCRvL79sSqLbasLS5LEcLK5lLG1wWZo8ljfYAQAA3isqjqzq
uleKW1Cl4tmNxf2r58pjE6nImdR1d8HblkKPpcljOVhcy1ja4LI0eSxvsAMA
ALxP4KqcCW2TblnQLKz6eU3brZYUr/f0xorPpM65YQ6WJo/lYGktY2mDy9Lk
scDBDgAA8D6B3zkeGMKITn2rvFEcC+64J9+ClgXFhtEd0wwCit8eliaP5WBp
LWNpg8vS5LHAwQ4AAPAeUa48P9Lvu1wLuj1TmTLXb+cvlrNMVeVnTvvckhzF
LU0ey8HSWsbSBpelyWOBgx0AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAMwrNr/szTewyoDAAAI5b83t3QbGOTg
gqlxrOs/0IOE/MS1YcT6bYWva1QcvPDGNt+mwdFTPDv2Ovb3K4G/qjyb0vcD
TBDdQy6VVik2zPqPjPyni0fa39VaIS14+YMtXw34d9PIKSMbNvRcc6kAN/p1
FglViozPXDW1GC8vKq8JqUUgsoI1iSJ54SctB3Sy0TSei79LYKBHyM4zFW9b
sJqnui2WGrWIhI2Id6rKAAAA1UB52iq1FdhEnvxCv3LjyvTkEXUw99mJj2vM
3qh8eSm0k1V0wqOCs3H/lnXZeEzgMl2etqJ2A5clx7KU2h/gl3YNVpuFfv0u
lGi/9Lz44vgwGxutTaUs3NPJkc8IxAuXTmhuVbvPpkMvzbJpcMWOxd4fNl3/
e1nFkU1drDD76YlPeevGJqHq1/2RdhZoBJpUwZrlVeoSZ7W1MDquQPW2RXl7
aCyWsoLUtg5xaXvvKUWqtbLo3ITIpk09uzf3qd2oYcRy+eVHtDe1mreIeEeE
ViS8IK6XQ7w86/4TcXXGywtTNkZ18Bw+bf6Uti0d+vXY+muuilIEGIEA8F6h
36IRQpOPtt6y/CUHz4sJxjDZqH03aNNj5YszvZpg9g023KyhKuDX07/4EAtO
yX26Yca/Pmi44ILQ3aQXyXPqLU6l2WnZ+0bUxjD/kEvPqd8rSPX21NpU5ZdC
XPiMwIrbk3qqVxjX+CSFOSbNq6I9XnbYiJi814QtemnD8p9zhaxEbBI+uZLg
YHlGoIkVrFHQm47FNV3NorFYkBaxYxV9LJ/9x6+enBrcKubYDWQCKc+mz/q3
TNar1+lHlczyaxK+EaEViRxNHHC/s+DFm6a3mrehEJm6uCp3eqhVo4bxx2/o
7EAwAgHgvaJIPlLoOkLMTrVXXKnZ81QTUCkOd7VnM/Y00+bI/TdrRpCSpFmO
2AeLLyrF/rBI3mrYEfrKxWoEVlX8FvZ/CZoeEWIEEibNldSdd0rNs2hMtNz+
OUagZUpFB4zAKp3Fkr0vtJ5D0AAPOgODHGo3mCy/z+GFodgQ5ZZ0tAynfjK7
hQxzn5eks6As1wh8rX5Pqe3Tn1Hl7sSW5sdee+5y1PlB1pdOnjvzKH/NOzW9
Lob59TjzlF4+AADvB++gEfjoyrJGGObln/Ff+udvnhzoZGdsZ0BiKnPG+mHu
7Q8Wiv0hXhDnufAyvZ3ZjUB197WXXxZjBEoCGIEWABiBVVqLpeLgKqfEQ28Y
bzbFNxK9uxzI5zCH1K+K/g3iT/xJPQmtKrq4oAGGtfE5/JhWfo0i0Ah8em1Z
x7Df6LNBVeWr6+PdRh/MUXG85CHfBrv+Ydml9Mdh+okdjEAAeK9494zAypPb
A63ZfKXyz8XbY5hLi513K9l/KS3I5gwem/NS7C8rbslHHC2iz+McRuDLg4vG
nX9E/i8YgdJhmVLRASOwSmuxlGzsPeGCgvYHVenFMLfJGbmcW96oi+1s5557
pP/w9cM97dUf1lnz+xtq+TWKQCMwL6O3nO4xUoWXfr/YbU5SMbe3C56dHlkX
c50Yl6ublDTt8FarDADA2+PdMwKfJk5V23p+m5hRGOisx3txslnucCLkuLb6
I+kCCjiMQApaE+vPopNjAn3HzZgRGGLv7rnitM7bp+K3sHaGsYeq388s7dRi
UOzgsLD4cb4dps+a2jCSWx9Uz04N/9TPrWcrtZntig7gPBeeLdD8MSfz609d
XCL6RU2KD3dziUpOLaRtwwg2ApVF56KjXPx8YufOi/VxcZkSdQ4VlHt2YRvy
0epVy6txxPc3b8ZF6iPBR4acLlZ/59z8puQndrW7LCX6WoIK/py52dUOtdzI
ffcLN8R5dR0dZGMTlnpad5hopO56t1t19/3XsHfKH2xZ2uWzHjGTZw90sB+6
VmgAu3AjEH+Ud2hE/6bdu0XHzBjc3GXyd2mP0SP+PBljj6qlHtdlhmKom25x
gO+4WQumetjbh4WdeqCtksk/1PXv+PAWIeqfzOz376ZTttP1hGiQFcEeXlFz
xo8fMM7n0+j4Lg1D9rG7cHBYLLhix5zWq/aUGhl6ZQ8PdHHFnJuu/72E8mHB
zlaCLCJ1d6/2UyuVuh8HNAz0/zrzpn7zjRLk67IqrSzfaFNU4cqTB+XeTX0j
1ZoTM9Cv59aMQ/L/MyU6GM/LnN4l9JJCZJhI1q6Q2rS9QTACAeC94l0zAlH0
B2Y989RD6sf4g2urXGT/+SLq+v+QF3jR0cEdJq9ZN6aZ56YzV38cGegbO3H9
9LndbeuN/YFc2YkYuk2TW7sOJub5fk7D2RayqTEd3dVL1ZeTWzsFJ1LW7vu/
LPPu26exl502fUfn2Qn3zWw2gUag4/8NHNtz2w0yigFX5UR2x9xbpRXodz6Z
sYcPr61s2UrvI4Qcxcfx6QOb5VZ24vuRjk7LzmsjDZ8/OT/8U/vJX/6l3wgV
ZgQ+uf2dj/2nq1M0hgquerwjwcexw+7cMvTvB/LR9tT+ffL76sb0EoquLHVu
uvpqMS5lBXHlD6u6WmMDp4X6rT2ovPtTpC2G9Qz77YWwuqPIaO9OsbGM3vFM
3Bzb87vTz0lzRfXzpgBrq1H7c4Qs5AKNQLzwxqa2tp0XamIB8PtZCxythnxz
SmO+qi2uhRMcsQ+i5BMYYkSs2zp+wIxbJeT3nt5c3wyznyh/oNtlMvmHlS+v
jm0dk6F9N8m/vMzJyn9liu7V7OW+1R+NjtM78j3L29HKKozDj5fVYsHvnPii
7RCx5hApDHlYwOsg9/C3pV10GZ/w0u9XfmLLDPtCA815fN+RY7mbggjTmN/Z
lhKX8bz41KDudiakiHmjyOjdbOnFR+LqrCw6HOSNtfPc/Hux7odgBALAe8W7
ZgSW/rmZyA7j9M1fGssHL75/eumGcY42vRYvz9UGRLxI+fLfK9Jevri53kn9
Zc0kXHEi+bNasr6bj5aVK69Hh9l275mB5nlivf5MNnzS7ReahzAWVnJ6lwVv
P011xXmRPL8JVmve+adVkiDQCMRk/b/7RWfzkVlE6D6QdPOm4siGBi6UtDPq
ql1N8xwh3kYqvrHeVfbxwuQS6t7Lgyy5A7VZBBiBla+uj+sr69rz9FNKU1a+
zOz/sa798av7w2wwz2XaszD8VWawM80FNP9Mr14Jj6WtYJW2C9r5/qxeaVXK
m0nxG34h93+E152ldzC7sJi/dEOK9EkTuHssyAisLLs68jPZx14HC3XtiefH
DZW10L8aoHIMxcCcnb/9U1s0amSKs5zpPyQiEWQdYnQWMl4oHyWrowvjqswZ
2/GDJamvKMmdCuWenmmCjUAiL1ODMel/mhD79DRxmiNGzgBGQ2VLkmZaW9eL
TPtFY82hWHKG4wdSIaNNgQ5nfVan0U51kSEq0gh8uTuhQVSC0ORXJfmHoyaO
HzA73NHJanh41tvOigMAwFvkHTMCkYWAtXGJ+jJEQ3jYsu2JJ+9SUnyojYpB
jVf/9rrq9rEoO1owIFmEKjdupM3/tdhxp0z3WXnaymYyuxVXSAvsWV5qh+ZW
o2JyGXtcZN5m3TNuTwrCnF133pcos4jQnUDHrbf1fYmWaVo0NN28qTyZ/Gkt
m+HrknTmcVXJrbXz05TGvSYNbKTSbfNbyAwiblCYtn5fRYAReO/cHDYr6Gni
1DoyrfvWi4LU1naYf78L/0PPJs1+yt7gi5SZHdM02YGkqiAB6gIDX1MRdWfr
naDtZ/SyiPFFFGQEku3JkJmMDpCN/ymXR4yQSbf11gFL35n4w4fXVjvLZJTz
R7IcnTzkwGnnseKEPklmxZnkqReLWetnaLHgV/aFOtCMVYGQe6R0fzkui2vf
Wv9ass/WH3xJtfAZIWD8TUEGjtlpZxXGD0UZgWVFuzvUMiHeTZl5IrGDm03o
EOoxBxiBAPBe8Y4ZgeT+G+Y4J6nEyCqPq/4+lq6e9lg361SZu8JsKRtNlGIJ
awovvx8/qo7sw0VZFEd0dAZNXemQDaA9LpQA4T6BBsu0ESNQ4xlFIGvft+2Y
hTGHhSTEYxSCtjgwQ91A21+6JDn8RiDaHHNZlcbQR1QR56Vog4jcy9J2QeXJ
TR6zNyz8t7bTK19eCG2bqov9kaSCCLILmLKZUXf+3jGKMSOwsuz2j+nFqqqK
g2vbynTtRqtIu3WHKkSIYbL8/PFKjHLQ/pjWz9M/btvGXO6MRgYWS+VfMf1l
JiTQJg5GPWxGa91FOMtnr4EwZ1f6157f3eHOdsWPeCOw8mxKLzsT3zeR6WvX
J/iCdliAEQgA7xXvlhFIvlwbpok28mX6CVcV/iY73Bezo9t4aHeCMBdLNB5o
um0oBNqM8ulxRvcjaaNCqqrNCKxCzo1xferZafOB0zLHssMoBMVUchpCOgH4
10pCG7mNQN3XkDc7aahX3p7isSL7OdFr6ET4QebkwLj8N5Qfm19BBKsRaEbd
q9EILCv49lNCVVB72vfxmTMvhM6QxAuayNm3YgQqMzO+HjJ5ULPGH4cMn9ap
jz29HFVO5rqggSgCiAjx6aV1zDCAabGQI5Fp9PKiUl6PHmo/imkBspSv/8nz
3M1bZgcM+bhx05Ap875obC/aCERfkMAIJGcnP5rPgwg0bzGY73pNjh0wAgHg
veKdMgJRcB/90I0T9CaOboXQgcw5Ro5BdP7oSThWofwzjJ1GZJPYT9X75KBb
3mgnZWZSPUYgnpv5fa528Xj+5Lekb2Y2c6E6xv8/e+cdFsX1/f9ZHhPwCepv
k69+glEsBKMEowEblriIAmoQC4hB7MYGgoAFiRGNBVvsLZHEKBqVaOwRG1gQ
G5YgNqJRA6gQMLKIZYG5v522O7M7bZdFAc/r8Y9k2Z255dxz33PvOXf4MQzk
o5JxhISQbq1VWgRSK65CIlD/HkDdjnDO7ZUq4rS0V7tXuFnVmHL86bPNUa23
pukD4CxSQQpeEViOulegCMw5M1FFrIaRx5XztKfxdV6fCFTnHAv0s2loP237
Hir3h3sdPPfQ1tuMkWsy0/dP+sa7JtZ8Vlwh31gyUCz4qc0+75g47nDNvZgR
vArQ+Pp0qa6emNv8A+s+3pvSqFSgN7oSSF2Hs+8siObW+eW/7n3ENVXqSUF3
BRCBAPBWUa1EIHX6PSc2TxgyINDwJBnKA3OVIaXxqPhtasLy3ZzKmjDI3cla
ygUXnug+snBWCKooEViSML/+Kk4L4Bd3Dqkp1ctG89Tj2HFKfVgXA3VSorMu
K0F6rqRetGc7MTaXu4KaGzvWFrMau18X7U/vCM9at6Q1dUowuUJrN23bbj/W
XrDlKkjAKwLLUfeKE4Gag6vtxhNtSIXI8qxIFz3MyH1hSjEsJQLx7HnjP1bU
CEvUb17qr/Py3rZl5w8NqL/qGns3F8+KGW71Bb/lGygWSvSa8EogXJO9Ilz/
GjXyo/szuq66UcJ7fQIqwIDKDzKqY1na7jkXc2U1Bb3pUO6YQMrpybEZ6tHJ
6PgsWgQysSsgAgHgraI6iUAqAkoiIJCBX6dRiX7sBnn1JMmnjaIXHTNDzars
WQbPPBVdT+G+cDPr+EH+rBB16v6fLt+R2IgUoqJE4ELrPqPS2YGLeWnzJZdS
jecpMtr/f1OW5rN/dyMxpJZR/LxEdjCZzdqaPcNquyD/QNf/sVMJEKPMGzu+
/90Zcg+eyCB2xhrWthvH2Qu2WAWRoAg0u+4VJQI1hSkDWlsvJMtJWG9brmIh
KFg9ol1C+hvYDqa0Mfc6euWmvhDh9fPWPtZfrEtkDxOiE/vxr3RxFQv10nAB
EahR3/0t7o877IhQXL1vTbdvV3NOKSwpTPTtLPbGkHTydCB2HUsKj3jYUZUq
SYhx2ZEhqymY6EfdPiwNYTkmiEBq8VPg+7j6wh9xyWl0ig0VqGxbM/QQK3Wa
GjiYPgoaw4wbCgCAaks1EoH0FBCw/ZK0+8Jfnh/YyjAgkKRg9ZSajsykqeGe
FYPI87g8m9SYTM/4hmfFUPBlhZAZhRjvHWXVjdxfFo38IacYrvKUIQIXNVHY
fL0rjZlz8cJNs+yCY7PF4+qpi3DC77Xzadyg91nhduqcRJ8ONTmR9rJ2zQyb
lFiriW7xPucoMwKDHGEiKXjOpwrFoG1p7K9ZroK0COSLN5Ndd77e4ZirKSKQ
SqIx/HJR7tmxwz9W6Fd7yPa0cYpeqjNRzZXEoT6RN5inCcFicKovKAJN+yGu
uRHsq1DUnHKMTmXFsy7HqgL9a2M91ie++ueAx/TDB/s5YK6st99qCk/72Q3b
yx/ly1VEYi8HJ5O4OdG8JRf3TXjf4PW7nTt/oqrdXT9yeURgwa31n9hiHd2P
0PaIq39bMrLVV/bvfLj62qv8ZR7Dkx7JbUMj28Yf3dmsat/ICsP6DDz/hN+N
GRRJLCqAyg3XRzgTotd99KSjf+sEHq7es9bPBrPt2TPpURlzfcOGAgCgGlMd
RCD7LQ/U+cx+vok5okqQWJFQfBzOJwa0wu+bEOJ1FdOjRrV0DIiNvf6U+3Km
7GubPB0chvmH+Ixp17zNrL1JaoO9NjIrxGBBUr11UZd3FO5zN+Sa8pKv0qQt
A5xdXVv0a2/DBMm7Nujt4+TkS74dg6Eg7rtu7OqHRN24d2Km60BVbTIbwrGu
Z/928Rl5xwP7UkdYY7bauc959omCkoR59jHbEqeMc/b1jJgcHdrFySk80uDc
MG7jPNFfBFO49Grh2ldfEnXKkRVeKscAr/CQ8H7NncLW6/M6eUpY9IRbHif/
Lcm0bnl052AwdRD3jOA2jqrICQf/Ml6XKPsrvKftHFYSd1bqzI9Yx7KRWKaC
92/94t6ffjUJWdQOsYbvnTGt7jy9869QaxhTEDf7C51J2NVW9acETI8eTbs2
UdB2wlmsJtoz8otGjuOioyaqXDrPmE2bdKacYmTkmVl+vh++oF4HE+leq07A
1AnBfYJUkyenPizOXj3XuybmMMA38Z8X5wPtv/09aaO3c89gvyC/qJGfOY3X
veLECIOVwOx54/737offpz0x/qbmxLagWqwTYJ7e0r0FxhCWP+SPCUw/s8rd
08bVKWzm5DGeqtCNCY+f5iQO+LKRlXWv2DXZxcaGLdAUiDwLfcemiU3r9Yuc
EOIzzHVI0J4Lx+bXpQuiy+AWrjK1nMhec2ZBHGbliH3ecstt/WlX6pTDa3yH
Oyvrevbz6d3gcytXh4gfOPnXGMZtKAAAqjX6d1rJoWH9H2+YevjCWwe5aicz
QxkAAPOp6AC2Shgg9xZWGQAAoApBvFCgfrMtdy2WGQwAAC9voSJ6C6sMAABQ
2SHeMzLsf+/W//F6YXLPD63Gsd8QCgBAhfAWKqK3sMoAAACVHSIZxKrpmPAb
91Nj6vNHJQEAYFneQkX0FlYZAACg0oOr963zbj0kvK1jwC+HDFNFAACoAN5C
RfQWVhkAAAAAAMAArWKp6H+VjbewygAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAABQRSk7sdnnXUwWPfzPFSJ0+1i4kv5g
6K6MN118C1B6NK77O1SFrBdefFmeSxWsnvqxgrySg1PCP6I33bO8tUJes3sH
XX4muwTVrndMQ1NwuLsjXf+xMTklb7o8AAAAAFCJKUlYaP2Bw9zEVHUp/Ql+
bpufVhZ27nP6KfOlotyzY4NsbBhhg5dkzR5nV51khqbofKB7+UUggTp7R3s7
SRFINLvnqEnOdTxmRCX/XaTR/u9oQrSUUP/xLO/K8h/G2NUMmjLRsb7/uSJT
ClD9esdENOd3jbattiIQv7RvdG3MIXDUpafSXwYAAAAAEZ7FTa8zJ74YZ310
aedgawxTcbXHswfxbZ11wqYkYbFD9ZIZOTFDLSMCUck5fwcZIlDbgFYDN/xB
ae8SAxFIqhc868piB1vDjpBTgjfYOyXq88vW3it/K8oh68KcPy6VGX+edzG2
brUVgfTCtZvqcK7Jv1Xvm7P7XnVsFAAAAMAscmJafvXHfc5HvCIQlV4O+r9Y
RiOBCBRGpghcaO3W5/R/rP81EoFa8peG1ehcpUTgk4ylbUwusHmU/rGq/oIE
Hk1TrUUgwjWPD/+0/3YeLv1VA8rSR9WfbwELBwAAAKoH+IMo59kXuPMCvwjU
yiSXmAsgAiWRJQJL9yyrPSE2l9mCFxKBKH2vn4MpMYH01d5Y72gOrv7Q4bWI
QFyTPvoL64Vvnwg0m/yMlU0sYuEAAABA9aD0RszgQzncRQUBEVi857sxpx5R
/w0iUBhZItDwN0Ii0LwSvKHe0aSnzG2mNGP/2mRwTXbc4n42mMNiEIHyUOec
HOyvtIyFAwAAANUXARHIhpYZO//O+mFep+5e4SHT+tdVDlq+IZs7w+CP7uwd
3Ne+R9fQ8Ml+TR1CNiU8Fp+C8JKsHxb6OrkGTx87tt8Yt26h0Z3q+e/MQFkn
Ylz6tbchsz4d6/ZcFFdArqEVrJ/RqgaZjOveKv56ni4zVKsNnt9PnuPecczU
WWFOSmVQ0PEsjXYePDbSo+OYyZM9/JXNnRcmXdOwxC8lAhccTt86oI1P8Mix
/ab0+cg+lK/AWqmzqpuDw7A+wROih3ziEBwXn/2C0zavWwRq1NcXzBvU1GFY
dEiIzyC38MgTG+YYi0D1qYPzXO27jh0T4fmVvYf7hvOZVPX1Gc3aHv9XrInE
6l5SeGq4u2sLso/saqv6O5E4zz7xQPdbEWPQXE2e177ZgAi/oKDoMR3bRE4N
qyfSCPfOzG/bo0fTrk0UmK1rg94+5K18/ZN0MXKMCLx318AGOP2ENEWZyxb5
NHEcFz0zxMW+Y0Rk6iPmC1pTGT6gmb9XeEREuJdPm4lzxjfRB8SK/ZAXdsr2
lrMnx49u+ZVX+PAx7ewcJm82zcD0SeU6A9NfXCvwnvOOx8L4hV2d+nvW1RqF
wqVXC1dXosE6xNKDSKKyAAAAwFuFbBH4RaDrxK1JReRUojm4zr2G1fBd6TrV
gGdfW9e6ZofZq6kpDL+XOsvOauDG48+Fg5mKdy6pPyLqnm5GfXLn55ZWQYyY
Kd6+uL0V1nhe/Av9FfA74T3qRC3VzZJUZmjjsT5DR02+8ZT8HrELhilHRq/7
ynvDNTKSithJ7IE1b5nwQJ9VQIpAxccD+iQyUsGg/BTPj24datdo/ilaQaGi
vFOB3ZQhM/8q1rfNaxWBL3KP+6qsvLwP/0OXUnPtRIy9LfeIGFy9L27Q+/Wi
j1CiDi/cNMfpPcf115j8UiqjuW37iAixJpKu+8uHO1z4LUfMGB5eWdSi5ZY7
TCvjmszIAKsxUo1AWqnYSuAXLfpGcW1gfIz2UYBGo/4zNKhmD6bdNIUpA9pb
BU24oS152fO0ofUHbLtYwpiZJmlT3zpMh4r8UAQmZRv73Hn91VzqwporR6d9
ZKWaY6KBGaef0xd/NzhmnPcmwfHIv9YtXlkAAADgbUO2CLQNCv9LN6XknJ31
AaaMXJpPLS8Qk0t3xaeue7L1qvB+1CBFM46u4FKWPqrdu3M5Gi87xtk5gREz
5FSO9Q66rCtYWfHpgNbxd1kXpARA48a/3GbUAf4ixbexVuD13XRG970X8XMb
Y1ahifqMGHKKrBGWeI8tUV/tXt6uhs2YfdfoD3OvrXRUfDo77mkp60tZqTF1
Fb4/JTGLZq9TBOLZ88Y1rKFccOEJ+9Nncd82ZIvAh1eWNFbUCot9rLvsswfx
nylq6UURWWbxJpJTdyERKGYMeOkfqz9wYJ1HpP1bWoLz4HKLQGMbaOV24DH9
QfHO5ap3rMbuv60vUOo2f2tSNRVnrGz07pyzav0FXzzc3pFeHBP7oWh5qSHj
uzmV/bX8pZPsMNZvzTUw6fEoJAKfiFUWAAAAeOuQLQI9f0rWyy+DQKy/T07/
AMNGRD3Q6H9V+se6TlaKsfszBa5adnOCJ/a508Kj+kMLS5Pjws7q9vnK/grv
q1C8911qAf3B38k9B7O0ja4Y/hNu6ldXyEnTzu7Hm/rvGUfN8U+Rjy7O/1Av
Ows3fNtMwZGOBJqCA12UWGev5HzW7V6PCCRmcOYQb87VOLUji40FbL/Ekh9a
vd0Za+6yJ5tVZtEmklV3IREoZgyPyo7FdXvHJnDFmsxCpoBPbyz/NkEt9KxA
ISkCjW1A1ykl6uRezbHGjlvYkp9sTNuJsblFt9c7YI4jgg79pcvALb2+IOxs
gdQP2crNCP5AzTvHI2tbwMCkx6OQhRcKVxYAAAB4C5EfE8ie0biTDhW8xN26
pa/8+Yq9QrMldRAugV1t1VBV1Ia1emFAfYFYdcGaz4orJGe7/KVduhzgrN3x
JQUITprSIpBSNQ0bbfyrjFlRNA6tp5bRdMspr08E4qc2+7zDkwHBrV3p5aDP
WcVj1de21rKrr4TKzLmIzLoLiEAJY9A83N2JCuZUuPi0Hjk7/ECmjPNPJEWg
iA3kX1lSn3scuq7wxPtZ8Ox546k4SVvXBgMn+a8+wjyVSPxQrLz8IvD5gy0t
LWBgkuMRCaY+CVcWAAAAeAuxhAgkZxxM2dtt+gx/LgOXns4UmeI16SkrPPu3
rEEH0tv21Ee7Ebx8vNtNiX3e8eAjHD3P+bVn35T/uL+vCBFIfc7+b25jkHO0
7mqvTwRStZAQgXSxrXqGDhg5ktsVIRNPPioTKjPfRaTqLiACpY1BnXMyLKp3
HVu61xvqwheFKY8IpCzcocHXMw3K4z9kbTyxsIyXZG/+IaKZK1Mghft3ZOSe
5A+F4ReBFjKwcohA4coCAAAAbyGWEIFP10y1wwTmaEHw3ENbbzM31WSm75/0
jXdN/bofBXllq+G7/i5NjW+3IKHYQCpU3Epg2bPkng2F5+h3ZpzKF7qdJBW4
ElhSeMTDTur0G6kmkll3AxGYf3l6P2KTVNwY8MyUrZnMylpR3uU1G6c0cWDt
fgrAFYGle+Z23c2EGUjaALUJK2ThL3KTfk+l05dwTW7i4fVeXzayqvnNyScS
PxSFXwQW3f25uQUMzHQRWHJpTNffc0Qq+8jkGgIAAADVAEuIQDxtV5ANJy6d
puhhRq7QKkPJuYD6q66x4sYQnhUz3OoLbkmIOHnMduSqXSOdFhrvwFlWBJLR
9ZjvqHQyN/Nx7DglZhTT+Cpvd3tbzFmX9fAaYwLzri5pIBkTiGfHDLfFjCLN
tDL7fsZD5vBvySaSVXcDEZh3IcKLqIuoMWhKEubXX5XI/gt+ceeQmlIn2nFF
YElCjMsOpjclbeBFzg5XW3aeCHNjTc7Nu5qnF75tQ/c4zfOc7W2sGmnvpRH9
oejSpVhMYLkNzAwReC7IZccDoo8EKytWGwAAAKCaYgkRiF49SfJpS+/bsihY
PaJdglAepXZ2s/5iXSJ7MiVEUT92hD+REXwuwI3YtvLnfs5bDPqyMkWgYXZw
8fZFbdjZwWSa7f+mLM1nT5A3EkNqKbqv3FMsnLwpSfmyg99fdoUjhsmcU33t
8MxT0fUwO4NivypI9G2347687WAkr+50CgMTMnc/uVfomqdl4sbwj0Zb5T6j
0tk1yEubz81S4eFmYrCtPs7wWdyw7ocfMj+XtAG84IeZrlaG3Y3fOuLhH5NV
oL37h6uvPWf9hbBM97jkMvEfsh9fjODJ3SCecUbUUljAwOSIwPylYUpdYGHZ
s6SA7ofzqKYWqixZxNy/D/y89a7a9JfUAQAAAFUQ/Nw2v3eNot+5UJMOJ+HU
aNIhj4azcYpmHeJ3JXGoT6TwiWrk7ObquuOu7geFp/3shu29ZjADvdq9ws1K
MWhbGs/MRBWDk4hKXpab0ckvAju3Hji6b6LuwD3qGLd5G3L1M7LBgXtEMFui
T4eaI4L//E93cXNE4LO4GdYRxEIZcV6KX/gd+W91MCwArj6+LfRDB1sMc1+W
wET4E8X+qk6dyYeYYuOa7JWh3TYmPWfrCokmklN3lLskjBGleOGmyV1+owW/
iDGUJCxqorD5elcaI/61P5xlFxybLaqp0MvcAypHOq9WaydBXbbrjh4SsgF2
p5DH/dm4uR94oD8g+lBgtw3Xn1E/dwyL0Z1Xid87M+OTNrv/KRP9ofBoYbUn
5tZx9336hyUX9wUrFe5zLWBgssbjtUPBdbCOK/e+wrU1ShnlQ6pW8cpS2dAY
5jw/3jDuAgAAAKhGlCZtGeDsSr/0AaOzBYnXMbDfxaAl88RM14Gq2rbUyzs8
+7eLz/j3eGDf3g3IwHJba7e+Tv5bkin1gT+6czA48otGjuOioyaqXDrPmH39
qchcUnI+0P7b35M2ejv3DPYL8osa+ZnTeN6XjBTeWtvS6LxBzROjYmTkxX3X
7RNvKs3EQeXgERJ1455R+W8RWiF3QZ+2u66VFVzb2MdtUHho6JcjnJu6ztqb
ZJwpqU45ssJL5RjgFR4S3q+5U9h6fQpzgfHtpALsqfNbjLENnHBT5iuDi3JT
J4e1+sgpbKa2kV0HLFya8csiB/oquvxfstie7g28u4ZOnTK0jeu0XXTVeMos
0ETidWdaJ/vY0EFK7Z+mB7pFzGOdoS1oDCUJ8+xjtiVOGefs6xkxOTq0i5NT
uNQ7OEg0V5MXtFIq/f0jPdyG7UoliijTBqhra4oy162b1KKB+3j/EJ/hLl/6
/nqdPMY578Islz57/oj/urXLBOIlLKOdunXTvWBF7IeiUDot6IdD5CtpIoj3
tnxeXgPzWhhXkCN7PBKv4/nev67Sf2pUQCePnXfI1T/xyuKazKjhTa1shm4/
Iy7JAQAAAOA1ceNA5xGx4smYAFCpqH6v2wYAAACA18/j2HbDjz6U/h4AVBpA
BAIAAACAOZAB8x+Hk3FiT++s9xx4XiICCwAqFyACAQAAAMAcslJj6ln3Whpf
UKLJWuDx5YHbEKUOVC3IdzEbvLwPAAAAAABJ8Mc/f9fG03OSb8fAXw7Ba62A
qoRBLtVQbqYVAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAADVAE1R5voNU1w/bdBXNXHajAltWzfwVs1J
2PP45ZsuGFCp0BQc7u6IUYyNySmx6MXV2ceG+tdz9wtu7awcOursv7hFr24i
t4+FK+mKDt2V8SZLUpEUrJ76sYKspINTwj9vujQivN7u0Fw9saB1vU6jpwbV
Vw5at6OgtKJvyOXtsD1zqFotU+7SVpnhWZFFfcODUV+Oipz73jR4dsamru1q
Dgk69Feebt7V3Lr8i0eHmgMHHs968SYLB1Q+NOd3jba19EB49eS0n8pq4Kh0
dVn6qM4YZhWaeN9yVzcLvCRr9ji7KjHdlAd19o72dpV/lnlt3YHfSY1pYPXl
D4eeP8tY2QjDWrkdeFyhN+QtxNthe2ZQtVrGtNLi2fPGNbWy7r1ub7FuJq4q
wxNVSFErxWBkYTz34Zf2ja6NOQSOuvT0TRasPODZ19a1/ljhN+TSf0YLL+qc
37s2U/T0PvwP6ECTUe+bs/te5XhayLow549LZRa8YN7F2LoWFoF42q4gG8x3
cypOPICcj1vy0+3CN7oSSFKSsNihqkw35lNyzt+hSswy/N1hYfPGs2OGK+o3
2vhXGcI1j/ZtWnAkVV2hiw8C5a8OtleiPr9s7T1LbydVrZYxpbSlNyd4ayWG
Y/Qa1nqXucPT4m5fGot7ktc+GCUxmvtKj8Z1fwfD3FSHc99owcxGU3g2sLui
lnLBhSe8f8cv7hxSE3MMi7kHMtA0ytJH1Z9/sVLsppf+sar+ggRL6tEKEIGV
07FXzlJZmqotAi1t3q+7NYTKXx1s70nG0jb+54osfNWq1TKmlbYo92L8lluc
518zDdLybl8ai4+dyueajOc+XPP48E/7b+e9+TULs9Ac3vDluxjmP+GmkMYr
KTziYYfZ1pxy7E3vzVUt8jNWNrFeWBlEIK5JH/2F9UIQgeZQOUtlaSqfpxWA
pzssb96vtzWEy18NbE9zcPWHDiACy1laswyyIty+NG+lCKzS4K8uDemIYVjn
dYkiK6z5S8OUGKYMi31cPWr9GlDnnBzsr8QqgQjENdlxi/vZYA6LQQSaQ+Us
laWpfJ5WAMPuqBDzfo2tIVr+qm57mvSUuc2UmApE4GsXgRXk9qUBEVjVKLy9
XmudUhH4pX+s62SFYa6qw//yJ8gYpwXRu+TUJ7dzDgV49/2sp9Vnzj9dlxU6
qT51cH47e/uvvMJHjnby6rntRi57oVXrW1Z1c3AY1id4QvSQTxyC4+KzmWVM
fUm0nuffnGMjPTqOmTzZw1/Z3Hlh0jUNXpL1w7xO3b3CQ6b1r6sctHxD9kuj
Hzo4xaekLO7W8quwbyLbd67bx+vH85ka6vby6l4Yv7CrU3/PutqWVbj0auHq
6qSlQ2ycPsZDU5S5bJFPE8dx0TNDXOw7RkSmPnpRrkYj6rXQ18k1ePrYsf3G
uHULje5Uz39nBnp8Zn7bHj2adm2iwGxdG/T2IUri5OuflCu3LrobqI/tiWlr
33G0ts3D+3f2/vHw3pj/Y36oeXI80J+sL4bZWrsNJq+vJfPk9Hq2xIeOdQO3
JovFcWSemOnq07uBq/bbDioHDw+mkGTVsjevH9vcYVh0aOiXwxy6qlalZJjU
HawEPa0mfy5kAEzXqK8vmDeoqfZ2ISE+g9zCI09smCPfgWuuJs9r32xAhF9Q
UPSYjm0ip4bVG82KH350Z+/gvvY9uoaGT/Zr6hCyKYFKvS9N2jKouXfLGmT7
uTYYRrWV5klSP/cmRF0ULgF+x/OIb2rHxTxX+65jx0R4fmXv4b6Bssynt9Y7
2tIZiDvvZa+Ocu0ywtPGJig+6TnVUNoZYeOyQGetecya6FyvU3jwyWyDdX/Z
nlbyXkKFRMJWWmqCKXLm03vC5i1yO1EK4mZ3cBqoqm1LWHJf7sjVPtmFBjt0
dov4ZkaEm4PDRH0zmjlyxcuvq+zOv6WMlt+fyEFrk3uGDLb/3CUkKmrkZ84R
O5PYAVdCXSnlZon9o1PD3V1b9Gtvg2F2tVX9yao5Oc8+8UAX9kZ19707R6a6
jQj4yKrpmPAblFaUNlfTZRUxrucHNajXL3LaRJXrsNWbs1+8ujTEbn7aSyTh
NAyXnSXLJuFDxEZQ6eWgz/mST/mGp9Yaxw5p5q+1iil9PrKf+JN+EpS0K8Ge
fZ2eRNdaIrO5yGAUhV8/ZJ6IcSENkpySei6iL1WwfkYr0vc6uLeKv6WhriA2
LrgisHTP8tYCOdHiMqaycOd4ZG1qchRdsLq0c7C1dizb/XiTtkue5FDjtCBN
0flAd6xxk/EhneddUD+OHav9xecr9kr1Ia7eF/dVnTqTD12jHA6efW1V1867
/6HjW58f3TrUrtH8U8zMUpR3KrCbMmTmX8XckrRtHxHhveEauU1PLIz3wJo7
L10f4b0pqYgsgebgOvcaVsN3pev7hfqh1kC+Dv6TypHR2vyKGR1q1os+QhdG
bt0RyokZyt+wGvWfoUE1ezC5NprClAHtrYIm0A7QrEYr3rmk/ogofdDmkzs/
t7QK0vkusvt4Hwnl1QXPXfctpxGKco8P6GFr4KlyLs6vj2Gd+5xmzXv4qV/a
13c/8EDWlMTj2Mue35g2Qtln4OmH9BU0N87MbaYc+dsZjUlVoBP03g2OGSdm
AC9yj/uqrLz0aVCaaydi7G3lHu/w8MqiFi233GEqi2syIwOsxtAFI9OvanaY
vZpycfi91Fl2VgM3Hme0E34/6itbrMaU4w/1F3yVf0BVK2R/OtnsxLgY9L6u
F/DCTXOc3nNcf41qblz96+IuNbD+kwI6L9+jvrt/dE0M8w66/Iz4W/HOhZ/N
oO9LxgB3s+rpezrP7KAjkXuJFVLcSmUOKx4jETBviUEhBl9r5N3c5KbstmQz
fWQWrnn8c6ybXZvtmc/pL5jp7sSGJ1XZLwJdJ24VNlpxfyIKaZM2TtFLGdso
+jOsjf/ua5TvE7U3ETfbMuEBk4vw8uEOF4x3JRB/cHGePYb17drXf2jav7m7
22sn+lrLrr5CsszVRBFIjGt3hYvLxgzqKnjh1lltJ38/6QOWfxZ0Gpy7SJdN
lg8RG618By8YGWRZcdqoz8IPMw75/oX5jaxUizZzBJKgXVUeTyJjNjdZVUro
h+Lti9tbYY3nxb/Qlxq/E96jTtRSnfgUHRd8K4F8k6Z4MSoRlLqTKQLZX+NZ
EeXpLFIIYXZTluaXIDznRsLM2SnGz01c8MxT0fWw5jPW5DP2rLWTkR8oOq0l
N6xzr610VHw6O+4p29qzUmPqKnx/SmJ0GlkSTNF30xldi7+In9sYw2yDwv/S
VTTn7KwPMGXk0nyDJKyGZCKSDu1E3NWO49lMqDtPwxbvXK56x2rs/ts6G8RT
t/lb6x276Y1Wlj6q3btzOVadHePsnCAtAuXUhcp/d1uSUMwe6/dPRisNg2OJ
KUD5/rIrz3TferY5qvXWNJmPP8aO/fm+tb2s35tx8iH7Cs82z2lk3eiH68zk
K687qIuLGgBxOEPDGoYZUs/ivm0ob7op/WP1Bw5cDZyW4DyYLFjZ87Sh3RWf
uu7J1nf7/ahBimZ6u6IysOymr3mqs77CW6u6+J+jLvjwypLGilrskIxnD+I/
U9QaH5NFCWJqkH7e8eAjXCsMMtZErz6TQa3JHPH4n6KTXq5QWdjcCBATPa3Q
vcQKKWWlpvSjDBEodTsxjOfcF3+O8VF08U7KZ1liWXFK308VgRNuMvZuhrsT
Lr++suJeS9KfCPLqSZJPW6yj+xHd+gQhdNsofEelF8uwN0E3y9pXEhaB9J+w
GmGJ93DtjJn0W/TGHVkvZZqrSSJQO67Hf6zgNgjl1Tn+WYaxSZdNtg8RGkFI
3kAgVm8UbcJ1YolMoa31weoMjcEteOyq8ngS+bO5bNckoR8QFauPYb2DLuts
sqz4dEDr+LuMFYuPCyRv0pQsRuXhZmIw8Yzy7pyzapFv4ee2+b2LYUqWjZki
AgO2X5K9Clr2V3hfW+ydGafydR+pty7q/K7NsJ1p2k4q3PBtM4XR5rWm4EAX
JdbZKzmfVRLWuiVihrPnT8l6eSevClqerpmq9RcdV+59JX+QConAEnVyr+ZY
Y8ct91hN8oQ4/sh2Ymxuqe6HpjXazQme2OdOC4/qc+dLk+PCzjKr/+USgeSR
fba2Cy8WSf0QlZ3Y7PMu5jw/npaLJYVJ/p13Z8uth5HLJdvK+FQo0mibz4or
LJNZBf3FxQyA7AWsh/+5QtFSCVN2LK7bOzaBK9Zk6jL7nt5Y/m2CWnvLv09O
/wDDRkQ9YDlpMspCMXZ/Jv3/Lx/vdlNiznqhqDm4vMUy2upIyzewCrJrmrvs
ySb/j3Ld3FuQ3yL1Z/0Pv09jJiay4jp7E2oxMQTuJVpIKSu1tAiUuJ0YRvcl
u4/7wEiQvzSslqLmNycfUf9r+sgVKT9ZDkmjleFPhKBGa8OYuGe6nz64MNde
8XFIzL2XMuxN2M3qe0dSBBqUHMk0V1NEIDWuqVgmFkb+WYaxSZZNvg8RGq1I
3kAghZyib9Al5kbkLVjOBAnaVeXxJCbM5nJdk4R+0H1HoXjvu9QC+oO/k3sO
1kti8XGhq7X4pCmjGJUGymilRhNlw5zpuHyrYYK8yNnhasvjGSjwFym+jfku
SD2T6qSsvLlDtgikNfDg8DtybUC47vlXlhjtmdL+kFlyN7nRmMU6ArvaqqGq
qA1rM9knDJRHBBbd/bk53wnwvMGxxBOlrX783jjQJYRYFZGJYR+Rix48Mwh1
a10bmi0euD/ET232eYcn3NeE6eb5w92dqNg2hYtP65Gzww9k0jslVNwIdw+C
7hf2jiH5uMGs6uCvLo1osfwa9dBNBQsZPqwRpsJsoon1sgGyLV8Q/nuJF7JE
wkotLAKlBoUYhvel9hGMb0EVRtetZoxckfIjOV5Lhj8RgFg7shWUrDLsTU7v
SIpAOTkjfK5G/qikx7XOe7PrYqoIlCqbCT6kfLszxsi+RaXxJOWYzQUR1w+6
OxNL5fplhPylXboc0P1AfFyQSNZaXjEqC8SOhrPWTXJ0ryH4nXBfImR9ZNT9
V8xnFSQCqcsK9Ti9gyBkNrohYGERSD8Z6fxVeepOXcqhwdcz/Q0Ysjaeehgx
byrRpKes8OxPJRcQncU+37s8DkeoRwQypB7HjlMyWzzZs9tPTSlAsjHsI4Nm
N7i1QQnLLQLpJ53yiEBERmuHRfWuQwdXYw3pwBtqjUjZ2236DINuH7j0dKZ+
5JErTvRAy7kQ3YU5uIm2fKueoQNGjuReIGTiyUdluuYSct34ozsHImePavVp
gw6tRwaHeFpXgAiUUUgxK7W0CJS4nRiG96W6T0gE6sr8BkSgDH8iVkchw5Zj
bxUpAqXM1YRRKTSuzRaBImUzwYdYQgSqUw6vGhgyoEmDT/0DJ7XvrZRzi8rj
Scoxmwsirh/0tyb3XKj97uc5v/bsm/Kf0N2F72LGpFlZoc8J9GZCj4x5nrO9
jdLwnMAKEoFUtrJQ65U9S+7ZUNhsdKuvll4JNHiWNKfuJZfGdP09h8nEEX3+
NX0qwXMPbb3NXFCTmb5/0jfeNVkbptxBXbpnbtfdzK6BZVcCEV1B5fiYrKIH
G70HnjflNTqGfUSFHQqJQDev5AJ5VeC9uNEPy78SiGembM1kKlyUd3nNxilN
HKh1USqiQPrhmnooc2i25S7OCaekzuoUtwoh142XZK9f6FvLutfM6IuPXxhX
nLqBBUSgRCGlrNRCIpAxb6nbiWF4XyqmS0gE6p6gLSIC2cNT2mvJ8CcCkNvl
QoYtx97MEIH5l6f3Y7YOhUSgLHM1fSXQaHPTHBEoVbbXtxKozjkW6GfT0H7a
9j1UppLccVFWaTxJOWZzQcT1Awtqz2X4rr9LU+PbLWCHu4uOCwrJWssuRmWB
CoMUPguaUonKEeGZxaxPjduB6tNyikD85fmBrXhiFHFNzs27GpxaaOJGPhBV
yCOSy/TBVBYWgdQMrg9/NafuJeeCXHY8YBaKjePcmAoa/VAOJecC6q+6xvZx
eFbMcKsvGAfLHdQlCTEuO4Sj8Q3qQp0kKS8mkPw5LWM271rjtJSJopRZDcMZ
hHxe08cgMaQTCWv6UyvldYe0AeRdXdKgXDGBJQnz66/ixP2SuR7ariyhIqiN
g8pQ0cOMXM7a1KvdK9ysMM8fzx7xa7fjvk6vUJsUPEc5ae5nPKQsRXRXlMpW
MKp42b24OWQMu0W2g8ULKWWlZvcjv3lL3U4MozDvP/d9/R5PlF0ukQKsT8qw
iAhkD09po5XhT4R4uWNRS+MQBbqzZNibGSIw70KEF1NyAREoz1xfU0ygQUKH
dNkeyPYh5RKBVKoLteFidIuX97Yt20vEIfPbVSXyJGbP5oJI6Qc9RPoJZjty
1a6RTgu5YROi48Kg1ro/cgspvxiVBjIh2hFT8Rzlof3Tiha1eN4dTI0sdjtQ
c2g5RaC2qZM2+duwkgsobhzwmE4+wpMBsf+bwo00u5EYUkvRfeUe5iflE4Hc
UGd6IdS1jT65W17dyRO2GTMoe5YU0P0wcdQbXvDDTFcrzvglPr11xMOfTs4y
RwT6W3+xLpFtXSUJC637MZuJZCaFzqqfxQ3rfpg5h0RGXaixr8+LoSDanP/A
TCoH37AZ5VTDqI/IzEfDttI2bI3/xwpOltcdMgyAyuzjZDeTt5sk8+XvRJv3
GZXO/nVe2nyiHUrpRy1qA4JFweoR7RK4WZxU4V3rtgjnnM1OpZvZGVj+q4JE
X0YrCrhuUqhwy08tHxEVZ55NLCMCxQupkbBSs/uR37ylBoUYxtnBZEh8a273
ERmm/2MH55spAoWHpxyjlfQnghBn5igxVZ/T/7E+fFWwr1+v5HwZ9ibHzdJB
/kzI4v3kXqFM8ruACJRnrmZkB3ObiI6DYncWmRzBOSKGfpOC7i4yyibbh5RH
BFIyidvy1EoFcQs1o7QF7KoSeRJzZ3MRJPSDjrLicwFuRIyI8bvSRMcFgYzl
I7nFqExoxd6G9q5WXl67WO+/09y8sLzVB9Z9fRONA2moNtQ1FK65NzdK9b4S
s6sXe05/IiLpFSVSj42KYnQ0nzrnUKDH5ttUhLzBGUfEXxN9OtQcwZzsR0D2
CDcsk3IanGhPoa7EsOZTYrNe0IXJig396N163xzPZDsQOXXHrx0KrkNrJ/xe
yigfxieT53rZuLEkN1HBbhuYc2VNbzSy2K6uO+4yF9QUnvazG7aXOdfoZe4B
lSOdFK/9U1CX7brjbuTUheiR6BbvO6+/Sn+CP7qzWdW+kVbp9Rl4/onRgw05
d3MiSGVWw7iPDM5A035w5ei0BjWDNh7SH90prztkGYChLeHq49tCP3TQuj73
ZQmSby0vSVjURGHz9a40RnjghZtm2QXHZpP9bnj2FFGXxKE+kUbnuVH7EYbT
uvHBU0S/rAzttpE5x5V03TwPsORKvv6wAk1R2vjxvZs2x/qPSn+q82zmiEDj
e4kWUspKTelHzkzEb95StxODx4EYHPNoPCiQee5OsPz6ykoYrZQ/EYEYTR9Z
qeawKrUy1GMrdQinlL0Ju1l27+QuCWNEkXY4TO7yG/PIQ4lAg5QWueZqcqRu
og/r7D5yiun9QSsDxV68fVGbGvqkUU3qzgiHL5SssS+rbDJ9iOAIkrPQpLkR
7KtQ6Dfv8KzLsapA/9pYj/WJr/5hlIagXVUeT2LmbC56SXH9oIfcc1EM2sZz
gpnouJC3hyi7GJULTVHm+g1TXD9t0Fc1cdqMCW1bN/BWzUmgQw6M0XrFzd1V
tXu4RXxDvBxh1tH7p/0c6Ahs76AL57f4O+lP5/bsR50VLw9c83jHLxGf1G0x
2Cs8ZISqp//W65yjttUpR1Z4qRwDtH8N79fcKWy9Pu+vIO67bp/QL18g3j0R
EnXj3omZruSp41RJ+reLz/j3eGBf6v0U1FHk/luo91lQXdli7b6EiI5uY6YS
x+/bDx34m9FB3+J1p1eXiRcWfO9fV+k/NSqgk8fOO6ze1zb1unWTWjRwH+8f
4jPc5UvfX8kKliaZ12gl5wPtv/09aaO3c89gvyC/qJGfOY1n3kZB3/Bq8oJW
SqW/f6SH27BdqZxNMll10fbIpolN6/WLnBDiM8x1SNCeC8fm16W/ZXQirlbG
fNT/N6ljythksvqIfL+A/mR4oq3Whnzm6BcREeHp59jbcwXr0A9ZVbgr3wCI
c7BTJ4e1+sgpbGbURJXrgIVLM35ZRF9Lnxcp0A0J8+xjtiVOGefs6xkxOTq0
i5NTOOfdDVrxfDA48otGjuOitRd36Txj9vWnPI2Ep/7qWV93QgIHwvI93Rt4
dw2dOmVoG9dpu8hz7J/e+sW9v/6NLX255+oTr1z5cWIjG6dAz4iICf4evj+e
yym+dOzbpg5Yc/uYo9mPNhgNGZG1MvF7iRRShpWa3I/M8f585i19O17YDoR8
24J+DJLdF96uuWvw9BnBbRxVkRMO/sVkf5s5cpFg+TNNMVoBfyLr1jcv/Ojt
Wbe9S0j0tBGqTt8YvDGEvyvluVmqd9TZx4YOUmq99PRAt4h55Ll2pTeigqj3
WdA/D2C9zELCXK9p/hE0AzGIcR3Rvq5D8Mxpwe5u47b+eeMbo2VbrZz+JqLj
Bw2+nhER7uXTZt6ae78v5ox9ybLhunsJ+5Az1wVHEPHqJXYXa62ogKepX1Av
r4l0r1UnYOqE4D5BqsmTUx8WZ6+e610TcxigX7QRcftv3pOwSyJjNjcYjGJI
6QeawltrW7KO/+XCPy4MO0g7BjPyuB3ktZBpMZnFACoXle81hVWRV/n7e7aT
fzwgAADAa8bMvXug2nDjQOcRsaIZ9MBbCIhAC4D/ubtdJOu1FwAAAJUMEIFv
OY9j2w0/+lD6e8DbBYhAs6DC5l3I3Bm85K8pbWPOPZH+FQAAwBsCROBbB5mH
8nE4GaT99M56T9NOMAPeCqgzzKvKQd+VByLVrpF1v4Gn8/CSi797hC2FNXYA
ACox+IOoAHOyeICqS1ZqTD3rXkvjC0o0WQs8vjxwG6Z5gE2BUHgnIAP8Zsqs
jq4TpozpOC6SldgFAABQycg8EeNCZ/EQ6QZBrLQUoDqDP/75uzaenpN8Owb+
ckjytAcAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAS5
fSxcSb8VSu5bILkUrJ76Mfnuocp/uF+FF1V99+cWtpgcbG2J07HK3fjViSpk
SG8ATcHh7o60rXDemGlRiPeL+ddz9wtu7awcOursv6I55nxFgk40ovTmBG/a
Kaj8zxm+pZrh9fQvAACAMXhJ1uxxdnJ1CJ49b1xTK+ve6/YW66YIdfaO9nZV
w+1XaFGJt1pbDViyWvfiRfT8wZaWGOcsLFzzeOu6wbWY1jat8as7VciQdDx/
uLuTI9a80corFX46t+b8rtG2FSYSXj057aeyGjgqXV2WPqozhlmFJt43p0iv
oxP5vFAlBn9wcZ69qAgkqdj+BQAAEKAkgXhJtzwdQj/YOkavYR3iZ+5rPrIu
zPnj0ut9uVlFvpHk/snIZn1O/8f65OXDHS6Y0an4+P2oZt1/o1vblMav9lTB
98U8vbXe0RaztZl8TMZ71WVSoj6/bO094xcpEE8ZFSUS8LRdQTaY7+ZUrarS
3Doft+Sn24UyBBZPkV5DJ/J6oYrHbH9F+QEpEVih/QsAACCEaTqkKPdi/JZb
nAnCTLdf+seq+gsSXq/Dq8gZ6lJCy+Cl+exZiV8EotI9S/+PqTiIQBZVUARq
JVPmpZ+Oplry4NMnGUvb8AmGihQJZtrhmxGBvF6owjHfX4EIBACgElNuHWKW
28c16aO/sF5YfUQgfm6Ls8EcISAC0aUdLvNBBBpTJUWgxdEcXP2hA4jASkZ5
/BWIQAAAKjFvQATimuy4xf1sMIfF1UcElibFDU7M5KxNCInAh5cmzo4vJDeW
QASyqKb6wRQ06Slzmyn5BQOIwIpBcyd955bf7qqF1xXL6a9ABAIAIAqeczPh
q2EffuIU9k1kYHvVklMZmsIr811Ip2FSFp465+TYIc38vcJDpvT5yH7iT/HZ
L4xuplFfXzBvUFOHYdEhIT6D3MIjT2yYo/f/VIwTlbK681726ijXLiM8bWyC
4pOe46WXgz7nS2Hjc/siJbl3Zn7bHj2adm2iIF8c6eNE4Mt5faT61MF5rvZd
x46J8PzK3sN9w/lMDS5eNqodNdkblwU6uwZPnzXRuV6n8OCThvU3Kqo659jw
AUQ5IyLCvXzaTJwzvomzxeYvIRHILhA1+e78O+uHeZ26a5trWv+6ykHLN2Rz
f4E/urN3cF/7Hl1Dwyf7NXUI2ZTwmPxCQdzc3mRLki9cdpxzkoxM0xQkfdmW
aClba7eQqBvGNsBCqzqWdG42IGLyZI9+9TxUq1IyNMxkWHo0rvs7jJndzjkU
4N33s55Wnzn/dP0p8+OizGWLfJo4joueGeJi3zEiMvWR6M20v7iaPK+99nZ+
QUHRYzq2iZwaVm+0zpaY3rmdc2ykR8cx2iL5K5s7L0y6puHOz9oyr+rm4DCs
T/CE6CGfOATH0dZVEDfPp4EraSIKF5+28ZdvbFLpX1Hqs4h4G3XBhu/cyE8w
x3oxJwv0Q0k7R/8rcV9D8q8sqc/N72aNVq1geH4/eY57xzFTZ4U5KZVBQcez
RBunpPDUcHfXFmSB7Wqr+pPjwsl59gkm2pARCffuSlyWf/gIkXlipqtPb7Ld
HFQOHh6swYiXZG9eP7a51leEhn45zKErxzzYRZLwBsLXMb3L8oy9kAmdqC8J
6SIiF/88MqDT7I3rPN0VI6Puv+JrH0l/Jel2aBHod+hMQkRHtzFTp5Jjzahf
+ESg0MAHAKDagN84EfWR4uMJkTeekh5BU3h2eNsZ30a811b/5CgrC6+sOG3U
Z+GHGad3/8L8RlaqRZs5sdMvco/7qqy8vA//Q7spzbUTMfa23FNKcPWvi7vU
wPpPCui8fI/67v7RNTHMO+jyM4GSGLt9OSW5tHOwNe+TNa7eFzfo/XrRR6if
44Wb5ji957j+2lPJshXvXPjZjNW0A9Y2Y2A3q56+p/OEwxfLnqcNrT9g28US
5iuapE1961huEUO2CPwi0HXi1qQisn00B9e517AavitdV248+9q61jU7zKar
ht9LnWVnNXDjcVr6lhWfC3Dj5CBrKfr7Z6c6kw9JyZiHl+d16plIGwNeuHXR
FzXrzTr9QP8jTdH5QHescZPxIZ3nXVA/jh2r7fzPV+wlSqpR/xkaVLMHY0ua
wpQB7a2CJtwQWe54eGVRi5Zb7jBTJK7JjAywGsMVgXb/13+U94ZrZLcRe3A9
sOYtEx7o4/GfH9061K7R/FPMBFqUdyqwmzJk5l/F1J9ztrdRYq6qw//S33+1
e4WbFWeNq3h77Pt9hlz6j6klNZTato+IELsvP3z53dQYaTzWZ+ioyfSgzs9Y
2QRTjo/J0khcT2zViBIJX7ToGyVyWfHhIwjPSmDZ8xvTRij7DDz9kPEVN87M
baYc+dsZ/d3kiEDJ65jeZYL+UKoTn+9b08PWfuVVsjVe5B5wb0Zpv+dJ28Yk
JD8XGSyC/kqG26H6VGnTcx7zNcNu4m9MiYEPAEA1gD5igjvd3EgMqcWdCOQ4
2zvHI2sr2oQzs6HWhcQMV9T6YHWGzmcTRys0rKFccIFznMWzuG8bGvh/0uNh
n3c8+AjXzvUZa6JXn2FWACxTEmGn+vDKksaKWmGxj3V/ePYg/jNFLd1MJ1S2
ksIjHv9TdGqzPfM5fVcy4bHzukSW9uQW9UnGykZc7fTi4faOb2Al0DYo/C/d
V3LOzvoAU0YyOSaEUu2u+NR1T7ZeFd6PGqRoprcZUjdiHVfufaX7SlZKiIfA
ygaLp2um1KhRZ3QCMx2/yNnhaov5jkov1n8nJ2aotg52U5bmlyA850bCzNkp
5JxUvHO56h2rsftv64uVus3fmiNfDSj9Y/UHDn1Os/QInpbgPJgrAjFF301n
dIPhRfzcxuzjSnKvrXRUfDo77in7gSIrNaauwvenJEr2EMameO+71AJ2e9pN
X/OUueizuJD2u2+zCinjvsLwyCdqjDRu/Mtt3XT+IsW3MdbK7cBjqctJikDx
y0oOH9m1eL5vbS/r92acfMjuzWeb5zSybvTD9eecIol6AxnXMb3LhO4r3oma
ggNdlJj/hJvMU4jW/j+w4volIYT8lRy3Q/Up5bJ04K8uDemIubbZ/Q9TXoNK
yRj4AABUdUr/WNfJiuPuCIwnAjnSi/T/ir5BlwqZbxCOXTF2fyb9/4TmwbAe
/ucKERueWYwSWiOiHhh7R4uUBAk61cIN3zZTYAHbL7HcJXlwWXOXPdmiZaN8
Zv0Pv09jJC5ZVNuJsblCp9kU3l7vgDmOCDr0l+65vfT6grCzBcgyyBaBnj8l
6/vfoIX/Pjn9A8P6kmbDak/qnGqV/oCawg3jOnN0Dj+kkFN0X7mHOW+NbB9d
U5NQIpDbI8QxJsm9mmONHbfcY31MGhi3wTmUHYvr9o5N4Io1+qMUn95Y/m2C
uox1dzu7H2+ybItrnKR5GGkzanLv7JWcT/wfqUUx5/nxVKXKjv3kUQPTLzSV
FZ/+qt2OB+zaSN9XBEERyBIbJkTKSYpA0ctKDx+ZtaD611i13kwMtsWaz4qj
IlqlvYG865jcZUL3Fe9Eo1+ZEAkpJALluB2BPn25Y1FLBevZzYyBDwBA1Qa/
E+6rnWGp47n0mCcCjTBwcfipzT7v8AQeC4lA/ihoS5RE+BZU2CF3dY7SIba1
ll19JVE2k4uKZ88bT0UT2bo2GDjJf/URi571IT8m0FhCMMUu3bO8tQJrPC/+
BdtEyEagt2XJihBLBIqa35x8RPzfq/x9X3Y58MiMTSOeriRFoFEVqHC4zpxl
Pbq+zO48D9S6Nx0A1nrk7PADmXmGK3Lcu3Pah1r44mlPahWIMRti7Usnictu
TnSauTjWzarGlOMPib/yrJFK3VcUyR4UugU/kiJQ7LIyho/MWpBrcTzFoMqg
63fJIsm8jqldJq+FDStFPvQZiUDmLuKUx+0I9Sn1PDs4/M5Lnh/KG/gAAFRp
qMnLaK4phwhUpxxeNTBkQJMGn/oHTmrfW8m6OOUSX5sIFCmJ4C1o1WTVM3TA
yJH+HEImnnxUJlE2Mo76QOTsUa0+bdCh9cjgEE9rqaISgeI/RDRzZd73pnD/
bjVPNo15WEIEUgtxyt5u02dwG8R/4NLT+mRk/M99X7/HbNpe3NF+Trzclylo
ijLX/zDNfeCnDez9J874uoFSlgik5i+HBl/PNCiV/5C18Y9FZkp1zsmwqN51
mPZuyA6LkprHBdvTYBxRkpjcXiy+vVIVdDnn6pIG9Hr7s81Rrbem4cY/rwYi
UM7wkVkLqn+FxJvujpJFknkdU7vMPBGIa24E+yo6eCXTS/3kM3hH9yO5MoZK
edyOuAjUfW7WwAcAoCpDrwQa7rWZJwLVOccC/Wwa2k/bvofKIHtjK4FSJTG+
RemeuV13Z6KywiMeduKqSbBsWjm3fqFvLeteM6MvPn4hq6gvcpN+T9VlFucm
Hl7v9WUjK2Y9rfxYQgQ+XTPVDpOxBFFCNh0RXFp675t2MedlvcVMc/XE3OYf
WPfx3pRG5VnIXgkkwj5lnHrBBc9M2ZrJLB0W5V1es3FKEwfdNq70PF72LLln
Q2ER+M6MU/SFdNuLRWnrnJbufUXHX6kO5xafDmgdf7eM5+eVUwTmX57ej9lY
lN57lTF8ZNbi/slopbB4c2N0lGSRZF7H1C4zTwTSd1H0mrc086nm8dY1g96v
981xeYKK118heW7HrJVAuQMfAICqjPkxgdSEaLizWSMsUR+kpfeBL+9tW7ZX
/ZR4uJYfE2iuCJRRkjLDW5QkxLjsyKBCxG35AvI19zMevhQrG35p3+ja9FKY
UVHL7sXNIbNhuEXNu/BtG04SBJmoaNXIUo7XEiKQijPX54noKHqYkctZsny2
ec6nCsWguH3LVUGX5WgzanOWE6+ub5+ytN1zLhKnYPCLQCqFxDjWC9fk3Lwr
lJJckjC//ip2ng7CL+4cUlN3cel5/HHsOCVmFBP1Km93e1vMmRVCT28vfrks
svWCS8TmNJlwWmPKtj18+TKVWATmXYjwYq4jZ+hJDh+ZtXj5eLebkieSMJ3I
x1fqEk+kFyflXQeZ2GVmikD8frTLrJMPLq/dMOMr//BlCy5InWikh99fyXM7
AiKQzFthpZCYO/ABAKjC8EzEVLYj12lQOR1sp5dHKjqd06PmQa4PpJ4lCR+o
pqYSKjv4/WVXODFb+Usn2VlQBMoqCR0Zrot4eRY3rPthIjIHzzwVXY/rVIlr
FiT6tttxX2w7OJc8vYRTC2q1iihqybkglx0PjIqalzbf7sPV156zLqP9grV7
HJ2mgef+feDnrWKnyIpjCRGIXj1J8mlraCHE2Wgj2iVw83BzLs4nj63jpJmI
QE7EnK6klpLI9tFNc/wiEOEFP8x0teJIfeLTW0c8/AUTUUsSFlr3GZXOtj6i
C3TB/DLmcTLn6H8G5kFk07PTWxCzvfju+z18U6g1UXJMKVvVGbEjzag7K5MI
pJNcmGC5+8m9QpknRBmXlR4+smtBJg0Z9m/+0rAa/88wCUK8SLKuQ5bdhC4z
UwRqv1NrdionYFIuAv5KltvhzQ6mTnYSyQ6WMfDL66AAAKgEaK4cnfaRlWoO
E4qmzjnUr3/zmlwRSHkMXfonrrk3N0r1vhKzqxd7Lpc6FIsId1HUnHKMXgTA
sy7HqgL9a2M91ie++ueAx3QyEU+dk+jToeaI4D/pE7dw9fFtoR86aP2Y+7IE
fU4EKbQMY5IpJN2vzJK8zD2gcsR6k2tWmsLTQV220+ceECdofVWHdcYdrsle
GdptI3MitEDZNIc3fPku1nzGGvrBWVOUNn5876bNsf6j0p8W7OvXi9xzNBCB
RF0cw2Lu6Q6uu3dmxieMW6YSGzF90qLJPH+wpSVmHKjPhpqnOPEA/MeF2ThF
L9UFK2quJA71iTQ8kY/aQXNotsVwu1OAglvrP7FlxUTh6t+WjGz1lf07WmH8
Kn+Zx/AkYlucFIF8VSDPCbRxcz/wgCmW1nQDu224LngkXUnCoiYKm693pTFL
hXjhpll2wbHZtGgke4ebcWy8mGN4wJqhSTPf4yacakdQSl9ngcaRc19BBEUg
J6/ThPdo5C4JY57UtO0zuctvjNSXdVmp4SNaC44dGpwDSXmqBjWDNh7SOwo5
YkzOdaiSyu8yoftKGc/9KL+a/n3WbIqhiVuTePGSrFwwAX8ly+2QIrDt8I4B
zIl/RKesmNGhJncz2tSBX34HBQBA5UBz88IGj651+qimTQvv39l706Vb2422
D7QOYXN3Ve0ebhHfEK9amHX0/mk/Bzq6nsrHVOecDI10r1UnYOqE4D5BqsmT
Ux8WZ6+e610TcxjgyxwITLx7PXVyWKuPnMJmRk1UuQ5YuDTjl0X0hWxrLTtz
/Rf3/p51yQ9srd36OnWIjaMPedY8OR7Yl3qzAPkn59knCgrivuv2iXfLGtQb
Kxw8qPdTyCuJ5mryglZKpb9/pIfbsF2p7NUjdcqRFZ7uDby7hk6dMrSN67Rd
SYSjfnpLsGyISvH4cWIjG6dAz4iICf4evj+eyym+dOzbpg5Yc/uYo9mPNhgV
Ne/CLJc+e/6I/7q1ywTi/Smjnbp10x/jj2syo4Y3tbIZuv2MjHPEWBDldHJy
YoqK6V4AwXr7A6Le1DBQVZtMkXCs69m/XXzGv9wWdvLfkkzVD39052Bw5BeN
HMdFa3vNpfOM2def8vj9smM/fDRSxonEDJr0M6vcPW1ctcYweYynKnRjwuOn
OYkDvmxkZd0rds39s1v8nejXNxAl7MctPyKTStatm9Sigft4/xCf4S5f+v56
XSzIviRhnn3MtsQp45x9PSMmR4d2cXIKp18ywmNI94za5xZdMcI8vFSOAV7h
IeH9mjuFrV+rP3NGh/ruz062s1P1x/082zzbNoB1HiOJSfc1xKAHh/onPXxi
1IMZebxjRAR19rGhg5Taek0PdIuYRxy2aTj0JC7LP3yEYNeCNFTWkNf279qQ
zxz9IiIiPP0ce3uuOMqkz5tUJJHrmNplMr2QQCdSu7eGtHKcK/l2GCF/JeF2
yMu+yv3ds+2ef8rUf8SP6ayaOG1GhFtH+6EDf7vBDBaexpQx8M12UAAAVHJk
vmsSALjkLx3QTsbxgADwFqK5cnRKE/tv/2Dpz6Lc9F8T13v1smafgA0AAPBm
AREImMHL3F1e3XTv3gIAQA+xudysRhQ3BY+CfPse99VCAAAAbw4QgYA8incu
7/quzZh913CENMlxbRckQHQQAPBAicDJ3JQZCkIEct43BwAA8CahEgoMXscA
AEY82/zde+/Zz0t5gL/I2enbfX8OzGMAwI/myrGpjT+ctu8MJxxR/fDUCH/l
cMPEIgAAgDdCQdzc3k27NlGQr9bq1eILdu4DABjwIvfU8C6uY6aN7NJtw1U5
bz4AgLcXza20+KETu9o3GjbFLygoKrSrl0NXtxlbd2SZfLo2AAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAABAVQEDAAAAAACoFrxpVVXFgBYDAAAAAKAaAJLGVKDF
AAAAAACoBoCkMRVoMQAAAAAAqgEgaUylirZYSQE6sR0tDkV+PVDXJtpaoNoq
5DYORe1DGc/p7+QkIofF6NUbLWdFc3QacnJCPr2Rqy3CHFBCifmXwp+jtL1E
kw71RA4Y0aTWbsg5EI1ch/ZlIdxyZbYU134k6t6DMYCYHHMuUpKFvh+KbD5B
/onohe7TPDTdibj4QBWy1bbDQvTSYqWufFTiyv6XgX6ZRRukwgWplqBrGpMv
8uQW2rUcTRuG+lOGbYsa+CDv+WjNefSUMmsNOhKChlyydOmNEW9qDToRi9xs
kOMcc6ppDjjKPo9+moOC/ehBpPUhDl7cxqlMlP6JvJyQqyvq154orVOCWVcR
aOd/E4mu6dwZebckLu5/zkKFrpRYcOKobFRRSfMGqXItVpKPds9GbW1J4dcb
jdqI4k+jS3+j+/fQ1T/QumlI6YwmnECXNyGVbeWa0SqCG7tQ/I9oyMe0Azdz
LOPozl40rBVxEccZaHM6yiKFtPofdGoz+bktcp6NktQWLXq5yTmNfv4JTelC
1t1cEXhxPv1zzA6tecp8qka7Y1H8bORIieHqbUWVs7I4urKcKJJ1LxR7Fb3I
R3PIjrZbjZ7JvkbBVRQ7iJBbWgN2iEAxu9HeKygjA/1zAx37Fc3sh+qNJaz9
1/HEd17HpC/a1C/Po1YYbY2qwxVelqJMtJRsHBs/NPM4ulJAPOiVqNH1JLrR
6nyFYq9Xrqe/siy0din6IZTsU3NFoFA7F2WgdevQgkH0n6q3CLTMxFEpqXKS
5o1TtVrsyUU0ltQqijZowin+Z1Wt55/KCIPXP6NdnGfu82k52Dm4HGNZQzwV
Ek7VEY0+y1oNYygpQBvI6yvc0epsC5TWslyMLZcITI3hE4EUOWio5ayo5Byy
Howyyn2disKilS0/BYdRc1K8hf9F/G/pZfQ5WTzFWJQp5/cl6PIG+lGxzigU
z7uUXYKu/YrcbV/7pC/Q1MUpyPl1icCcRLrizitQpvGqo7b11pBK1RZ5H+bx
CW8W7VByKIcIFG/nhzssZw8laKG1mX7p9VCuiaOyUrUkTWWgCrVY0Z8oQEka
bXMUmyX2TU0mGvHxm5jRcLTNt4qJwAvz6cfqTgdQmcB38McovBk5BXdHOwrL
V1ZLU04RWJKFlg1Ciiao53703OBvFtVFD7YgbCiIQLkcjyS71RMlU0apQXsm
IQcX4jlFem0KR9dWICVZnZoTUbro1uqdeHpd7o2LQG0dkxegNgpkH4XSKnI7
uPAs6kEqwJqh6LZQa+LoUAjZBbZo4LnKtR5YThEo3s4WFIH4AxRgrl96PYAI
BFDVaTG8AM10pYen+xFpp3TnZ2IWeN0z2mM01qoqicDnafR0YDUcpYu2ac52
elZVLkBPylNWS1NOESiGBXURjvZ9DSLQBGiTNqvFniShthj9tLgmX+rbGrTJ
v3KIwNdDMVquIhtHiWJEH6XxLDSCeuh2QwnFr6t4MiivCBTFgiLw8W7CZ4II
fM1UFUlTeagqLXZ1CbNt1xHtlZPskY8m2b1uN0utqlUZEYijnUPoVnXdI6Wr
H6NxSllzx2umSohAeu0FRKBszBeBr9AKN9ok3l8mK4Aw/wCye2tEoO5pzmqs
8DIgBfXkQn65ZYLgNsHrp0qIQLwQLVZVjF+yHCACAVRVWuwZmvMpPTZtF6Ii
eT9KDH6NbrYEXdmAXCvMNYlj3ljG7yBfJjYm6oHkt9E2P/rLjTZWohmh8ovA
gjQ09nPz17VeE9VFBLIjvuTO4/ko1OrtEIE42uxDN47jFun9FCKGgWpMX5Ra
abaEK78ILMlHv4ysML9kOUAEAqiKtBg7n0v+wM87g0KPIgPrpg6dGKaiA+Fq
q5D7HJTAjRvnpM+T0xD+HCWtQeO6k79yQE7j0QJW3tz5lah/S8Zbcv/p/Dx1
uIHu/AGtZ8DVaPcs5N6EOPvCcwXKYEWnlBSgRO3tetK+jjjUYiAK+gElF/DX
1LyxnLebbgSZP9TJLXZwPtVWPOe0MKdh0OdyGM3m/11HP0Ygv/bMNV1Q69Eo
KhFlCZRE2wXntqFvhtA3snZDbhFobSa/CKROj2H3oPo6ih1KlKR2bxR8ko51
53zNuBGEJ2uZHfTfWRTem2lkg3/GtytBNw6hBaNpC6GuOWQLusYKVZRZL3Na
WKiyJejmfjTFF3l5EbfW/tM2+8YVyP4rk+XZ8yz0+/f6RqN6cEGKYXoXbcxG
/2ROyvp0b/nzL45Sp6A4cn1bJzDY/9jX0dmbcSdqTfTSPjR/JH2AifZfXU+k
iiKslFNFvqY28A88lSWPc9EdmEM1oMtwFH4A5cmXZ7lorCmJMPrWsEWxufSH
1FEqvOe0CHoD6momujWiyilotc6GHZDjUDTpAPqPTwTKdLCS7SwoAsmBoPM/
9NwxG23I4I6XJ2j9OHJ4yrNhbZsc/wGF+tM/oQbp7DOsQVGKfvbSHytEVBlH
NxPQ1250znt8NudqFpk4qOv0d0E+HchR3wH1WYLWhSOXHQI9VZmoEpKmUlEl
Wkw3MMv1gIaja2TCoMIdzbyICnHik5xTaPjHRGJs8J96R81Jnx+K/lGjtZ3Q
yIPoznPCFZydS37uiKIYJVSYje7eRVfW0SV0WE8cQ0H9u5FPX9bgcIOYeyi+
LRpyDP2bhjzJ4a/fcGGCdj78no6+e5GL9kwlfqhog8L/5Hl+N08E6qezAHRJ
xjxy92eeuY/TVmy3zz0Nw0AE0rGItiiIOpwNR3lX0Qwyp7vOKHTI6Cyaokw0
x5tcvpiDEnPJFihB98+gKDfUsQPPTM05PWYouvcXcndFGzLRlZVk+zM72tqv
iZ2TIKSLZHdQSSFhAzmXkD/VCP5obxZjG3dIC2TQTlibRhJXqBeO9j4irqBV
FGfIM1JsgvQNIrNeZrQwf2VxdHI6qhmEEh4zlcJR7kUy+96kNTocZWxCXRXE
aSRLrtIV1zbawe+ICtYdjxJZ5dGOpqwstKE/WcfGaOkDusWyDPN2+NFrSLPW
N7TNfvc2uneAXk5U+KId/6A81nVeFKDLa5GVK4q+iK7d1XeiJhvNJU3Ufhra
cYv+/NZ6Ou9eO9718DW11j/8JHI+iQYd+5aY2a17oegz6AHZFKU3kTfpOj5L
MHzUFYItcaUX/7mbBboiGRylwlZigt4Ame7W1GjfDKK0bJtR30W/RqIOzekd
bfatZTpYiXYWFoFXlpBF7Y72kOGR+At07Tcyw9oWucahXP2YRzkZLAPG0IRL
+unAwIbVf5KHXdgi919RJvkn7YPSOtKAndcz1yxDZ1aibSvpbG5tle/8glxj
0a1/0dpuxCf6cG4LTRx4LvqmBXJeRxeJvBC68ityV7yBTS4zqBKSplJRJVqM
/fRttgik0wCVKJx7xgR9GIVR8DM9QILQmgCODy9LR53JknywGrFzy3TeQ2Sk
6Jzw7O9R9/3EqNQtx9VaRp9rrTsNQ58aiYhZYJ07OSv5oENGs6F5InD/aKZV
5U3oeinOWhbgFMB47YWZ7wxucYWJ8LT7UT9/adJRD/JD+5WIfViL1inNJNWL
cTIjXojmtRe4tc5sgtCyXmjpY06Vgy4bFV62CDS5gwQaQY8GbQsi/XkASmGb
FI6OkUmyBsk4cuplUgsLVfbVJdQRQ31OG5Y3/wCqMcQEEUgPPeM0DaaCNkPR
GW6eppkbVSVosUO5RCCNBm34kr7OqHSjMocZxsjpTZSbjKwbFxyfILzCzK9A
cHQiivQS3FMR9ONRtiDXL/7LXCbVmS6GXPbwF9XY3fF6A9NGDavKlIWz/5Q6
S/DWchwsEt3z5f9TKVremhF1N/UfZ6yk/aGhkYi4RF3VmSMsmv3MPZegAE1r
ZlQAxrBbLEPDupNuULeo+znaW0qW0UITBxF+3xjFGx0MdGg8iMDqSZVoMQuI
QCavgSccmgk4NDgzih4gjVGj1dxByjhGgyPLTBKB1u50egtegFYHIBtPFPuX
UVFD0X3Wb2mHYzwrmTtj6tdMTBWBRp7NVBFI5c1pP3c7wPq0FK3rRH65M0os
1X+s2+BjKzfpW+vMpjGy+55OEHhyFg1uiBqEo1TjmVr+SqCpHSQlAnWtYZye
Q0e4cc8wlFMvk1pYqLJUj9svRg8MWiYbeY9Cd/jqwkMumkROdu/MQMapus+S
UUPyvm12c2TVGxaBTLYIoeumcHq57C/U8z1DNaszUQPBnLOf3Hpog5awD9g0
UQQWn0Nu5IfvfYfY23p4NppEriN12i83RldkCPPDEoEGbs1UEWjSqNFVmTe1
R+TWshysGSJQlyOjREtZXS+0ICDYCHwXjH1s+Efq8NIaU9BDfcVow373febV
Njg6vww52aBuvzPTk4UmDuJDWxR01sg496E+iXx1qWRUCUlTqagSLabfiDRX
BD6Ip58HjUcrIlNIDB4VEWsUsx/9CATmdJNEIO+EqL9DChodjvZwnYO01606
K4HaPji7Fo35xfCgWp7rPEPfNiQ/ND7MWfzWrGcHr2SxepksAk3tIHERiKNt
/oJeWmslYUpDASyrXvJbWLiyuiQLa0/kvwjF7kSJNzm72HLQDT3eTATqLDXi
kWoQSmP92eyEd13iQ3nD3YvR4va0tUex5tSL81CjH7hPhToT5SoEiud5RhvZ
JorAk9H0hxw9T4I/Rzf/NeEQvze4EohMGTW6KvMemi1HBIo7WJNFoPbK2Wj9
aDT7AvfobOGhLS4C8fvoK1uBxzGECg6QT3DMEh95e+bppiGKE854t8jEoTs/
v8HXaMJKtOYwOpdvgo29caqEpKlUVIkW0y0X8HpCOei8Cq9Co2dV7kA2VdiY
JALlpOYZYHERqF9flZf6xxsTyCmAfBEogPF1ym4iT9E5XY4IFA9/MkME8mKm
CNRJCN75gnH+7GvKrBcvJolArdbZZJSmoWiDfNZy8pjEER96+sbhzm5m5y3q
bscryUxCJ1912/F4Fhr2juHSjaSJGmKSCCxDP3kIKhZTYccEhstYyeWNCTQo
qnwRyAvPdaSqLEcEijtYM0QgP+aKQP2MxucTdLXQ/1YnAuXFb/PWSObE8eIG
GSfPHfV1AlD4yUr37hheqoSkqVRUjRZ7iqba0dbIu5THS+5uVJtZ3NMNSWs3
OsnR+J/zbMSeVCtUBEoGV2if8a8fQXGxKGwg8nVHddvrUw4tJQL1ywJ8ESDG
nJ1FF8BguwGZKwJfPEbJ29HyGWjwF6hHPdSgtz7zTncd/bRVDhEoPhmZJwJN
6CBxEchabKnrKWic/kkm1wvJa2HxyuJqtId5VTf7n+SbOHTwx8XxVZ9dJLNF
YOERehsX411ZFWCvH1+wAROdpcu4ub6C57B0SRM1xCQRyNrgtsAhNqzsYONQ
T2NepKDGAoraPBEoa9RIVVmOCBR3sGaKQBzlpaPf16C5Y1DvHqhxXdSPydQ2
VQTqd1UckIOHwKjvgOJ02/+6NpF6mrbIxEGcOTCI51iDjrurgA6sGpKmMlFV
Wkx/8gM76lWUU9P1z4PUhq8c9aXDAiIQR7d2ogzWsJHlozTozCrUqwmxD6XV
pZvT6eREi68E6t8IYLzlzfNt/Uab8cmxprZVSTb6cSLRFIo2yH8zSnpAz4YV
tBJoYRFoagfxNcKTGyjxH/K/mA1fOaJOfr3kt7BEZamrFaLLh9GvS9CsicSZ
G/JVBJIcerrG4coM808w023jcpNixHiGZrzDv6yqi6dq9AN6VYAmv8fZGqao
QiuB7PPh5TSObvHf+I1CJotA+aPGEiuBFheBOSfR5B7E53W+QjOPowwqn92U
lUC8AO08h6i3btIbvjJEHVMxGSLQ0hOH+g5K2oVWz0LThjBa1xnFV6Z3x/BS
VSRN5aGqtBiejcYza9S+KTL2UkmPHc4EA99eT/9W/kKiBUSg0QvEpX2ULi1O
iUZzk/otLgJ1uZnaf41/kZgR9EEsfK/iMqmtdKmUVgPRH2qp6+gWgcsRE2hJ
EWhGB/E1wsV5zNdYU57MlSvJepnWwsKVfZKKhh8yNIySJ2hnOPFNgxhaIXRD
j1d16BUU9+GuPMfYPtzNHEzkhuJlvOq64DB6ryc6w/doqX9Qao4WzkbvTTZc
Aydg7VPI2qA3MSbwODNIzYghMYY+DEH7dNCXv8p6WNGqxm/qNE0EmjhqdFU2
OybQsiIw9zh9QovjStZpMMg0Eagtm/Vg+mv/v70zD2vi+uL+hAcLPo34Rl99
pT8ElKJIXcENxQJFFrUIKlGLuFM3RAVckGpxx624VFwq2ipWBbUoblAVN6RW
oFakLhQFCihYsBIVNZGZN7MlM1nITEAJeD5P/6hhcufek7n3fufec85VPvaa
fAI1oFME1t/E8dtyLLZA9cqnf2ELiGNbNUbnGRSNRdIYDo3IYoqeiPTBYkp0
XHxjFWYejT2mO0PN35gfmY2T7X+uQCq/YCXGPA+tQUSgYnBQd2yufxEoHznK
sNBOlEmprQcUyz+OzRqMCTpgjsuUPsaKldiBpzSEImqzlfL4BoatFKpAPa5B
YzmXF9emkd6zCNTnB6pdBBLrLeTOS6cDmsM88xOwqVd4tIuvhbU1Fm+RB5ai
9tZEuopxfJ9SdD11LwKMsSSi8hpSp7MMFBMigrWcj92utZZoFRZtjo2+rlVf
MbNPa1PpCl96jccvvszG+q7BHiv+zTc6mO5Emg96e4nF9uWkdSlQ7Oxs6i7e
aVRtn+dhG6dgDgKs7UQsio59UIToqqdmwmp52hmnO6mv53PsNZKLlFLV+Iy9
bxGoeE1TD8rQVwTKy6Q2VoQa1pZxpNhRPyxe4XmgSwTW48RxbCzWTiUhBgG5
LMzdxaKhaESSxkBoXBYrPY+NIdYDBS5Y6BXVswYoJNiZ5ZhoLJbGfo7vxRHr
A0JNA74UOzhSS5IKziJQcayJYsUDLcHGtcASGQO9bhFI5xxg5QfAlKnk6lcE
YkTCUtIN2DQIS3uOvfwds56DXasi0gL/hvlaYdtKsNIUSn4rU5iyUUyULFvJ
p5t5mI1Q1VaKLTaV13xZATZJ08aotBibRyhV0XKlqid5fgsbo30v9Z2IQD1+
oNfYevIQEMViF4od8WHMMnT8hWAwlqA2m0vzsAARFs1469HZLr4W1tZYcvpQ
dwQi8w1y3A6Wc5vOZR1RoFIQZTT1JGZ1PdBKil1aRa0HtpmJHSjWrPHk4meN
B9Z1j1rWRGZJdzBfUsSqbYkqULxMyRtyXCURNzG2sF6d+OcJpGSbEE8PolKF
ov2YMETXKcAqtZVgcaR5bbHwOxj6ElttjUXn4ZV5VYbtcMe8U7HqEmwpsZjM
zFXORDHcqTzt5aewflZqIpBvr5FhyaQXgdparrzy2/21dLR3JAIViZXUNiMK
47Xu6iqGRIWnzaPDWIu1yjNPFfEX7aJVhzWMSK0pmoLdZuSg1iEC62/iwD9k
Z6QkwUcV2A5uijQ6i0nLsETaU73lGGxmHBZ/Fct+iD18iOVewg6uw4a1xJy2
aYpeJI4tcBXiQ5/vz1hGBXUuw9/p2DIPlrxhnVlAp3zH/SuIbPCqB0CU0iO5
orv1wdYW4CWfXYB1phOByv+Zn4v9c5JytKZOFclXS7ghxY9eEhIDvtcR6oQv
yUPsl0XYmFRsHaElTAOw1aexI7fwqVnD8QrqZXIw6b45xHkEntjK2ZgojBCB
xOEI1zZgRlZ4nVt+pVwi0FDCXWws4Somn0/LiTq/KseSI7ARZ7F15Nhlh40/
hiX8jrvESOn5ReCGrf6LsJ4MK/wdWzIQSz1Ozywrsbjz2EV6HVKZWv8n6hg1
WRWWfQRzs8RG9KJ+Joe1+FdID8zqf7GiIuzsYtYveEct0YG69ahr2D/0R0uw
mw/oP/H8gUiobMkI5paEvUCxwmTMfBgrL7R8ajs4Ey/W1B+LSqeOhHhVgV0/
gPmIlMfZcGwXPwtrbyw1IRJmzyLnYuLkkRgx1jIYy+IcICw3WnoMdVhPBH3g
BX76w1y8yS2nYgmMeFuNJ4aot5EL5Tdo/3YhZr8Yi0rCTtzESyv6G7uWhG0J
w1r2xGZd0e3rnjJbs2BgojjURv7rb/uDGC7ktsrF9k7BOq3G8sjaaze1/Hlm
njrkdZLdkenjM+RjV+AZyiFNLtgu7cIs3bD9aonmdCPFbuwm/MdsML8IbJCI
EoHyYarkCjbYCOtgSXiTxqumGGKWsG8UoY0nYheI+uCHaCRhAxdgx1erdUn+
vYZ5hg51rCfxDK92wYYNocpvHoRtOEn51nIcYGuxs4Y/0Wd8KN6C2y7G0iqp
i7MTsYFLsTOrKTk9OgFLOIXl0+ZS5IJuOR/LqsaqC7AIc9VzCuTD2lxCXtou
oU+ZQbHK+1jiN/giBqW9UawiHyspwpZaMyYd9QN06m/iIJUh2VXJwRz/Zc9g
XzXHBhyDwJAmSCO1GD4AHsY2zMH8PZSHyTpMwqZux1LLapsvqouxoxuxYH/q
W2auxAGmbHmj8fRS/K2WEcmo/I/5aibBUumjG+X18f5BOYRqPJNU80IH+wxZ
gQPWL5w6frQ0HVszWRnL/K/Gquq7eCKflM9sxxZNpE/7JZrQX4wNaaG6HyT5
HdteoPp1+SSoPKlWiFkG4aJRSr/AylvRxRGfiMm8FConZpoNxobHYhkSIrtd
HDZtiIaQWNWvDMPE2/CvKF5mySC72Cf4xawDXun/1Bde1K1HXaPph1Z+nfMP
pHQQQ7H8U/TBozaYfRh+EJsqxEmp3y+iD4cVYhY+2PDv8FPkFHBsFz8La29s
+S+YVRR2Jx9LWIEFKH7ZSdisQ9q1gXae3sMOrsG+9qGrRHS96POqZxlr7H0c
s/RogIjoPLaZ9WDjR/rOwY9Rzud2FF1pAmbkg6XparJch/x2EIuaRMVj4ocj
z2CfA6vd1Mw0zpo7ssrjQRykO3Uf62hpvsiVTOYJ1iiK9yMvbJyH2lEdEmxl
kppLJ2O4I5+x0YRopJ5SIR6NruiS+vQata+4EAcxl9K2IqPpyQzGHAfYWuys
4U8M5c86dJ7oBfOIU5tlJdj+ZZiPejwve0hsMxILz9CgoFSeGXkb7QPY/YuZ
/1xTxRg/Z/1MHMcDMN9T2MPfsfUzqaeCLGqt9kUAg6KRSpoGBCwG1AYdFNx1
B3VshPztcmOfRuAeDAD1A4od9NIQGdGEIb2/TAOx44R7mVwrpq/HWnKLAwKA
hgUkDV/AYkDtKKIMlP/VOQ0vABgoL7G4kfju3qxb9AfXMZFI9WDxpo0ydpXx
n35Z+gHgPQOShi9gMaB23mRjA9jTQS0e8gDQqFEePktuQFdj2wZqjohvyrzB
tjipvvdFqUUKAIABApKGL2AxQAcolhzEmA6EjSBLAADoSRW2tBO+Ehh6B3c8
TpiFdduhOSK+aaPMtUj8Z7m1tgBqADAcQNLwBSwG6ERWgR0Ix9OImQzEghrJ
CZIAoB/4mVkT8PVAs2HYrNO48/+HiAz740dsZDc8XsAphsdR0QDQsICk4QtY
DAAAAACAJgBIGr6AxQAAAAAAaAKApOELWAwAAAAAgCYASBq+gMUAAAAAAGgC
gKThC1gMAAAAAIAmAEgaviAAAAAAAABNgoZWVY0MsBgAcAF6CgAAgIEDAzVf
wGIAwAXoKQAAAAYODNR8AYsBABegpwAAABg4MFDzhZvFqv/7a/vu8L7DuhnL
rxc4+PQMWr/8WvFLtOT2Fs/x15+TF729Feplb+/s3Nm7m7HJuszX77TeDQ5a
XpC2/LsZTv3t7Yd9ZmEVtGV3SRNvMYu3KXvlP7a9/UjPNjbI9KhSWUNXiC9v
/k3xl9ffw6Ojk0lr+8R/dH4BxhYAAAADBwZqvnCwmKQ0xcfVyMvrYGZ2FXF6
kKy89I9tOyba9B9qZYu4imkRiFYXl/xz8mCQUF5mExeBaH5GlIUQsbXdmlku
u3c+VCRvstGclMKGrheb7ET7gHclz9CqioI/78b3Ncf9cBujCERlVQ9KCnau
HyR/r7FpzCLw9aPDTlzqDwAA0OQx1IHacNFpMbQ4apKRkWjtjacqf5Ddv7bK
SsgQgQRPMqPbNHkRWPN3qJ9c6povjn1Wg4vk81MCuk0Yf77YsA7VfRG3pNnX
71Seya6LbRqrCCTJPjrOpJGLwMLLi9qBCAQAAMAMd6A2XHRZ7FVpgqNQ2yxZ
uW1B8/4foAikxI/NhkTD1T5vKlM97d6xPAMR2PDI++D/NQURCAAAgBnsQG3A
6LIYJeqMZ5y8h6r/Nf98sA2IQMOj+mlW8KRPBe9anoEIbFBQWeXR3eNacKw/
AABAk8fwBmpDh9tKoJz2bWbujbtdVFxdw/irVHIrKbWCKQCUIlCGlt5NmBo+
vq/Yo61ZjwCvLVdzpUwdWV15c+2a8f28vLo5OnbxaNvWclLUrEPZecxrnsQu
piNNkAmJt+/v2btk6KSRDn5927b1nj489teLlVLV+qKVJddWrJ/W1cJikItL
Jxsbf68tqRou0wbx9bVBPW1s+spr5WDTlwyBeaaolCxxg41qakpOildWePfk
vMUB9p9ZOHRxdLS37+8wZf3yG2WMHWRZdXFiwoovfCw+s3F3w28dsiM2t4Iu
ufL2D87yKo3oZ4rgW/ASWcWZIwu9Avy7DbETtRkZGXy55BVttGWuZkLVOip0
gko5zyS3loT72bm07Gwz/3CK5C1pBXnhvywf7Pd5z/729r5u5m2cg4Z/98uJ
x6qt5C8C8QijXYvcxsl/QQ+xg/OU0fFZ+C/+8uh37aZQhWgOOblzblFP+Yc+
wywcBC6M9w6uVSUkU9rZ70eHDLWyGDTM3ifAdXL08huXD9azCMTvkhLrN8XT
2uIzT7wZ8kqtPHK8jFGf2h9RovkeHh1dOgiItwxp5Z+rl051njCsYw+z/vah
cfHU73zn/DcdHdV+ZmTCsVxWdWq7FxnJRdgZf4alkjMHZvceNbBVy2FLIm/9
RzzyqLQs6dCSL73DlswL9J821dtz2vLNofZOSaUcTAEAAPC+ARHIF90Wq9y2
qJNAOcsIHS1Gh/iu/GHjub/yWYKQhBaBa89cXTp82m+PiRnrTsrsFghibbXr
r2rFheUb530qQGxnRxUQ86PswR+bu4gQUcv5Z28rdKDsSVnRxfNRFvh9rXtY
zNh7oPgl/je0ojD5SzchInCJWP33S+XN0ZLbO3raIr267sgqkqH4FFayZemg
ZoLBMQlVb3XbAr1/Y303W+TzAftvEV/Hldu9Q1/0QXrZb8ksZohTvuIHlZzc
N6W1QDDE68idYrzkmpfXxzjJCxDNjComZ2S5nJ4zsaORaWDc8QriE+nNc4v+
JxD4jr5eSVblVUVu/o050/FIDFf/06dXun+fQEqLiph58g+FAbPuvuBQQ1Y5
o+J3Dg06+feLlD3uxghibv7DXfxq9PbZ4JYI0qt74kPiy9VPM6eNESFInyUx
JSy3R352QEty97m4yn81t6jovCrid3ycf3R4t/AjqZtshYpCNIecvJKU5hal
jXbDP2S4oXKtqty84dN7GMtvvfqvSsJqqOzpueMLOnxqKag/Eah+l9LMNZ/g
QUOTjuWglBF0PKJoVWXhteztjnjzbdYkX57u/l0G8Wb0puKUi/xDge+eNGUH
IV9JtNRf173wSK77P++ZSkRyRR86NDQypqDi3k7iJ/Xcc7FGLiH3Lmvb0yu1
lJaw8hI2LrBrDguPAAAYJiAC+cLBYq/+/W3q+E8ZOpBG4LIggloxUEBvH3tO
CUgpo//0+lGCg2JmIanJmeqsMqG/iFvaXv6Js9fFCkaB9HfbR8W9YNwKvXc+
vBXCmhNJLzgE8diZolxOfF2W5CRCrK1/uq9LplQ/ShpoK5+vp5+8z2wSeiv5
648RxLF30j8KyctTBBbdWGUpn2iN56YUUCXLJBeH4lUVBob+TUywlNIeOTVH
KeSwsugZIkTgt++a8sbkpG/7P4/12ysUspbc06QlHJcaUuW0N+u/IlZeDppx
SIwviHU68AC/1dszOwYasVc4Cy9HyqWVsPk3lx8zi+Fhh5rqrAkeuNzwFl9/
xvj88Z8brBC1QjSXXBo1QeWZ4VjVl0c3uzZDkAFuv5azHtdX8austYsoNrp7
iuTn9YPkd+k14PRj+i4PLy9ujT+l1I/I9RGlmm/u0WltmjLknGq+eNZdWt/W
JgI53ovqsEa9fH3wDvuiKL67/FcSjD2UhdZU/epujowLzWcuq1bd32EPIhAA
AMMERCBfuFmM2qkMwPcQ2djOjMhjrMXRcwrSY0Pia+XUQwk5phOd9PfTC/s5
zD2eodyqJcWMsMWmP98oC9T0XZyaFxeH4JoR8RBfryI+uLTf5yO1r2NoUcQY
tv7UDCUn2lv9+Df7wucP9uJzKeK8I4WWXfxEIKHlEMTO4XiJ8kPZwz+Pro4+
k/cEN5Lkwd4uuD7qteUEc8ESvX7I/yNNk75QuC6T4YhJ2o21K81NBCLNllwh
BTcqyU5OfvCE+sWeFZ0Y7ewQEa1cZaV/BXYNediB0tIafoiau7M89RaBnKpK
Kh8EEYXHVLAXhGtfSWOjq6fQdxGGRJcr7oLKKlJ/WR635z6x8sn5EaWbTz/b
2ppfS/253ovusIqXLLT8QfLVbNwxQFp5apAIEZr6r1h0IuPigwpy9VZadu1S
WRN2+AUAoBEDIpAvPC0me1Xx51+Xth+MmbRY3Ir0SGIvndFzCss3SZuQU0GD
mKnlu9R0plgBK4+eLtQ0IZITJZXORSt0aerzKV0BxpIIrxUwWqyq5NJhknMy
qLma0TDamI6uqf+y2qJaSb1FoLXtgQJUw5/V0fwr8LDDs9iFxP7uRyt/k6j8
idI2+olALlUl1wY1PX71KQK130UB50eUa/NrqT/Xe9EddszhbLVHAa3cuxJf
26Sx8XRYuJvhpwoAAGBYgAjki871jad/pWRUaprVCKc1fJ5h6Ss+IhCtLLm+
Y390wMyhfV28vd2CRwT2Utna0/5dTDEnUtfT86bIbOwiMYMli52GiVTWZzRA
f70WEaicfPmIQA1fV7s3HWziOMErLExR8+Dg4bM9TVhLiPUsAmsRP7Lq4pOn
dwevnDbAcfxE1yFfR4o1KBwedmD/WJr+pLcI1FlVyj7vWARqv4tqo3Q/onUX
gZzvpbHDKoupfrjj+68tWbFQwmG+V59we3cAAAB4r4AI5Isuiz25sbKT18VK
zX+kQhKY+oqjCERlJTvXjxAiQg+n7xVBvvqtBFIbuLSToZ7pMuhNyXpfCZQR
jlW1ikDasU3LRMwsTF8RWJN7NfpqrqpvoRZbSf+8tMrOFmnfZsZOetnHUFcC
OVU1/0K42bsXgdrvQsP9EdVXBL4ouRSbWPyGz71qF4HUbV79eyP7QlzSjmnf
DCeW/3U6VwAAADQEIAL5olMEZq5p+/GKDM0qkJyDGM5yXEUg5bDEjhfmJwIV
26zDAv8g5sSq3Uvx2ApR6225nDPCMHidsL6bxq8/zd1KRC4wvBx5+QSiJVGT
hIgmb0MMrS55gJ/ER4UPsC2pCb1FoCxxrdlapQFrEz+UgyIrCrXuIpCKPUEQ
3/0ZKqtInEUgLfsVKohjVek0R+/WJ1CRTEklkgK/TXV54RMZyv0R1VcEPrmx
3J76K9d71SIC35QnDfyEEW1E3DEzOVjUmDNDAgDQlAERyBfdIlA+RwiHeKf+
o3YmGirNCfJQFXLcRKDGfT3p6R1uxlpFoEp0MJV2Rmg6Lfk29XHlvZ2d1SQB
UdGqfVGffBtXVfvixdP8vd1EVFwk88ukerHttPeeopk8U6PkXYlsi2ioWOW9
7Q69k0pQuSXvBPsKVdO8EN8tyIjsqgyX5iwC6YUguoYv4ha126ZUmLWJH41S
vCJ3a4c6iUBFsKpqG6sK4x1EaoWo1h+HjrxQPjacq0oFX7sOv/ofq1LkUnY9
RQejlbu+dTRSe7WRP9ipuzrMjC6TcX9EeQZHK+pfeCmkx9QcMkaG471qEYFE
13PamPgSVf2QFfYFAABgKIAI5As3Eeg8cKCFbXhczJXcm5Wv8NFf9qjw2qIF
TqYtpx5Mq0ZVr9cpAtHs5CAzhJkVUPYga+uE9Yvxact4WvzpB8X5VVLWd5H2
bRcfTyM3jmUP/ojtaYsITYZGx5Yw5n/pzfNLO9ogtjarLmRTOQxl1cUH4sSO
Q1LURawa1NcVedUUN7KzjDp3mzGT6pcnUCgvecvV22TF0IrCkz5WI36+Ri3T
SEpTRvl0EBiN2rS7gBK7aPWf13Z90TUs5baOvHCatNCbk9u/aIYgPRwTCl5h
sqdpI+y23GKkEaxFBFKpchip9qqfZkYsWjpkHH5c8szQmwW5pZLXetiBSlsn
VOZCJPIE+ncVqYtAOqmLp296BdF46fO86JkRo8Kt8TVZx/23buPBqm84VxVP
wzjpU4HAbcU26kpZdcGuTYH/14bwam27Ji3rYdkTWW3ChsPYQuUJRGyDgq5Q
CcbR6utnwu26x9+nZCG3R5SzS+S/uVs74l1m+i+3pKhchc63iz37hm4Fp3vp
EoHyfhd5Jov6OiqrTIz1ETFfiAAAAAwHEIF80WWxipvRfbxT/5HKivLOR3+/
yG0ieRqF0NFy0uKph+mkygT0zKWA0Bh0RIACSqtI0lNj/WYMaWPa2bPL52LX
kM2b8qpQydnDYQP64+cs9O8bf48QCgoBuSLm5vbvpg0Y/nkX4oyM8PEHrt9W
z1aNVpakr9sWNsDnMwtLL9+en3sPCPuBRzwj/vWV383q19fGwaGvnY2Nm9OM
73SdGMJNAskK75wMXz7NvodZLxt3f6exweMPZLGOR8En6KO/fOdLHTbh5eM4
KmLeSTK5NKacrFn3fUUrZAUKhYDKSvbvCOnp0vJTC/FEt2+S0iRvtZSjFqwh
12an5n0zvlM/U3uLYaP6BSwIOn7/mVzCxfsHEL+NvfjArddqdtDp0IjzvPzG
yvUzGUZIuPXkqr8mJSmvf3xceF/nNl1t3N27Dgn02XS1+FUCmSHHxMnP3msv
vrDJoaoX6WALMs3RiLZtLYb5dB0yzisqMb14r7JA+2WxT2rbjOc2tlDnksz1
a2fWYyh9LkkZ6wWk9kdU/QGbcOyhIupE2bfo9ylpTvqWIYEDW7V0+cpx8pro
v56hnO+l1mFVVnrfPPnFvdPKpEsnQyNGdyc6pZfDl6GzTv8NYSEAABgm3AZq
QInBW4xjehmgsdJYDiA2+J4CAADwoQMDNV8M3mIgAps4IAIBAACAegEGar4Y
vMVABDZxQAQCAAAA9QIM1HwxeIuBCGzigAgEAAAA6gUYqPli0BbTFlQCNA00
BUFwiC5pGAy6pwAAAAAwUPMHLAYAXICeAgAAYODAQM0XsBgAcAF6CgAAgIED
AzVfwGIAwAXoKQAAAAYODNR8QQAAAAAAAJoEDa2qGhlgMQDgAvQUAAAAAwcG
ar6AxQCAC9BTAAAADBwYqPkCFgMALkBPAQAAMHBgoOYLWAwAuAA9BQAAwMCB
gZovYDEA4AL0FAAAAAMHBmq+gMUAgAvQUwAAAAwcGKj5AhYDAC5ATwEAADBw
YKDmC1gMALgAPQUAAMDAgYGaL43AYpXbFn4qIHJA2tgn/kN8dP98qIjKCznh
WK6ehQAAD2rtKaj0TrCvkJWwVOC371qNxourHyUNtEU4XgwAAABwpRFIGgOj
kVhMUpLQz5yl31BZ8fIZ5pxFoOZCAIArHHrK60cJDghi2/nAgxrp6W3tnAP/
eK7hqppL+30+QpDpUaUy7MX+5cIR47P/Q/WvFyot2RLZNggvrfbrKndFioKj
y9+yPpXe/X3Xl0O6BniFzp7v39FmypZNeVX6VkZSmuLTVnxUrT++Lk1wNPVf
FXXj8SuywmVJCct6Wq++8ZRVv8f5J8b5Wo3wDAuLHN/ZJjguvuSVnhWR1+Ty
jCBLy64eHZ1M2rWduJa+NeNukvNJ3/azdf06NNTZxfIr8ZE75SrNrs/6MHnz
NM1HNCk5T+Vj3bfT3Sh+SO/e+MHbzcLbZc6sIHsf31/uP2FaQJqT/t3AzywG
jfRsY2Li5rgs8XjZa9USJFdOr3a0Gj4veM6XE21cXL9Pz5XW4UHGnpdnLFjw
uZXtjMURU7p3jTxxTUI/q+j1n52tvQ7eyJa8rbUEsuY3zy3o2LWug7xU8tfa
VaPs7IMWRU6zs/RbHf3XM9W26Wy+3IZbhsg7l+88z/Ht2tnM35+obkOgvmkk
ksaAaCwWk10X26joN1niBhteIlBTIQDADa4i0NrGpM/mE29eF8X3bBXN1jk4
6Jvs8QPwxT9CBJZGjTNZl6hDvmlD+vzhL2d3j5rYw5gqrRbQgoxl5qqXoXcu
Bg/0u6BQG9Lnf6+Y225S6B1N2rW2wssLrmzd/233PkKN/ZHUxkyEpoE/nmVN
6E/z43s39952nPpQUvqLy8d9Vu4u18M0r55c8O8WmnKbnJEll5IX/k8gGDIk
7bFiqRWt3LvSsYXt1puk8EOrfl7bs1W3A/er30l9WKBV+1b3M1Kzks7b6W4U
v2pITv40sV27xalUgWjepdl9A7Or6D/fuRjSd0jKP8SDIX2eF71kUDOB2ypW
86WXDo5tbbkxixLPsszkmW3afnMhTz8ZiJbc3t1P5BC1jXoY5VJ5ROf1WVT3
IYd6zfRwOlVGNyrrtxML14xtJazrIP/m6VX/QcaBQbdI4Set+i3g8+bTI/Je
Ki/R2XyWDeXXp+0TmwrcVmyrn1cJQCuNRdIYDo3FYiACgYaFqwgct/Rbd4vh
V//DyqKDhEvjqlRm6eKMqLYff7M8wiSobiLw2b2f3LoGhI5buyt2hpkuEYjP
Yh5ChH0ZLkfbhJ5/xG5CWZJTs+mn7nOfyt+mxfv1cJq2YmX8lJD2mkVgaYKj
SZdO5DQucBjruUV1zQQtjppk1H3A6cfKT6Wnt7t8JFqrrqJ1UbktuHPs2WqU
+cmiTgLEbklsBSGx0Hvnw1shThsTXyquwVtt1HFedIm0/uvDovDGGiuhmhOL
7tvpbBQv0PyMKAvjsfHpVHOllamDbRFR6225xAdvKlO/7Lzlz2fKL8g/8bRD
hM0XnC+kPqkuPdzbqPX8mArl4yTNCfJAvMXXGd/jCim6JocqVBbpveO8I4Vs
HN5NnGzc3e0ZODp28e3b3PTrY1nEs/T2TsSorgFeS2OPxPRpX8dBXn73Dsas
3xq9dTJIaDot+Tb1C+hsfs3LdL8W4xIyZYqfTFb1q7u53IbfXH6sf80A3TQW
SWM4NBaLgQgEGhauInDC4ewkp4/mpJSi+efnmjseL2HJnYqYucbegdfPrqur
CFTwJDO6jQ4RWJ28qc/C7xa2Zl+G19Z4bkoBW+/J+4iJflXS2h9fPzrsVGun
q7q/U/7NyRFFUsaHpb8ta42YL459xmutS1p5yrV15Ln7LJFJFEUvGaElUZOE
iPGCC0z1i+aH+iI2nQ48qKnn+jCpqb41q0/UskhVK+m8ne5G8arGy+tjnBBX
/D1F8Ul20DDTIb5XyQ3hu2cn2ninslesXsWvskYQUXgMqTlrzu9xN0bGHM5G
Va9RMSwnXh5e39v44xUZlcpPkmI9zNouu1pElC/LnmC14eYLlW9VJ2/pHBJd
rLqwVudB/pX8nUWIOLqm/sv48PmDvXIVPCWi8A3+L93Nf5q71QpB2rf7Lkuh
JImKIYjNhrr1d0AHjUXSGA6NxWKGJQKl+TlHDxx5IKmLBwzQuOAsAo+VVO3+
Rjg7ukz6Mt1POPJglvIpIVacBu+59SbxPYrAyrtbXf3SC9Que/MkqZ9AMMQ7
9R/GPPqiKL7Hx/otVugtAtGsY4GmSPuouBfM/kRMu4iH+HqV1i9qgLSGynoL
uR8tbLHpzzcY+uLikPYIYrIuk+WeJRfnIsRoTkphPdeHgTR1e49V8RVJqlbS
fTudjeIDeiv564/VbseA2nt19rpYwfg0++g4EwTxDvwD12KkkG625ArzCgy9
st+nGdJjQ+JrXuMi3ilEiJPXxUotF8iqzn41Iv0/9oeFN5b1dv/1kboir/Mg
X3g5UoQgruLrTKcIuQ4fJGK/R9TafDL4qxfTx4ASgb22nOC/dgtwp7FIGsOh
VouR2wQkXy/KOL1poqPTtIVLpnRo4xkZnqHiliwpvTx9fCexV+jsBcP/Zxmy
h+HY/OzeTlsqdHLC0YKSbRGOgyZ7mpoGxqdRGxyotOTHTQFdHYMXLwvp2nZg
aPBlVc8JriKQcNa1dJk+LczzK0t3t92/5zFenzWND6isZP/O6XY2EyPnaPbv
VV5A1C18w94pYwYu/3GHp5tgypZjE72phk2PKsj/daHT5DH/M+o4TelVJc1J
3+jcaVTY/PnuI9q6swtXxjjLp6Tq4l2rBw6WW2/RyDaisZt3l7zGpH9eXOk2
YNrCZXPtRaLAwAtqL73Ae4S7CMzFnmau6tDpwAP0TdKmVt5Tc+g1DDTjoJ8Z
/rnsvYlAVJq3oM/cC0XoM/XL0JLVM/GQeTvLRcfScG80VFocPavVrKgCvR40
vUUg+UXVFRJS5PCdzcnJ19pyK3M3s7roQDdSL0lpB0VVEUjWgZyg67M+Cp7m
73IfevEJqm4l3bfT0Sh+IpCQu7W9O6PZyUFmiHDM1BwJ48Prh/w/UohAUs+o
2pASirrcU1W5mxIs5PmtN5VXvuq+IuOxJrFZZxFItkJFBJLFUtbWq/ny16vu
QvbaIPAuABHIF90Wk/5+LEjI9uXGwwBdjbwYawg1L7Omdg+l3YwJ1xcj1/X7
K5XvPKjk4IZBxsjIeWOcNx+XPDgZ1FwxpGAvj67rvoT2mMX9l74wUuxNUHAR
gagkOW5sq7aRv5LVQKv2rbT/2Hbn7WdaC6mpvrNosmj46KuPaPfdO9dWdRJN
OXJNsTNTnRzrIaSH31flp9w6CYhNgeq0Q9MSL8pFLFqUudoSQfxc/MQTsv4t
T+onVI7Mj/5YPVDhG4xW/bz+8+aKPQ7yMzLG+aPgqBne+9KeE+aSnt7hZmw0
ccsP00fMv0N6Jlfkbu2AiGZGFTM3jID3Ch8RiDsItWsXmyJ9lb+nKx0egn/4
hdGc6DIZ9t5EoDQ9vs9Cwm1M42XyjjzKpwOeOknQe8aijT7duq2M0Ts6uBYR
mNCv46q9sTP64a+QYU4DLKcFMd/yyqOnC7WpIIWjWl0g13bIpS3SNUttBie3
O8nt1/qvDyor+KbP1F/xZUZ1K+l5O2ajePD2j8BeCPLRyrQHl2dOdJwonu0z
ra9d7zVnrtUeePsibml7+evCMsLHFV9DFmpVQb5Tc15qKUVjhY5v7ilArFft
/jsxJqCfa8j8iKndbMdsrO05rNw2p8P6hCrNFa6zCMy/EG6mJgLRV+m+8geE
2O2V8W8+Ki3ZuLCHsVo8FFD/gAjkCweLkdPHuNB85iN/J2V2C4YswTuOoHfo
t39Tzz++YC5owR7ByD7Si/B/lkpyYyO3XSOWxfBh+f8JBvY+nEetnJP7Iwqv
YAIOIvDRzY3WghZz8UmWAn/5ErRQaifVQqqTtw81+XjJ5UfM4ebF/pVWJla7
/iIqQ+4CiGfdpaesZ7ELWhux20WtLZDuVagk7UjkjwnFr6mLjY1bBiXSkpL0
NmGPEmQrhIGhfyvMS3r7WFv/dJ9uCTkE6eH/A9QbfEQgvuj386AO4uvP0OKo
8VR4SGnm6v9RO3rvSQRWlx770v1USU1tl0klWZOHU6vZdpaLDmvIBMKR2kSg
g9GozftKyJLlb14ho409lZGtpVETNPhKaVmy04OKmHnmiMBnJxlYgRZGfKXu
E1gUMYYRsl3P9UGzfxkUGkOOS+pW0u927EZxhtJvxr6Bg9ZmUpGtaO75sLaM
fRkN36o45WKuXIrUVjfNa2g6IDWw+RDbr3fSwdGvylO97U2DtESpl2autFV1
tWVQZxFILtmp+ASS667kDyfj3HxU+nD7qvHib0N6DjRpZ7sxI69OKXQAToAI
5AtnEagyfZAv1KJWm0h/XUKACfyUSQaIsU4w/SQjHRbZR1T8nzF8UsiaMFjw
CWOdnLijMISZ00y3CKzavbSTQMVZtyZnqjNi53C8RFMhMsnFoXYalBWxPUG9
86q1XcNMRw6J1rYHClR7+Mujm12bCQZvPU7HIRIVUNZHWaDnnotK7xbypgzl
CSEtBgA/ESgXYAl9hN9c/g+7c3b6J/iLT9Xub5q7U8GD70UEomUxXw36hY5n
1HiZVHIrXNwpPCI9M/2HQa6EFBS4LVmdp+qDzwmtIrCm+t6RI8XMCZNYbOm6
Jp7sF+9UBJK5cWxnKvN7oLfPBrdEBmw98UbRX/FgT9G7EoGvypN9B/1SRPXv
ehGB6o3iCp2uh+0TSMTFWNNvvmp3q9q3qrex6YTD9MtsvYpAsvkqPoGEf53A
d0+ammqSv1VNbBYWoz0muh6GyvKNc9sb01MbedfMo+Ob8xeBiq8/zj87dYqZ
me2qtNugA98xIAL5oq8IpN+dffdnaHyoNcwIRB/hFBul4Y46RSC9zfGbhFkS
PsIo3WbYhZALbup9lry78/Crz+jAPVURyF5GIIdETkMfN89Gbs0H3i88RSC+
VjPnoxAyPKRF4KHMY05GX+xMIaeA9yAC0XupQ0YyvPvUL8NX5L5sFRFDu2E8
z9sUg+dYQ4jXlreSzCXjxbUy/qcTEoZjPo9ALTLqgV5seYfbwZLSU572ppOD
bzHTcRPpta3bDEgqJJNXy0pigicMCGpPR7/Wb30qYmc4J2Qppv562A7W2CiO
UPqNCoFRQO6GszdfKKTZZ0Pbsvcx63U7mBSBirhj+lNicFYvSvJgbxfBmEPZ
2lteH0Ml7u/U5+MwOvRYUnpidHCgXXvKbnpsB2O4m1P6KCekPdsdCKh/QATy
RW8RqOEFVpKe+v3o2aM6WHwmDpjXb5iq+3GtIlD+rnQqfPnUHp9Z9O85JXi2
p6qHrS75RA9uQ+aMmjKFPVfNDrlMbTyxC9H24ka2l7yMOA5M0F/xlkq8Mg9w
+5V5vEDtIlA+t+7ctcht9GcWluKQJV9biEAENk54i0CsOONbq26JRXh4SPtW
Pbu3oDOQvAcR+OZpmrhP3L3qWi5DMw4Nb6W6rSa9+/sGO5F+jgc8RCBb4byT
QAyMWOecM1Y0SZNYwiPRtk60sZkY+U2os8OUn7Oe7FWqoHqsD5p3aZJ7aJ6a
+we/wBCOjeKE5qAGyiklRPVAGbTk9nYH0VhVT7b6DAzR3HzycWVvmmBUbhbV
N30NDaz7UEmez+LmFLZ4/vA+bj/lPLnqa00/sXo2n1TayDDNBwkB9QSIQL7o
vxKIyyHFSqCk9HyAv2l7pU8Rj5VA+Zv4znW+LUyGfhuZWfZKyx11iUAt/t5s
2IVoTAWguDu9PSGfK8UmgqGrY/KeSct+jh3bSi0rvnYRKP3z0iq71ibDvfdl
kd4gsBLYeOEvAvFszK2/2Het5nVRQt+ORjOUcT3vXATmJE9s1cZzhCKzrrNz
Z+9uxghiS3zoK04rxxegBOq+GXL9mLS5TzN91t80i8Dn8rbbIr26Jz5k1I+9
n0hGnqqm4CMzrZEL8nqASguiJnMXS8QrLbXCX4/1KY8OMu3HzHLsM8zCEV/3
c8U/7B8dV/mWz+14NkoT5Litms1PswisKjo8QF0BYvQ2kGohb8/sGGiEWK+O
f8WndmRmFdXmaxaBROXNzX+4W0uPeTdDJfnEUmvXHJr/vOy37Zt/V0mgQapE
HfUH6giIQL7U0SeQnCzIXBOsxLPKGeF1waFNxLaRFhFIZiQwX8DIvq68Y01B
3EoitlKnfCJzN6luc8iRFuY+ooQhuxAyP5XayyaWg0cui6gAE7Qw0mHZ5aI/
tu9e8pU4dNNaDed1ahOBVKoo5kEAygrUZCWtzCxXa4U2g4MIbHD4i0B84eIH
8wGBf/xXRqSPZvaO95osGkdtmaIiZo5RADvai75SLFLrFBzQLAIrbm78BFEV
geR2sGK9kRQ8KqFnxDuansmZ8Q3f0G5LmEd0oYVLXL6/o8VG5GimyJ9c7/Vh
QG6gsKzE8XZ8G6UFjYmOyeBflmeypPTsCOVBdcRFhXtGBJOOyqTgUfEFIgrh
nyxaY65s8g2d5RdN/0w6hsF3M1SyvVh1NZ8MPlLbGib7IP+sPgAfQATyhbMI
ZPdH0lHWNpQ4aIl0EWH3u2exC83JsU5yI8yLmHq0iEDSJYY1KpJB+viEJbse
6JBQhHFZQ0PzrkS2ZYtJDM8oleLbN6FQ03YwFbihemgCfqbD/1FEqci/0mJ5
Ri27D9pFICEmWbMzYxCTJUY5JOSqtwIHRKAhoo8IJHIvC6N+3ONrxTigoTYR
iEpunNmTySeKUF8RiN4+O7ONhliAym1hrcNjyvgLU80iUFaVNqL7nnusVydy
9OizMo5OIUWcm2bP2pt+eXi9Y7OWy6+VK77E2TKoJDn2i6XsQ1plVSm+zqTm
xA9NszQdtv2E4tg4NPPY+I8VB5BxrA+Glj9M2p/8mGeYiAYRyLH5tTaKR320
HXlm1y2Rjl4hIoa+mHOWHcWQn/rFNNpzjyiEzHdEQR5E4jH8qiK+Qyp5cGTP
b+pvzapoPDUPT5M16VgO69cm3x30F4EcHyG0cu+KXmZWW28qEvoRNezlmPCA
bouu5pPJGO0WsfrRi/0rPxMgrLNagPoHRCBfOItAYfOQkzlU98HPN++kPL6c
dJwTKE+WRIv/iHYNEJshHjtT3vxzyn0xEWlLTEPqmwXS1N1ffsQ4BFP6PGvm
zGEd7ZCRU3OeVSaPGEokwuKaJ/Crli3nK8Yu+bvz1jlf/KhIfaBWCO5gE9jc
Q5nwUHrz3CKL5gwvaPk7nX9z8fDYfVEUcbEpmdms/RFSBKrvE1Xe29lZyHAg
RCVHNk7p8ZVls3bbbr+p2OQ+Ke2xohWsF3PS4KxXYxCBDY7uniLLTA4WIXah
kcwUZ2XRM+TTASsWFc/K4iFcia8qvDwc3Wr4+GzF7h6ZP5xXRlnShV7Txi4L
9dh8fGVpcbsBbofu0B6u0ud529a72rHPEOEM6fKkssSE3+fOxZC+3sfuU3k/
0ZLbO3qaqsY1PLkX59D88xg6+VtV0WGn5v1X7S5XzKGcLSP/FWa1MnHyY54z
6+zc2dVsMJWVtObSfp+PENvIWFKCSu/e2Nyjef/lbH2lsz5UIn1m7D8nSBGo
aiVdt9PZKF71qU79iZlPVZK8e6yoZfDxLMWwWRwd0rw5052A3Mg2M9ukPO2C
KKRd9HVKukkzjk5pzXKVIc//FTJSRmiFaL7iJyCekOZ281erJi1nemtrg8ym
pSlXA+dHqObvUD+BwHT++SLSGqQXEG0uTs2XN+F77y92Xs5SzBTyT7Z0ESHt
1byJgHoGRCBfOIvAyTNP7VzYewR+IMiYDpbj1kX/9YzxLEtKL88Jd2vRcszC
WcHDA13nz8949LJk2yrv5ojNKN+U+zk/uY30bEOcIC/EhzLSGYYCP5LjhxAr
U/sAz7CwWWJ33x+ul77MPr+0ow1iZxl1ruTx7hVfkB5NpC/N7Ig7BZe+dRzt
akbktLBt4zmyb/w9am6TpP+6xdPNwttlzsIFE3o7UkchyEekOLVCFEGRO7bP
7m7rHxYW5ulvO8xzy7kMpsYjd6tV6UEG+7+9ExHo0dGFSLdLFDsG97ZSIM25
9r2bp6mj/dxv50/zdJ3zY2LZs9KUUV9aGZkMjY4tUW9F7r8XAvxIryHSUOID
uU+01Rx4r9TaU8h0Q0oEfvuuUasqDy8vMlemfCQViBqC/mv24y9KeKol/MfX
GKfJQvr0QkB/e3v6+aHdzMQHLqp88W3agVFd6d6HCByGdnGcST9C8gku6fCy
3r3Metm4uw2xE7WduJ7dr7mQJ3+MaZ9D+rm176/skhhxbs4WT882XW3cnV1a
drYJ27VdPRUwWnr3yGhfqxHyQSByfGeb4Lh4lirjaBnG4USqKFZBpZK/1q4Y
2dnW1dXDo2MPM2fHZSfS1FP46qgPntjKQ8OWn1bkY4XYscuIfqZEZczNXEey
fqzabselUfzqg0rOH1/e3aqlyxceHa3bDPfcwjjJ6O25uMHNNN9NZQFTXkiU
g9XwecEaz1oi9lm4xlMTzR8rsrAYNsyjbSebsD3xqmdGYaSDzacCLaqyMm55
f9rlkhpR5SJ2JmO05Ny58MqM8bftIZe+IzzamvUKGn3kTrlar9DRfDzUcV5U
4CdmPYbKe4dnFxOzYYtnnf77CSjAd0ytAzWgAQ4W47jf1BSR3jy3oIPl0jMM
Wfi8POdgyk6voSYm2tJqAU2S9zi2ZCc4rIFT5jVhaJZ5/eigF7+0eO8WQ6sP
vvLpEHWjrum+6xNDe4SAegZEIF9ABGqn5mW6XyfjCE2u4MQ5brqXa4Cmw/sb
W96e2TDoCIdEKx8eBmeZp7dX+hnSwGho9cHe5swadLiooWvBwOAeIaCeARHI
FxCB2iFF4Hx2pAkJLgIZW35A0+d9jS2oNGdGz1ieIZ8fBIZnGenpTT1/uGg4
g4Ch1QeruL1uMDvCt2ExvEcIqG9ABPKFg8U4ep43RaQ3zy+0brcomX26uuTR
lcniumXrAhod72lsQe/96i5WZhQEFBicZViZBwwAQ6sPHhsyuW9ijuGMkgb3
CAH1D4hAvtRqMdz5nBmn0HX5JUNa2X8vSO9lxU8IcbG0mrjAPzAwYo6Ll42L
05KfE4oNyc8FePe8l7FFJrkywXlfHviaqmF4lpHs/8b5wDXDERSGVh+sMH3e
l/xPN353GN4jBLwDQATyBSwGAFyAngIAAGDgwEDNF7AYAHABegoAAICBAwM1
X8BiAMAF6CkAAAAGDgzUfAGLAQAXoKcAAAAYODBQ8wUsBgBcgJ4CAABg4MBA
zRewGABwAXoKAACAgQMDNV/AYgDABegpAAAABg4M1HwBiwEAF6CnAAAAGDgw
UPMFAQAAAAAAaBI0tKpqZIDFAIAL0FMAAAAMHBio+QIWAwAuQE8BAAAwcGCg
5gtYDAC4AD0FAADAwIGBmi9gMQDgAvQUAAAAAwcGar6AxQCAC9BTAAAADBwY
qPkCFgMALkBPAQAAMHBgoOYLWAwAuAA9BQAAwMCBgZovYDEA4AL0FAAAAAMH
Bmq+gMUAgAvQUwAAAAwcGKj5AhbTh8ptCz8VELnJbewT/2no2gDvAx095e3x
zT0F3PLZewf+8eJ91RoAAOADAiQNX8BiGJqdHGSG2ARMzX7G52uSkoR+5iAC
Pxh09BRZ4joTz6nzurZ0XxJx8eFzqfyfQVGlMuJz+f+8eHJz865p5s0DF4TY
fiK+/pznzVFZyf7twb27BsxbGtKzS5vhXj/8nidF9W2KpPTy3BD3Hk7TwhYG
WLTxjAzPePxK5X6S80nf9rN1/To01NnF8ivxkTvlKndDS+8mfjXG1stlzqyZ
Azp0W34iTfJW3/oAAADUDyBp+MLNYsU3Vp7JrnnnlXnnSJJXJhXIVD58ey5u
cDMEcXJNLedVmOy62AZE4AeDThG4wQYxGr37DKmFZCoikHjo0OKbG2yEiCtf
EYiW7wjvtmRbCanUUGle+Bijdm0jf72tjw589eSCf7fQFPq7T/P3dmshGOKd
+o9CB6KVe1c6trDdepMUfmjVz2t7tup24H61skL5GVEWxorGYoWZq62bjz90
Tcq/OgAAAPUHiEC+cLLY2zPff7I2UVU8NT5qcqZ+sibzterHqLQsdc/J+094
zqggAj8oOKwEOg2/+h/jn2oiUE5FzFxjZ54isDjjW6uuB/IZi3X5F8LNEMTZ
62IFn3IIXuxf3mJqRAGjsGexC80RxG5ZXBXxmofeOx/eCnHamPhS0R9elyU5
GXWcF11Cirw3lamedoi3+Dpj5bwserpRr95J/zSBN0UAABovIAL5wsFiqDQn
6HOTdY1fBFbkbu1gsk5dBOoJiMAPCp0+gZvMZkWX01ui2kQglnPC34afT+Db
MzsGGiFCv8DsKvqjJ5nRbeT10eNhlr8HOSOIYPDW4wqNR6xhIvT6JFoSNUmI
GC+48IjxLTQ/1Bex6XTgAa7x0KxjgaaI+eLYZwzFh17Z79NMMPZQlt571AAA
AHUGRCBfdFkMlZbEbRhhithseN8iUJqfc/TAkQeSeppVJKWXx4lF+syb2gAR
+EHBb2zRKgL5Q/qs2s6MyHtJf0SKQGGLTX++4VtYyeoZHY1MJxxWbt1SIpAM
V6l5cXFIe3V5WREzV4QYzUkplP//i7il8itUB4S7KcFCRBQeUwGegQAANBgg
AvlSq8UKrq3p4+HR0aWDABE6WgzzscfxFacpfOfkymr6+E5ir9DZC4b/zzJk
T3wJY5tJGULrKr7+b+n5Ke4Dps2f7y4W2XVdl8Z2Z8L93ndOt7OZGLkspGvb
geEb9k4ZM3D5jzs83QRTIgqJiQ59nH9inJ+lh8uc0Pn+HW1m70ssI6ep++dD
RWTUpXzmqi7etXrgYHl9Fo1sIxq7eXcJcU1V/DoX+5GebeRzncBhaBdHR7wd
/aPjKt8ygjpV5FytTSMAEfhB0WAiUB0045DYhL02WIfCCiO+EirWBl8/SnDQ
sMZICsVeW07IJV5p1AREXQSSuhQCnwEAaEhABPKFg8Wyj44z0bQSWPMya2r3
0FRazhXeWGNl5Lp+fyVzKYAMoe3TLyzMe/dtwukO31z2QOy6JRYpN5Oqk2M9
hJZb/yR8jF6Vn3LrRGq/6rRD0xIvVqMYWnJ7R8/m/ZdTvvFoQcYyc6PRP16o
Jm+NyoqXzzBHPgqOmuG9L+05UQHp6R1uxkaTjuUoxCYxeWlaCVSP8+XSNBCB
HxYGIwIlpac8+yC9uu78UzViVw+k2WfD2iC2Xwff+o8oTFb1q7u5ejd5Fb/K
GqG2gEkfQtUBofS3Za0RxNE19d861wkAAEBPQATypQ4iEPdOF/QO/fZvapcK
9yYStGi9LZcZI0goJUTgt++aQvMREwq1tYQjrTw1SISIZ92ll9qexS5obcQo
p6Y6a8JgwWeOx0sUkx5aGDFW0EmpJMmVCmFg6N+KuYuYlZj7U1pFoLqc4940
EIEfCg0tAp8VngqeOX3EovHmVkYB49WSuvBDeuPs8q/mh3kGOZkajY49XKbs
E+TCoKpPYFHEGHy1fDreEHIdUtUn8Poh/48gbSYAAA0LiEC+1EEEPrq50Vog
YOxJEUpMMP1kHuMiQimZm/9wV/ltUrBNOJZL/ZvcSJqunChVL3h4eXFrBJkc
UcSQYIS3vPJe5Fc891xUzktqxfIQgdybBrPeh0JDi0AaSfq5mN6dTceMvlBc
Jx2II32et33bxNam/psoxwk56O2zwS2RAVtPvFG8clWXHu4tUohA7HX5KVdb
ZFjgH8oYZ7Q4arIIcqcDANDAgAjkSx1EoBqq4o34TF0pqV5WdX+njboIVK5F
kG571qvjXzF3v4hakU5Kmm9dFxGob9OApouhiECMcodAhMN8r/JNa6SpsKp9
q/sZCdzW0d4OqLRkS6R1mwFJhaTvhawkJnjCgKD2iHJdXXrz3CKLj0OSc0h/
CWn2qSC3WRNbIEgPp1Nlda4RAACAnoAI5EtdRaAkPfX70bNHdbD4TBwwr98w
kR4iEJXeCfYV9Pe6WEn9G89HMcDtV9rjiXREFw1zWrxEzGZ0zNU8VGOZWD2I
QD2aBjRdDEgEYuirdF9reYVY63V6Q7rziVptukkHdch14I9bJ9rYTIz8JtTZ
YcrPWU/24j6BzjtSFF6x0pz07wZaDggaN+dLf4eQiFsPM/BCfKfmvNRyFwAA
gHcOiEC+8BaBb4+vckkidkUlpecD/E3bWy46fJz0KdJzJZCKdhQMXR2T90xa
9nPs2FZtv7mQp5jcNDuis+EvAmXZ01x+KdVSSX2bBjRdGkwESu/9vvngicfs
dxfyzYjpScsJVPo4efNmlSPnqIhgtjcFG+J2Ko6CbIhRQsVREAAA4P0CIpAv
vEWgLDHKISGXSDg281OB8dyUAsV8olRKrwsObTohwacDLiIQLYx0WHa56I/t
u5d8JQ7dtPYG2+mdTE6rIQXZ80e55a+0lKlbBF4PdEgoor7NrqT+TQOaLg0k
Al8UxXcXIuxVOEwhAnmmZCFjOhARO8SJFoEK5wpVyJBhV+V5KOrI39T+n+Dj
FRmVPGoDAABQz4AI5AsHixFpYBUueS/iJg5OfYTJniT1E6pIIHLJDldKkhth
XuTEx0UEyq9psTxDorUCb56m+fRBeg04/Zi19VW5bXLfxBzu28FEwtuPVv5G
3KjmRdqYwalPFBVgVPKN/k0Dmi7vQARKJQ+O7Pmt9jhfMnZe2HzO2fvKp7/m
ZbpfV3mFuq6Jpw/+QCU3zuzJzNNxmjDRlxGngadKGAt2xRlReOppSsLh5wJb
mg7bfkJxpAiaeWz8x6ZfH8uiCn/z9Kq/k6l4arbi2Dg8csSo45yogjqHqgAA
ANQBEIF84WAxZjCgtOpq4KDDRTWUI5+g+YLzVKYXtPiPaNcAsRnisTPlzT+n
3BeTR5ESSsna9oByUU3TSmCEf3Px8Nh9URRxsSmZ2RLGqgSRJ9DUPjJGkbFZ
ejNlgk/4neesMscczlbeRk0EMsMe0YL0qT5RxdRyCFvO8WoaiMAPBX5jy4u4
JSZh+Nr12zPbWvuH5ms6pobMpq4r5zMqSY51C5p37qEiCASVHN/ub4oIhwxJ
e0xrOTJlevt232U9ra1aUsmtcLehO/Y8VBzEI31+a8YYESJwW7W7nOgpNZf2
+3yE2EbGknEi0rs3NvdQpujEkTzY20WIOLmmkknjn5f/Nj2wuYd36j8gAQEA
aFhABPKFk8Wkf15c20MkEovD3Z0mHsugpJOk9PKccLcWLccsnBU8PNB1/vyM
Ry9Ltq3ybo7YjPJN+UdaGbfii87e3YyJ4zhcbdxnR9wpuPSt42hXM3x7C7Ft
4zmyb/w9vDDyYCxVetiuYhwsgj7OPx0c/rmV7YzIiBBXB+cly/96RvwtT63M
3H8vBPgNs3DEPxKaOPnZiw9cxCc0VFa86ztxG5F4YcSYge5H86vln6lU0msd
foyIPk2DCbCJw3Vsqdq9tJNA7WGWP4kBs+6yt25fHt3s2kxtc1YTkvTUWN9J
XUVtPEf4DLPoZeRoE7Zre14VY9UPT2qkYddYA9LneTt3L3ToZdbLxt1d3nGM
eo3x3HIuQ/nOJZX8tXbFyM62rq4eHh17mDk7LjuRJmEVikrOJy3ta2v7uaNj
lyF2orYT10dTnREAAKAhARHIl4a3mPTmuQUdLJeeYUxDz8tzDqbs9BpqYmK1
66/qhqwcAFC8q55SGuUQdaOezrPOTnBY877P+AYAADAYGl7SNDYa2mK4d1Mn
4whNQYUVuVs7cFjZAID3wTvqKW9zZg06XFRPZZ3ZMOhIru7rAAAAmiYNLWka
Hw1tMVIEzo+pUF+/wEUg67w5AGg43k1Pqbi9bjDPNC/aQKU5M3rG3oGFQAAA
PlgaWtI0PhreYtKb5xdat1uUfI3ldyR5dGWyWDSJPtceABqYd9JTmBHudQS9
96u7WBHrBAAA8AHS8JKmsWEQFpPey4qfEOJiaTVxgX9gYMQcFy8bF6clPycU
15OrFADUmXfQUwrT530ZkVcvR2zIJFcmOO/LAwdaAAA+ZAxC0jQqwGIAwAXo
KQAAAAYODNR8AYsBABegpwAAABg4MFDzBSwGAFyAngIAAGDgwEDNF7AYAHAB
egoAAICBAwM1X8BiAMAF6CkAAAAGDgzUfAGLAQAXoKcAAAAYODBQ8wUsBgBc
gJ4CAABg4MBAzRewGABwAXoKAACAgQMDNV8QAAAAAACAJkFDqyoAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAADAgPj/HPJJ3g==
    "], {{0, 481.58490566037733`}, {580.754716981132, 0}}, {0, 255},
    ColorFunction->RGBColor,
    ImageResolution->{106., 106.},
    RasterInterpolation->"High"],
   BoxForm`ImageTag["Byte", ColorSpace -> "RGB", Interleaving -> True],
   Selectable->False],
  DefaultBaseStyle->"ImageGraphics",
  ImageSize->Automatic,
  ImageSizeRaw->{580.754716981132, 481.58490566037733`},
  PlotRange->{{0, 580.754716981132}, {0, 481.58490566037733`}}]], "Text",
 CellChangeTimes->{3.9547289833023987`*^9, 3.9547318536950836`*^9, 
  3.95474566857682*^9, 3.955504290685812*^9, 
  3.9575716205752983`*^9},ExpressionUUID->"27562332-302c-684c-a6e9-\
c7f5988655e4"],

Cell[CellGroupData[{

Cell[BoxData[
 GraphicsBox[
  TagBox[RasterBox[CompressedData["
1:eJztnQtcVNX2+Gf4W8onsh/10RtlpRGGXLyVaAV6a0ZNQEV8kaZoKgoKKgKi
aBZSKpWm+cC3FuIjScU3oPgWrqbkAwRUTAxQUDFnUpCZOPznnH1m5jz2OXPO
MPLQ9f187v0kHPbZr7PXWnuvtXa7MeEDg+0UCkVUC8P/DRw9XR0ZOXrGoP8z
/CNgctSEkMnjxvpOnjouZFzkh2P+n+GHww3/a99MoSD/uxYAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAKDuEJq7hbm5uUXFlTUN
XRUAACxDVBaTn2zhXQ3R0FVpPOhvlxr6JPfmbb0tO+XJ7Oomt+Y3uQoDTwml
sSMVUnBo7jmg06jYsM3HMyt0DV3pRgGh3b85qv17dh7OU39J0/5jVRk67YVZ
M/q8YPfeEO/Ei+VP0hLdmCHO7Z/yrpsc/vPjmQrDH+oObQzs+KmqpQP5RXTz
PnK3ISpfUZL5dfxoD0OtVB+5OHtHh+67etswc3RZW9+fnnAf5AsggO78kW/U
XsHTIsf49lt0Ilf3NCw3hC5v5uhub/t0bEZ+su7zkh4+Da22AHF37Rx1hwEf
tCD7xDE8vkxvk1KfzK5mrfmqfif+augKWaIxCCkAEKIq93QySdbxiPDXjOZF
n/kLjx9PZnB8z/frvvpPF2oSK5wH+my59NSrxw9uJP3Hge4v5/Ybr1mj6hFZ
WwKaG026MTFF1TavpY24l7vkDUWX8KD1P8WKk5J324riibs3MkYNa9Ez8PcH
Nq865m1FMUOV/3ph9NKFp6/k3q2iJ3J1ymJPO4XC1X1jYRX9oL7qzunszT5q
5fMvLjpnrllNxroezWwnqeXUXHvw19D27Wdt33WrElWbqDyfuaBb5+XHTq/p
9Ny43Zcfy1dZpbl254nasawThF7TBHcOicKs2Nefm5pRXpN3LPZN5yahO9mO
mvzQXgqFXcge3gfSNEfTJtxPmOakUPRad8TK1uOXBeGubspYv+Y30ARrOCEl
GRArTzf65PnORotj5PZczBM67YXJo95SUk+8577u0v16r2NjglLCaRxfWpaL
O/i5fSa+VfPvzjwSKuOf/Su62hkL8Q+6+PAx1rdOFB6KainlIKzF1Iwb0kvV
3y67mnF8c2hswItoByng1N+Prw1GDKbiO/YjtmSyB8xghnzmgLP7ajLWeLX0
2FliXho1a75sr1T2T8ysXzFCaHevHviK+8rzXGNfl76m77MKRdu2P19mSxed
Nnd+8NeHcuq0m32vMKmzi8Kjc8qfT6VaxoHQXYkZ9aZdi+DdOXWXlURp3uZJ
kw4WV1l+tK5vqr44tpfy3+Q0frjtR9UzSvWcNeWNVhWxOY/KUjwdMftCNh3N
JgZRnT3CS+Hw3NdZFdb8udCyINTVMiunzdgavHBtsaDkrG/K4sc7KpRDt5yV
N08e8wQTWUAaSEhJBsTKY8ImQr9esGxxGLibu6SdUcseG3O90SwIDQChuz4n
/B3yBFnZOeKrq1hj4eKesfZiFket5sZ2FXVy5PTC2OTMRuutRhzf4PeMRXtD
qf56WYkk7Ul/KsA415xafuTlQZ8V1YvFQWRtfPvtwGwN+6dIUCoUXkt2VXM+
1cKDwW6Bv5sqVkdJbS3kHnUbO7/1hzErifba+g4Oij6MSqI/oU7Q6rrNdSd3
hVtL1Rfx+Bn+tGFQ3UO9W3p333G1su5lUUZuvewG3z6/oI3Rmn4Kd/WLs2Jb
KfgfiE1Hs6mBVjx31l6KDISWBaGulgXyH7C6bjan5uHJ/u4KR9ZJtyQe7wQT
XkAaSEjJAMTK48E2Qr9ekGRx1Dw44mv0vXJyWp3f6Fv1WDHI7nOntv2WrREw
FaiNEVGLw0CVtjB926nr5TYN37MxVUlz2lqyN1xCIvKkShmiImtf8oG0SzcK
DV1nnnj1YXEYVmlV29U8vR0JStwSXZOx+pVAxsEHUu/rWRoSurwwf7RHjfmt
XnOgR7N2sWs1bDXSyn05oH6wzW6wJJCLxRPjWi8X5DD51DYfD7Xi2dyV1yZd
TVzYPe65xuRmTBnsjc4RUWQBaRAhBTQCmpDQl2RxMHenFcqQPVfqtYpNCuJ6
1mwnQy9ZsjiaAmR6gX4Bh0txXpc67dnRfe28fQ/fslJxqleL41H5DpUrf4mu
ObrB71kFdomuTlnQ5huzAG0YaYg2/QJC87FHSKTF8WwwZ6dLrz3S21XR9o1V
l56+/dsmwR/HZrykcBgWmv/4Y5coMfSkudZL5ylvPhZkGmCOdOuGTboaeQT5
r8Od5zYEaM1vdPvGwgtIozPZgPqhSQl9+RaHyGNPOUTlmaPfdXShOukJsDgM
g968y/I0TDouQlccP8nepePGy9bP8Pq0OIgLKV3HxJfwzqQoQYlfosviB7lu
NO8YPNjwzb+VtpfUFkBxNEK+CgZ7pMvbXDMK7cvV0b0BeGw8JpUPA3KxsMIn
5MkASeF6OUtqOlDZM5S29rqxSVc3vumKLKDGtm8ssoA0jJACGpwmJfQlWRxE
1Ul/o38NI1z6dsIMKonoJ5+8+XE7pUHH1tX+XZ41c/YIJ2eFS6uBM8OOcf37
icqc7N0x88Z0onP0OXi08Qvu98O2pIIKtn6u++v4aD9jktKBvVq1/PaMrvLC
/zZPih1F/a2zytl7jOEPN17TCn9d+sriPamrAicOdjZUjzyd6dTbbdjMUHym
X0J3a9e2BQHjfN3pBKSdBqvj1v2yenD/Nj/uorXu+wU/q92MTfZs/pJb8p/0
X/+TuXOiG3oLBuf5yaZtkn8ObxzkbmqXsyIktpS/hSK55v+krfcmi+qG8hOi
F1GZVL+fgOrj1LJnSL+Eg1myE/nq7h0a1jHuKD8knNDuXOH//Mvxp27VZWGr
X68qbA0oQYkN4uCApKGiWfShm/VUNwRy+npNoKtxnvno1MZ1NtfVCmgc1FyN
6K9U2n9x7NZjf1UdPfabOk1KCtcTaMWz+ZSwSVcjj6DGk9a18VlAFMILSEMJ
KaChaVpCX5LFobm80vgQ8zhPe2TPiik/fN7agd7VP1WRPaZ9z4VrLuekRr3I
fbhWp7309Swfe4VDt04LU9P+1D4iDZDrhZkzqR96uX93mBFor/87d+Xq1ZPi
BtDRxc0GjBnu6OW5dP+ugjsaQqe9tm37rDfJOjl081iTfYMfDUGU5m/p7ddO
qew8Ycy+C7laHZn19G7W6URf6odBgYeYqR7IfFyBLT7wWncqx6TC6YsK9o8Y
8ZaSYS88KD3x/YZVw4LfQ5mmnM0WB1FcsC/50KG1iaF0cqdnJm/YlJpKZxne
V1BsqmBNbubSrzbM8/CgO5RncciqeU1u1urpK6NcXEymje6vnGXdOs7YuvXa
fV1t5b0zwUPI0GiHFiN/sU2IOpGbEdnaBqU1vMWBBKWDBPUPeTc5t994RXNl
5YpgH5+IyC9He7hP2SJ2IYu+KH/PlKje76smTZ8W2kMdty9TttFXXZHei7SJ
FK5tJi2Lz8ilJgMfovpC1CCzDUvapx08yJs73EZuPsJ1Uaj869Ly1RFdPT6P
mjjRT62OX3iF6TRn+BC+DPEeFx3Y3ZdzU4zu/OHZvdShw716zF9TQn67urKU
LbP6eo+LmDXFy91/IfVDIURfaig5tm//Kd50yWTO5MmjVaMHBwaS/TYj5bDl
fiN0JT99/2nPqM+7dJ5HLSP6Py7+MlytDp0epvYc/1NyGa5ulGE+d0hXwwCR
jwUnLL/C9R8ktPsTg3yDInxUQRvZY60tzQhSq8cEe302IoP6HnUFZ5NG9fce
N2VK72Huw+kf0tzJXfWxYTQ8PNBtCE4tVQOp4fq4a2K+3FNCovLCqaSRwzyH
9QsLjRjYzXsxdzOBKIqfYNqCULi06jWAfNWHXyzkn/GJveXM4YT+Xl7BERE+
6vBfD2sflp/Z+qvY9o4Iur8vr/t5dk/PoREhIQNGqsI4O1GokyMNsygwMZXT
Fm1q0shFmORFxK3CtJlzqLGLNIzO6JVJnM0tJIXZkQXCoymnZGnwOvAfQrt7
2X+X0psbRMnF9QHe44YMcx8fdeEvVq/qLh5fFBQmlMrM8HUciIr06uMdMXGE
ekbcpb90ZRkbD1y7jR0Y7sN/njNnEqCf0BevivMZGhPUretcMtGNodpHFvmp
RkYGBg4OUw/+9Nc8ahEQXhZq8V0t3A/siVSduq6/u2nTktyB7IM2GsNi8jjB
xYS+4nBaQn9/j88NMz9MPTxw5xVGqyU2REKVaJAFJC+Iw9IEI/R39++Ioz+E
YK8hzFqJImUBaSghhVom/tWIihWpi7/VywihL0laOoK9jAiLs5hJKo9Bc+Mv
3SdQu/ZOCfH+LHh8/zGdOlm4PU2beWhVILUyhxla6rOYf/mR+ByWJVNsJ/Rt
IH/lYNniMEjzBdM8kI6Ny45rvEyw+dx1y9/5cm3FP4wyTTp5TVVeFJVi16X9
+gKOkCUqVn1Flv9a6y8OXWF11aObWzvRdXMZF8ZdmbNTI1sJ1Op2wdpOpBLu
ODriCmfhqr532K8LqYP7mmMQ0JrpvyGLO53uF65zV7b7PpllE5DJb7kWB/dX
lryqzF3EsThk1pxTmvM3ydv6vb8u9565IflpYchqs0kEnObGL55vKW3hhd7g
Fgd9K4qEHT/kH6v46IOoSJ/vDmcjm5TI+iWghX10RhHuD/QlK+M/cXL7/gj9
cG1l6Q5V2wVn78mtpC5rexAjQbGDx+ujYkM3nzyLXwQsuTfozh+d08ExYOna
6w/oez1K5ga2XbSTVhVqKvOm9/gm6xZBZddnjXJl6Xbfbil/EpSjl3LoxvPn
pvsMSNxFn7iRZzGCDtgWXlpRsOyDbntL6JKHLE5e1Nd/22VqHb55fvHbzlK8
NYjslG5Bsderau8nRDdr9cbiPSlj+oadvfMIlb/C1T4w6XAlq24G8bQpuM3L
01MO003Qaf437CP7kBjmR1eZvqbHwq2af2prMtaq7JleskRJfLduKTlEjeZA
j38px0w/n7naJyyGfiOZ4ubf+G8E+WBb7WhtENwx41t/5P1rXjG9x1J0Zm5b
fs5nqhZWh40bFvxls7u2NiZkJnR5U/p7d/R1sGr7lCjJTVS1eTdukXH0a4mC
g2M7mbPG6Y4mvR8Rb5ClvE4WCt0lxy6o3RuxqWdNu0MVyya3M80oCn5kgfBo
yitZQpv5HdglaklC4PPG+ty79nPP7juKdNRWHvvDEU03pDuX8aXzC5+tpxUq
XfryXp2CPnlW4TQDcweo0MPMI11d+grXiIVleurDecXlx81LusfEI23kYcry
3vbUXH0kvCwIdLVwPwhOJAsuTAZlbJif4/ARh4ru04tI9k7//zBmkZSGVMuo
khVBHBYmmOHVi6e1DY8zfQiGpSnh/a57b8qZW8ILSMMJKUtfjYhYkbz423gZ
ERdn1POusxIMVlS4/9iM62jKUR6JXuoDWJuDXJmD2/Ty3/vHfaMtXZHeu938
bEZnWpjD1sqUOgp9W8hfWTAtjoB1u4qLc41cvXrh8plNqWsGfU4lgxW8AdBo
cdi95+myEqWxunluQVtSzXWJoJ3n6bsDFPi10XyGwhlQhsWBs4boyxQUnJy9
VIYf6ud4EYlkMblzPCvhLrUal8eHGJ73/C5Jw1XkDN+Iuvl39WVxyK85pzTH
dxxHbTzJUj9MVbJBkjHDXJ3wltI2wZgNbnHQQRyBEVctBdwg/1iDRTz7xA1z
w6kgC4xGR0qWWR/asx8mJ5JhAKy5dYvc6BgZ2ecF472TJAIZiUVzVOrOHZz+
qp3q+w0VjJlTk7HaqQ8dmU5K7RhqXqG0kB6q9Dv0Y9V7FjvPIVtKBye+0zpk
E0OHp75frBy0+NIHG75qs5BUgWgDkOFCRt1e18I3PkHs9KSW+momuYYdJKUq
ut3Mwf/TUxXmQ0XybjLWwkJod68d1rLFuO1nmSYSJZ1bTN5v3PSoyF/m2T29
jKilJwDjk7yT88MH/ifvGT2XnJ73CI9iZGyj3ohbqOvkaI3OYd08tl5j7eyR
crCz1z6e3kJ1hRVe6ET5iq+6PcvSUqTb5tyyis/Nd7ZTfcOYq2hHxdQ5BiWn
Z5etReR/G3ROFzuWpo3zFiC0v/7Y67nWMw+YD8Qr0xOHP8+efnwpLDKaskqW
0GjBDqTrY1hFP+6SfJF8CaVAstYQYeciIu9ozKvK9syVn76OFrMgCz7MtGUM
n/mgNgvI61eN1xKZPxyiYv3X77V8PfbgjYdpgssCiaDCI2ciieeh1Zam+ans
fP1PME9yNAUr3zZKNEkNIQ8+pFdJdhCHpQlG5KROaMXQhA1iIuFbP0eHODkx
NSILSAMJKctfjYhYkbj423wZ4Yoz5xeCmD4baFV/580+Y4ccv2PuHsOK+i9s
DBSdRccn/U9j/egNdsb8sTiHrZUpdRT6NpC/MmFaHBicWqoCOo2KDcPHPlAY
LQ4FM6kOobmbl1dI549FM40Cf9UpmXXHCalSrG/cgsVh1sBZl/GhIRDRsU0X
2xlH8O7CcMr1qHmv6LG/HEq9dPO2yU2L0Ny+pmH3+OOzOOTXnFsaf05KrpJl
Ss/Me8UaxQNLA1scxjkpOYiDa+WhxYq/mFfuXt77WbOtTaMpSnr/1WUX6nAy
pK8qO561c+aiCDfqJhcHhm5sRCxHZXnOEhcH7tVLhP76zIGvJqSSPUDq7R1m
ZpLLKVGQEfUiY3/P0AMjX512lPQ9Q3KNmymFee+DvJcaSm7zFbWGUyKe28mS
MMl6en+Ys6dHrdUMZYa4mDrRUeESTp6JsKA+LtOWiEFQdqCkEu3bxpj21Sk/
vPolJb/QB8tJEoKqgbl4ri7Z8omyBVNc7LhWUi1tWfD0Z2vfhe8cqmek2OYs
yPNQ7m1fHCmmS1/VbgI1zdD3yF5b+Jvn6MiP/XExVUrjz3iRBSKjKa9kS4h0
IF2fioLlnTqnlJhUU1YDBbfWq8r3ql0VHmx7E8lN/h2gIg8zG3773LxO1MYv
shq4Hw6qkPCyQBeCD+KQN5FE8tDWVF0I9lMqubfp6U5ufN896OLfkhsiq0ry
gzgsTrCy+BC79xjGWs3D7LGftPT/9ATeIQ6HyEfdQELK8ldjQaxIWPxtvoww
xBmSmFxxhjbAebPIUM7zfIuD0F2PDeHe9lh978Rgzxb+/mnIBpEwh62UKXUV
+raQvzJhWhzMAGfpmCwO/PmFgbvnFrwiZjgwc2E5TIovNzXZksVRW3RspiP3
gX92/viuUsAiQJiVcDrTL5GTGvYCy9Jy8GjzaUTg0p2/Fj/gDeRjszisqDm3
NL72bjOLgyiOHU12tlCyVpk0sMUhN4iDl3qO0hZ4m2CVN1O6uigcHb/9zXic
SugrTp5Y5+MeKOw6Lg/S/+cTg9HBU0tErpZDh1MKzwXJpnVJf+Pqkejx7qEx
tLNidUXml1OzqC2dimXTDMqt2aKpeXj+22jyV3iVnt4e4S16Ul567/SShMt/
WyPizdy6EBeXTO7hYF2vadPSqJMjfQAntWm3BHp6ExXJU6dmkRuASFC6TFto
uq37YdrKaOpXaLXnrtJowvDVpzpccIbqgFXJ0FEddyfHurBxunO442tdfq2K
ZdPbs0efj6knMdosnfKRoU6j6jE/LgF4kQVioymrZAuIdiBdH9N0xammQndG
o87kzjQBbV/kYaZqTVw/892eTPKkUiT0W2RZoMAHccicSCL3lxHZu8cajDWf
gFMmv+nKewWJG8Z26mpyqpfYEBlVkh3EYWmCoX0PhxZjk1LvWR0AKbKANIiQ
kvLViMwfaYu/7ZcRi+IMHXxwzBAkR3g6P70yM+cnDylz2EqZUlehbwv5KxMb
WhyCf07ewS3V4lD4BP5uarRFi8OsTpvfjlykpOntivcWozxURMWmHwcw/VZM
fTLIaKjy/9zWFodVNWeX9vgsDrQIi9iVMmlYi4Pt5yD6JFp/pG2C0cU6vTBk
2uDAwJhJKl/3YT7zEhNOl9yXp2XqK0tu465BYb6FY/qJ3AxFe18oO4/oFTl1
4kS/oB7veI6fH7M7OxdzCTUqB+uwisrh/QrvyC3rpbbIVIPfH0YlG0eK7jqc
LkHvd/FOaqitLeyuKco1ihdYfPWpDtnyaV8RnHcE2tvkKRVWpQ+iN16444vS
48g8LkGjL1mEUXoFewrxmkCPnYRGiVwPgR1N6SWLI9KBfK0Aox0Jyf1H5XtV
LnzVCK/tiz6MNRsl5boRWBawXS13IgnfX2b0kvJyC/8qMHBw9Oce7sOixqzY
vxuzEyjaEFlVqstNHELLRfWe5d2foeSdS6uBEQHL0o4IOY0IIbKANIiQkvfV
iIgVkcX/MSwj3MJ5VUJmGjcsEV8OPT9Fd2NkzWF5MsVmQr8eM8XVh8WRvW14
c8kWB1P/lGNxmDRws5eXBL2dWWcqb8MXI9pzk9xyg7gfm8Vhfc0fv8VhcmCz
bpLwaViLA+0MS1kt8a6zFQUr33bg/zmKI6j7pVE1R396c4JwIZQnAPctIv6c
yKlD2o63wIEF9SvsuifgRSDvpba4bAvrek2fXBirgcYd1zqkFvIGWnBzSfAc
ASP1UElWB3GgF2G9Kdj2lAmRTWMRUOdw/8qqoxkRyw4Dbgqh0D/mOYWg2cWB
v6vJaQsvFF1qyZbAd6CAViCoHfE6jTOH2dXmafv4h2lNGHukK+X+PvyyINDV
8iaSSBAH7W4tNXJQ3NKUXiWhkybLiCwXZDatH0Y6mW9S/jhm7tWHmDIEy7YU
xFG/QkreVyNbrDD+qi7LiIjTEf69AmYaWo7w0kHceVXWHJYpU2wm9Ovxssv6
sDhK/zf7JckWBzOuwaLFYYprYHgZVSXNaStZb6eLrbp3m5HLhtBUFGWdT52z
bNIbVK0400+uxaEpTAkatusaa0cDa3FYU3NOaY/L4iAKI/xRKUN+ya6bWKZp
SIvD6PVqebU0HrxyJDV+/UFH59aE63Ipiw98dZVgBB+1PnA3YUSWVmQtStpd
p3IXCG1oYwUx3rtb1kvpFbVu/SYgKdChPO3kQHtY4ZZuejON6yHA03sZoLwx
nH1FIfurLkEcSKzgZActkXln+kgDwQfNCWH8KDh/Zd3RDKqAVBFGNZD9Cp46
LTJ2HIR3NfGjKb1kcUQ7kFsfnJOGkJ2IPm2JZ5piD2PVDzRjxU97hZYFbFfL
nUgiQRzIo15ithyRhsiqUh08TMSWC4S+6s5vpGoR/LIlTRXbBJEgjnoWUrK+
GlGxIrL4234ZYYC3K7G7/aj+z/OmhPDKzHiNnDksS6bYSujbRP5Kpj4sDl3F
3v/S4RZMXyAz1bdTPqD9iVhrgvTIcWaotSkfrMPzi87jutvk5WX8q9LYQLvJ
OBO7JGdxB0fu2+VaHOQPudo+PnJcfs25pT0mi8Mc2m/5xnnifvn5PbvO3xJ0
CrJcZ9ZzVWUndu3KLcQcBVoN7SEmYbXEboIR1RfH9lK+4oSC7IiLB8NTsih7
Ei3mdb6Didw5tFetFVIXieLYUXavclx2eUtrVfnB0LD/UUIcfSaS3OHu5C55
07gtRuiuLA4/WGL8GwFBXL4g/E2Td67JR13WS8Uz1UgEjSlH+eE4b6NpjHsR
Uva4vrtooI2CRpe5PfxgrmkeYD3AkfOGycChHYZrMROJyDs0fGkyzjeEh+DV
82jQ+XmJrbpaGnUOT6Vh+hgQ17Kik9KkbGmifVSJBzpoqrAe5qvTwmPHLY3p
WnPz99kBsdfRUio0mpJLtoBYB/K0AqSHsMeU6VxE5B8L30h3NepMbglIv0Iz
troiMy7ugsbSw0iTYTxs+pWF016BZQHf1TInEs/OIsrXDP/2dIW5lzjZsYQQ
aYisKjF1zpqH2WE9N/8hTfYITTDcVa3IHJCxJyCygDSMkJLz1YiIFdHF36bL
CFGWFL72oil0RcDlDLvbT9ZfqRyEoryJknXh269SwldwZWYgZw7Lkym2Evo2
kb+SqQ+Lo7b24S/zP6Bu9MDbXKYcTa4dk28wOkjc4iB0F8d+gn7LypZQ8/DU
EE/qx2KGswHHCbHFOmMTOK82vuNGzBDu5ylicZhj5FkWx7zWXAsCb3HIrzm3
tMdkcfx9bb2rmOlngijMnONM1cX19bknb4isE5Isjup7J4b5kU5uDs17L0yq
sNGRH73rKD2IgzNpUQwmrZ0SRTPfCT5Ae10KJN4k0Z3bE52WI0XBRJ+D4MYO
mXraru+qVNYFE7w9zIfb5reLMUafUQXiFx9tSUrcctNcolY8owb74Eaiis73
SD2J2/xhe+c+2DCzw2qj9iv5pWKbnJJBI8V5HQrZc52+0JwdxSBl+IngyGD8
nsrXX19ynnOtj+BAC13+y/LiLs6M7EabMFxBVlN5dlS7yQdxefL5oP7hZ2wo
+m3eG0rlkKCLWvbPkTIgN486tnPQimQURhXLwlzX4G9d4YDkHV6h0pbsCZ/J
zIiDSbeF0R4pTUkgiZ/uXOron9OQmGa61lSnLGjzjVH3FhxNqSVbQKQD+Rkq
2InR0JOk3Dd6KJXFD3LdSIsApIdwOhOJVKScEAUHRnjSM03Ww7Wi26QmhJYF
fFfLnEhcV6ib5+Z1Mi472Hy8dG/rS9ZE72Ek4RFriJwqsT5VUxYsKeAnmO5K
zChuLiMDhRmRL0jIW2JqgfAC0jBCSs5XIyZWRBd/mywjtKH9qHyHytW8JApE
LmAPPgTrj6wJbC4dQle8fPSqiw9qCelzWJ5MsZXQt4n8lU79WBxUujA1uX/P
yPdLYxia+CntSa2Sl/uRYXE4Bo69wA5sMl+O5umVUsQacjJ5WhsqhygrMz+F
tnTHx5T2zEgeiJrQZdZC7h0HaFHqwk53L2JxmM8C7Can0R84cTxR9RJ3vgnd
ACi35tzSHpPFIeDNxYfOM4yGLGqhSKY1SRaH6dDHwDuee8usrD4HlAjO6iAO
ahk0rj+MNOy1tIsRxgFYd+7AxPd7c+5tFIL2i+AlHiEh03p/yLmojmoSe8tU
c2Ozd9ctpklCbvW3V/KTUmpLUwd0jDJfu0kJEeN7dekJ7y80332G3/yhFCc6
sYbhLX1dV5jqLPWlVgYdcEBjyhK75JqjsvNmXZdZvWe5+lnOVieh2fT9R/as
lPJ0d7AHerH3CNOFU3g3FfT5G+0vplrF2X/TZW3pOo6XnlcItF35MVsikFZS
d1YSeBPWSpCKZdPaNWPudBHaXxf3fta4QVfz8MSnHVZgLs7DQe0K/nsuT/3T
lh4LVoen5vAcAlmqAvKF42iPuLEj0V08EefT35jfg5EMmXFRS63oaEor2TKC
Hcj3iKDGiKUPkPajMQSArR0hx0XmKkTdUOBg2gpjWvrCD9NaPWtbQNTtxIjQ
siDY1XImEjt5NaG/Hte1a7JZDTAU9XJzXkgOeZ1ERMfYNYx8UBYaIr1KzE/V
fJeEBPATjFqZnf3VW/KZuxmEJvHrF73NF9hJKxy/gDSIkKqV8dWIihXxxb9O
y4hhYZ+veoZeRogLKZ39zNIBL87wu/2c+jOmBHZlrqXm5/o56lj6AhGpc1im
TLGR0LeN/LVIVe7pZJKs4xHhrxl1utfCI45nUT/Ozq2SYOhShZzaHdCH9ef7
0v7ExkP9XZ4VFkJeJvie23d7dxXc0RCEXpubdyR62n+fMeiTLt/sz+RmZmNY
HO995Oo40H/TqbPkHR9V2j82/DzhZVIZdR7EuOeRgS7/dML75M0FLqMDd549
ddfQnirtn4dO/tSDNHxchgfsZtwvbzSalOoZ04/kIQceovL61czp0R8yVZFH
9/J3HTq0NjEUWTqvtZm7Ozn5SBZz7113dEvg85S+PXzEsev3K68XbOnuqF5h
3pEmigv2Mbt9YMDuzOR9BcWEVTXnlubhueaIsUqc2iqembxhU2rqtoJ78v2T
7uUueUPBsaSwmE5hFLgoCeOsY088VGcEZ/KYDr8UtrPBH5Tv7UEabpxzIgwC
rrPUik2tbITu+hzf8RmMdJGE7krMCPu+ZmuRuH/7/PezvMKm05eHWsYgOgcb
bIpLeQcmeXRdfcR0Dw5ReT5z1cese1eZVSWXvsHUZotOeyGq+2T2amyYlp+9
yDD29VXlqbtnqLr/lH1Dz3isYlm0vSslgjVFmwYPOMSQPvh8MmRworIX6QBG
aDZ/0+Mn1tXeEl8qnKlGMmik2r46ZHjnRecoyU7el/fZC314ieZIM6TLc5Hk
7bRUlSqLE5cNfMXt++O5/K17kYEW8ACn3H3RKBSd+qI/4wonSnRSHVVLlFxc
0leGHluLNiJef27S7ou0VllRejx4qGGFOY65BrIOYYDkvVr2vZGWQugrti3t
/uXOo2FDlZ3IKUFe7D6encBftMoV6+PefomxN2Io8HDavL6+q09f4XY1eWyn
/HA+yuJIVJ5Knf6qA+ZcgBy7D+0nMiy1ynuXlnzrPSEq65a5H6r3JKhaOK3O
ryGuZ03zNCt1Yp+ttJItw+3A5aM9hnV9BncDRU3l2ZE9ld50AA5xtyglZPZs
dU9lb1J/4Cq65IVigfaf0nub+mvZi/r235eeGNCcao4OXaBcY83DIrluGAgt
C0JdLWsiGQvRk1bA7oTuX7LvNr1XmNTZ/iPqLm8KoupyTspwr2GmG6IlNkR6
lUyf6j+aE0Ncv5d8Bzd+ghG6qzPfH7XzIuNaef29gzvC3veVtQIILiANI6Qo
JH81ssUKox11WEZ2Tx4+P7qN0muxwRZjWcSC7xXYqxGpP7Uy2wdvM9vI+qL8
vSHeQ9Yml5n6Utocli1TbCT0bSB/JWBOi4SFvfEurxChqGcSojLn7K6ZC8Z7
BvRqZTDPlJ16d+g3IWDBr0kFFbipzvSq2lZ4N233D/7je7akDA2V8+DJgasO
iaaYM6gTe1JXjI74rOOAD1qI3WZYHv/5y1NjL5WUZH793dh3fDqSsSHKTn7v
jomL2JNXbB4dxla/Ge4WPaH97fjPIycOdu7a+pmWqqFes7an3sV6QDH7jHM8
JLnm+AscUZWwtbXupMNgjy+b42Ov7Bwaevau6MTUlh4cHfyhffOu40dkFHNX
VAuzjj956PwezZurPeIPybiHi1//vJkj3dw8PDpQ/WnCpVWvAW5ufv5ppbii
Sa3gI/uxEXmcoxCyVvM6f6SeOtYnLoNXK93fV1YsDeqmmjQ9MsLbyysydMvp
HBlBKPr7aSP7plFdRyVPmzm8g7Pzx25ubu7DZooVRZTk/NTPc2hE5BjffotO
YPRn7cn0Rb0ND4SEDAj28uv3ww7cXTPa0oxR//UImuzz+Uj28BElc0PsP/Hl
7YAR2v0bR3fxjIjwDsHlcpfwUqGS5WAM4sguzt/0qXpERExQN6/I1cuvYGOJ
/i7/LW5W157eEZHosYTcuwJfhPBAE9m7g15q/QVjp8jYmJxE304Dw8d5R86k
c54bf6PdnxRsmBVTx3lPDDuGsxTE0RVkb/ish1fwGNSTCQcElz7kA2BNph1q
u2Oln2G8poX2UM/YRi1cglPCEoSuLGXLDJVX8DTRKYfee/Hkj+Q8mTK5t8+0
ddu/dRUIczaPnfDHZRC+s8Z7DpsQ2N13M3NjWfyzlVKyBNgd+Pu1xeTRG94R
XVt6LDzYc1i/sM/7e0fHZN7SEaX5m/t39A4OVYdFsScPtV8XbWhUwEQ/tXr2
3PMGzVCkOdIfJq9msP9wzppycXEvNAeEulrWRKIL6RfWz3vciiT+l0HcKtwX
RnVUGPXBLvv2ZDFvj1FCQyRXif5Uw0aqgrYeqZQudIQ62SwRAgICLK05wqXj
F5AGEVImJH41ssUK8xHrlhHvCYkGnZ/QHvw1unOnMZPUn/+UyhBP6L28A+Kb
5+a3sw9MOswddNE10Lgyk6mGheanlDksX6bYROjbQv4+MVjMVQUAwFMPNojj
aYUKG+enVWlCoIQt1lxc0sgQSCIEAAAANDrA4gAAwBLYmzieUpDfb32FAdoA
fWV50W3mKf+DDXPc+JG2TZE63DIPAAAA1CtgcQAAIE4d8uc/OVRprt2hfMgo
V2TPBcl1vMyunqAyirAS+ZLuMW9hEnA1Rai8CpggDgAAAKCxARYHAADioCCO
JrSrb3PIqFgXhUfnlD+J6pQf32uBy3LWOKHsI+dB/Y1exIRm07fvvui+7tJ9
C3/YFMBm1wcAAAAaFzVVfx5MTd2UOqcdbXH0mb/w+PHk08WS08kBAPAUQJzZ
NsJeICn60wGR9UtAi+a94xNKKh+eGvKiaulOfgh/I+XR7T2+nZMK0cgR2tQN
gW3cV54vfxI0dCrJjKXEswAAAEBDwzjdYAInHQAAIIjcg9M7faqiktcpHJp7
9ndzC4vJw6bmfrLRaS99O81naESEj2r0Sky2n8aMLv/0Cn/VyMjpYWrPYfFx
v5U1qdrjoKalX582Hg6MhHgTdmaD3QEAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
Ty/6yjsFubm5eXcrIXM5RZWmJC83t7BQo7NlqYTmbqGhm4uKK2tsWWxDQ1QW
k80qvKuB2QMAAAAAAPCEQOiLV83t2tM7ImKc98SwY3W5d6qi4OcexiuTHOy/
OHbLdrVskhCXj87uPLBXK2fyAil3j50ltlGidYc2BnY03pim6nfiL5uU2tAQ
uryZo7u97dOxGdVb85IegskBAAAAAADwJEBUrJ/durX6QHlN2ao5Pva20PQ0
l1c621LBbvIUHopqqVAEhOZbZ8wReg3uIKMmY12PZgrH8PgyfZ1r2IioyQ/t
pVDYhey5DLMHAAAAAADgSeBO7pI3lc8btFZd5dmRPZWvtP7i0BVJmp5Omzs/
+OtDOTr+038cm/GSwiEw4uojm1e3SVKdstjTzlpTjtBdiRn1pl2L4N05nL8u
ix/vqFAO3XK2Lpo5UZq3edKkg8V1ONiyLY/KUjwdFc7tN157onzFAAAAAAAA
nlooZdiotVZprt2R6jxPZG0JaI7fYK+Tgv0kQpkG1m7aE9UXQ71benffcbWS
9fOahyf7uyscX1x07kEdqkYUxXzm0KgOFIqzYlspFH0Cf/+7oWsCAAAAAAAA
2ADKg8Xhua+zKuT+pfAGe83ViP6NS4ltWJBpYPNN+9vnF7SpcxBH4ztQAHMV
AAAAAADgiQIpnFYEXOi1R3q7Ktq+sepSJfdXjU+JbWCQaWDrTXviwu5xz9U5
iAP5vw0Lza/LOYlNqdN5EAAAAAAAANDYsFoZFvlD8Iphg9zPbL5pr1nzZXtl
XYM40IGC15Jd1Y1Ev0eWLJirAAAAAAAATwpW75PXHN3g96zCdfZaDU8xREqs
04yE+6AzUlCmga037Ynq7BFedQ7iIP3flMrGlMT48ZwHAQAAAAAAADZGX1mc
/EtcT8+hERMn+g31DAvdd/U2S919cGN7bzc3N/riDGeVc48ehn+6R+7jZkNi
QVRfiBrkRoIumFB26t3Bw4P898jNR4wZq1AksnLolrz7J9OXDvbuP3F6dHdf
96iZF/4SLrvyr0vLV0d09fg8ylBhtTp+4RWrLn8j7t44EBXp1cc7YuII9Yy4
S/cJouTiIr+x2bT6Smj3Jwb5Rk7xcg9MTNX+w/xLfUnS0hGL1hZjk2vpq66v
Xz35v17B06Z+2rP/5kv3dVfObjx+llWC0MO5d0nTgL1przt/OLZv/yneXj3m
ryl5RFY7Y/Jo1ejBgYHTQnuoZ6QcpkpGtQ2K8FEFbUzjvkt7bX0HB6EgDm4/
/KUry9h44JpxDtzJXfWxYdA8PDoM+KCFQuHUUjWQGtWPuybm83zkRIdGWkNk
9CGyZCGIAwAAAAAAoDFDlOQmfty6/RdzL1Ug7ZnQbPr23Rc7brzMUyatDhsX
cX1BQRyOL4R8GeSzcO31B5Ti+OBG0n+U7Wcl3MWp6LrzR+d0cAxYanzY0IK5
gW0X7ZSrc+rOZXzp/MJn62lTQpe+vMvUNQvffdNuMn2Cozua9H5EfHFVbU3G
WpU9OwJFJApbW5o2qMcLo8Noi6miYOnHgUNfcVB4qNLvSH6YuWlfUbDsg257
Swjqkg7lkMXJi/r6b7tMmQM3zy9+25nqWKIyfU2PhVs1/+BqK3o4xe+HXp2C
PnkWd+qEgjjGxBRVC3Sp+NBIakiNrD6EIA4AAAAAAIBGDlGSs+LdFi0mxV5n
3q5AKfxvTVtYztFO9ZoDPZys8ZkXidRAv1Io1d9tqDDvb1MvwunzunMHp79q
p/qe8TB5sd1qpz7yLssj8o7GvMo2ashWOyhM2bQqS3f07LK1iGypZs2XLnYs
O0vQSayq/JC/WumlPlBuUoHRIQ5O2xd+mLlp/2DDV20WknETKL5D8drL8adu
0Qp9YVbs6y184xNK7uYv8+yeXkZQz3/zb2Wz6EM3ma8SCuIQ7geMGk+VLBjE
YXFoJDXkkZw+hCAOAAAAAACARk5V+V61q8LDY+s1trKOFH7+nry16VVF8pei
XylY6qXx4IP/ovKcJS4OCo/OKX8yNExCf33mwFcTUmXEMmMbjlptjHTQpa9q
N4HSb1GuWnZ6LoGtdaJswRQXuxbjtp9l3nJ4P2Gak0LZPzGzRurDjJKJ6uyR
bb6ijB3KalC44o5+dOkrOsyhure6Ir2XKzeZmFAQh0g/tG3782W2gYQKETrh
sjg00hoirw8hiAMAAAAAAKBxU7FsukHxwxgCSOF3clqdz9I5rQ0bF7kzjg7i
8F93mHUROXXwwfPeIUrmTnhLqfBckGyqsP7G1SPR491DY8SCPnighnM1XrY9
9TBtZXTWDVJTLsiIepHdajrTL1cnR09yrScBbV/sYWbJ1fdOL0m4/Ld46DdR
kTx1KqO2LpzzKYEgDrF+4Kvx6OwDnxhZwtBIaoi8PoQgDgAAAAAAgEYNUiCx
W9ZI5+Q5q1iZGVXkug30K57qjn+R0eup84hekVMnTvQL6vGO5/j5Mbuzcytl
+dQ8Kt+rclE42EdnFDF/jNRXvj1FqeVsc0lAJy9fMOUtvgIvoO2LPYzdtEe/
6uZ95K5Y48rixz+v5DYNbyqK9gNfjUeF4IM4ZA2NaENk9SEEcQAAAAAAADRm
kAKJdZFCOidP7xU5qhDFYhAH51eELi/MX/k8bw+cDDdWWHP5IBu64bxy8Fei
45yU8E5iyHri9Q+KWeBp+wIPU3XD5hCWdMCENH/emKIgDo5LkkA/CI6yWBCH
nKERa4isPhQ4aQIAAAAAAAAaCUiBxCl+dJQu00OGBIUz8FytLGIxiIOrYFcU
rHwbs89fk7GuRzOxREmy6qMIYEea0ymzeGYOxr9LQCdHBx+8/sEbMmIP4206
6qjFwv19uvQ1ffnHEwIuSWL9wD+QEg3ikDU0Yg2xog8hiAMAAAAAAKCxQoXi
4ras0T55W256VaH9c0vw9POq8oOhYf/7C/criuo9y7s/o+y1ggo3rixN+3Lh
lYfkz5FaW/eLAlHDuWo5Om3htQ69lNVLLJ2cKEsKX3vxHvlztM/PKQGZaXRn
EhXJ0SstP4w27RkPm34lfn8fUX1xbC/T2ZAuc3v4wVyy1kwvppqH2WE9N/9R
I94PDsNC8x+Q5zuZcXEXNNTPeUEcRN6h4UuTURJcGUMj3hA5fchKF3bz99kB
sdfrZooCAAAAAAAAtgVtcfdad4Szl63ZNF/1jNJvZWolxxKhtEHZRwxIP2do
qg+3zW8XQ3npY7fT6dBp2t4hspLemWZ06aeUYbxaqy1JiVterJNUI2zDH/4y
/wP+aQutlrMzzSKdPDDi6iMyFGKHypWuP9py5xwZlJ6Z94pxH766Ir2v6wpk
x8l6uFZaljDqGdpYMFhzM98JPkAGaLC8mG6fm9eJLkSkH5CFRRQcGOGJSuO5
QtVUnh3VbvJBYwCI9KERb4icbmGeB1WnLGjzDcSPAwAAAAAANDLu5C55U/nv
uWw9rei3eW/Yqb5ZVsK720LEOUoMzeWVzgzXF82Nzd5dt6BcrNggDup5Wm0m
dHmTXMNMai0ZUtFeiVR9JtrS1AEdow5dkVgvlA2JeWxBFJ+b74y/gYJqNdPi
QBYZ3Q/EhZTOfkYTDEV8MJuj054d3c9QLq2KF2dGdqMVeJGHaa2e+bBQIAMb
6qDBmPWrIn+x94hsjenndHt16StcY2gLTrgf6PY+2DCzw2o6hxjnrEeXtaXr
OMYdLpKHxkJDZPQhdRklOithzxOiJOcnP1/3oLH/uwMWCAAAAAAAQMNCVKyf
3baVV0oRUhyJyvOZP77rGLB0A9/cqLU6LxBy9RlM7VrrtBeiuk9OzUFKLN6E
IXXOds1iSPXSoNb6xq5hZnnVHd3y2Yvma+Nq9VXlqbtnqLr/lH1DL71aNVV5
UYH2n9L6vP7a74t7jRzQygEfg3zz3IK2yg/no5AWovLU7snD50e3UXotNuje
bIOotrYyPXHIS0ZvtMp7Z6Z0n7zj5NqOyn+R2jJREt+tW0oOYdXD+EAGTk+T
FgRlLBC663N8x2cY9XzKtOy19kjNP5oTQ1y/P2vy1OL0Q/aivv33pScGNKcK
0ZVu9+1mvlzDVAip0l9c0rd/2p+sWSJxaCw2RHq3VO9JULVwWp1fQ1zPmuYZ
iMwr+ozMgNC9IQAAAAAAAEB9QujKUrbMUHkFT4uM8PbymjplT14xXnXn3xMh
/SUlOT/18xwaETnGt9+iE7mmezceblv07ovu6y7d5zyvO39kTleP0VE+PvPX
lDzilqY9mb6ot6G0kJABwV5+/X7Y8WvxA/lb2X+XZ0WP9xwWMNFPrZ4993xu
xoyXBGOQdRdP/ki+ccrk3t4TEpPLHhHag79Gd+40ZpL6859Stcwkrob+3Lo2
uJtq0tQw9eBPt14glW3B5sh4mCiZG2L/ie/hW6JhEoS+eNW8zh+pp471icvI
YdxvQmj3JxleFDZSFbT1CMtZjtMPdx5ZLGTS1HHeE8OO4YxSCUMjoSHSu8Vg
wM4yVH5CYHffzfmmWUSUr4nv9fLLwSvxhjMAAAAAAADQSEGBw09oXiB8yiwA
AAAAAAAAAOoNKmz8Cb3c2dp7RgAAAAAAAAAAqBv629duU1441Sk/dnnG8dvf
7ln8k6aHXnOghxNcJAcAAAAAAAAA9UxleuLw5xUuEfEl1WQQh3KYOXXSEwVc
JAcAAAAAAAAADQBRFDNU2f712IM5uoozc9u+vuBs+RPpdITu6RZPPAsAAAAA
AAAAgM0hSvO3jvDxCYsO7O6zmJFj6gnhUXlaQPdub/t0bKagkqk29+zv5jY1
Xt79hgAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAANHn+P89gAsU=
    "], {{0, 61.811320754716974`}, {721.3584905660376, 0}}, {0, 255},
    ColorFunction->RGBColor,
    ImageResolution->{106., 106.},
    RasterInterpolation->"High"],
   BoxForm`ImageTag["Byte", ColorSpace -> "RGB", Interleaving -> True],
   Selectable->False],
  DefaultBaseStyle->"ImageGraphics",
  ImageSize->Automatic,
  ImageSizeRaw->{721.3584905660376, 61.811320754716974`},
  PlotRange->{{0, 721.3584905660376}, {0, 61.811320754716974`}}]], "Input",
 CellLabel->
  "In[160]:=",ExpressionUUID->"ab0aa141-f81e-a441-ab20-bf3fed10f65e"],

Cell[BoxData[
 GraphicsBox[
  TagBox[RasterBox[CompressedData["
1:eJztnQtcVNX2+Gf4W8onsh/10RtlpRGGXLyVaAV6a0ZNQEV8kaZoKgoKKgKi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    "], {{0, 61.81132075471698}, {721.3584905660377, 0}}, {0, 255},
    ColorFunction->RGBColor,
    ImageResolution->{106., 106.}],
   BoxForm`ImageTag["Byte", ColorSpace -> "RGB", Interleaving -> True],
   Selectable->False],
  DefaultBaseStyle->"ImageGraphics",
  ImageSizeRaw->{721.3584905660377, 61.81132075471698},
  PlotRange->{{0, 721.3584905660377}, {0, 61.81132075471698}}]], "Output",
 CellChangeTimes->{3.9614126709099083`*^9},
 CellLabel->
  "Out[160]=",ExpressionUUID->"92541fd8-ff18-44f4-bda2-f4136dadea4a"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ptE", "=", "ptO"}]], "Input",
 CellChangeTimes->{{3.955532028301876*^9, 3.955532030902384*^9}},
 CellLabel->
  "In[161]:=",ExpressionUUID->"3e8dd887-2087-0a47-896d-8880febfaa56"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{
    SuperscriptBox["a", "2"], " ", 
    RowBox[{"(", 
     RowBox[{
      SuperscriptBox["a", "2"], "-", 
      SuperscriptBox["b", "2"], "-", 
      SuperscriptBox["c", "2"]}], ")"}]}], ",", 
   RowBox[{
    SuperscriptBox["b", "2"], " ", 
    RowBox[{"(", 
     RowBox[{
      RowBox[{"-", 
       SuperscriptBox["a", "2"]}], "+", 
      SuperscriptBox["b", "2"], "-", 
      SuperscriptBox["c", "2"]}], ")"}]}], ",", 
   RowBox[{
    SuperscriptBox["c", "2"], " ", 
    RowBox[{"(", 
     RowBox[{
      RowBox[{"-", 
       SuperscriptBox["a", "2"]}], "-", 
      SuperscriptBox["b", "2"], "+", 
      SuperscriptBox["c", "2"]}], ")"}]}]}], "}"}]], "Output",
 CellChangeTimes->{
  3.9555320321457787`*^9, 3.9575744904326897`*^9, 3.957576361903036*^9, 
   3.957577380717657*^9, {3.9575801708501434`*^9, 3.957580186537068*^9}, 
   3.961119179922825*^9, 3.9611196344039345`*^9, 3.961412670916754*^9},
 CellLabel->
  "Out[161]=",ExpressionUUID->"a628f525-387f-4119-ae34-c36ee736c0c7"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["FGHI parallelogram", "Section",
 CellChangeTimes->{{3.95553234842535*^9, 
  3.95553238304664*^9}},ExpressionUUID->"f0419b89-23d5-8644-b69d-\
cc4e3fce7177"],

Cell[CellGroupData[{

Cell["X \[Element] \[DoubleStruckCapitalM] ", "Subsection",
 CellChangeTimes->{{3.9547318899015656`*^9, 3.954731893974074*^9}, {
   3.95473265785647*^9, 3.954732659663503*^9}, {3.954732890679308*^9, 
   3.954732891487614*^9}, 3.954733054504549*^9, 3.954734909088499*^9, {
   3.9547456826790233`*^9, 3.954745683267832*^9}, {3.955532399470188*^9, 
   3.955532399508514*^9}, {3.955532733349869*^9, 3.955532733926052*^9}, {
   3.955532899238508*^9, 3.9555329102464027`*^9}, {3.9575779644687576`*^9, 
   3.957578000565407*^9}, {3.961120090450142*^9, 3.961120148594164*^9}, {
   3.961120347218914*^9, 3.961120352554741*^9}, 3.961120420161833*^9, {
   3.961121401651226*^9, 3.9611214293728294`*^9}, 
   3.961121482939451*^9},ExpressionUUID->"73d38772-8e07-1841-9a9c-\
3044cf07162c"],

Cell[TextData[{
 "F,G,H,I are the midpoints of AB,BC,CD,DA respectively by Theorem 9.3 of \n\
S. Rabinowitz  and  E. Suppa, ",
 StyleBox["Relationships  between  a  Central  Quadrilateral  and its  \
Reference  Quadrilateral,",
  FontSlant->"Italic"],
 " International  Journal  of  Computer  Discovered  Mathematics . 7 (2022) \
214-287.\nTherefore FGHI is a parallelogram"
}], "Text",
 CellChangeTimes->{{3.9611201915312634`*^9, 3.9611202646669044`*^9}, {
  3.9611203781006393`*^9, 3.9611204004435863`*^9}, {3.961121324702301*^9, 
  3.9611213254439564`*^9}},ExpressionUUID->"a320793f-0690-da48-889b-\
40ba65c593f6"]
}, Closed]],

Cell[CellGroupData[{

Cell["X (148) ", "Subsection",
 CellChangeTimes->{{3.9547318899015656`*^9, 3.954731893974074*^9}, {
   3.95473265785647*^9, 3.954732659663503*^9}, {3.954732890679308*^9, 
   3.954732891487614*^9}, 3.954733054504549*^9, 3.954734909088499*^9, {
   3.9547456826790233`*^9, 3.954745683267832*^9}, {3.955532399470188*^9, 
   3.955532399508514*^9}, {3.955533472269945*^9, 3.955533474519298*^9}, {
   3.9555335376277065`*^9, 3.95553355693482*^9}, {3.9575783809567223`*^9, 
   3.9575783820767975`*^9}, {3.957578489189989*^9, 3.957578489217974*^9}, {
   3.957580930543604*^9, 3.957580960750847*^9}, {3.957581010310951*^9, 
   3.9575810104638233`*^9}},ExpressionUUID->"4a5cb8ca-2a70-f34f-9f6e-\
2f07ca1fc495"],

Cell[BoxData[{
 RowBox[{
  RowBox[{
   RowBox[{"X148", "=", 
    RowBox[{"Simplificar", "[", 
     RowBox[{"Evaluar", "[", 
      RowBox[{"ETC", "[", 
       RowBox[{"[", 
        RowBox[{"148", ",", "2"}], "]"}], "]"}], "]"}], "]"}]}], ";"}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"ptF", "=", 
   RowBox[{"Simplificar", "[", 
    RowBox[{"CentroETCTriangulo", "[", 
     RowBox[{"X148", ",", 
      RowBox[{"{", 
       RowBox[{"ptA", ",", "ptB", ",", "ptE"}], "}"}]}], "]"}], "]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"ptG", "=", 
   RowBox[{"Simplificar", "[", 
    RowBox[{"CentroETCTriangulo", "[", 
     RowBox[{"X148", ",", 
      RowBox[{"{", 
       RowBox[{"ptB", ",", "ptC", ",", "ptE"}], "}"}]}], "]"}], "]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"ptH", "=", 
   RowBox[{"Simplificar", "[", 
    RowBox[{"CentroETCTriangulo", "[", 
     RowBox[{"X148", ",", 
      RowBox[{"{", 
       RowBox[{"ptC", ",", "ptD", ",", "ptE"}], "}"}]}], "]"}], "]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"ptI", "=", 
   RowBox[{"Simplificar", "[", 
    RowBox[{"CentroETCTriangulo", "[", 
     RowBox[{"X148", ",", 
      RowBox[{"{", 
       RowBox[{"ptD", ",", "ptA", ",", "ptE"}], "}"}]}], "]"}], "]"}]}], 
  ";"}]}], "Input",
 CellChangeTimes->{{3.9611205300556774`*^9, 3.9611205869165783`*^9}},
 CellLabel->
  "In[162]:=",ExpressionUUID->"1a0a2b6d-8427-6540-91cc-7948a2861b9f"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"parallelogramQ", "[", 
  RowBox[{"{", 
   RowBox[{"ptF", ",", "ptG", ",", "ptH", ",", "ptI"}], "}"}], "]"}]], "Input",
 CellChangeTimes->{{3.955532598359007*^9, 3.955532602815159*^9}, 
   3.957578362301132*^9},
 CellLabel->
  "In[167]:=",ExpressionUUID->"18c7be5a-057b-f443-8626-d9b8e892e696"],

Cell[BoxData["True"], "Output",
 CellChangeTimes->{3.9555326038565083`*^9, 3.957578362905468*^9, 
  3.957578503057682*^9, 3.957580954621615*^9, 3.961120527248575*^9, 
  3.961120599058069*^9, 3.961412671411687*^9},
 CellLabel->
  "Out[167]=",ExpressionUUID->"72d81ae5-c038-45ee-a6a3-b53a769129ca"]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell["X (149) ", "Subsection",
 CellChangeTimes->{{3.9547318899015656`*^9, 3.954731893974074*^9}, {
   3.95473265785647*^9, 3.954732659663503*^9}, {3.954732890679308*^9, 
   3.954732891487614*^9}, 3.954733054504549*^9, 3.954734909088499*^9, {
   3.9547456826790233`*^9, 3.954745683267832*^9}, {3.955532399470188*^9, 
   3.955532399508514*^9}, {3.955533472269945*^9, 3.955533474519298*^9}, {
   3.9555335376277065`*^9, 3.95553355693482*^9}, {3.9575783809567223`*^9, 
   3.9575783820767975`*^9}, {3.957578489189989*^9, 3.957578489217974*^9}, {
   3.957580930543604*^9, 3.957580960750847*^9}, {3.957581010310951*^9, 
   3.9575810104638233`*^9}, {3.961120708980234*^9, 
   3.9611207090356483`*^9}},ExpressionUUID->"3ed9955a-edde-0b46-9042-\
879ae97f56ae"],

Cell[BoxData[{
 RowBox[{
  RowBox[{
   RowBox[{"X149", "=", 
    RowBox[{"Simplificar", "[", 
     RowBox[{"Evaluar", "[", 
      RowBox[{"ETC", "[", 
       RowBox[{"[", 
        RowBox[{"149", ",", "2"}], "]"}], "]"}], "]"}], "]"}]}], ";"}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"ptF", "=", 
   RowBox[{"Simplificar", "[", 
    RowBox[{"CentroETCTriangulo", "[", 
     RowBox[{"X149", ",", 
      RowBox[{"{", 
       RowBox[{"ptA", ",", "ptB", ",", "ptE"}], "}"}]}], "]"}], "]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"ptG", "=", 
   RowBox[{"Simplificar", "[", 
    RowBox[{"CentroETCTriangulo", "[", 
     RowBox[{"X149", ",", 
      RowBox[{"{", 
       RowBox[{"ptB", ",", "ptC", ",", "ptE"}], "}"}]}], "]"}], "]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"ptH", "=", 
   RowBox[{"Simplificar", "[", 
    RowBox[{"CentroETCTriangulo", "[", 
     RowBox[{"X149", ",", 
      RowBox[{"{", 
       RowBox[{"ptC", ",", "ptD", ",", "ptE"}], "}"}]}], "]"}], "]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"ptI", "=", 
   RowBox[{"Simplificar", "[", 
    RowBox[{"CentroETCTriangulo", "[", 
     RowBox[{"X149", ",", 
      RowBox[{"{", 
       RowBox[{"ptD", ",", "ptA", ",", "ptE"}], "}"}]}], "]"}], "]"}]}], 
  ";"}]}], "Input",
 CellChangeTimes->{{3.9611205300556774`*^9, 3.9611205869165783`*^9}, {
  3.9611206259815464`*^9, 3.9611206409589634`*^9}},
 CellLabel->
  "In[168]:=",ExpressionUUID->"dae4f3c5-907f-d54e-ba2d-f9f9769b95f2"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"parallelogramQ", "[", 
  RowBox[{"{", 
   RowBox[{"ptF", ",", "ptG", ",", "ptH", ",", "ptI"}], "}"}], "]"}]], "Input",
 CellChangeTimes->{{3.955532598359007*^9, 3.955532602815159*^9}, 
   3.957578362301132*^9},
 CellLabel->
  "In[173]:=",ExpressionUUID->"790495a0-ff2a-204e-ad81-af5c115f946c"],

Cell[BoxData["True"], "Output",
 CellChangeTimes->{3.9555326038565083`*^9, 3.957578362905468*^9, 
  3.957578503057682*^9, 3.957580954621615*^9, 3.961120527248575*^9, 
  3.961120599058069*^9, 3.9611206607853546`*^9, 3.9611207255655556`*^9, 
  3.961412690966345*^9},
 CellLabel->
  "Out[173]=",ExpressionUUID->"e199ef1d-0923-4ad5-8738-ca2224f69598"]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell["X (150) ", "Subsection",
 CellChangeTimes->{{3.9547318899015656`*^9, 3.954731893974074*^9}, {
   3.95473265785647*^9, 3.954732659663503*^9}, {3.954732890679308*^9, 
   3.954732891487614*^9}, 3.954733054504549*^9, 3.954734909088499*^9, {
   3.9547456826790233`*^9, 3.954745683267832*^9}, {3.955532399470188*^9, 
   3.955532399508514*^9}, {3.955533472269945*^9, 3.955533474519298*^9}, {
   3.9555335376277065`*^9, 3.95553355693482*^9}, {3.9575783809567223`*^9, 
   3.9575783820767975`*^9}, {3.957578489189989*^9, 3.957578489217974*^9}, {
   3.9575809417442055`*^9, 3.9575809424402046`*^9}, 
   3.95758102568441*^9},ExpressionUUID->"5ce4c659-b0dd-e64d-8ec3-\
088a6ea4ef55"],

Cell[BoxData[{
 RowBox[{
  RowBox[{
   RowBox[{"X150", "=", 
    RowBox[{"Simplificar", "[", 
     RowBox[{"Evaluar", "[", 
      RowBox[{"ETC", "[", 
       RowBox[{"[", 
        RowBox[{"150", ",", "2"}], "]"}], "]"}], "]"}], "]"}]}], ";"}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"ptF", "=", 
   RowBox[{"Simplificar", "[", 
    RowBox[{"CentroETCTriangulo", "[", 
     RowBox[{"X150", ",", 
      RowBox[{"{", 
       RowBox[{"ptA", ",", "ptB", ",", "ptE"}], "}"}]}], "]"}], "]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"ptG", "=", 
   RowBox[{"Simplificar", "[", 
    RowBox[{"CentroETCTriangulo", "[", 
     RowBox[{"X150", ",", 
      RowBox[{"{", 
       RowBox[{"ptB", ",", "ptC", ",", "ptE"}], "}"}]}], "]"}], "]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"ptH", "=", 
   RowBox[{"Simplificar", "[", 
    RowBox[{"CentroETCTriangulo", "[", 
     RowBox[{"X150", ",", 
      RowBox[{"{", 
       RowBox[{"ptC", ",", "ptD", ",", "ptE"}], "}"}]}], "]"}], "]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"ptI", "=", 
   RowBox[{"Simplificar", "[", 
    RowBox[{"CentroETCTriangulo", "[", 
     RowBox[{"X150", ",", 
      RowBox[{"{", 
       RowBox[{"ptD", ",", "ptA", ",", "ptE"}], "}"}]}], "]"}], "]"}]}], 
  ";"}]}], "Input",
 CellChangeTimes->{{3.9611205300556774`*^9, 3.9611205869165783`*^9}, {
  3.9611206259815464`*^9, 3.9611206409589634`*^9}, {3.961120762245165*^9, 
  3.961120805756878*^9}},
 CellLabel->
  "In[174]:=",ExpressionUUID->"eb21106e-57e1-2243-a671-3ee27339c7d1"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"parallelogramQ", "[", 
  RowBox[{"{", 
   RowBox[{"ptF", ",", "ptG", ",", "ptH", ",", "ptI"}], "}"}], "]"}]], "Input",
 CellChangeTimes->{{3.955532598359007*^9, 3.955532602815159*^9}, 
   3.957578362301132*^9},
 CellLabel->
  "In[179]:=",ExpressionUUID->"6d78f710-5ce8-314f-b95e-349a31bbf775"],

Cell[BoxData["True"], "Output",
 CellChangeTimes->{3.9555326038565083`*^9, 3.957578362905468*^9, 
  3.957578503057682*^9, 3.9575810435837936`*^9, 3.961412729757147*^9},
 CellLabel->
  "Out[179]=",ExpressionUUID->"d224a86f-fd79-4d7b-b190-052ea5630eea"]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell["X (290) ", "Subsection",
 CellChangeTimes->{{3.9547318899015656`*^9, 3.954731893974074*^9}, {
   3.95473265785647*^9, 3.954732659663503*^9}, {3.954732890679308*^9, 
   3.954732891487614*^9}, 3.954733054504549*^9, 3.954734909088499*^9, {
   3.9547456826790233`*^9, 3.954745683267832*^9}, {3.955532399470188*^9, 
   3.955532399508514*^9}, {3.955533472269945*^9, 3.955533474519298*^9}, {
   3.9555335376277065`*^9, 3.95553355693482*^9}, {3.9575783809567223`*^9, 
   3.9575783820767975`*^9}, {3.957578662788761*^9, 3.9575786923886757`*^9}, {
   3.957578867297783*^9, 3.957578867375639*^9}, 3.957578905725321*^9, {
   3.957579153293701*^9, 3.957579153999096*^9}, {3.957579224877733*^9, 
   3.9575792258336353`*^9}, {3.9575792703015146`*^9, 
   3.9575792990200844`*^9}, {3.9575793731195526`*^9, 
   3.957579373709362*^9}},ExpressionUUID->"40c4b4f5-5c94-304c-bb93-\
bea419c253d0"],

Cell[BoxData[{
 RowBox[{
  RowBox[{
   RowBox[{"X290", "=", 
    RowBox[{"Simplificar", "[", 
     RowBox[{"Evaluar", "[", 
      RowBox[{"ETC", "[", 
       RowBox[{"[", 
        RowBox[{"290", ",", "2"}], "]"}], "]"}], "]"}], "]"}]}], ";"}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"ptF", "=", 
   RowBox[{"Simplificar", "[", 
    RowBox[{"CentroETCTriangulo", "[", 
     RowBox[{"X290", ",", 
      RowBox[{"{", 
       RowBox[{"ptA", ",", "ptB", ",", "ptE"}], "}"}]}], "]"}], "]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"ptG", "=", 
   RowBox[{"Simplificar", "[", 
    RowBox[{"CentroETCTriangulo", "[", 
     RowBox[{"X290", ",", 
      RowBox[{"{", 
       RowBox[{"ptB", ",", "ptC", ",", "ptE"}], "}"}]}], "]"}], "]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"ptH", "=", 
   RowBox[{"Simplificar", "[", 
    RowBox[{"CentroETCTriangulo", "[", 
     RowBox[{"X290", ",", 
      RowBox[{"{", 
       RowBox[{"ptC", ",", "ptD", ",", "ptE"}], "}"}]}], "]"}], "]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"ptI", "=", 
   RowBox[{"Simplificar", "[", 
    RowBox[{"CentroETCTriangulo", "[", 
     RowBox[{"X290", ",", 
      RowBox[{"{", 
       RowBox[{"ptD", ",", "ptA", ",", "ptE"}], "}"}]}], "]"}], "]"}]}], 
  ";"}]}], "Input",
 CellChangeTimes->{{3.9611205300556774`*^9, 3.9611205869165783`*^9}, {
  3.9611206259815464`*^9, 3.9611206409589634`*^9}, {3.961120762245165*^9, 
  3.961120805756878*^9}, {3.961120874557827*^9, 3.9611208932938232`*^9}},
 CellLabel->
  "In[180]:=",ExpressionUUID->"f991a97c-4af4-6d43-b91b-a3502468cb66"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"parallelogramQ", "[", 
  RowBox[{"{", 
   RowBox[{"ptF", ",", "ptG", ",", "ptH", ",", "ptI"}], "}"}], "]"}]], "Input",
 CellChangeTimes->{{3.955532598359007*^9, 3.955532602815159*^9}, 
   3.957578362301132*^9},
 CellLabel->
  "In[185]:=",ExpressionUUID->"42f1884f-52af-ef4e-a666-bc027aa924af"],

Cell[BoxData["True"], "Output",
 CellChangeTimes->{3.9555326038565083`*^9, 3.957578362905468*^9, 
  3.957578678463127*^9, 3.957578876579569*^9, 3.957579182459612*^9, 
  3.9575792498644295`*^9, 3.9575793495526066`*^9, 3.957579389848701*^9, 
  3.9611208981912136`*^9, 3.961412730277005*^9},
 CellLabel->
  "Out[185]=",ExpressionUUID->"89f23a10-d23a-4f81-8991-5a78452759b2"]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell["X (402) ", "Subsection",
 CellChangeTimes->{{3.9547318899015656`*^9, 3.954731893974074*^9}, {
   3.95473265785647*^9, 3.954732659663503*^9}, {3.954732890679308*^9, 
   3.954732891487614*^9}, 3.954733054504549*^9, 3.954734909088499*^9, {
   3.9547456826790233`*^9, 3.954745683267832*^9}, {3.955532399470188*^9, 
   3.955532399508514*^9}, {3.955533472269945*^9, 3.955533474519298*^9}, {
   3.9555335376277065`*^9, 3.95553355693482*^9}, {3.9575783809567223`*^9, 
   3.9575783820767975`*^9}, {3.957578662788761*^9, 3.9575786923886757`*^9}, {
   3.957578867297783*^9, 3.957578867375639*^9}, 3.957578905725321*^9, {
   3.957579153293701*^9, 3.957579153999096*^9}, {3.957579224877733*^9, 
   3.9575792258336353`*^9}, {3.9575792703015146`*^9, 
   3.9575792990200844`*^9}, {3.957579378277878*^9, 
   3.957579379119905*^9}},ExpressionUUID->"e616d80a-6849-c747-a318-\
909ffd7e2916"],

Cell[BoxData[{
 RowBox[{
  RowBox[{
   RowBox[{"X402", "=", 
    RowBox[{"Simplificar", "[", 
     RowBox[{"Evaluar", "[", 
      RowBox[{"ETC", "[", 
       RowBox[{"[", 
        RowBox[{"402", ",", "2"}], "]"}], "]"}], "]"}], "]"}]}], ";"}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"ptF", "=", 
   RowBox[{"Simplificar", "[", 
    RowBox[{"CentroETCTriangulo", "[", 
     RowBox[{"X402", ",", 
      RowBox[{"{", 
       RowBox[{"ptA", ",", "ptB", ",", "ptE"}], "}"}]}], "]"}], "]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"ptG", "=", 
   RowBox[{"Simplificar", "[", 
    RowBox[{"CentroETCTriangulo", "[", 
     RowBox[{"X402", ",", 
      RowBox[{"{", 
       RowBox[{"ptB", ",", "ptC", ",", "ptE"}], "}"}]}], "]"}], "]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"ptH", "=", 
   RowBox[{"Simplificar", "[", 
    RowBox[{"CentroETCTriangulo", "[", 
     RowBox[{"X402", ",", 
      RowBox[{"{", 
       RowBox[{"ptC", ",", "ptD", ",", "ptE"}], "}"}]}], "]"}], "]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"ptI", "=", 
   RowBox[{"Simplificar", "[", 
    RowBox[{"CentroETCTriangulo", "[", 
     RowBox[{"X402", ",", 
      RowBox[{"{", 
       RowBox[{"ptD", ",", "ptA", ",", "ptE"}], "}"}]}], "]"}], "]"}]}], 
  ";"}]}], "Input",
 CellChangeTimes->{{3.9611205300556774`*^9, 3.9611205869165783`*^9}, {
  3.9611206259815464`*^9, 3.9611206409589634`*^9}, {3.961120762245165*^9, 
  3.961120805756878*^9}, {3.961120918870306*^9, 3.9611209428949223`*^9}},
 CellLabel->
  "In[186]:=",ExpressionUUID->"fb66ad6d-72a5-6045-a537-a85957af16ee"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"parallelogramQ", "[", 
  RowBox[{"{", 
   RowBox[{"ptF", ",", "ptG", ",", "ptH", ",", "ptI"}], "}"}], "]"}]], "Input",
 CellChangeTimes->{{3.955532598359007*^9, 3.955532602815159*^9}, 
   3.957578362301132*^9},
 CellLabel->
  "In[191]:=",ExpressionUUID->"5ddfc980-7d54-1c41-9ed3-77af13b33450"],

Cell[BoxData["True"], "Output",
 CellChangeTimes->{3.9555326038565083`*^9, 3.957578362905468*^9, 
  3.957578678463127*^9, 3.957578876579569*^9, 3.957579182459612*^9, 
  3.9575792498644295`*^9, 3.9575793495526066`*^9, 3.957579507496573*^9, 
  3.96112095793655*^9, 3.961412731393186*^9},
 CellLabel->
  "Out[191]=",ExpressionUUID->"5a6a538c-67ff-4741-9058-492a64909dbf"]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell["X (620) ", "Subsection",
 CellChangeTimes->{{3.9547318899015656`*^9, 3.954731893974074*^9}, {
   3.95473265785647*^9, 3.954732659663503*^9}, {3.954732890679308*^9, 
   3.954732891487614*^9}, 3.954733054504549*^9, 3.954734909088499*^9, {
   3.9547456826790233`*^9, 3.954745683267832*^9}, {3.955532399470188*^9, 
   3.955532399508514*^9}, {3.955533472269945*^9, 3.955533474519298*^9}, {
   3.9555335376277065`*^9, 3.95553355693482*^9}, {3.9575783809567223`*^9, 
   3.9575783820767975`*^9}, {3.957578662788761*^9, 3.9575786923886757`*^9}, {
   3.957578867297783*^9, 3.957578867375639*^9}, 3.957578905725321*^9, {
   3.957579153293701*^9, 3.957579153999096*^9}, {3.957579224877733*^9, 
   3.9575792258336353`*^9}, {3.9575792703015146`*^9, 
   3.9575792990200844`*^9}, {3.957579378277878*^9, 3.957579379119905*^9}, {
   3.957579531767336*^9, 
   3.957579532391123*^9}},ExpressionUUID->"2acc5e13-a32c-0747-9720-\
35d803739e49"],

Cell[BoxData[{
 RowBox[{
  RowBox[{
   RowBox[{"X620", "=", 
    RowBox[{"Simplificar", "[", 
     RowBox[{"Evaluar", "[", 
      RowBox[{"ETC", "[", 
       RowBox[{"[", 
        RowBox[{"620", ",", "2"}], "]"}], "]"}], "]"}], "]"}]}], ";"}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"ptF", "=", 
   RowBox[{"Simplificar", "[", 
    RowBox[{"CentroETCTriangulo", "[", 
     RowBox[{"X620", ",", 
      RowBox[{"{", 
       RowBox[{"ptA", ",", "ptB", ",", "ptE"}], "}"}]}], "]"}], "]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"ptG", "=", 
   RowBox[{"Simplificar", "[", 
    RowBox[{"CentroETCTriangulo", "[", 
     RowBox[{"X620", ",", 
      RowBox[{"{", 
       RowBox[{"ptB", ",", "ptC", ",", "ptE"}], "}"}]}], "]"}], "]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"ptH", "=", 
   RowBox[{"Simplificar", "[", 
    RowBox[{"CentroETCTriangulo", "[", 
     RowBox[{"X620", ",", 
      RowBox[{"{", 
       RowBox[{"ptC", ",", "ptD", ",", "ptE"}], "}"}]}], "]"}], "]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"ptI", "=", 
   RowBox[{"Simplificar", "[", 
    RowBox[{"CentroETCTriangulo", "[", 
     RowBox[{"X620", ",", 
      RowBox[{"{", 
       RowBox[{"ptD", ",", "ptA", ",", "ptE"}], "}"}]}], "]"}], "]"}]}], 
  ";"}]}], "Input",
 CellChangeTimes->{{3.9611205300556774`*^9, 3.9611205869165783`*^9}, {
  3.9611206259815464`*^9, 3.9611206409589634`*^9}, {3.961120762245165*^9, 
  3.961120805756878*^9}, {3.9611209774940643`*^9, 3.9611209947652264`*^9}},
 CellLabel->
  "In[192]:=",ExpressionUUID->"de40bcbb-2824-2d49-bdc8-e06042119241"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"parallelogramQ", "[", 
  RowBox[{"{", 
   RowBox[{"ptF", ",", "ptG", ",", "ptH", ",", "ptI"}], "}"}], "]"}]], "Input",
 CellChangeTimes->{{3.955532598359007*^9, 3.955532602815159*^9}, 
   3.957578362301132*^9},
 CellLabel->
  "In[197]:=",ExpressionUUID->"1e191cb1-e27b-e94c-9220-c0d71548bc5e"],

Cell[BoxData["True"], "Output",
 CellChangeTimes->{3.9555326038565083`*^9, 3.957578362905468*^9, 
  3.957578678463127*^9, 3.957578876579569*^9, 3.957579182459612*^9, 
  3.9575792498644295`*^9, 3.9575793495526066`*^9, 3.957579507496573*^9, 
  3.9575796159922466`*^9, 3.961120997835787*^9, 3.9614127317031307`*^9},
 CellLabel->
  "Out[197]=",ExpressionUUID->"7213cf54-f963-473a-8d72-1db90fa2cbc3"]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell["X (671) ", "Subsection",
 CellChangeTimes->{{3.9547318899015656`*^9, 3.954731893974074*^9}, {
   3.95473265785647*^9, 3.954732659663503*^9}, {3.954732890679308*^9, 
   3.954732891487614*^9}, 3.954733054504549*^9, 3.954734909088499*^9, {
   3.9547456826790233`*^9, 3.954745683267832*^9}, {3.955532399470188*^9, 
   3.955532399508514*^9}, {3.955533472269945*^9, 3.955533474519298*^9}, {
   3.9555335376277065`*^9, 3.95553355693482*^9}, {3.9575783809567223`*^9, 
   3.9575783820767975`*^9}, {3.957578662788761*^9, 3.9575786923886757`*^9}, {
   3.957578867297783*^9, 3.957578867375639*^9}, 3.957578905725321*^9, {
   3.957579153293701*^9, 3.957579153999096*^9}, {3.957579224877733*^9, 
   3.9575792258336353`*^9}, {3.9575792703015146`*^9, 
   3.9575792990200844`*^9}, {3.957579378277878*^9, 3.957579379119905*^9}, {
   3.9575795375020695`*^9, 
   3.9575795379738464`*^9}},ExpressionUUID->"2cabee88-2c3b-4d4e-a33b-\
41564b2d341b"],

Cell[BoxData[{
 RowBox[{
  RowBox[{
   RowBox[{"X671", "=", 
    RowBox[{"Simplificar", "[", 
     RowBox[{"Evaluar", "[", 
      RowBox[{"ETC", "[", 
       RowBox[{"[", 
        RowBox[{"671", ",", "2"}], "]"}], "]"}], "]"}], "]"}]}], ";"}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"ptF", "=", 
   RowBox[{"Simplificar", "[", 
    RowBox[{"CentroETCTriangulo", "[", 
     RowBox[{"X671", ",", 
      RowBox[{"{", 
       RowBox[{"ptA", ",", "ptB", ",", "ptE"}], "}"}]}], "]"}], "]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"ptG", "=", 
   RowBox[{"Simplificar", "[", 
    RowBox[{"CentroETCTriangulo", "[", 
     RowBox[{"X671", ",", 
      RowBox[{"{", 
       RowBox[{"ptB", ",", "ptC", ",", "ptE"}], "}"}]}], "]"}], "]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"ptH", "=", 
   RowBox[{"Simplificar", "[", 
    RowBox[{"CentroETCTriangulo", "[", 
     RowBox[{"X671", ",", 
      RowBox[{"{", 
       RowBox[{"ptC", ",", "ptD", ",", "ptE"}], "}"}]}], "]"}], "]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"ptI", "=", 
   RowBox[{"Simplificar", "[", 
    RowBox[{"CentroETCTriangulo", "[", 
     RowBox[{"X671", ",", 
      RowBox[{"{", 
       RowBox[{"ptD", ",", "ptA", ",", "ptE"}], "}"}]}], "]"}], "]"}]}], 
  ";"}]}], "Input",
 CellChangeTimes->{{3.9611205300556774`*^9, 3.9611205869165783`*^9}, {
  3.9611206259815464`*^9, 3.9611206409589634`*^9}, {3.961120762245165*^9, 
  3.961120805756878*^9}, {3.9611210123342304`*^9, 3.9611210323967743`*^9}},
 CellLabel->
  "In[198]:=",ExpressionUUID->"dc4ebc18-e6d3-b44d-abf9-bead836217b0"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"parallelogramQ", "[", 
  RowBox[{"{", 
   RowBox[{"ptF", ",", "ptG", ",", "ptH", ",", "ptI"}], "}"}], "]"}]], "Input",
 CellChangeTimes->{{3.955532598359007*^9, 3.955532602815159*^9}, 
   3.957578362301132*^9},
 CellLabel->
  "In[203]:=",ExpressionUUID->"4c1f3cd7-8a05-3347-8949-9d482cc297cd"],

Cell[BoxData["True"], "Output",
 CellChangeTimes->{3.9555326038565083`*^9, 3.957578362905468*^9, 
  3.957578678463127*^9, 3.957578876579569*^9, 3.957579182459612*^9, 
  3.9575792498644295`*^9, 3.9575793495526066`*^9, 3.957579507496573*^9, 
  3.957579648697682*^9, 3.9611210351550655`*^9, 3.961412732092248*^9},
 CellLabel->
  "Out[203]=",ExpressionUUID->"2f031138-3811-4f29-aa8c-555bf31d61af"]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell["X (903) ", "Subsection",
 CellChangeTimes->{{3.9547318899015656`*^9, 3.954731893974074*^9}, {
   3.95473265785647*^9, 3.954732659663503*^9}, {3.954732890679308*^9, 
   3.954732891487614*^9}, 3.954733054504549*^9, 3.954734909088499*^9, {
   3.9547456826790233`*^9, 3.954745683267832*^9}, {3.955532399470188*^9, 
   3.955532399508514*^9}, {3.955533472269945*^9, 3.955533474519298*^9}, {
   3.9555335376277065`*^9, 3.95553355693482*^9}, {3.9575783809567223`*^9, 
   3.9575783820767975`*^9}, {3.957578662788761*^9, 3.9575786923886757`*^9}, {
   3.957578867297783*^9, 3.957578867375639*^9}, 3.957578905725321*^9, {
   3.957579153293701*^9, 3.957579153999096*^9}, {3.957579224877733*^9, 
   3.9575792258336353`*^9}, {3.9575792703015146`*^9, 
   3.9575792990200844`*^9}, {3.957579378277878*^9, 3.957579379119905*^9}, {
   3.9575795427014475`*^9, 
   3.957579543293764*^9}},ExpressionUUID->"d3082fb0-fba0-3646-9c25-\
d2919c7eb74b"],

Cell[BoxData[{
 RowBox[{
  RowBox[{
   RowBox[{"X903", "=", 
    RowBox[{"Simplificar", "[", 
     RowBox[{"Evaluar", "[", 
      RowBox[{"ETC", "[", 
       RowBox[{"[", 
        RowBox[{"903", ",", "2"}], "]"}], "]"}], "]"}], "]"}]}], ";"}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"ptF", "=", 
   RowBox[{"Simplificar", "[", 
    RowBox[{"CentroETCTriangulo", "[", 
     RowBox[{"X903", ",", 
      RowBox[{"{", 
       RowBox[{"ptA", ",", "ptB", ",", "ptE"}], "}"}]}], "]"}], "]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"ptG", "=", 
   RowBox[{"Simplificar", "[", 
    RowBox[{"CentroETCTriangulo", "[", 
     RowBox[{"X903", ",", 
      RowBox[{"{", 
       RowBox[{"ptB", ",", "ptC", ",", "ptE"}], "}"}]}], "]"}], "]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"ptH", "=", 
   RowBox[{"Simplificar", "[", 
    RowBox[{"CentroETCTriangulo", "[", 
     RowBox[{"X903", ",", 
      RowBox[{"{", 
       RowBox[{"ptC", ",", "ptD", ",", "ptE"}], "}"}]}], "]"}], "]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"ptI", "=", 
   RowBox[{"Simplificar", "[", 
    RowBox[{"CentroETCTriangulo", "[", 
     RowBox[{"X903", ",", 
      RowBox[{"{", 
       RowBox[{"ptD", ",", "ptA", ",", "ptE"}], "}"}]}], "]"}], "]"}]}], 
  ";"}]}], "Input",
 CellChangeTimes->{{3.9611205300556774`*^9, 3.9611205869165783`*^9}, {
  3.9611206259815464`*^9, 3.9611206409589634`*^9}, {3.961120762245165*^9, 
  3.961120805756878*^9}, {3.9611210502579765`*^9, 3.961121071813555*^9}},
 CellLabel->
  "In[204]:=",ExpressionUUID->"06d8550d-1f32-364d-bdb6-2ac69e0548fc"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"parallelogramQ", "[", 
  RowBox[{"{", 
   RowBox[{"ptF", ",", "ptG", ",", "ptH", ",", "ptI"}], "}"}], "]"}]], "Input",
 CellChangeTimes->{{3.955532598359007*^9, 3.955532602815159*^9}, 
   3.957578362301132*^9},
 CellLabel->
  "In[209]:=",ExpressionUUID->"d594044c-5d16-a248-a659-8be91e608bad"],

Cell[BoxData["True"], "Output",
 CellChangeTimes->{3.9555326038565083`*^9, 3.957578362905468*^9, 
  3.957578678463127*^9, 3.957578876579569*^9, 3.957579182459612*^9, 
  3.9575792498644295`*^9, 3.9575793495526066`*^9, 3.957579507496573*^9, 
  3.957579668223112*^9, 3.9611210744588776`*^9, 3.961412732441937*^9},
 CellLabel->
  "Out[209]=",ExpressionUUID->"92112c5b-68ce-404d-9f63-3feb6d9863c1"]
}, Open  ]]
}, Closed]]
}, Open  ]],

Cell[CellGroupData[{

Cell["FGHI tangential  quad", "Section",
 CellChangeTimes->{{3.95553234842535*^9, 
  3.955532366934231*^9}},ExpressionUUID->"c59d6c3a-6d51-4444-9820-\
9f8160119815"],

Cell[CellGroupData[{

Cell["X \[Element] \[DoubleStruckCapitalT] ", "Subsection",
 CellChangeTimes->{{3.9547318899015656`*^9, 3.954731893974074*^9}, {
   3.95473265785647*^9, 3.954732659663503*^9}, {3.954732890679308*^9, 
   3.954732891487614*^9}, 3.954733054504549*^9, 3.954734909088499*^9, {
   3.9547456826790233`*^9, 3.954745683267832*^9}, {3.955532399470188*^9, 
   3.955532399508514*^9}, {3.955532733349869*^9, 3.955532733926052*^9}, {
   3.955532899238508*^9, 3.9555329102464027`*^9}, {3.9575779644687576`*^9, 
   3.957578000565407*^9}, {3.961120090450142*^9, 3.961120148594164*^9}, {
   3.961120347218914*^9, 3.961120352554741*^9}, 3.961120420161833*^9, {
   3.961121401651226*^9, 3.9611214293728294`*^9}, {3.961121482939451*^9, 
   3.9611215107011223`*^9}},ExpressionUUID->"1ca53b5d-5d51-dc40-9345-\
dd90375bc23b"],

Cell["See Theorem 7.7 (synthetic proof)", "Text",
 CellChangeTimes->{{3.9611215643672256`*^9, 
  3.961121661284836*^9}},ExpressionUUID->"fc148123-71e8-1b4c-8d50-\
f455e2c90c1a"]
}, Closed]],

Cell[CellGroupData[{

Cell["X (3)", "Subsection",
 CellChangeTimes->{{3.9547318899015656`*^9, 3.954731893974074*^9}, {
   3.95473265785647*^9, 3.954732659663503*^9}, {3.954732890679308*^9, 
   3.954732891487614*^9}, 3.954733054504549*^9, 3.954734909088499*^9, {
   3.9547456826790233`*^9, 3.954745683267832*^9}, {3.957574457314209*^9, 
   3.9575744574718914`*^9}, {3.9611192439300976`*^9, 
   3.9611192440817814`*^9}},ExpressionUUID->"33a511e8-7174-904f-b7c0-\
99ddf2d4b253"],

Cell[BoxData[{
 RowBox[{
  RowBox[{
   RowBox[{"X3", "=", 
    RowBox[{"Simplificar", "[", 
     RowBox[{"Evaluar", "[", 
      RowBox[{"ETC", "[", 
       RowBox[{"[", 
        RowBox[{"3", ",", "2"}], "]"}], "]"}], "]"}], "]"}]}], ";"}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"ptF", "=", 
   RowBox[{"Simplificar", "[", 
    RowBox[{"CentroETCTriangulo", "[", 
     RowBox[{"X3", ",", 
      RowBox[{"{", 
       RowBox[{"ptA", ",", "ptB", ",", "ptE"}], "}"}]}], "]"}], "]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"ptG", "=", 
   RowBox[{"Simplificar", "[", 
    RowBox[{"CentroETCTriangulo", "[", 
     RowBox[{"X3", ",", 
      RowBox[{"{", 
       RowBox[{"ptB", ",", "ptC", ",", "ptE"}], "}"}]}], "]"}], "]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"ptH", "=", 
   RowBox[{"Simplificar", "[", 
    RowBox[{"CentroETCTriangulo", "[", 
     RowBox[{"X3", ",", 
      RowBox[{"{", 
       RowBox[{"ptC", ",", "ptD", ",", "ptE"}], "}"}]}], "]"}], "]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"ptI", "=", 
   RowBox[{"Simplificar", "[", 
    RowBox[{"CentroETCTriangulo", "[", 
     RowBox[{"X3", ",", 
      RowBox[{"{", 
       RowBox[{"ptD", ",", "ptA", ",", "ptE"}], "}"}]}], "]"}], "]"}]}], 
  ";"}]}], "Input",
 CellChangeTimes->{{3.9575745870248795`*^9, 3.9575746314661713`*^9}, {
  3.957574709684349*^9, 3.957574739857065*^9}, {3.9575748473784943`*^9, 
  3.9575748625135956`*^9}, {3.9611193066214104`*^9, 3.961119347274618*^9}},
 CellLabel->
  "In[210]:=",ExpressionUUID->"cfed2460-98ed-da43-bcfd-4fd646a60880"],

Cell["\<\
We have d (E, FG)=d (E, GH),  d (E, GH)=d (E, HI), d (E, HI)=d (E, IF)\
\>", "Text",
 CellChangeTimes->{{3.957576532951077*^9, 3.957576623206949*^9}, {
  3.957576765546618*^9, 
  3.957576818465838*^9}},ExpressionUUID->"24e74562-c4ec-fd44-abd2-\
b2762497b730"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Factor", "[", 
  RowBox[{
   RowBox[{"CuadradoDistanciaPuntoRecta", "[", 
    RowBox[{"ptE", ",", 
     RowBox[{"Recta", "[", 
      RowBox[{"ptF", ",", "ptG"}], "]"}]}], "]"}], "-", 
   RowBox[{"CuadradoDistanciaPuntoRecta", "[", 
    RowBox[{"ptE", ",", 
     RowBox[{"Recta", "[", 
      RowBox[{"ptG", ",", "ptH"}], "]"}]}], "]"}]}], "]"}]], "Input",
 CellChangeTimes->{{3.957576645694599*^9, 3.9575766660040035`*^9}},
 CellLabel->
  "In[215]:=",ExpressionUUID->"6ab90913-ca04-6e45-8a0d-7e126691918c"],

Cell[BoxData["0"], "Output",
 CellChangeTimes->{
  3.957576667189493*^9, 3.9575773951452274`*^9, 3.9611191877551117`*^9, {
   3.9611192973524723`*^9, 3.961119320454771*^9}, 3.9614127326695347`*^9},
 CellLabel->
  "Out[215]=",ExpressionUUID->"5e6d54b5-d408-476b-a3fb-669c3bd2a0cb"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Factor", "[", 
  RowBox[{
   RowBox[{"CuadradoDistanciaPuntoRecta", "[", 
    RowBox[{"ptE", ",", 
     RowBox[{"Recta", "[", 
      RowBox[{"ptG", ",", "ptH"}], "]"}]}], "]"}], "-", 
   RowBox[{"CuadradoDistanciaPuntoRecta", "[", 
    RowBox[{"ptE", ",", 
     RowBox[{"Recta", "[", 
      RowBox[{"ptH", ",", "ptI"}], "]"}]}], "]"}]}], "]"}]], "Input",
 CellChangeTimes->{{3.957576683619833*^9, 3.957576701052153*^9}},
 CellLabel->
  "In[216]:=",ExpressionUUID->"95aba7e7-3a32-e347-9f85-d5677484d9fa"],

Cell[BoxData["0"], "Output",
 CellChangeTimes->{3.957576701797138*^9, 3.9575773966202984`*^9, 
  3.9611191896492634`*^9, 3.96111932260367*^9, 3.961412732841978*^9},
 CellLabel->
  "Out[216]=",ExpressionUUID->"dc4bb578-cb35-4ba3-b8a8-7f843f0ce7e7"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Factor", "[", 
  RowBox[{
   RowBox[{"CuadradoDistanciaPuntoRecta", "[", 
    RowBox[{"ptE", ",", 
     RowBox[{"Recta", "[", 
      RowBox[{"ptH", ",", "ptI"}], "]"}]}], "]"}], "-", 
   RowBox[{"CuadradoDistanciaPuntoRecta", "[", 
    RowBox[{"ptE", ",", 
     RowBox[{"Recta", "[", 
      RowBox[{"ptI", ",", "ptF"}], "]"}]}], "]"}]}], "]"}]], "Input",
 CellChangeTimes->{{3.9575767113398476`*^9, 3.957576725557123*^9}},
 CellLabel->
  "In[217]:=",ExpressionUUID->"f22af56c-3bfc-d941-9420-b1c2e326befd"],

Cell[BoxData["0"], "Output",
 CellChangeTimes->{3.957576730995468*^9, 3.957577397850586*^9, 
  3.961119190616604*^9, 3.961119323892639*^9, 3.961412732907959*^9},
 CellLabel->
  "Out[217]=",ExpressionUUID->"42b12469-ea97-461d-95c8-af387dc86860"]
}, Open  ]],

Cell["\<\
Therefore d (E, FG)=d (E, GH)=d (E, HI)=d (E, IF),  hence E is the incenter \
of FGHI.\
\>", "Text",
 CellChangeTimes->{{3.957576532951077*^9, 3.957576623206949*^9}, {
   3.957576765546618*^9, 3.957576766043865*^9}, {3.95757682212254*^9, 
   3.95757683953898*^9}, 3.961119081657341*^9, {3.9611191146664696`*^9, 
   3.9611191260025845`*^9}},ExpressionUUID->"d1bef6ea-7663-7f4c-9171-\
60f7b68577a0"]
}, Closed]],

Cell[CellGroupData[{

Cell["X (399)", "Subsection",
 CellChangeTimes->{{3.9547318899015656`*^9, 3.954731893974074*^9}, {
   3.95473265785647*^9, 3.954732659663503*^9}, {3.954732890679308*^9, 
   3.954732891487614*^9}, 3.954733054504549*^9, 3.954734909088499*^9, {
   3.9547456826790233`*^9, 3.954745683267832*^9}, {3.957574457314209*^9, 
   3.9575744574718914`*^9}},ExpressionUUID->"d11bcbe3-4466-8d48-8d95-\
b256984be2d3"],

Cell[BoxData[{
 RowBox[{
  RowBox[{
   RowBox[{"X399", "=", 
    RowBox[{"Simplificar", "[", 
     RowBox[{"Evaluar", "[", 
      RowBox[{"ETC", "[", 
       RowBox[{"[", 
        RowBox[{"399", ",", "2"}], "]"}], "]"}], "]"}], "]"}]}], ";"}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"ptF", "=", 
   RowBox[{"Simplificar", "[", 
    RowBox[{"CentroETCTriangulo", "[", 
     RowBox[{"X399", ",", 
      RowBox[{"{", 
       RowBox[{"ptA", ",", "ptB", ",", "ptE"}], "}"}]}], "]"}], "]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"ptG", "=", 
   RowBox[{"Simplificar", "[", 
    RowBox[{"CentroETCTriangulo", "[", 
     RowBox[{"X399", ",", 
      RowBox[{"{", 
       RowBox[{"ptB", ",", "ptC", ",", "ptE"}], "}"}]}], "]"}], "]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"ptH", "=", 
   RowBox[{"Simplificar", "[", 
    RowBox[{"CentroETCTriangulo", "[", 
     RowBox[{"X399", ",", 
      RowBox[{"{", 
       RowBox[{"ptC", ",", "ptD", ",", "ptE"}], "}"}]}], "]"}], "]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"ptI", "=", 
   RowBox[{"Simplificar", "[", 
    RowBox[{"CentroETCTriangulo", "[", 
     RowBox[{"X399", ",", 
      RowBox[{"{", 
       RowBox[{"ptD", ",", "ptA", ",", "ptE"}], "}"}]}], "]"}], "]"}]}], 
  ";"}]}], "Input",
 CellChangeTimes->{{3.9575745870248795`*^9, 3.9575746314661713`*^9}, {
  3.957574709684349*^9, 3.957574739857065*^9}, {3.9575748473784943`*^9, 
  3.9575748625135956`*^9}, {3.9611193543464565`*^9, 3.9611193558422985`*^9}},
 CellLabel->
  "In[218]:=",ExpressionUUID->"745a30b3-f1a0-bf42-9ffa-c1b54561d882"],

Cell["\<\
We have d (E, FG)=d (E, GH),  d (E, GH)=d (E, HI), d (E, HI)=d (E, IF)\
\>", "Text",
 CellChangeTimes->{{3.957576532951077*^9, 3.957576623206949*^9}, {
  3.957576765546618*^9, 
  3.957576818465838*^9}},ExpressionUUID->"810a75ce-e0f1-7843-a8ce-\
179ea8d8f52c"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Factor", "[", 
  RowBox[{
   RowBox[{"CuadradoDistanciaPuntoRecta", "[", 
    RowBox[{"ptE", ",", 
     RowBox[{"Recta", "[", 
      RowBox[{"ptF", ",", "ptG"}], "]"}]}], "]"}], "-", 
   RowBox[{"CuadradoDistanciaPuntoRecta", "[", 
    RowBox[{"ptE", ",", 
     RowBox[{"Recta", "[", 
      RowBox[{"ptG", ",", "ptH"}], "]"}]}], "]"}]}], "]"}]], "Input",
 CellChangeTimes->{{3.957576645694599*^9, 3.9575766660040035`*^9}},
 CellLabel->
  "In[223]:=",ExpressionUUID->"67094f67-49dc-6c43-9d3b-15eb732de9b0"],

Cell[BoxData["0"], "Output",
 CellChangeTimes->{3.957576667189493*^9, 3.9575773951452274`*^9, 
  3.9611191877551117`*^9, 3.9614127337013903`*^9},
 CellLabel->
  "Out[223]=",ExpressionUUID->"c867a6f1-2260-43bf-8a00-0fcd1ee39207"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Factor", "[", 
  RowBox[{
   RowBox[{"CuadradoDistanciaPuntoRecta", "[", 
    RowBox[{"ptE", ",", 
     RowBox[{"Recta", "[", 
      RowBox[{"ptG", ",", "ptH"}], "]"}]}], "]"}], "-", 
   RowBox[{"CuadradoDistanciaPuntoRecta", "[", 
    RowBox[{"ptE", ",", 
     RowBox[{"Recta", "[", 
      RowBox[{"ptH", ",", "ptI"}], "]"}]}], "]"}]}], "]"}]], "Input",
 CellChangeTimes->{{3.957576683619833*^9, 3.957576701052153*^9}},
 CellLabel->
  "In[224]:=",ExpressionUUID->"b9c5735b-652c-d24f-82ea-e77d4229fd39"],

Cell[BoxData["0"], "Output",
 CellChangeTimes->{3.957576701797138*^9, 3.9575773966202984`*^9, 
  3.9611191896492634`*^9, 3.96141273387825*^9},
 CellLabel->
  "Out[224]=",ExpressionUUID->"19e1ebac-2093-4d70-add6-2d6434f03ac0"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Factor", "[", 
  RowBox[{
   RowBox[{"CuadradoDistanciaPuntoRecta", "[", 
    RowBox[{"ptE", ",", 
     RowBox[{"Recta", "[", 
      RowBox[{"ptH", ",", "ptI"}], "]"}]}], "]"}], "-", 
   RowBox[{"CuadradoDistanciaPuntoRecta", "[", 
    RowBox[{"ptE", ",", 
     RowBox[{"Recta", "[", 
      RowBox[{"ptI", ",", "ptF"}], "]"}]}], "]"}]}], "]"}]], "Input",
 CellChangeTimes->{{3.9575767113398476`*^9, 3.957576725557123*^9}},
 CellLabel->
  "In[225]:=",ExpressionUUID->"3b59d433-1b0a-934c-9d80-b9299ec37ba7"],

Cell[BoxData["0"], "Output",
 CellChangeTimes->{3.957576730995468*^9, 3.957577397850586*^9, 
  3.961119190616604*^9, 3.9614127339677067`*^9},
 CellLabel->
  "Out[225]=",ExpressionUUID->"753c5d4c-a32e-4cad-99ca-89fe5a873021"]
}, Open  ]],

Cell["\<\
Therefore d (E, FG)=d (E, GH)=d (E, HI)=d (E, IF),  hence E is the incenter \
of FGHI.\
\>", "Text",
 CellChangeTimes->{{3.957576532951077*^9, 3.957576623206949*^9}, {
   3.957576765546618*^9, 3.957576766043865*^9}, {3.95757682212254*^9, 
   3.95757683953898*^9}, 3.961119081657341*^9, {3.9611191146664696`*^9, 
   3.9611191260025845`*^9}},ExpressionUUID->"37cecdf6-7d12-9a45-9a17-\
7ed14ad84dc7"]
}, Closed]]
}, Open  ]]
}, Open  ]]
},
WindowSize->{1294, 655},
WindowMargins->{{136, Automatic}, {Automatic, 30}},
FrontEndVersion->"14.2 for Mac OS X x86 (64-bit) (March 16, 2025)",
StyleDefinitions->"Default.nb",
ExpressionUUID->"2c987011-4232-1444-860d-88047ca04ba6"
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{}
*)
(*CellTagsIndex
CellTagsIndex->{}
*)
(*NotebookFileOutline
Notebook[{
Cell[CellGroupData[{
Cell[580, 22, 425, 6, 96, "Title",ExpressionUUID->"29001ab6-6556-7b4b-a45f-7ca429ca0ceb"],
Cell[1008, 30, 1524, 26, 164, "Text",ExpressionUUID->"22c83543-03f0-524a-b077-52bf40ea5d06"],
Cell[CellGroupData[{
Cell[2557, 60, 223, 4, 66, "Section",ExpressionUUID->"4726c28a-23e3-c144-b5b8-1febfd23a730"],
Cell[2783, 66, 1409, 29, 49, "Input",ExpressionUUID->"fe7e3f24-57f0-1445-8125-872b46d33312"],
Cell[4195, 97, 319, 6, 33, "Text",ExpressionUUID->"54ce8b45-a9ff-364a-b007-50e763233c41"],
Cell[CellGroupData[{
Cell[4539, 107, 391, 8, 29, "Input",ExpressionUUID->"2b97bda7-fc4c-854c-a342-fa797e627188"],
Cell[4933, 117, 863, 14, 33, "Output",ExpressionUUID->"f13281aa-faa7-4b12-bb73-f832d574037d"]
}, Open  ]],
Cell[CellGroupData[{
Cell[5833, 136, 878, 20, 49, "Input",ExpressionUUID->"d4990506-4c5e-3c4f-ae15-03b45e912fc7"],
Cell[6714, 158, 734, 21, 35, "Output",ExpressionUUID->"cf2f0efb-76e7-4125-b536-0028d1199333"]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[7497, 185, 255, 4, 66, "Section",ExpressionUUID->"fc2fcd82-4d50-ec47-b5a7-8944aef04ea5"],
Cell[7755, 191, 9192, 248, 565, "Input",ExpressionUUID->"c44d3c99-d821-aa44-a5bf-67b591807924"]
}, Open  ]],
Cell[CellGroupData[{
Cell[16984, 444, 211, 4, 66, "Section",ExpressionUUID->"2609bf4c-7f5c-314e-a744-f86d4be283dd"],
Cell[17198, 450, 154226, 2533, 496, "Text",ExpressionUUID->"27562332-302c-684c-a6e9-c7f5988655e4"],
Cell[CellGroupData[{
Cell[171449, 2987, 20391, 339, 74, "Input",ExpressionUUID->"ab0aa141-f81e-a441-ab20-bf3fed10f65e"],
Cell[191843, 3328, 20373, 338, 78, "Output",ExpressionUUID->"92541fd8-ff18-44f4-bda2-f4136dadea4a"]
}, Open  ]],
Cell[CellGroupData[{
Cell[212253, 3671, 202, 4, 29, "Input",ExpressionUUID->"3e8dd887-2087-0a47-896d-8880febfaa56"],
Cell[212458, 3677, 1036, 31, 35, "Output",ExpressionUUID->"a628f525-387f-4119-ae34-c36ee736c0c7"]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[213543, 3714, 161, 3, 66, "Section",ExpressionUUID->"f0419b89-23d5-8644-b69d-cc4e3fce7177"],
Cell[CellGroupData[{
Cell[213729, 3721, 775, 11, 53, "Subsection",ExpressionUUID->"73d38772-8e07-1841-9a9c-3044cf07162c"],
Cell[214507, 3734, 617, 12, 99, "Text",ExpressionUUID->"a320793f-0690-da48-889b-40ba65c593f6"]
}, Closed]],
Cell[CellGroupData[{
Cell[215161, 3751, 699, 10, 37, "Subsection",ExpressionUUID->"4a5cb8ca-2a70-f34f-9f6e-2f07ca1fc495"],
Cell[215863, 3763, 1471, 44, 131, "Input",ExpressionUUID->"1a0a2b6d-8427-6540-91cc-7948a2861b9f"],
Cell[CellGroupData[{
Cell[217359, 3811, 317, 7, 29, "Input",ExpressionUUID->"18c7be5a-057b-f443-8626-d9b8e892e696"],
Cell[217679, 3820, 296, 5, 33, "Output",ExpressionUUID->"72d81ae5-c038-45ee-a6a3-b53a769129ca"]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[218024, 3831, 751, 11, 37, "Subsection",ExpressionUUID->"3ed9955a-edde-0b46-9042-879ae97f56ae"],
Cell[218778, 3844, 1524, 45, 131, "Input",ExpressionUUID->"dae4f3c5-907f-d54e-ba2d-f9f9769b95f2"],
Cell[CellGroupData[{
Cell[220327, 3893, 317, 7, 29, "Input",ExpressionUUID->"790495a0-ff2a-204e-ad81-af5c115f946c"],
Cell[220647, 3902, 347, 6, 33, "Output",ExpressionUUID->"e199ef1d-0923-4ad5-8738-ca2224f69598"]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[221043, 3914, 676, 10, 37, "Subsection",ExpressionUUID->"5ce4c659-b0dd-e64d-8ec3-088a6ea4ef55"],
Cell[221722, 3926, 1573, 46, 131, "Input",ExpressionUUID->"eb21106e-57e1-2243-a671-3ee27339c7d1"],
Cell[CellGroupData[{
Cell[223320, 3976, 317, 7, 29, "Input",ExpressionUUID->"6d78f710-5ce8-314f-b95e-349a31bbf775"],
Cell[223640, 3985, 251, 4, 33, "Output",ExpressionUUID->"d224a86f-fd79-4d7b-b190-052ea5630eea"]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[223940, 3995, 879, 13, 37, "Subsection",ExpressionUUID->"40c4b4f5-5c94-304c-bb93-bea419c253d0"],
Cell[224822, 4010, 1621, 46, 131, "Input",ExpressionUUID->"f991a97c-4af4-6d43-b91b-a3502468cb66"],
Cell[CellGroupData[{
Cell[226468, 4060, 317, 7, 29, "Input",ExpressionUUID->"42f1884f-52af-ef4e-a666-bc027aa924af"],
Cell[226788, 4069, 371, 6, 33, "Output",ExpressionUUID->"89f23a10-d23a-4f81-8991-5a78452759b2"]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[227208, 4081, 877, 13, 37, "Subsection",ExpressionUUID->"e616d80a-6849-c747-a318-909ffd7e2916"],
Cell[228088, 4096, 1621, 46, 131, "Input",ExpressionUUID->"fb66ad6d-72a5-6045-a537-a85957af16ee"],
Cell[CellGroupData[{
Cell[229734, 4146, 317, 7, 29, "Input",ExpressionUUID->"5ddfc980-7d54-1c41-9ed3-77af13b33450"],
Cell[230054, 4155, 368, 6, 33, "Output",ExpressionUUID->"5a6a538c-67ff-4741-9058-492a64909dbf"]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[230471, 4167, 927, 14, 37, "Subsection",ExpressionUUID->"2acc5e13-a32c-0747-9720-35d803739e49"],
Cell[231401, 4183, 1623, 46, 131, "Input",ExpressionUUID->"de40bcbb-2824-2d49-bdc8-e06042119241"],
Cell[CellGroupData[{
Cell[233049, 4233, 317, 7, 29, "Input",ExpressionUUID->"1e191cb1-e27b-e94c-9220-c0d71548bc5e"],
Cell[233369, 4242, 395, 6, 33, "Output",ExpressionUUID->"7213cf54-f963-473a-8d72-1db90fa2cbc3"]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[233813, 4254, 931, 14, 37, "Subsection",ExpressionUUID->"2cabee88-2c3b-4d4e-a33b-41564b2d341b"],
Cell[234747, 4270, 1623, 46, 131, "Input",ExpressionUUID->"dc4ebc18-e6d3-b44d-abf9-bead836217b0"],
Cell[CellGroupData[{
Cell[236395, 4320, 317, 7, 29, "Input",ExpressionUUID->"4c1f3cd7-8a05-3347-8949-9d482cc297cd"],
Cell[236715, 4329, 393, 6, 33, "Output",ExpressionUUID->"2f031138-3811-4f29-aa8c-555bf31d61af"]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[237157, 4341, 929, 14, 37, "Subsection",ExpressionUUID->"d3082fb0-fba0-3646-9c25-d2919c7eb74b"],
Cell[238089, 4357, 1621, 46, 131, "Input",ExpressionUUID->"06d8550d-1f32-364d-bdb6-2ac69e0548fc"],
Cell[CellGroupData[{
Cell[239735, 4407, 317, 7, 29, "Input",ExpressionUUID->"d594044c-5d16-a248-a659-8be91e608bad"],
Cell[240055, 4416, 393, 6, 33, "Output",ExpressionUUID->"92112c5b-68ce-404d-9f63-3feb6d9863c1"]
}, Open  ]]
}, Closed]]
}, Open  ]],
Cell[CellGroupData[{
Cell[240509, 4429, 165, 3, 66, "Section",ExpressionUUID->"c59d6c3a-6d51-4444-9820-9f8160119815"],
Cell[CellGroupData[{
Cell[240699, 4436, 801, 11, 53, "Subsection",ExpressionUUID->"1ca53b5d-5d51-dc40-9345-dd90375bc23b"],
Cell[241503, 4449, 177, 3, 33, "Text",ExpressionUUID->"fc148123-71e8-1b4c-8d50-f455e2c90c1a"]
}, Closed]],
Cell[CellGroupData[{
Cell[241717, 4457, 453, 7, 37, "Subsection",ExpressionUUID->"33a511e8-7174-904f-b7c0-99ddf2d4b253"],
Cell[242173, 4466, 1609, 46, 131, "Input",ExpressionUUID->"cfed2460-98ed-da43-bcfd-4fd646a60880"],
Cell[243785, 4514, 269, 6, 33, "Text",ExpressionUUID->"24e74562-c4ec-fd44-abd2-b2762497b730"],
Cell[CellGroupData[{
Cell[244079, 4524, 529, 13, 29, "Input",ExpressionUUID->"6ab90913-ca04-6e45-8a0d-7e126691918c"],
Cell[244611, 4539, 280, 5, 33, "Output",ExpressionUUID->"5e6d54b5-d408-476b-a3fb-669c3bd2a0cb"]
}, Open  ]],
Cell[CellGroupData[{
Cell[244928, 4549, 527, 13, 29, "Input",ExpressionUUID->"95aba7e7-3a32-e347-9f85-d5677484d9fa"],
Cell[245458, 4564, 247, 4, 33, "Output",ExpressionUUID->"dc4bb578-cb35-4ba3-b8a8-7f843f0ce7e7"]
}, Open  ]],
Cell[CellGroupData[{
Cell[245742, 4573, 529, 13, 29, "Input",ExpressionUUID->"f22af56c-3bfc-d941-9420-b1c2e326befd"],
Cell[246274, 4588, 244, 4, 33, "Output",ExpressionUUID->"42b12469-ea97-461d-95c8-af387dc86860"]
}, Open  ]],
Cell[246533, 4595, 407, 8, 33, "Text",ExpressionUUID->"d1bef6ea-7663-7f4c-9171-60f7b68577a0"]
}, Closed]],
Cell[CellGroupData[{
Cell[246977, 4608, 401, 6, 37, "Subsection",ExpressionUUID->"d11bcbe3-4466-8d48-8d95-b256984be2d3"],
Cell[247381, 4616, 1623, 46, 131, "Input",ExpressionUUID->"745a30b3-f1a0-bf42-9ffa-c1b54561d882"],
Cell[249007, 4664, 269, 6, 33, "Text",ExpressionUUID->"810a75ce-e0f1-7843-a8ce-179ea8d8f52c"],
Cell[CellGroupData[{
Cell[249301, 4674, 529, 13, 29, "Input",ExpressionUUID->"67094f67-49dc-6c43-9d3b-15eb732de9b0"],
Cell[249833, 4689, 228, 4, 33, "Output",ExpressionUUID->"c867a6f1-2260-43bf-8a00-0fcd1ee39207"]
}, Open  ]],
Cell[CellGroupData[{
Cell[250098, 4698, 527, 13, 29, "Input",ExpressionUUID->"b9c5735b-652c-d24f-82ea-e77d4229fd39"],
Cell[250628, 4713, 225, 4, 33, "Output",ExpressionUUID->"19e1ebac-2093-4d70-add6-2d6434f03ac0"]
}, Open  ]],
Cell[CellGroupData[{
Cell[250890, 4722, 529, 13, 29, "Input",ExpressionUUID->"3b59d433-1b0a-934c-9d80-b9299ec37ba7"],
Cell[251422, 4737, 224, 4, 33, "Output",ExpressionUUID->"753c5d4c-a32e-4cad-99ca-89fe5a873021"]
}, Open  ]],
Cell[251661, 4744, 407, 8, 33, "Text",ExpressionUUID->"37cecdf6-7d12-9a45-9a17-7ed14ad84dc7"]
}, Closed]]
}, Open  ]]
}, Open  ]]
}
]
*)

